/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.tasks.crates.types;

import com.badbones69.crazycrates.api.PrizeManager;
import com.badbones69.crazycrates.api.builders.CrateBuilder;
import com.badbones69.crazycrates.api.enums.misc.Keys;
import com.badbones69.crazycrates.api.objects.Crate;
import com.badbones69.crazycrates.api.objects.Tier;
import com.badbones69.crazycrates.managers.events.enums.EventType;
import com.badbones69.crazycrates.utils.MiscUtils;
import io.papermc.paper.persistence.PersistentDataContainerView;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import libs.com.ryderbelserion.vital.paper.util.scheduler.FoliaRunnable;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import us.crazycrew.crazycrates.api.enums.types.KeyType;

public class CasinoCrate
extends CrateBuilder {
    private final Inventory inventory = this.getInventory();
    private final Player player = this.getPlayer();
    private final UUID uuid = this.player.getUniqueId();
    private final Crate crate = this.getCrate();
    private int counter = 0;
    private int time = 1;
    private int open = 0;

    public CasinoCrate(@NotNull Crate crate, @NotNull Player player, int size) {
        super(crate, player, size);
    }

    @Override
    public void run() {
        if (this.isCancelled) {
            return;
        }
        if (this.counter <= 50) {
            this.playSound("cycle-sound", Sound.Source.PLAYER, "block.note_block.xylophone");
            this.cycle();
        }
        ++this.open;
        if (this.open >= 5) {
            this.player.openInventory(this.inventory);
            this.open = 0;
        }
        ++this.counter;
        if (this.counter > 51) {
            if (MiscUtils.slowSpin(120, 15).contains(this.time)) {
                this.playSound("cycle-sound", Sound.Source.PLAYER, "block.note_block.xylophone");
                this.cycle();
            }
            ++this.time;
            if (this.time >= 60) {
                this.playSound("stop-sound", Sound.Source.PLAYER, "entity.player.levelup");
                this.crateManager.endCrate(this.player);
                PrizeManager.getPrize(this.crate, this.inventory, 11, this.player);
                PrizeManager.getPrize(this.crate, this.inventory, 13, this.player);
                PrizeManager.getPrize(this.crate, this.inventory, 15, this.player);
                this.crateManager.removePlayerFromOpeningList(this.player);
                new FoliaRunnable(this.player.getScheduler(), null){

                    @Override
                    public void run() {
                        if (CasinoCrate.this.player.getOpenInventory().getTopInventory().equals((Object)CasinoCrate.this.inventory)) {
                            CasinoCrate.this.player.closeInventory();
                        }
                    }
                }.runDelayed(this.plugin, 40L);
                this.cancel();
                return;
            }
        }
        ++this.counter;
    }

    @Override
    public void open(@NotNull KeyType type, boolean checkHand, boolean isSilent, EventType eventType) {
        boolean keyCheck;
        boolean isRandom;
        if (this.isCrateEventValid(type, checkHand, isSilent, eventType)) {
            return;
        }
        String fileName = this.crate.getFileName();
        ConfigurationSection section = this.crate.getFile().getConfigurationSection("Crate.random");
        if (section != null && !(isRandom = section.getBoolean("toggle", false))) {
            String row_uno = section.getString("types.row-1", "");
            String row_dos = section.getString("types.row-2", "");
            String row_tres = section.getString("types.row-3", "");
            if (row_uno.isEmpty() || row_dos.isEmpty() || row_tres.isEmpty()) {
                if (MiscUtils.isLogging()) {
                    ComponentLogger logger = this.plugin.getComponentLogger();
                    logger.warn("One of your tiers in the config is empty.");
                    logger.warn("Tier 1: {}", (Object)row_uno);
                    logger.warn("Tier 2: {}", (Object)row_dos);
                    logger.warn("Tier 3: {}", (Object)row_tres);
                }
                return;
            }
        }
        if (!(keyCheck = this.userManager.takeKeys(this.uuid, fileName, type, this.crate.useRequiredKeys() ? this.crate.getRequiredKeys() : 1, checkHand))) {
            this.crateManager.removePlayerFromOpeningList(this.player);
            return;
        }
        this.setDisplayItems(true);
        this.runAtFixedRate(this.plugin, 1L, 1L);
        this.player.openInventory(this.inventory);
    }

    private void setDisplayItems(boolean isStatic) {
        ConfigurationSection section = this.crate.getFile().getConfigurationSection("Crate.random");
        if (isStatic) {
            for (int index = 0; index < 27; ++index) {
                this.setItem(index, this.getRandomGlassPane());
            }
        }
        if (section != null) {
            Tier tierTres;
            Tier tierDos;
            boolean isRandom = section.getBoolean("toggle", false);
            if (isRandom) {
                List<Tier> tiers = this.crate.getTiers();
                int size = tiers.size();
                ThreadLocalRandom random = ThreadLocalRandom.current();
                this.setItem(2, this.getDisplayItem(tiers.get(random.nextInt(size))));
                this.setItem(11, this.getDisplayItem(tiers.get(random.nextInt(size))));
                this.setItem(20, this.getDisplayItem(tiers.get(random.nextInt(size))));
                this.setItem(4, this.getDisplayItem(tiers.get(random.nextInt(size))));
                this.setItem(13, this.getDisplayItem(tiers.get(random.nextInt(size))));
                this.setItem(22, this.getDisplayItem(tiers.get(random.nextInt(size))));
                this.setItem(6, this.getDisplayItem(tiers.get(random.nextInt(size))));
                this.setItem(15, this.getDisplayItem(tiers.get(random.nextInt(size))));
                this.setItem(24, this.getDisplayItem(tiers.get(random.nextInt(size))));
                return;
            }
            String row_uno = section.getString("types.row-1", "");
            String row_dos = section.getString("types.row-2", "");
            String row_tres = section.getString("types.row-3", "");
            Tier tierUno = this.crate.getTier(row_uno);
            if (tierUno != null) {
                this.setItem(2, this.getDisplayItem(tierUno));
                this.setItem(11, this.getDisplayItem(tierUno));
                this.setItem(20, this.getDisplayItem(tierUno));
            }
            if ((tierDos = this.crate.getTier(row_dos)) != null) {
                this.setItem(4, this.getDisplayItem(tierDos));
                this.setItem(13, this.getDisplayItem(tierDos));
                this.setItem(22, this.getDisplayItem(tierDos));
            }
            if ((tierTres = this.crate.getTier(row_tres)) != null) {
                this.setItem(6, this.getDisplayItem(tierTres));
                this.setItem(15, this.getDisplayItem(tierTres));
                this.setItem(24, this.getDisplayItem(tierTres));
            }
        }
    }

    private void cycle() {
        for (int index = 0; index < 27; ++index) {
            PersistentDataContainerView container;
            ItemStack itemStack = this.inventory.getItem(index);
            if (itemStack == null || (container = itemStack.getPersistentDataContainer()).has(Keys.crate_prize.getNamespacedKey())) continue;
            this.setItem(index, this.getRandomGlassPane());
        }
        this.setDisplayItems(false);
    }
}

