/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.tasks.crates.other;

import com.badbones69.crazycrates.api.PrizeManager;
import com.badbones69.crazycrates.api.builders.ItemBuilder;
import com.badbones69.crazycrates.api.enums.misc.Keys;
import com.badbones69.crazycrates.api.objects.Crate;
import com.badbones69.crazycrates.api.objects.Tier;
import com.badbones69.crazycrates.tasks.crates.other.AbstractCrateManager;
import io.papermc.paper.persistence.PersistentDataContainerView;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CosmicCrateManager
extends AbstractCrateManager {
    private final ItemBuilder mysteryCrate;
    private final ItemBuilder pickedCrate;
    private final YamlConfiguration file;
    private final int totalPrizes;
    private final Map<UUID, Map<Integer, Tier>> prizes = new HashMap<UUID, Map<Integer, Tier>>();

    public CosmicCrateManager(@NotNull YamlConfiguration file) {
        this.file = file;
        String path = "Crate.Crate-Type-Settings.";
        this.totalPrizes = file.getInt(path + "Total-Prize-Amount", 4);
        this.mysteryCrate = (ItemBuilder)((ItemBuilder)((ItemBuilder)((ItemBuilder)((ItemBuilder)((ItemBuilder)new ItemBuilder().withType(file.getString(path + "Mystery-Crate.Item", "chest").toLowerCase())).setDisplayName(file.getString(path + "Mystery-Crate.Name", "<bold><white>???</bold>"))).setHidingItemFlags(file.getBoolean(path + "Mystery-Crate.HideItemFlags", false))).setDisplayLore(file.contains(path + "Mystery-Crate.Lore") ? file.getStringList(path + "Mystery-Crate.Lore") : Collections.singletonList("<gray>You may choose 4 crates."))).setPersistentInteger(Keys.cosmic_mystery_crate.getNamespacedKey(), 1)).setCustomModelData(file.getInt(path + "Mystery-Crate.Custom-Model-Data", -1));
        this.pickedCrate = (ItemBuilder)((ItemBuilder)((ItemBuilder)((ItemBuilder)((ItemBuilder)((ItemBuilder)new ItemBuilder().withType(file.getString(path + "Picked-Crate.Item", "gray_stained_glass_pane").toLowerCase())).setDisplayName(file.getString(path + "Picked-Crate.Name", "<bold><white>???</white>"))).setHidingItemFlags(file.getBoolean(path + "Picked-Crate.HideItemFlags", false))).setDisplayLore(file.contains(path + "Picked-Crate.Lore") ? file.getStringList(path + "Picked-Crate.Lore") : Collections.singletonList("<gray>You have chosen #%slot%."))).setPersistentInteger(Keys.cosmic_picked_crate.getNamespacedKey(), 1)).setCustomModelData(file.getInt(path + "Picked-Crate.Custom-Model-Data", -1));
    }

    @NotNull
    public final YamlConfiguration getFile() {
        return this.file;
    }

    public final int getTotalPrizes() {
        return this.totalPrizes;
    }

    @NotNull
    public final ItemBuilder getMysteryCrate() {
        return this.mysteryCrate;
    }

    @NotNull
    public final ItemBuilder getPickedCrate() {
        return this.pickedCrate;
    }

    public final Tier getTier(@NotNull ItemStack itemStack, @NotNull Crate crate) {
        PersistentDataContainerView container = itemStack.getPersistentDataContainer();
        if (container.has(Keys.crate_tier.getNamespacedKey())) {
            return crate.getTier((String)container.get(Keys.crate_tier.getNamespacedKey(), PersistentDataType.STRING));
        }
        return PrizeManager.getTier(crate);
    }

    public void setTier(@NotNull ItemBuilder itemBuilder, @Nullable String name) {
        if (name == null || name.isEmpty()) {
            return;
        }
        itemBuilder.setPersistentString(Keys.crate_tier.getNamespacedKey(), name);
    }

    public void addPickedPrize(@NotNull Player player, final int slot, final @NotNull Tier tier) {
        UUID uuid = player.getUniqueId();
        if (this.prizes.containsKey(uuid)) {
            this.prizes.get(uuid).put(slot, tier);
            return;
        }
        this.prizes.put(uuid, (Map<Integer, Tier>)new HashMap<Integer, Tier>(){
            {
                this.put(slot, tier);
            }
        });
    }

    public void removePickedPrize(@NotNull Player player, int slot) {
        UUID uuid = player.getUniqueId();
        Map<Integer, Tier> map = this.prizes.get(player.getUniqueId());
        map.entrySet().removeIf(value -> (Integer)value.getKey() == slot);
        if (map.isEmpty()) {
            this.prizes.remove(uuid);
        }
    }

    public void removePickedPlayer(@NotNull Player player) {
        this.prizes.remove(player.getUniqueId());
    }

    public final Map<Integer, Tier> getPrizes(@NotNull Player player) {
        return Collections.unmodifiableMap(this.prizes.getOrDefault(player.getUniqueId(), new HashMap()));
    }
}

