/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.tasks.crates;

import ch.jalu.configme.SettingsManager;
import com.Zrips.CMI.Modules.ModuleHandling.CMIModule;
import com.badbones69.crazycrates.CrazyCrates;
import com.badbones69.crazycrates.api.ChestManager;
import com.badbones69.crazycrates.api.builders.CrateBuilder;
import com.badbones69.crazycrates.api.builders.ItemBuilder;
import com.badbones69.crazycrates.api.enums.Messages;
import com.badbones69.crazycrates.api.enums.misc.Files;
import com.badbones69.crazycrates.api.enums.misc.Keys;
import com.badbones69.crazycrates.api.objects.Crate;
import com.badbones69.crazycrates.api.objects.Prize;
import com.badbones69.crazycrates.api.objects.Tier;
import com.badbones69.crazycrates.api.objects.crates.BrokeLocation;
import com.badbones69.crazycrates.api.objects.crates.CrateHologram;
import com.badbones69.crazycrates.api.objects.crates.CrateLocation;
import com.badbones69.crazycrates.api.objects.crates.quadcrates.CrateSchematic;
import com.badbones69.crazycrates.common.config.ConfigManager;
import com.badbones69.crazycrates.common.config.impl.ConfigKeys;
import com.badbones69.crazycrates.managers.InventoryManager;
import com.badbones69.crazycrates.managers.events.enums.EventType;
import com.badbones69.crazycrates.support.holograms.HologramManager;
import com.badbones69.crazycrates.support.holograms.types.CMIHologramsSupport;
import com.badbones69.crazycrates.support.holograms.types.DecentHologramsSupport;
import com.badbones69.crazycrates.support.holograms.types.FancyHologramsSupport;
import com.badbones69.crazycrates.tasks.crates.types.CasinoCrate;
import com.badbones69.crazycrates.tasks.crates.types.CosmicCrate;
import com.badbones69.crazycrates.tasks.crates.types.CrateOnTheGo;
import com.badbones69.crazycrates.tasks.crates.types.CsgoCrate;
import com.badbones69.crazycrates.tasks.crates.types.FireCrackerCrate;
import com.badbones69.crazycrates.tasks.crates.types.QuadCrate;
import com.badbones69.crazycrates.tasks.crates.types.QuickCrate;
import com.badbones69.crazycrates.tasks.crates.types.RouletteCrate;
import com.badbones69.crazycrates.tasks.crates.types.WarCrate;
import com.badbones69.crazycrates.tasks.crates.types.WheelCrate;
import com.badbones69.crazycrates.tasks.crates.types.WonderCrate;
import com.badbones69.crazycrates.tasks.menus.CrateMainMenu;
import com.badbones69.crazycrates.utils.ItemUtils;
import com.badbones69.crazycrates.utils.MiscUtils;
import io.papermc.paper.persistence.PersistentDataContainerView;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TimerTask;
import java.util.UUID;
import java.util.WeakHashMap;
import libs.com.ryderbelserion.vital.common.utils.FileUtil;
import libs.com.ryderbelserion.vital.paper.api.enums.Support;
import libs.com.ryderbelserion.vital.paper.api.files.CustomFile;
import libs.com.ryderbelserion.vital.paper.api.files.FileManager;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.PluginManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import us.crazycrew.crazycrates.api.enums.types.CrateType;
import us.crazycrew.crazycrates.api.enums.types.KeyType;

public class CrateManager {
    private final CrazyCrates plugin = CrazyCrates.getPlugin();
    private final InventoryManager inventoryManager = this.plugin.getInventoryManager();
    private final FileManager fileManager = this.plugin.getVital().getFileManager();
    private final List<CrateLocation> crateLocations = new ArrayList<CrateLocation>();
    private final List<CrateSchematic> crateSchematics = new ArrayList<CrateSchematic>();
    private final List<BrokeLocation> brokeLocations = new ArrayList<BrokeLocation>();
    private final Map<UUID, Location> cratesInUse = new HashMap<UUID, Location>();
    private final List<String> brokeCrates = new ArrayList<String>();
    private final List<Crate> crates = new ArrayList<Crate>();
    private final Map<UUID, Map<Integer, Tier>> tiers = new WeakHashMap<UUID, Map<Integer, Tier>>();
    private HologramManager holograms;
    private boolean giveNewPlayersKeys;
    private final SettingsManager config = ConfigManager.getConfig();
    private final Map<UUID, Crate> playerOpeningCrates = new HashMap<UUID, Crate>();
    private final Map<UUID, KeyType> playerKeys = new HashMap<UUID, KeyType>();
    private final Map<UUID, ScheduledTask> currentTasks = new HashMap<UUID, ScheduledTask>();
    private final Map<UUID, TimerTask> timerTasks = new HashMap<UUID, TimerTask>();
    private final Map<UUID, List<ScheduledTask>> currentQuadTasks = new HashMap<UUID, List<ScheduledTask>>();
    private final Map<UUID, Boolean> canPick = new HashMap<UUID, Boolean>();
    private final Map<UUID, Boolean> canClose = new HashMap<UUID, Boolean>();
    private final Map<UUID, Boolean> checkHands = new HashMap<UUID, Boolean>();
    private final List<Entity> allRewards = new ArrayList<Entity>();
    private final Map<UUID, Entity> rewards = new HashMap<UUID, Entity>();
    private final Map<UUID, ArrayList<Integer>> slots = new HashMap<UUID, ArrayList<Integer>>();

    public void addTier(Player player, final int slot, final Tier tier) {
        if (this.tiers.containsKey(player.getUniqueId())) {
            this.tiers.get(player.getUniqueId()).put(slot, tier);
            return;
        }
        this.tiers.put(player.getUniqueId(), (Map<Integer, Tier>)new WeakHashMap<Integer, Tier>(this){
            {
                this.put(slot, tier);
            }
        });
    }

    public void removeTier(Player player) {
        this.tiers.remove(player.getUniqueId());
    }

    public final Tier getTier(Player player, int slot) {
        return this.tiers.get(player.getUniqueId()).get(slot);
    }

    public Map<UUID, Map<Integer, Tier>> getTiers() {
        return Collections.unmodifiableMap(this.tiers);
    }

    public void reloadCrate(@Nullable Crate crate) {
        block10: {
            try {
                if (crate == null) {
                    return;
                }
                YamlConfiguration file = crate.getFile();
                this.inventoryManager.closePreview();
                crate.purge();
                ArrayList<Prize> prizes = new ArrayList<Prize>();
                ConfigurationSection prizesSection = file.getConfigurationSection("Crate.Prizes");
                if (prizesSection != null) {
                    for (String prize : prizesSection.getKeys(false)) {
                        boolean isEnabled;
                        Object list;
                        ConfigurationSection prizeSection = prizesSection.getConfigurationSection(prize);
                        ArrayList<Tier> tierPrizes = new ArrayList<Tier>();
                        if (prizeSection == null) continue;
                        ArrayList<ItemStack> editorItems = new ArrayList<ItemStack>();
                        if (prizeSection.contains("Editor-Items") && (list = prizeSection.getList("Editor-Items")) != null) {
                            Iterator iterator = list.iterator();
                            while (iterator.hasNext()) {
                                Object key = iterator.next();
                                editorItems.add((ItemStack)key);
                            }
                        }
                        list = prizeSection.getStringList("Tiers").iterator();
                        while (list.hasNext()) {
                            String tier = (String)list.next();
                            for (Tier key : crate.getTiers()) {
                                if (!key.getName().equalsIgnoreCase(tier)) continue;
                                tierPrizes.add(key);
                            }
                        }
                        Prize alternativePrize = null;
                        ConfigurationSection alternativeSection = prizeSection.getConfigurationSection("Alternative-Prize");
                        if (alternativeSection != null && (isEnabled = alternativeSection.getBoolean("Toggle"))) {
                            alternativePrize = new Prize(prizeSection.getString("DisplayName", ""), prizeSection.getName(), alternativeSection);
                        }
                        prizes.add(new Prize(prizeSection, editorItems, tierPrizes, crate.getFileName(), alternativePrize));
                    }
                }
                crate.setPrize(prizes);
                this.inventoryManager.openPreview(crate);
            }
            catch (Exception exception) {
                String fileName = crate.getFileName();
                this.brokeCrates.add(fileName);
                if (!MiscUtils.isLogging()) break block10;
                this.plugin.getComponentLogger().warn("There was an error while loading the {}.yml file.", (Object)fileName, (Object)exception);
            }
        }
    }

    public void loadHolograms() {
        String pluginName = this.config.getProperty(ConfigKeys.hologram_plugin);
        if (this.holograms != null && !pluginName.isEmpty()) {
            this.holograms.purge(false);
        }
        switch (pluginName) {
            case "DecentHolograms": {
                if (!Support.decent_holograms.isEnabled()) {
                    return;
                }
                this.holograms = new DecentHologramsSupport();
                break;
            }
            case "FancyHolograms": {
                if (!Support.fancy_holograms.isEnabled()) {
                    return;
                }
                this.holograms = new FancyHologramsSupport();
                break;
            }
            case "CMI": {
                if (!Support.cmi.isEnabled() && !CMIModule.holograms.isEnabled()) {
                    return;
                }
                this.holograms = new CMIHologramsSupport();
                break;
            }
            default: {
                if (Support.decent_holograms.isEnabled()) {
                    this.holograms = new DecentHologramsSupport();
                    break;
                }
                if (Support.fancy_holograms.isEnabled()) {
                    this.holograms = new FancyHologramsSupport();
                    break;
                }
                if (!Support.cmi.isEnabled() || !CMIModule.holograms.isEnabled()) break;
                this.holograms = new CMIHologramsSupport();
            }
        }
        if (this.holograms == null) {
            if (MiscUtils.isLogging()) {
                List.of("There was no hologram plugin found on the server. If you are using CMI", "Please make sure you enabled the hologram module in modules.yml", "You can run /crazycrates reload if using CMI otherwise restart your server.").forEach(arg_0 -> ((ComponentLogger)this.plugin.getComponentLogger()).warn(arg_0));
            }
            return;
        }
        if (MiscUtils.isLogging()) {
            this.plugin.getComponentLogger().info("{} support has been enabled.", (Object)this.holograms.getName());
        }
    }

    public List<String> getCrateNames() {
        return this.plugin.getInstance().getCrateFiles();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void loadCrates() {
        String[] schems;
        if (ConfigManager.getConfig().getProperty(ConfigKeys.update_examples_folder).booleanValue()) {
            Path path = this.plugin.getDataFolder().toPath();
            Class<@NotNull ?> classObject = ((Object)((Object)this.plugin)).getClass();
            List.of("config.yml", "data.yml", "locations.yml", "messages.yml").forEach(file -> FileUtil.extract(file, "examples", true));
            FileUtil.extracts(classObject, "/guis/", path.resolve("examples").resolve("guis"), true);
            FileUtil.extracts(classObject, "/logs/", path.resolve("examples").resolve("logs"), true);
            FileUtil.extracts(classObject, "/crates/", path.resolve("examples").resolve("crates"), true);
            FileUtil.extracts(classObject, "/schematics/", path.resolve("examples").resolve("schematics"), true);
        }
        this.giveNewPlayersKeys = false;
        this.purge();
        if (this.holograms != null) {
            this.holograms.purge(false);
        }
        if (MiscUtils.isLogging()) {
            this.plugin.getComponentLogger().info("Loading all crate information...");
        }
        for (String crateName : this.getCrateNames()) {
            try {
                PermissionDefault permissionDefault;
                boolean isTiersEmpty;
                YamlConfiguration file2;
                CustomFile customFile = this.fileManager.getFile(crateName, true);
                if (customFile == null || (file2 = customFile.getConfiguration()) == null) continue;
                CrateType crateType = CrateType.getFromName(file2.getString("Crate.CrateType", "CSGO"));
                ArrayList<Prize> prizes = new ArrayList<Prize>();
                ArrayList<Tier> tiers = new ArrayList<Tier>();
                String previewName = file2.contains("Crate.Preview-Name") ? file2.getString("Crate.Preview-Name", " ") : (file2.contains("Crate.Preview.Name") ? file2.getString("Crate.Preview.Name", " ") : (file2.contains("Crate.CrateName") ? file2.getString("Crate.CrateName", " ") : file2.getString("Crate.Name", " ")));
                int maxMassOpen = file2.getInt("Crate.Max-Mass-Open", 10);
                int requiredKeys = file2.getInt("Crate.RequiredKeys", 0);
                ConfigurationSection section = file2.getConfigurationSection("Crate.Tiers");
                if (file2.contains("Crate.Tiers") && section != null) {
                    for (String tier : section.getKeys(false)) {
                        String path = "Crate.Tiers." + tier;
                        ConfigurationSection tierSection = file2.getConfigurationSection(path);
                        if (tierSection == null) continue;
                        tiers.add(new Tier(tier, tierSection));
                    }
                }
                boolean bl = isTiersEmpty = crateType == CrateType.cosmic || crateType == CrateType.casino;
                if (isTiersEmpty && tiers.isEmpty()) {
                    this.brokeCrates.add(crateName);
                    if (!MiscUtils.isLogging()) continue;
                    this.plugin.getComponentLogger().warn("No tiers were found for {}.yml file.", (Object)crateName);
                    continue;
                }
                ConfigurationSection prizesSection = file2.getConfigurationSection("Crate.Prizes");
                if (prizesSection != null) {
                    for (String prize : prizesSection.getKeys(false)) {
                        boolean isEnabled;
                        Object keys;
                        ConfigurationSection prizeSection = prizesSection.getConfigurationSection(prize);
                        ArrayList<Tier> tierPrizes = new ArrayList<Tier>();
                        Prize alternativePrize = null;
                        if (prizeSection == null) continue;
                        ArrayList<ItemStack> editorItems = new ArrayList<ItemStack>();
                        if (prizeSection.contains("Editor-Items") && (keys = prizeSection.getList("Editor-Items")) != null) {
                            Iterator iterator = keys.iterator();
                            while (iterator.hasNext()) {
                                Object key = iterator.next();
                                editorItems.add((ItemStack)key);
                            }
                        }
                        keys = prizeSection.getStringList("Tiers").iterator();
                        while (keys.hasNext()) {
                            String tier = (String)keys.next();
                            for (Tier key : tiers) {
                                if (!key.getName().equalsIgnoreCase(tier)) continue;
                                tierPrizes.add(key);
                            }
                        }
                        ConfigurationSection alternativeSection = prizeSection.getConfigurationSection("Alternative-Prize");
                        if (alternativeSection != null && (isEnabled = alternativeSection.getBoolean("Toggle"))) {
                            alternativePrize = new Prize(prizeSection.getString("DisplayName", "<lang:item.minecraft." + prizeSection.getString("DisplayItem", "stone").toLowerCase() + ">"), prizeSection.getName(), alternativeSection);
                        }
                        prizes.add(new Prize(prizeSection, editorItems, tierPrizes, crateName, alternativePrize));
                    }
                }
                int newPlayersKeys = file2.getInt("Crate.StartingKeys", 0);
                if (!this.giveNewPlayersKeys && newPlayersKeys > 0) {
                    this.giveNewPlayersKeys = true;
                }
                List prizeMessage = file2.contains("Crate.Prize-Message") ? file2.getStringList("Crate.Prize-Message") : Collections.emptyList();
                List prizeCommands = file2.contains("Crate.Prize-Commands") ? file2.getStringList("Crate.Prize-Commands") : Collections.emptyList();
                CrateHologram holo = new CrateHologram(file2.getBoolean("Crate.Hologram.Toggle"), file2.getDouble("Crate.Hologram.Height", 0.0), file2.getInt("Crate.Hologram.Range", 8), file2.getString("Crate.Hologram.Color", "transparent"), file2.getInt("Crate.Hologram.Update-Interval", -1), file2.getStringList("Crate.Hologram.Message"));
                this.addCrate(new Crate(crateName, previewName, crateType, this.getKey((FileConfiguration)file2), file2.getString("Crate.PhysicalKey.Name", "Crate.PhysicalKey.Name is missing from " + crateName + ".yml"), prizes, file2, newPlayersKeys, tiers, maxMassOpen, requiredKeys, prizeMessage, prizeCommands, holo));
                PluginManager server = this.plugin.getServer().getPluginManager();
                boolean isNewSystemEnabled = this.config.getProperty(ConfigKeys.use_new_permission_system);
                String node = isNewSystemEnabled ? "crazycrates.deny.open." + crateName : "crazycrates.open." + crateName;
                String description = isNewSystemEnabled ? "Prevents you from opening " + crateName : "Allows you to open " + crateName;
                PermissionDefault permissionDefault2 = permissionDefault = isNewSystemEnabled ? PermissionDefault.FALSE : PermissionDefault.TRUE;
                if (server.getPermission(node) != null) continue;
                Permission permission = new Permission(node, description, permissionDefault);
                server.addPermission(permission);
            }
            catch (Exception exception) {
                this.brokeCrates.add(crateName);
                if (!MiscUtils.isLogging()) continue;
                this.plugin.getComponentLogger().warn("There was an error while loading the {}.yml file.", (Object)crateName, (Object)exception);
            }
        }
        this.addCrate(new Crate("Menu"));
        if (MiscUtils.isLogging()) {
            List.of("All crate information has been loaded.", "Loading all the physical crate locations.").forEach(line -> this.plugin.getComponentLogger().info(line));
        }
        YamlConfiguration locations = Files.locations.getConfiguration();
        int loadedAmount = 0;
        int brokeAmount = 0;
        ConfigurationSection section = locations.getConfigurationSection("Locations");
        if (section != null) {
            for (String locationName : section.getKeys(false)) {
                try {
                    String worldName = locations.getString("Locations." + locationName + ".World");
                    if (worldName == null) {
                        return;
                    }
                    if (worldName.isEmpty() || worldName.isBlank()) {
                        return;
                    }
                    World world = this.plugin.getServer().getWorld(worldName);
                    int x = locations.getInt("Locations." + locationName + ".X");
                    int y = locations.getInt("Locations." + locationName + ".Y");
                    int z = locations.getInt("Locations." + locationName + ".Z");
                    Location location = new Location(world, (double)x, (double)y, (double)z);
                    Crate crate = this.getCrateFromName(locations.getString("Locations." + locationName + ".Crate"));
                    if (world != null && crate != null) {
                        this.crateLocations.add(new CrateLocation(locationName, crate, location));
                        if (this.holograms != null) {
                            this.holograms.createHologram(location, crate, locationName);
                        }
                        ++loadedAmount;
                        continue;
                    }
                    this.brokeLocations.add(new BrokeLocation(locationName, crate, x, y, z, worldName));
                    ++brokeAmount;
                }
                catch (Exception exception) {}
            }
        }
        if (MiscUtils.isLogging()) {
            ComponentLogger logger = this.plugin.getComponentLogger();
            if (loadedAmount > 0 || brokeAmount > 0) {
                if (brokeAmount <= 0) {
                    logger.info("All physical crate locations have been loaded.");
                } else {
                    logger.info("Loaded {} physical crate locations.", (Object)loadedAmount);
                    logger.info("Failed to load {} physical crate locations.", (Object)brokeAmount);
                }
            }
            logger.info("Searching for schematics to load.");
        }
        if ((schems = new File(String.valueOf(this.plugin.getDataFolder()) + "/schematics/").list()) != null) {
            for (String schematicName : schems) {
                if (!schematicName.endsWith(".nbt")) continue;
                this.crateSchematics.add(new CrateSchematic(schematicName, new File(String.valueOf(this.plugin.getDataFolder()) + "/schematics/" + schematicName)));
                if (!MiscUtils.isLogging()) continue;
                this.plugin.getComponentLogger().info("{} was successfully found and loaded.", (Object)schematicName);
            }
        }
        if (MiscUtils.isLogging()) {
            this.plugin.getComponentLogger().info("All schematics were found and loaded.");
        }
        this.cleanDataFile();
        this.inventoryManager.loadButtons();
    }

    public void openCrate(@NotNull Player player, @NotNull Crate crate, @NotNull KeyType keyType, @NotNull Location location, boolean virtualCrate, boolean checkHand, EventType eventType) {
        this.openCrate(player, crate, keyType, location, virtualCrate, checkHand, false, eventType);
    }

    public void openCrate(@NotNull Player player, @NotNull Crate crate, @NotNull KeyType keyType, @NotNull Location location, boolean virtualCrate, boolean checkHand, boolean isSilent, EventType eventType) {
        CrateBuilder crateBuilder;
        SettingsManager config = ConfigManager.getConfig();
        if (crate.getCrateType() == CrateType.menu) {
            if (config.getProperty(ConfigKeys.enable_crate_menu).booleanValue()) {
                new CrateMainMenu(player, this.config.getProperty(ConfigKeys.inventory_name), this.config.getProperty(ConfigKeys.inventory_rows)).open();
                return;
            }
            Messages.feature_disabled.sendMessage((CommandSender)player);
            return;
        }
        String fancyName = crate.getCrateName();
        switch (crate.getCrateType()) {
            case csgo: {
                crateBuilder = new CsgoCrate(crate, player, 27);
                break;
            }
            case casino: {
                crateBuilder = new CasinoCrate(crate, player, 27);
                break;
            }
            case wonder: {
                crateBuilder = new WonderCrate(crate, player, 45);
                break;
            }
            case wheel: {
                crateBuilder = new WheelCrate(crate, player, 54);
                break;
            }
            case roulette: {
                crateBuilder = new RouletteCrate(crate, player, 27);
                break;
            }
            case war: {
                crateBuilder = new WarCrate(crate, player, 9);
                break;
            }
            case cosmic: {
                crateBuilder = new CosmicCrate(crate, player, 27);
                break;
            }
            case quad_crate: {
                if (virtualCrate) {
                    HashMap<String, String> placeholders = new HashMap<String, String>();
                    placeholders.put("{cratetype}", crate.getCrateType().getName());
                    placeholders.put("{crate}", fancyName);
                    Messages.cant_be_a_virtual_crate.sendMessage((CommandSender)player, placeholders);
                    this.removePlayerFromOpeningList(player);
                    return;
                }
                crateBuilder = new QuadCrate(crate, player, location);
                break;
            }
            case fire_cracker: {
                if (this.cratesInUse.containsValue(location)) {
                    Messages.crate_in_use.sendMessage((CommandSender)player, "{crate}", fancyName);
                    this.removePlayerFromOpeningList(player);
                    return;
                }
                if (virtualCrate) {
                    HashMap<String, String> placeholders = new HashMap<String, String>();
                    placeholders.put("{cratetype}", crate.getCrateType().getName());
                    placeholders.put("{crate}", fancyName);
                    Messages.cant_be_a_virtual_crate.sendMessage((CommandSender)player, placeholders);
                    this.removePlayerFromOpeningList(player);
                    return;
                }
                crateBuilder = new FireCrackerCrate(crate, player, 45, location);
                break;
            }
            case crate_on_the_go: {
                if (virtualCrate) {
                    HashMap<String, String> placeholders = new HashMap<String, String>();
                    placeholders.put("{cratetype}", crate.getCrateType().getName());
                    placeholders.put("{crate}", fancyName);
                    Messages.cant_be_a_virtual_crate.sendMessage((CommandSender)player, placeholders);
                    this.removePlayerFromOpeningList(player);
                    return;
                }
                crateBuilder = new CrateOnTheGo(crate, player);
                break;
            }
            case quick_crate: {
                if (this.cratesInUse.containsValue(location)) {
                    Messages.crate_in_use.sendMessage((CommandSender)player, "{crate}", fancyName);
                    this.removePlayerFromOpeningList(player);
                    return;
                }
                if (virtualCrate) {
                    HashMap<String, String> placeholders = new HashMap<String, String>();
                    placeholders.put("{cratetype}", crate.getCrateType().getName());
                    placeholders.put("{crate}", fancyName);
                    Messages.cant_be_a_virtual_crate.sendMessage((CommandSender)player, placeholders);
                    this.removePlayerFromOpeningList(player);
                    return;
                }
                crateBuilder = new QuickCrate(crate, player, location);
                break;
            }
            default: {
                crateBuilder = new CsgoCrate(crate, player, 27);
                if (!MiscUtils.isLogging()) break;
                ComponentLogger logger = this.plugin.getComponentLogger();
                List.of(crate.getFileName() + " has an invalid crate type. Your Value: " + crate.getFile().getString("Crate.CrateType", "CSGO"), "We will use " + CrateType.csgo.getName() + " until you change the crate type.", "Valid Crate Types: CSGO/Casino/Cosmic/QuadCrate/QuickCrate/Roulette/CrateOnTheGo/FireCracker/Wonder/Wheel/War").forEach(arg_0 -> ((ComponentLogger)logger).warn(arg_0));
            }
        }
        ((CrateBuilder)crateBuilder).open(keyType, checkHand, isSilent, eventType);
    }

    public void addCrateInUse(@NotNull Player player, @NotNull Location location) {
        this.cratesInUse.put(player.getUniqueId(), location);
    }

    public Location getCrateInUseLocation(@NotNull Player player) {
        return this.cratesInUse.get(player.getUniqueId());
    }

    public boolean isCrateInUse(@NotNull Player player) {
        return this.cratesInUse.containsKey(player.getUniqueId());
    }

    public void removeCrateInUse(@NotNull Player player) {
        this.cratesInUse.remove(player.getUniqueId());
    }

    public Map<UUID, Location> getCratesInUse() {
        return Collections.unmodifiableMap(this.cratesInUse);
    }

    public void endCrate(@NotNull Player player) {
        UUID uuid = player.getUniqueId();
        if (this.currentTasks.containsKey(uuid)) {
            this.currentTasks.get(uuid).cancel();
        }
    }

    public void endQuadCrate(@NotNull Player player) {
        UUID uuid = player.getUniqueId();
        if (this.currentQuadTasks.containsKey(uuid)) {
            for (ScheduledTask task : this.currentQuadTasks.get(uuid)) {
                task.cancel();
            }
            this.currentQuadTasks.remove(uuid);
        }
    }

    public void addQuadCrateTask(@NotNull Player player, @NotNull ScheduledTask task) {
        UUID uuid = player.getUniqueId();
        if (!this.currentQuadTasks.containsKey(uuid)) {
            this.currentQuadTasks.put(uuid, new ArrayList());
        }
        this.currentQuadTasks.get(uuid).add(task);
    }

    public boolean hasQuadCrateTask(@NotNull Player player) {
        return this.currentQuadTasks.containsKey(player.getUniqueId());
    }

    public void addCrateTask(@NotNull Player player, @NotNull ScheduledTask task) {
        this.currentTasks.put(player.getUniqueId(), task);
    }

    public void addRepeatingCrateTask(@NotNull Player player, @NotNull TimerTask task, long delay, long period) {
        this.timerTasks.put(player.getUniqueId(), task);
        this.plugin.getTimer().scheduleAtFixedRate(task, delay, period);
    }

    public void removeCrateTask(@NotNull Player player) {
        TimerTask task = this.timerTasks.remove(player.getUniqueId());
        if (task != null) {
            task.cancel();
        }
    }

    public void addCrateTask(Player player, TimerTask task, Long delay) {
        this.timerTasks.put(player.getUniqueId(), task);
        this.plugin.getTimer().schedule(task, delay);
    }

    public final ScheduledTask getCrateTask(@NotNull Player player) {
        return this.currentTasks.get(player.getUniqueId());
    }

    public final boolean hasCrateTask(@NotNull Player player) {
        return this.currentTasks.containsKey(player.getUniqueId());
    }

    public void addPlayerToOpeningList(@NotNull Player player, @NotNull Crate crate) {
        this.playerOpeningCrates.put(player.getUniqueId(), crate);
    }

    public void removePlayerFromOpeningList(@NotNull Player player) {
        this.playerOpeningCrates.remove(player.getUniqueId());
    }

    public boolean isInOpeningList(@NotNull Player player) {
        return this.playerOpeningCrates.containsKey(player.getUniqueId());
    }

    public final Crate getOpeningCrate(@NotNull Player player) {
        return this.playerOpeningCrates.get(player.getUniqueId());
    }

    public void addPlayerKeyType(@NotNull Player player, @NotNull KeyType keyType) {
        this.playerKeys.put(player.getUniqueId(), keyType);
    }

    public void removePlayerKeyType(@NotNull Player player) {
        this.playerKeys.remove(player.getUniqueId());
    }

    public final boolean hasPlayerKeyType(@NotNull Player player) {
        return this.playerKeys.containsKey(player.getUniqueId());
    }

    @Nullable
    public final KeyType getPlayerKeyType(@NotNull Player player) {
        return this.playerKeys.get(player.getUniqueId());
    }

    public void purge() {
        this.crates.clear();
        this.brokeCrates.clear();
        this.crateLocations.clear();
        this.crateSchematics.clear();
    }

    public void setNewPlayerKeys(@NotNull Player player) {
        if (this.giveNewPlayersKeys) {
            String uuid = player.getUniqueId().toString();
            if (!player.hasPlayedBefore()) {
                this.getUsableCrates().stream().filter(Crate::doNewPlayersGetKeys).forEach(crate -> {
                    Files.data.getConfiguration().set("Players." + uuid + "." + crate.getFileName(), (Object)crate.getNewPlayerKeys());
                    Files.data.save();
                });
            }
        }
    }

    public void addCrate(@NotNull Crate crate) {
        this.crates.add(crate);
    }

    public void addLocation(@NotNull CrateLocation crateLocation) {
        this.crateLocations.add(crateLocation);
    }

    public void removeCrate(@NotNull Crate crate) {
        this.crates.remove(crate);
    }

    public boolean hasCrate(@NotNull Crate crate) {
        return this.crates.contains(crate);
    }

    public void addCrateLocation(@NotNull Location location, @NotNull Crate crate) {
        YamlConfiguration locations = Files.locations.getConfiguration();
        Object id = "1";
        int i = 1;
        while (locations.contains("Locations." + i)) {
            id = "" + (i + 1);
            ++i;
        }
        for (CrateLocation crateLocation : this.getCrateLocations()) {
            if (!crateLocation.getLocation().equals((Object)location)) continue;
            id = crateLocation.getID();
            break;
        }
        locations.set("Locations." + (String)id + ".Crate", (Object)crate.getFileName());
        locations.set("Locations." + (String)id + ".World", (Object)location.getWorld().getName());
        locations.set("Locations." + (String)id + ".X", (Object)location.getBlockX());
        locations.set("Locations." + (String)id + ".Y", (Object)location.getBlockY());
        locations.set("Locations." + (String)id + ".Z", (Object)location.getBlockZ());
        Files.locations.save();
        this.addLocation(new CrateLocation((String)id, crate, location));
        if (this.holograms != null) {
            this.holograms.createHologram(location, crate, (String)id);
        }
    }

    public void removeCrateLocation(@NotNull String id) {
        Files.locations.getConfiguration().set("Locations." + id, null);
        Files.locations.save();
        CrateLocation location = null;
        for (CrateLocation crateLocation : this.getCrateLocations()) {
            if (!crateLocation.getID().equalsIgnoreCase(id)) continue;
            location = crateLocation;
            break;
        }
        if (location != null) {
            this.removeLocation(location);
            if (this.holograms != null && location.getCrate().getHologram().isEnabled()) {
                this.holograms.removeHologram(location.getID());
            }
        }
    }

    @NotNull
    public final List<Crate> getUsableCrates() {
        ArrayList<Crate> crateList = new ArrayList<Crate>(this.crates);
        crateList.removeIf(crate -> crate.getCrateType() == CrateType.menu);
        return crateList;
    }

    @NotNull
    public final List<Crate> getCrates() {
        return Collections.unmodifiableList(this.crates);
    }

    @Nullable
    public final Crate getCrateFromName(@Nullable String name) {
        if (name == null) {
            return null;
        }
        if (name.isEmpty()) {
            return null;
        }
        Crate crate = null;
        for (Crate key : this.crates) {
            if (!key.getFileName().equalsIgnoreCase(name)) continue;
            crate = key;
            break;
        }
        return crate;
    }

    public final boolean isCrateLocation(@NotNull Location location) {
        for (CrateLocation crateLocation : this.getCrateLocations()) {
            if (!crateLocation.getLocation().equals((Object)location)) continue;
            return true;
        }
        return false;
    }

    public final boolean isKey(@NotNull ItemStack item) {
        return this.getCrateFromKey(item) != null;
    }

    @Nullable
    public final Crate getCrateFromKey(@NotNull ItemStack item) {
        return this.getCrateFromName(ItemUtils.getKey(item.getPersistentDataContainer()));
    }

    @Nullable
    public final CrateLocation getCrateLocation(@NotNull Location location) {
        CrateLocation crateLocation = null;
        String asString = MiscUtils.location(location);
        for (CrateLocation key : this.crateLocations) {
            String locationAsString = MiscUtils.location(key.getLocation());
            if (!locationAsString.equals(asString)) continue;
            crateLocation = key;
            break;
        }
        return crateLocation;
    }

    @Nullable
    public final Crate getCrateFromLocation(@NotNull Location location) {
        Crate crate = null;
        String asString = MiscUtils.location(location);
        for (CrateLocation key : this.crateLocations) {
            String locationAsString = MiscUtils.location(key.getLocation());
            if (!locationAsString.equals(asString)) continue;
            crate = key.getCrate();
            break;
        }
        return crate;
    }

    @Nullable
    public final CrateSchematic getCrateSchematic(@NotNull String name) {
        if (name.isEmpty()) {
            return null;
        }
        for (CrateSchematic schematic : this.crateSchematics) {
            if (!schematic.schematicName().equalsIgnoreCase(name)) continue;
            return schematic;
        }
        return null;
    }

    public final boolean isDisplayReward(@NotNull Entity entity) {
        if (entity instanceof Item) {
            Item item = (Item)entity;
            ItemStack itemStack = item.getItemStack();
            if (itemStack.getType() == Material.AIR) {
                return false;
            }
            return itemStack.getPersistentDataContainer().has(Keys.crate_prize.getNamespacedKey());
        }
        return false;
    }

    public final boolean isKeyFromCrate(@Nullable ItemStack item, @Nullable Crate crate) {
        if (item == null || crate == null) {
            return false;
        }
        if (crate.getCrateType() == CrateType.menu) {
            return false;
        }
        if (item.getType() == Material.AIR) {
            return false;
        }
        PersistentDataContainerView container = item.getPersistentDataContainer();
        if (!container.has(Keys.crate_key.getNamespacedKey())) {
            return false;
        }
        return crate.getFileName().equals(ItemUtils.getKey(container));
    }

    @Nullable
    public final HologramManager getHolograms() {
        return this.holograms;
    }

    @NotNull
    public final List<CrateLocation> getCrateLocations() {
        return Collections.unmodifiableList(this.crateLocations);
    }

    public void removeLocation(@NotNull CrateLocation crateLocation) {
        this.crateLocations.remove(crateLocation);
    }

    @NotNull
    public final List<String> getBrokeCrates() {
        return Collections.unmodifiableList(this.brokeCrates);
    }

    @NotNull
    public final List<BrokeLocation> getBrokeLocations() {
        return Collections.unmodifiableList(this.brokeLocations);
    }

    public void removeBrokeLocation(@NotNull List<BrokeLocation> crateLocation) {
        this.brokeLocations.removeAll(crateLocation);
    }

    @NotNull
    public final List<CrateSchematic> getCrateSchematics() {
        return Collections.unmodifiableList(this.crateSchematics);
    }

    private ItemBuilder getKey(@NotNull FileConfiguration file) {
        String name = file.getString("Crate.PhysicalKey.Name", "");
        int customModelData = file.getInt("Crate.PhysicalKey.Custom-Model-Data", -1);
        List lore = file.getStringList("Crate.PhysicalKey.Lore");
        boolean glowing = file.getBoolean("Crate.PhysicalKey.Glowing", true);
        boolean hideFlags = file.getBoolean("Crate.PhysicalKey.HideItemFlags", false);
        ItemBuilder itemBuilder = file.contains("Crate.PhysicalKey.Data") ? new ItemBuilder().fromBase64(file.getString("Crate.PhysicalKey.Data", "")) : (ItemBuilder)new ItemBuilder().withType(file.getString("Crate.PhysicalKey.Item", "tripwire_hook").toLowerCase());
        return (ItemBuilder)((ItemBuilder)((ItemBuilder)((ItemBuilder)((ItemBuilder)itemBuilder.setDisplayName(name)).setDisplayLore(lore)).setGlowing(glowing)).setHidingItemFlags(hideFlags)).setCustomModelData(customModelData);
    }

    private void cleanDataFile() {
        YamlConfiguration data = Files.data.getConfiguration();
        if (!data.contains("Players")) {
            return;
        }
        if (MiscUtils.isLogging()) {
            this.plugin.getComponentLogger().info("Cleaning up the data.yml file.");
        }
        ArrayList<String> removePlayers = new ArrayList<String>();
        ConfigurationSection section = data.getConfigurationSection("Players");
        if (section == null) {
            return;
        }
        for (String uuid2 : section.getKeys(false)) {
            if (data.contains("Players." + uuid2 + ".tracking")) {
                return;
            }
            boolean hasKeys = false;
            ArrayList<String> noKeys = new ArrayList<String>();
            for (Crate crate2 : this.getUsableCrates()) {
                String fileName = crate2.getFileName();
                if (data.getInt("Players." + uuid2 + "." + fileName) <= 0) {
                    noKeys.add(fileName);
                    continue;
                }
                hasKeys = true;
            }
            if (hasKeys) {
                noKeys.forEach(crate -> data.set("Players." + uuid2 + "." + crate, null));
                continue;
            }
            removePlayers.add(uuid2);
        }
        if (!removePlayers.isEmpty()) {
            if (MiscUtils.isLogging()) {
                this.plugin.getComponentLogger().info("{} player's data has been marked to be removed.", (Object)removePlayers.size());
            }
            removePlayers.forEach(uuid -> data.set("Players." + uuid, null));
            if (MiscUtils.isLogging()) {
                this.plugin.getComponentLogger().info("All empty player data has been removed.");
            }
        }
        if (MiscUtils.isLogging()) {
            this.plugin.getComponentLogger().info("The data.yml file has been cleaned.");
        }
        Files.data.save();
    }

    public void addPicker(@NotNull Player player, boolean value) {
        this.canPick.put(player.getUniqueId(), value);
    }

    public final boolean containsPicker(@NotNull Player player) {
        return this.canPick.containsKey(player.getUniqueId());
    }

    public boolean isPicker(@NotNull Player player) {
        return this.canPick.getOrDefault(player.getUniqueId(), false);
    }

    public void removePicker(@NotNull Player player) {
        this.canPick.remove(player.getUniqueId());
    }

    public void addCloser(@NotNull Player player, boolean value) {
        this.canClose.put(player.getUniqueId(), value);
    }

    public final boolean containsCloser(@NotNull Player player) {
        return this.canClose.containsKey(player.getUniqueId());
    }

    public void removeCloser(@NotNull Player player) {
        this.canClose.remove(player.getUniqueId());
    }

    public void addHands(@NotNull Player player, boolean checkHand) {
        this.checkHands.put(player.getUniqueId(), checkHand);
    }

    public void removeHands(@NotNull Player player) {
        this.checkHands.remove(player.getUniqueId());
    }

    public final boolean getHand(@NotNull Player player) {
        return this.checkHands.get(player.getUniqueId());
    }

    public void addReward(@NotNull Player player, @NotNull Entity entity) {
        this.allRewards.add(entity);
        this.rewards.put(player.getUniqueId(), entity);
    }

    public void endQuickCrate(@NotNull Player player, @NotNull Location location, @Nullable Crate crate, boolean useQuickCrateAgain) {
        CrateLocation crateLocation;
        UUID uuid;
        if (this.hasCrateTask(player)) {
            this.getCrateTask(player).cancel();
            this.removeCrateTask(player);
        }
        if (this.rewards.get(uuid = player.getUniqueId()) != null) {
            this.allRewards.remove(this.rewards.get(uuid));
            this.rewards.get(uuid).remove();
            this.rewards.remove(uuid);
        }
        ChestManager.closeChest(location.getBlock(), false);
        this.removeCrateInUse(player);
        this.removePlayerFromOpeningList(player);
        if (!useQuickCrateAgain && this.holograms != null && crate != null && crate.getHologram().isEnabled() && (crateLocation = this.getCrateLocation(location)) != null) {
            this.holograms.createHologram(location, crate, crateLocation.getID());
        }
    }

    public void purgeRewards() {
        if (!this.allRewards.isEmpty()) {
            this.allRewards.stream().filter(Objects::nonNull).forEach(Entity::remove);
        }
    }

    public final Tier getTier(Crate crate, ItemStack item) {
        NamespacedKey key;
        PersistentDataContainerView container = item.getPersistentDataContainer();
        if (!container.has(key = Keys.crate_tier.getNamespacedKey())) {
            return null;
        }
        return crate.getTier((String)container.get(key, PersistentDataType.STRING));
    }

    public void addSlot(Player player, final int rawSlot) {
        UUID uuid = player.getUniqueId();
        if (this.slots.containsKey(uuid)) {
            ArrayList<Integer> slots = this.slots.get(uuid);
            slots.add(rawSlot);
            this.slots.put(uuid, slots);
            return;
        }
        this.slots.put(uuid, new ArrayList<Integer>(){
            {
                this.add(rawSlot);
            }
        });
    }

    public final ArrayList<Integer> getSlots(Player player) {
        return this.slots.get(player.getUniqueId());
    }

    public final boolean containsSlot(Player player) {
        return this.slots.containsKey(player.getUniqueId());
    }

    public void removeSlot(Player player) {
        this.slots.remove(player.getUniqueId());
    }
}

