/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.support.placeholders;

import com.badbones69.crazycrates.CrazyCrates;
import com.badbones69.crazycrates.api.objects.Crate;
import com.badbones69.crazycrates.managers.BukkitUserManager;
import com.badbones69.crazycrates.tasks.crates.CrateManager;
import com.badbones69.crazycrates.utils.MiscUtils;
import java.text.NumberFormat;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import me.clip.placeholderapi.PlaceholderAPI;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class PlaceholderAPISupport
extends PlaceholderExpansion {
    private final CrazyCrates plugin = CrazyCrates.getPlugin();
    private final BukkitUserManager userManager = this.plugin.getUserManager();
    private final CrateManager crateManager = this.plugin.getCrateManager();

    @NotNull
    public final String onRequest(OfflinePlayer player, @NotNull String identifier) {
        if (player == null) {
            return "N/A";
        }
        if (identifier.isEmpty()) {
            return "N/A";
        }
        Player human = (Player)player;
        for (Crate crate : this.crateManager.getUsableCrates()) {
            String fileName = crate.getFileName();
            if (identifier.equalsIgnoreCase(fileName)) {
                return NumberFormat.getNumberInstance().format(this.userManager.getVirtualKeys(human.getUniqueId(), fileName));
            }
            if (identifier.equalsIgnoreCase(fileName + "_physical")) {
                return NumberFormat.getNumberInstance().format(this.userManager.getPhysicalKeys(human.getUniqueId(), fileName));
            }
            if (identifier.equalsIgnoreCase(fileName + "_total")) {
                return NumberFormat.getNumberInstance().format(this.userManager.getTotalKeys(human.getUniqueId(), fileName));
            }
            if (identifier.equalsIgnoreCase(fileName + "_opened")) {
                return NumberFormat.getNumberInstance().format(this.userManager.getCrateOpened(human.getUniqueId(), fileName));
            }
            if (!identifier.equalsIgnoreCase("crates_opened")) continue;
            return NumberFormat.getNumberInstance().format(this.userManager.getTotalCratesOpened(human.getUniqueId()));
        }
        int index = identifier.lastIndexOf("_");
        String value = PlaceholderAPI.setPlaceholders((Player)human, (String)("%" + StringUtils.substringBetween((String)identifier.substring(0, index), (String)"{", (String)"}") + "%"));
        Player target = this.plugin.getServer().getPlayer(value);
        if (target == null) {
            UUID offlinePlayer = (UUID)((CompletableFuture)CompletableFuture.supplyAsync(() -> this.plugin.getServer().getOfflinePlayer(value)).thenApply(OfflinePlayer::getUniqueId)).join();
            String crateName = identifier.split("_")[2];
            return this.getKeys(offlinePlayer, identifier, crateName, value);
        }
        String crateName = identifier.split("_")[2];
        return this.getKeys(target.getUniqueId(), identifier, crateName, value);
    }

    @NotNull
    private String getKeys(@NotNull UUID uuid, @NotNull String identifier, @NotNull String crateName, @NotNull String value) {
        if (crateName.isEmpty() || value.isEmpty()) {
            return "N/A";
        }
        if (this.crateManager.getCrateFromName(crateName) == null && identifier.endsWith("opened")) {
            return NumberFormat.getNumberInstance().format(this.userManager.getTotalCratesOpened(uuid));
        }
        Crate crate = this.crateManager.getCrateFromName(crateName);
        if (crate == null) {
            if (MiscUtils.isLogging()) {
                this.plugin.getComponentLogger().warn("Crate: {} is not a valid crate name.", (Object)crateName);
            }
            return "N/A";
        }
        String fileName = crate.getFileName();
        String result = value + "_" + fileName + "_" + identifier.split("_")[3];
        if (result.endsWith("total")) {
            return NumberFormat.getNumberInstance().format(this.userManager.getTotalKeys(uuid, fileName));
        }
        if (result.endsWith("physical")) {
            return NumberFormat.getNumberInstance().format(this.userManager.getPhysicalKeys(uuid, fileName));
        }
        if (result.endsWith("virtual")) {
            return NumberFormat.getNumberInstance().format(this.userManager.getVirtualKeys(uuid, fileName));
        }
        if (result.endsWith("opened")) {
            return NumberFormat.getNumberInstance().format(this.userManager.getCrateOpened(uuid, fileName));
        }
        return "N/A";
    }

    public final boolean persist() {
        return true;
    }

    public final boolean canRegister() {
        return true;
    }

    @NotNull
    public final String getIdentifier() {
        return this.plugin.getName().toLowerCase();
    }

    @NotNull
    public final String getAuthor() {
        return "BadBones69";
    }

    @NotNull
    public final String getVersion() {
        return this.plugin.getPluginMeta().getVersion();
    }
}

