/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.support.holograms;

import com.badbones69.crazycrates.CrazyCrates;
import com.badbones69.crazycrates.api.objects.Crate;
import com.badbones69.crazycrates.api.objects.crates.CrateHologram;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class HologramManager {
    protected CrazyCrates plugin = CrazyCrates.getPlugin();

    public abstract void createHologram(Location var1, Crate var2, String var3);

    public abstract void removeHologram(String var1);

    public abstract boolean exists(String var1);

    public abstract void purge(boolean var1);

    public abstract String getName();

    @NotNull
    protected final String name() {
        return this.plugin.getName().toLowerCase() + "-" + String.valueOf(UUID.randomUUID());
    }

    @NotNull
    protected final String name(String id) {
        return this.plugin.getName().toLowerCase() + "-" + id;
    }

    @NotNull
    protected final Vector getVector(@NotNull Crate crate) {
        return new Vector(0.5, crate.getHologram().getHeight(), 0.5);
    }

    @Nullable
    protected final String color(@NotNull String message) {
        if (message.isEmpty()) {
            return null;
        }
        Matcher matcher = Pattern.compile("#[a-fA-F\\d]{6}").matcher(message);
        StringBuilder buffer = new StringBuilder();
        while (matcher.find()) {
            matcher.appendReplacement(buffer, net.md_5.bungee.api.ChatColor.of((String)matcher.group()).toString());
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)matcher.appendTail(buffer).toString());
    }

    @NotNull
    protected final List<String> lines(@NotNull CrateHologram crateHologram) {
        if (crateHologram.getMessages().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> lines = new ArrayList<String>();
        crateHologram.getMessages().forEach(line -> lines.add(this.color((String)line)));
        return lines;
    }
}

