/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.managers.events;

import ch.jalu.configme.SettingsManager;
import com.badbones69.crazycrates.CrazyCrates;
import com.badbones69.crazycrates.api.enums.misc.Files;
import com.badbones69.crazycrates.api.objects.Crate;
import com.badbones69.crazycrates.common.config.ConfigManager;
import com.badbones69.crazycrates.common.config.impl.ConfigKeys;
import com.badbones69.crazycrates.managers.events.enums.EventType;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import libs.com.ryderbelserion.vital.common.utils.FileUtil;
import libs.com.ryderbelserion.vital.paper.util.AdvUtil;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import us.crazycrew.crazycrates.api.enums.types.KeyType;

public class EventManager {
    private static final CrazyCrates plugin = CrazyCrates.getPlugin();
    private static final SettingsManager config = ConfigManager.getConfig();

    public static void logEvent(EventType type, Player player, CommandSender sender, Crate crate, KeyType keyType, int amount) {
        EventManager.handle(type, (OfflinePlayer)player, sender, crate, keyType, amount);
    }

    public static void logEvent(EventType type, OfflinePlayer player, CommandSender sender, Crate crate, KeyType keyType, int amount) {
        EventManager.handle(type, player, sender, crate, keyType, amount);
    }

    private static void handle(EventType type, OfflinePlayer player, CommandSender sender, Crate crate, KeyType keyType, int amount) {
        Object message = "";
        File file = null;
        switch (type) {
            case event_key_given: 
            case event_key_removed: 
            case event_key_received: 
            case event_key_sent: 
            case event_key_taken: 
            case event_key_taken_multiple: {
                message = "Player: %player% | Sender: %sender% | Key Name: %key_name% | Key Type: %key_type%".replace("%key_type%", keyType.getFriendlyName()).replace("%player%", player.getName()).replace("%sender%", sender.getName()).replace("%key_name%", crate.getKeyName());
                if (amount >= 1) {
                    message = (String)message + " | Amount: %amount%".replace("%amount%", String.valueOf(amount));
                }
                file = Files.key_log.getFile();
                break;
            }
            case event_crate_opened: {
                message = "Player: %player% | Crate Name: %crate_name% | Force Opened: %force_opened% | Crate Type: %crate_type% | Key Name: %key_name% | Key Type: %key_type% | Key Item: %key_item%".replace("%player%", player.getName()).replace("%crate_name%", crate.getCrateName()).replace("%crate_type%", crate.getCrateType().getName()).replace("%key_name%", crate.getKeyName()).replace("%key_type%", keyType.getFriendlyName()).replace("%key_item%", crate.getKey().getType().getKey().getKey()).replace("%force_opened%", "no");
                if (amount >= 1) {
                    message = (String)message + " | Amount: %amount%".replace("%amount%", String.valueOf(amount));
                }
                file = Files.crate_log.getFile();
                break;
            }
            case event_crate_force_opened: {
                message = "Player: %player% | Crate Name: %crate_name% | Force Opened: %force_opened% | Crate Type: %crate_type% | Key Name: %key_name% | Key Type: %key_type% | Key Item: %key_item%".replace("%player%", player.getName()).replace("%crate_name%", crate.getCrateName()).replace("%crate_type%", crate.getCrateType().getName()).replace("%key_name%", crate.getKeyName()).replace("%key_type%", keyType.getFriendlyName()).replace("%key_item%", crate.getKey().getType().getKey().getKey()).replace("%force_opened%", "yes");
                if (amount >= 1) {
                    message = (String)message + " | Amount: %amount%".replace("%amount%", String.valueOf(amount));
                }
                file = Files.crate_log.getFile();
            }
        }
        EventManager.log((String)message, file, type);
    }

    private static void log(String message, File file, EventType type) {
        boolean log_to_console;
        boolean log_to_file = config.getProperty(ConfigKeys.log_to_file);
        String time = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss").format(new Date(System.currentTimeMillis()));
        if (log_to_file) {
            FileUtil.write(file, "[" + time + " " + type.getEvent() + "]: " + message);
        }
        if (log_to_console = config.getProperty(ConfigKeys.log_to_console).booleanValue()) {
            plugin.getComponentLogger().info("[{} {}]: {}", new Object[]{time, type.getEvent(), AdvUtil.parse(message)});
        }
    }
}

