/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.managers;

import ch.jalu.configme.SettingsManager;
import com.badbones69.crazycrates.CrazyCrates;
import com.badbones69.crazycrates.api.builders.ItemBuilder;
import com.badbones69.crazycrates.api.enums.Messages;
import com.badbones69.crazycrates.api.enums.misc.Keys;
import com.badbones69.crazycrates.api.objects.Crate;
import com.badbones69.crazycrates.api.objects.Tier;
import com.badbones69.crazycrates.common.config.ConfigManager;
import com.badbones69.crazycrates.common.config.impl.ConfigKeys;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import libs.com.ryderbelserion.vital.paper.api.builders.gui.types.PaginatedGui;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import us.crazycrew.crazycrates.api.enums.types.CrateType;

public class InventoryManager {
    private final SettingsManager config = ConfigManager.getConfig();
    private final CrazyCrates plugin = CrazyCrates.getPlugin();
    private ItemBuilder menuButton;
    private ItemBuilder nextButton;
    private ItemBuilder backButton;
    private final List<UUID> previewViewers = new ArrayList<UUID>();

    public void loadButtons() {
        this.menuButton = (ItemBuilder)((ItemBuilder)((ItemBuilder)((ItemBuilder)new ItemBuilder().withType(this.config.getProperty(ConfigKeys.menu_button_item).toLowerCase())).setDisplayName(this.config.getProperty(ConfigKeys.menu_button_name))).setDisplayLore(this.config.getProperty(ConfigKeys.menu_button_lore))).setCustomModelData(this.config.getProperty(ConfigKeys.menu_button_model_data));
        this.nextButton = (ItemBuilder)((ItemBuilder)((ItemBuilder)((ItemBuilder)new ItemBuilder().withType(this.config.getProperty(ConfigKeys.next_button_item).toLowerCase())).setDisplayName(this.config.getProperty(ConfigKeys.next_button_name))).setDisplayLore(this.config.getProperty(ConfigKeys.next_button_lore))).setCustomModelData(this.config.getProperty(ConfigKeys.next_button_model_data));
        this.backButton = (ItemBuilder)((ItemBuilder)((ItemBuilder)((ItemBuilder)new ItemBuilder().withType(this.config.getProperty(ConfigKeys.back_button_item).toLowerCase())).setDisplayName(this.config.getProperty(ConfigKeys.back_button_name))).setDisplayLore(this.config.getProperty(ConfigKeys.back_button_lore))).setCustomModelData(this.config.getProperty(ConfigKeys.back_button_model_data));
    }

    public final ItemStack getMenuButton(@NotNull Player player) {
        return ((ItemBuilder)this.menuButton.setPlayer(player)).asItemStack();
    }

    public final ItemStack getNextButton(@Nullable Player player, @Nullable Tier tier, @NotNull PaginatedGui gui) {
        ItemBuilder button = new ItemBuilder(this.nextButton);
        if (player != null) {
            ((ItemBuilder)button.setPlayer(player)).addLorePlaceholder("{page}", String.valueOf(gui.getNextPageNumber()));
        }
        if (tier != null) {
            button.setPersistentString(Keys.crate_tier.getNamespacedKey(), tier.getName());
        }
        return button.asItemStack();
    }

    public final ItemStack getNextButton(@Nullable Player player, @NotNull PaginatedGui gui) {
        return this.getNextButton(player, null, gui);
    }

    public final ItemStack getBackButton(@Nullable Player player, @Nullable Tier tier, @NotNull PaginatedGui gui) {
        ItemBuilder button = new ItemBuilder(this.backButton);
        if (player != null) {
            ((ItemBuilder)button.setPlayer(player)).addLorePlaceholder("{page}", String.valueOf(gui.getPreviousPageNumber()));
        }
        if (tier != null) {
            button.setPersistentString(Keys.crate_tier.getNamespacedKey(), tier.getName());
        }
        return button.asItemStack();
    }

    public final ItemStack getBackButton(@Nullable Player player, @NotNull PaginatedGui gui) {
        return this.getBackButton(player, null, gui);
    }

    public void openNewCratePreview(@NotNull Player player, @NotNull Crate crate) {
        if (crate.getCrateType() == CrateType.casino || crate.getCrateType() == CrateType.cosmic && crate.isPreviewTierToggle()) {
            crate.getTierPreview(player).open();
            return;
        }
        crate.getPreview(player).open();
    }

    public void addPreviewViewer(UUID uuid) {
        this.previewViewers.add(uuid);
    }

    public void removePreviewViewer(UUID uuid) {
        this.previewViewers.remove(uuid);
    }

    public final List<UUID> getPreviewViewers() {
        return Collections.unmodifiableList(this.previewViewers);
    }

    public final boolean hasPreviewViewer(UUID uuid) {
        return this.previewViewers.contains(uuid);
    }

    public void openPreview(Crate crate) {
        for (UUID uuid : this.getPreviewViewers()) {
            Player player = this.plugin.getServer().getPlayer(uuid);
            if (player == null || !player.isOnline()) {
                this.removePreviewViewer(uuid);
                continue;
            }
            this.openNewCratePreview(player, crate);
        }
    }

    public void closePreview() {
        for (UUID uuid : this.getPreviewViewers()) {
            Player player = this.plugin.getServer().getPlayer(uuid);
            if (player == null || !player.isOnline()) {
                this.removePreviewViewer(uuid);
                continue;
            }
            player.closeInventory(InventoryCloseEvent.Reason.UNLOADED);
            if (!this.config.getProperty(ConfigKeys.send_preview_taken_out_message).booleanValue()) continue;
            Messages.reloaded_forced_out_of_preview.sendMessage((CommandSender)player);
        }
    }
}

