/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.listeners.crates.types;

import com.badbones69.crazycrates.CrazyCrates;
import com.badbones69.crazycrates.api.PrizeManager;
import com.badbones69.crazycrates.api.events.PlayerPrizeEvent;
import com.badbones69.crazycrates.api.objects.Crate;
import com.badbones69.crazycrates.api.objects.Prize;
import com.badbones69.crazycrates.tasks.crates.CrateManager;
import com.badbones69.crazycrates.tasks.menus.CratePrizeMenu;
import com.badbones69.crazycrates.utils.MiscUtils;
import libs.com.ryderbelserion.vital.paper.util.scheduler.FoliaRunnable;
import net.kyori.adventure.sound.Sound;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import us.crazycrew.crazycrates.api.enums.types.CrateType;

public class WarCrateListener
implements Listener {
    private final CrazyCrates plugin = CrazyCrates.getPlugin();
    private final CrateManager crateManager = this.plugin.getCrateManager();

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        ItemStack item;
        Crate crate;
        final Inventory inventory = event.getInventory();
        InventoryHolder inventoryHolder = inventory.getHolder(false);
        if (!(inventoryHolder instanceof CratePrizeMenu)) {
            return;
        }
        CratePrizeMenu holder = (CratePrizeMenu)inventoryHolder;
        final Player player = holder.getPlayer();
        event.setCancelled(true);
        if (this.crateManager.isPicker(player) && this.crateManager.isInOpeningList(player) && (crate = this.crateManager.getOpeningCrate(player)).getCrateType() == CrateType.war && this.crateManager.isPicker(player) && (item = event.getCurrentItem()) != null && item.getType().toString().contains(Material.GLASS_PANE.toString())) {
            final int slot = event.getRawSlot();
            Prize prize = crate.pickPrize(player);
            inventory.setItem(slot, prize.getDisplayItem(player, crate));
            if (this.crateManager.hasCrateTask(player)) {
                this.crateManager.endCrate(player);
            }
            this.crateManager.removePicker(player);
            this.crateManager.addCloser(player, true);
            PrizeManager.givePrize(player, prize, crate);
            if (prize.useFireworks()) {
                MiscUtils.spawnFirework(player.getLocation().add(0.0, 1.0, 0.0), null);
            }
            this.plugin.getServer().getPluginManager().callEvent((Event)new PlayerPrizeEvent(player, crate, prize));
            this.crateManager.removePlayerFromOpeningList(player);
            crate.playSound(player, player.getLocation(), "cycle-sound", "block.anvil.land", Sound.Source.PLAYER);
            this.crateManager.addCrateTask(player, new FoliaRunnable(player.getScheduler(), null){

                @Override
                public void run() {
                    for (int i = 0; i < 9; ++i) {
                        if (i == slot) continue;
                        inventory.setItem(i, crate.pickPrize(player).getDisplayItem(player, crate));
                    }
                    if (WarCrateListener.this.crateManager.hasCrateTask(player)) {
                        WarCrateListener.this.crateManager.endCrate(player);
                    }
                    WarCrateListener.this.crateManager.addCrateTask(player, new FoliaRunnable(player.getScheduler(), null){

                        @Override
                        public void run() {
                            for (int i = 0; i < 9; ++i) {
                                if (i == slot) continue;
                                inventory.setItem(i, null);
                            }
                            if (WarCrateListener.this.crateManager.hasCrateTask(player)) {
                                WarCrateListener.this.crateManager.endCrate(player);
                            }
                            WarCrateListener.this.crateManager.addCrateTask(player, new FoliaRunnable(player.getScheduler(), null){

                                @Override
                                public void run() {
                                    if (WarCrateListener.this.crateManager.hasCrateTask(player)) {
                                        WarCrateListener.this.crateManager.endCrate(player);
                                    }
                                    WarCrateListener.this.crateManager.removePlayerFromOpeningList(player);
                                    player.closeInventory();
                                }
                            }.runDelayed(WarCrateListener.this.plugin, 30L));
                        }
                    }.runDelayed(WarCrateListener.this.plugin, 30L));
                }
            }.runDelayed(this.plugin, 30L));
        }
    }
}

