/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.listeners.crates.types;

import com.badbones69.crazycrates.CrazyCrates;
import com.badbones69.crazycrates.api.ChestManager;
import com.badbones69.crazycrates.api.PrizeManager;
import com.badbones69.crazycrates.api.enums.Messages;
import com.badbones69.crazycrates.api.enums.misc.Keys;
import com.badbones69.crazycrates.api.objects.Crate;
import com.badbones69.crazycrates.api.objects.Prize;
import com.badbones69.crazycrates.tasks.crates.other.quadcrates.QuadCrateManager;
import com.badbones69.crazycrates.tasks.crates.other.quadcrates.SessionManager;
import com.badbones69.crazycrates.utils.ItemUtils;
import java.util.HashMap;
import java.util.List;
import libs.com.ryderbelserion.vital.paper.util.scheduler.FoliaRunnable;
import net.kyori.adventure.sound.Sound;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.util.Vector;

public class QuadCrateListener
implements Listener {
    private final CrazyCrates plugin = CrazyCrates.getPlugin();
    private final SessionManager sessionManager = new SessionManager();

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        if (this.sessionManager.inSession(event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onChestClick(PlayerInteractEvent event) {
        final Player player = event.getPlayer();
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK || event.getAction() == Action.LEFT_CLICK_BLOCK) {
            final Block block = event.getClickedBlock();
            if (block == null) {
                return;
            }
            if (!this.sessionManager.inSession(player)) {
                return;
            }
            final QuadCrateManager session = this.sessionManager.getSession(player);
            if (session == null) {
                return;
            }
            List<Location> crateLocation = session.getCrateLocations();
            if (!crateLocation.contains(block.getLocation())) {
                return;
            }
            event.setCancelled(true);
            if (session.getCratesOpened().get(block.getLocation()).booleanValue()) {
                return;
            }
            ChestManager.openChest(block, true);
            final Crate crate = session.getCrate();
            Prize prize = crate.pickPrize(player, block.getLocation().add(0.5, 1.3, 0.5));
            PrizeManager.givePrize(player, prize, crate);
            ItemStack display = prize.getDisplayItem(player, crate);
            ItemMeta itemMeta = display.getItemMeta();
            itemMeta.getPersistentDataContainer().set(Keys.crate_prize.getNamespacedKey(), PersistentDataType.STRING, (Object)"1");
            display.setItemMeta(itemMeta);
            ItemStack itemStack = ItemUtils.convertItemStack(display).asItemStack();
            Item reward = player.getWorld().dropItem(block.getLocation().add(0.5, 1.0, 0.5), itemStack);
            reward.setVelocity(new Vector(0.0, 0.2, 0.0));
            reward.customName(itemMeta.displayName());
            reward.setCustomNameVisible(true);
            reward.setCanMobPickup(false);
            reward.setCanPlayerPickup(false);
            session.getCratesOpened().put(block.getLocation(), true);
            session.getDisplayedRewards().add((Entity)reward);
            if (session.allCratesOpened()) {
                new FoliaRunnable(this, player.getScheduler(), null){

                    @Override
                    public void run() {
                        session.endCrate(false);
                        crate.playSound(player, block.getLocation(), "stop-sound", "block.anvil.land", Sound.Source.BLOCK);
                    }
                }.runDelayed(this.plugin, 60L);
            }
        }
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        if (!this.sessionManager.inSession(player)) {
            return;
        }
        Location oldLocation = event.getFrom();
        Location newLocation = event.getTo();
        if (oldLocation.getBlockX() != newLocation.getBlockX() || oldLocation.getBlockZ() != newLocation.getBlockZ()) {
            player.teleportAsync(oldLocation);
            event.setCancelled(true);
        }
        for (Entity en : player.getNearbyEntities(2.0, 2.0, 2.0)) {
            Player p;
            if (!(en instanceof Player) || !this.sessionManager.inSession(p = (Player)en)) continue;
            Vector velocity = player.getLocation().toVector().subtract(p.getLocation().toVector()).normalize().setY(1);
            if (player.isInsideVehicle() && player.getVehicle() != null) {
                player.getVehicle().setVelocity(velocity);
                break;
            }
            player.setVelocity(velocity);
            break;
        }
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        if (this.sessionManager.inSession(event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onCommandProcess(PlayerCommandPreprocessEvent event) {
        Player player = event.getPlayer();
        QuadCrateManager session = this.sessionManager.getSession(player);
        if (session != null && !player.hasPermission("crazycrates.admin")) {
            event.setCancelled(true);
            HashMap<String, String> placeholders = new HashMap<String, String>();
            Crate crate = session.getCrate();
            placeholders.put("{crate}", crate.getCrateName());
            placeholders.put("{player}", player.getName());
            Messages.no_commands_while_in_crate.sendMessage((CommandSender)player, placeholders);
        }
    }

    @EventHandler
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        Player player = event.getPlayer();
        QuadCrateManager session = this.sessionManager.getSession(player);
        if (session != null && event.getCause() == PlayerTeleportEvent.TeleportCause.ENDER_PEARL) {
            event.setCancelled(true);
            HashMap<String, String> placeholders = new HashMap<String, String>();
            Crate crate = session.getCrate();
            placeholders.put("{crate}", crate.getCrateName());
            placeholders.put("{player}", player.getName());
            Messages.no_teleporting.sendMessage((CommandSender)player, placeholders);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        QuadCrateManager session = this.sessionManager.getSession(player);
        if (session != null) {
            session.endCrate(true);
        }
    }
}

