/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.listeners.crates.types;

import com.badbones69.crazycrates.CrazyCrates;
import com.badbones69.crazycrates.api.PrizeManager;
import com.badbones69.crazycrates.api.builders.ItemBuilder;
import com.badbones69.crazycrates.api.enums.Messages;
import com.badbones69.crazycrates.api.enums.misc.Keys;
import com.badbones69.crazycrates.api.events.PlayerPrizeEvent;
import com.badbones69.crazycrates.api.events.PlayerReceiveKeyEvent;
import com.badbones69.crazycrates.api.objects.Crate;
import com.badbones69.crazycrates.api.objects.Prize;
import com.badbones69.crazycrates.api.objects.Tier;
import com.badbones69.crazycrates.common.config.ConfigManager;
import com.badbones69.crazycrates.common.config.impl.ConfigKeys;
import com.badbones69.crazycrates.common.utils.Methods;
import com.badbones69.crazycrates.managers.BukkitUserManager;
import com.badbones69.crazycrates.managers.events.EventManager;
import com.badbones69.crazycrates.managers.events.enums.EventType;
import com.badbones69.crazycrates.tasks.crates.CrateManager;
import com.badbones69.crazycrates.tasks.crates.other.CosmicCrateManager;
import com.badbones69.crazycrates.tasks.menus.CratePrizeMenu;
import com.badbones69.crazycrates.utils.MiscUtils;
import io.papermc.paper.persistence.PersistentDataContainerView;
import java.util.HashMap;
import java.util.List;
import java.util.TimerTask;
import java.util.UUID;
import java.util.logging.Level;
import libs.com.ryderbelserion.vital.paper.api.enums.Support;
import libs.com.ryderbelserion.vital.paper.util.AdvUtil;
import me.clip.placeholderapi.PlaceholderAPI;
import net.kyori.adventure.sound.Sound;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import us.crazycrew.crazycrates.api.enums.types.CrateType;
import us.crazycrew.crazycrates.api.enums.types.KeyType;

public class CosmicCrateListener
implements Listener {
    private final CrazyCrates plugin = CrazyCrates.getPlugin();
    private final CrateManager crateManager = this.plugin.getCrateManager();
    private final BukkitUserManager userManager = this.plugin.getUserManager();

    @EventHandler
    public void onPrizeReceive(InventoryClickEvent event) {
        Inventory inventory = event.getInventory();
        InventoryHolder inventoryHolder = inventory.getHolder(false);
        if (!(inventoryHolder instanceof CratePrizeMenu)) {
            return;
        }
        CratePrizeMenu holder = (CratePrizeMenu)inventoryHolder;
        Player player = holder.getPlayer();
        event.setCancelled(true);
        Crate crate = this.crateManager.getOpeningCrate(player);
        if (crate == null) {
            return;
        }
        if (!this.crateManager.isInOpeningList(player) || crate.getCrateType() != CrateType.cosmic) {
            return;
        }
        if (!holder.contains(" - Prizes")) {
            return;
        }
        int slot = event.getRawSlot();
        if (this.crateManager.containsSlot(player) && this.crateManager.getSlots(player).contains(slot)) {
            Messages.already_redeemed_prize.sendMessage((CommandSender)player);
            return;
        }
        InventoryView view = event.getView();
        Inventory topInventory = view.getTopInventory();
        if (event.getClickedInventory() != topInventory) {
            return;
        }
        ItemStack itemStack = topInventory.getItem(slot);
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            return;
        }
        Tier tier = this.crateManager.getTier(player, slot);
        if (tier == null) {
            return;
        }
        Prize prize = crate.pickPrize(player, tier);
        for (int stop = 0; prize == null && stop <= 2000; ++stop) {
            prize = crate.pickPrize(player, tier);
        }
        if (prize == null) {
            return;
        }
        PrizeManager.givePrize(player, prize, crate);
        this.plugin.getServer().getPluginManager().callEvent((Event)new PlayerPrizeEvent(player, crate, prize));
        event.setCurrentItem(prize.getDisplayItem(player, crate));
        holder.getCrate().playSound(player, player.getLocation(), "click-sound", "ui.button.click", Sound.Source.PLAYER);
        if (prize.useFireworks()) {
            MiscUtils.spawnFirework(player.getLocation().add(0.0, 1.0, 0.0), null);
        }
        this.crateManager.addSlot(player, slot);
    }

    @EventHandler
    public void onMysteryBoxClick(final InventoryClickEvent event) {
        Inventory inventory = event.getInventory();
        InventoryHolder inventoryHolder = inventory.getHolder(false);
        if (!(inventoryHolder instanceof CratePrizeMenu)) {
            return;
        }
        final CratePrizeMenu holder = (CratePrizeMenu)inventoryHolder;
        final Player player = holder.getPlayer();
        final UUID uuid = player.getUniqueId();
        event.setCancelled(true);
        final Crate crate = this.crateManager.getOpeningCrate(player);
        if (crate == null) {
            return;
        }
        if (!this.crateManager.isInOpeningList(player) || crate.getCrateType() != CrateType.cosmic) {
            return;
        }
        if (!holder.contains(" - Choose")) {
            return;
        }
        int slot = event.getRawSlot();
        final InventoryView view = event.getView();
        Inventory topInventory = view.getTopInventory();
        if (event.getClickedInventory() != topInventory) {
            return;
        }
        ItemStack itemStack = topInventory.getItem(slot);
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            return;
        }
        final CosmicCrateManager cosmicCrateManager = (CosmicCrateManager)crate.getManager();
        int totalPrizes = cosmicCrateManager.getTotalPrizes();
        int pickedSlot = slot + 1;
        PersistentDataContainerView container = itemStack.getPersistentDataContainer();
        if (container.has(Keys.cosmic_mystery_crate.getNamespacedKey())) {
            int size = cosmicCrateManager.getPrizes(player).size();
            if (size < totalPrizes) {
                Tier tier = this.crateManager.getTier(player, slot);
                if (tier == null) {
                    return;
                }
                tierName = tier.getName();
                ItemBuilder builder = (ItemBuilder)((ItemBuilder)((ItemBuilder)cosmicCrateManager.getPickedCrate().setPlayer(player)).addNamePlaceholder("%Slot%", String.valueOf(pickedSlot))).addLorePlaceholder("%Slot%", String.valueOf(pickedSlot));
                builder.setAmount(pickedSlot);
                cosmicCrateManager.setTier(builder, tierName);
                event.setCurrentItem(builder.asItemStack());
                cosmicCrateManager.addPickedPrize(player, slot, tier);
                crate.playSound(player, player.getLocation(), "click-sound", "ui.button.click", Sound.Source.PLAYER);
            }
        } else if (container.has(Keys.cosmic_picked_crate.getNamespacedKey())) {
            Tier tier = this.crateManager.getTier(player, slot);
            ItemBuilder builder = (ItemBuilder)((ItemBuilder)((ItemBuilder)cosmicCrateManager.getMysteryCrate().setPlayer(player)).addNamePlaceholder("%Slot%", String.valueOf(pickedSlot))).addLorePlaceholder("%Slot%", String.valueOf(pickedSlot));
            builder.setAmount(pickedSlot);
            tierName = tier.getName();
            cosmicCrateManager.setTier(builder, tierName);
            event.setCurrentItem(builder.asItemStack());
            cosmicCrateManager.removePickedPrize(player, slot);
            crate.playSound(player, player.getLocation(), "click-sound", "ui.button.click", Sound.Source.PLAYER);
        }
        final String fileName = crate.getFileName();
        final String fancyName = crate.getCrateName();
        int size = cosmicCrateManager.getPrizes(player).size();
        if (size >= totalPrizes) {
            boolean cannotTakeKey;
            boolean value;
            KeyType playerType = this.crateManager.getPlayerKeyType(player);
            final KeyType type = playerType == null ? KeyType.virtual_key : playerType;
            boolean bl = value = type == KeyType.physical_key && !this.userManager.hasPhysicalKey(uuid, fileName, this.crateManager.getHand(player));
            if (value) {
                HashMap<String, String> placeholders = new HashMap<String, String>();
                placeholders.put("{crate}", fancyName);
                placeholders.put("{key}", crate.getKeyName());
                Messages.no_keys.sendMessage((CommandSender)player, placeholders);
                this.crateManager.removePlayerFromOpeningList(player);
                this.crateManager.removePlayerKeyType(player);
                this.crateManager.removeTier(player);
                this.crateManager.removeHands(player);
                cosmicCrateManager.removePickedPlayer(player);
                player.closeInventory(InventoryCloseEvent.Reason.UNLOADED);
                return;
            }
            boolean bl2 = this.crateManager.hasPlayerKeyType(player) && !this.userManager.takeKeys(uuid, fileName, type, crate.useRequiredKeys() ? crate.getRequiredKeys() : 1, this.crateManager.getHand(player)) ? true : (cannotTakeKey = false);
            if (cannotTakeKey) {
                MiscUtils.failedToTakeKey((CommandSender)player, fileName);
                this.crateManager.removePlayerFromOpeningList(player);
                this.crateManager.removePlayerKeyType(player);
                this.crateManager.removeTier(player);
                this.crateManager.removeHands(player);
                cosmicCrateManager.removePickedPlayer(player);
                player.closeInventory(InventoryCloseEvent.Reason.UNLOADED);
                return;
            }
            String shufflingName = fancyName + " - Shuffling";
            holder.title(shufflingName);
            holder.sendTitleChange();
            view.getTopInventory().clear();
            YamlConfiguration configuration = crate.getFile();
            String broadcastMessage = configuration.getString("Crate.BroadCast", "");
            boolean broadcastToggle = configuration.getBoolean("Crate.OpeningBroadCast", false);
            if (broadcastToggle && !broadcastMessage.isBlank()) {
                String builder = Support.placeholder_api.isEnabled() ? PlaceholderAPI.setPlaceholders((Player)player, (String)broadcastMessage) : broadcastMessage;
                this.plugin.getServer().broadcast(AdvUtil.parse(builder.replaceAll("%crate%", fancyName).replaceAll("%prefix%", Methods.getPrefix()).replaceAll("%player%", player.getName())));
            }
            EventManager.logEvent(EventType.event_crate_opened, player, (CommandSender)player, crate, type, 1);
            this.crateManager.addRepeatingCrateTask(player, new TimerTask(){
                int time = 0;

                @Override
                public void run() {
                    try {
                        CosmicCrateListener.this.startRollingAnimation(player, view, holder);
                    }
                    catch (Exception exception) {
                        player.getScheduler().run((Plugin)CosmicCrateListener.this.plugin, scheduledTask -> {
                            PlayerReceiveKeyEvent keyEvent = new PlayerReceiveKeyEvent(player, crate, PlayerReceiveKeyEvent.KeyReceiveReason.REFUND, 1);
                            CosmicCrateListener.this.plugin.getServer().getPluginManager().callEvent((Event)keyEvent);
                            if (!event.isCancelled()) {
                                CosmicCrateListener.this.userManager.addKeys(uuid, fileName, type == null ? KeyType.virtual_key : type, 1);
                                CosmicCrateListener.this.crateManager.removePlayerFromOpeningList(player);
                                CosmicCrateListener.this.crateManager.removePlayerKeyType(player);
                                CosmicCrateListener.this.crateManager.removeTier(player);
                                CosmicCrateListener.this.crateManager.removeCrateTask(player);
                                CosmicCrateListener.this.crateManager.removeHands(player);
                                cosmicCrateManager.removePickedPlayer(player);
                                Messages.key_refund.sendMessage((CommandSender)player, "{crate}", fancyName);
                                if (MiscUtils.isLogging()) {
                                    CosmicCrateListener.this.plugin.getLogger().log(Level.SEVERE, "An issue occurred when the user " + player.getName() + " was using the " + fileName + " crate and so they were issued a key refund.", exception);
                                }
                                crate.playSound(player, player.getLocation(), "stop-sound", "block.anvil.place", Sound.Source.PLAYER);
                            }
                        }, null);
                        this.cancel();
                        return;
                    }
                    ++this.time;
                    if (this.time == 40) {
                        CosmicCrateListener.this.crateManager.removeCrateTask(player);
                        CosmicCrateListener.this.showRewards(player, view, holder, cosmicCrateManager);
                        crate.playSound(player, player.getLocation(), "stop-sound", "block.anvil.place", Sound.Source.PLAYER);
                        this.cancel();
                    }
                }
            }, 0L, 80L);
        }
    }

    private void startRollingAnimation(Player player, InventoryView view, CratePrizeMenu cosmic) {
        Crate crate = cosmic.getCrate();
        for (int slot = 0; slot < cosmic.getSize(); ++slot) {
            Tier tier = PrizeManager.getTier(crate);
            if (tier == null) continue;
            view.getTopInventory().setItem(slot, tier.getTierItem(player, crate));
        }
        crate.playSound(player, player.getLocation(), "cycle-sound", "block.note_block.xylophone", Sound.Source.PLAYER);
        player.updateInventory();
    }

    private void showRewards(final Player player, InventoryView view, CratePrizeMenu cosmic, CosmicCrateManager cosmicCrateManager) {
        Crate crate = cosmic.getCrate();
        String rewardsName = crate.getCrateName() + " - Prizes";
        cosmic.title(rewardsName);
        cosmic.sendTitleChange();
        view.getTopInventory().clear();
        cosmicCrateManager.getPrizes(player).forEach((slot, tier) -> {
            Inventory inventory = view.getTopInventory();
            inventory.setItem(slot.intValue(), tier.getTierItem(player, crate));
        });
        player.updateInventory();
        if (ConfigManager.getConfig().getProperty(ConfigKeys.cosmic_crate_timeout).booleanValue()) {
            this.crateManager.addCrateTask(player, new TimerTask(){

                @Override
                public void run() {
                    player.getScheduler().run((Plugin)CosmicCrateListener.this.plugin, scheduledTask -> player.closeInventory(InventoryCloseEvent.Reason.UNLOADED), null);
                    if (MiscUtils.isLogging()) {
                        List.of(player.getName() + " spent 10 seconds staring at a gui instead of collecting their prizes", "The task has been cancelled, They have been given their prizes and the gui is closed.").forEach(CosmicCrateListener.this.plugin.getLogger()::info);
                    }
                }
            }, 10000L);
        }
    }
}

