/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.listeners;

import com.badbones69.crazycrates.CrazyCrates;
import com.badbones69.crazycrates.api.objects.Crate;
import com.badbones69.crazycrates.api.objects.crates.BrokeLocation;
import com.badbones69.crazycrates.api.objects.crates.CrateLocation;
import com.badbones69.crazycrates.support.holograms.HologramManager;
import com.badbones69.crazycrates.tasks.crates.CrateManager;
import com.badbones69.crazycrates.utils.MiscUtils;
import java.util.ArrayList;
import org.bukkit.Location;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.WorldLoadEvent;

public class BrokeLocationsListener
implements Listener {
    private final CrazyCrates plugin = CrazyCrates.getPlugin();
    private final CrateManager crateManager = this.plugin.getCrateManager();

    @EventHandler
    public void onWorldLoad(WorldLoadEvent event) {
        if (this.crateManager.getBrokeLocations().isEmpty()) {
            return;
        }
        int fixedAmount = 0;
        ArrayList<BrokeLocation> fixedWorlds = new ArrayList<BrokeLocation>();
        for (BrokeLocation brokeLocation : this.crateManager.getBrokeLocations()) {
            Location location = brokeLocation.getLocation();
            if (location.getWorld() == null || brokeLocation.getCrate() == null) continue;
            CrateLocation crateLocation = new CrateLocation(brokeLocation.getLocationName(), brokeLocation.getCrate(), location);
            this.crateManager.addLocation(crateLocation);
            HologramManager manager = this.crateManager.getHolograms();
            Crate crate = crateLocation.getCrate();
            if (manager != null && crate.getHologram().isEnabled()) {
                manager.createHologram(location, crate, crateLocation.getID());
            }
            fixedWorlds.add(brokeLocation);
            ++fixedAmount;
        }
        this.crateManager.removeBrokeLocation(fixedWorlds);
        if (MiscUtils.isLogging()) {
            this.plugin.getComponentLogger().warn("Fixed {} broken crate locations.", (Object)fixedAmount);
            if (this.crateManager.getBrokeLocations().isEmpty()) {
                this.plugin.getComponentLogger().warn("All broken crate locations have been fixed.");
            }
        }
    }
}

