/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.common;

import com.badbones69.crazycrates.common.config.ConfigManager;
import com.badbones69.crazycrates.common.impl.Settings;
import java.io.File;
import java.util.List;
import libs.com.ryderbelserion.vital.common.utils.FileUtil;
import org.jetbrains.annotations.NotNull;
import us.crazycrew.crazycrates.CratesProvider;
import us.crazycrew.crazycrates.api.users.UserManager;
import us.crazycrew.crazycrates.platform.IServer;
import us.crazycrew.crazycrates.platform.ISettings;

public class Server
implements IServer {
    private final File directory;
    private final File crates;
    private UserManager userManager;
    private Settings settings;

    public Server(@NotNull File directory) {
        this.directory = directory;
        this.crates = new File(this.directory, "crates");
    }

    public void apply() {
        ConfigManager.load(this.directory);
        this.settings = new Settings();
        CratesProvider.register(this);
    }

    public void setUserManager(@NotNull UserManager userManager) {
        if (this.userManager != null) {
            return;
        }
        this.userManager = userManager;
    }

    public void disable() {
        CratesProvider.unregister();
    }

    @Override
    public void reload() {
        ConfigManager.refresh();
    }

    @Override
    @NotNull
    public final File getCrateFolder() {
        return this.crates;
    }

    @Override
    @NotNull
    public File getDataFolder() {
        return this.directory;
    }

    @Override
    @NotNull
    public final List<String> getCrateFiles() {
        return FileUtil.getFiles(this.getCrateFolder(), ".yml", false);
    }

    @Override
    @NotNull
    public final UserManager getUserManager() {
        return this.userManager;
    }

    @Override
    @NotNull
    public final ISettings getSettings() {
        return this.settings;
    }
}

