/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.commands.crates.types.admin.keys;

import com.badbones69.crazycrates.api.enums.Messages;
import com.badbones69.crazycrates.api.enums.Permissions;
import com.badbones69.crazycrates.api.events.PlayerReceiveKeyEvent;
import com.badbones69.crazycrates.api.objects.Crate;
import com.badbones69.crazycrates.commands.crates.types.BaseCommand;
import com.badbones69.crazycrates.utils.MiscUtils;
import java.util.HashMap;
import libs.com.ryderbelserion.vital.paper.api.builders.PlayerBuilder;
import libs.dev.triumphteam.cmd.bukkit.annotation.Permission;
import libs.dev.triumphteam.cmd.core.annotations.ArgName;
import libs.dev.triumphteam.cmd.core.annotations.Command;
import libs.dev.triumphteam.cmd.core.annotations.Suggestion;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.permissions.PermissionDefault;
import us.crazycrew.crazycrates.api.enums.types.CrateType;
import us.crazycrew.crazycrates.api.enums.types.KeyType;

public class CommandGive
extends BaseCommand {
    @Command(value="give")
    @Permission(value={"crazycrates.givekey"}, def=PermissionDefault.OP)
    public void give(CommandSender sender, @ArgName(value="key_type") @Suggestion(value="keys") String type, @ArgName(value="crate") @Suggestion(value="crates") String crateName, @ArgName(value="amount") @Suggestion(value="numbers") int amount, @ArgName(value="player") @Suggestion(value="players") PlayerBuilder target) {
        if (crateName == null || crateName.isEmpty() || crateName.isBlank()) {
            Messages.cannot_be_empty.sendMessage(sender, "{value}", "crate name");
            return;
        }
        if (amount <= 0) {
            Messages.not_a_number.sendMessage(sender, "{number}", String.valueOf(amount));
            return;
        }
        Crate crate = this.getCrate(sender, crateName, false);
        if (crate == null || crate.getCrateType() == CrateType.menu) {
            Messages.not_a_crate.sendMessage(sender, "{crate}", crateName);
            return;
        }
        KeyType keyType = this.getKeyType(type);
        if (target.getPlayer() != null) {
            this.addKey(sender, target.getPlayer(), crate, keyType, amount);
            return;
        }
        this.addKey(sender, target.getOfflinePlayer(), crate, keyType, amount);
    }

    @Command(value="give-random")
    @Permission(value={"crazycrates.giverandomkey"}, def=PermissionDefault.OP)
    public void random(CommandSender sender, @Suggestion(value="keys") String type, @Suggestion(value="numbers") int amount, @Suggestion(value="players") PlayerBuilder target) {
        this.give(sender, type, this.crateManager.getUsableCrates().get((int)MiscUtils.pickNumber(0L, this.crateManager.getUsableCrates().size() - 2)).getFileName(), amount, target);
    }

    @Command(value="giveall")
    @Permission(value={"crazycrates.giveall"}, def=PermissionDefault.OP)
    public void all(CommandSender sender, @Suggestion(value="keys") String type, @Suggestion(value="crates") String crateName, @Suggestion(value="numbers") int amount) {
        if (crateName.isEmpty()) {
            Messages.not_a_crate.sendMessage(sender, "{crate}", crateName);
            return;
        }
        if (amount <= 0) {
            Messages.not_a_number.sendMessage(sender, "{amount}", String.valueOf(amount));
            return;
        }
        Crate crate = this.getCrate(sender, crateName, false);
        if (crate == null) {
            Messages.not_a_crate.sendMessage(sender, "{crate}", crateName);
            return;
        }
        KeyType keyType = this.getKeyType(type);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("{amount}", String.valueOf(amount));
        placeholders.put("{keytype}", keyType.getFriendlyName());
        placeholders.put("{key}", crate.getKeyName());
        Messages.given_everyone_keys.sendMessage(sender, placeholders);
        for (Player player : this.plugin.getServer().getOnlinePlayers()) {
            if (Permissions.CRAZYCRATES_PLAYER_EXCLUDE.hasPermission(player)) continue;
            PlayerReceiveKeyEvent event = new PlayerReceiveKeyEvent(player, crate, PlayerReceiveKeyEvent.KeyReceiveReason.GIVE_ALL_COMMAND, amount);
            this.plugin.getServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            Messages.obtaining_keys.sendMessage((CommandSender)player, placeholders);
            if (crate.getCrateType() == CrateType.crate_on_the_go) {
                MiscUtils.addItem(player, crate.getKey(amount, player));
                return;
            }
            this.addKey(sender, player, crate, keyType, amount);
        }
    }
}

