/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.commands.crates.types.admin.crates.migrator.types.plugins;

import com.badbones69.crazycrates.api.enums.misc.Files;
import com.badbones69.crazycrates.commands.crates.types.admin.crates.migrator.ICrateMigrator;
import com.badbones69.crazycrates.commands.crates.types.admin.crates.migrator.enums.MigrationType;
import com.badbones69.crazycrates.common.config.impl.ConfigKeys;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import libs.com.ryderbelserion.vital.paper.api.files.CustomFile;
import libs.com.ryderbelserion.vital.paper.util.AdvUtil;
import libs.com.ryderbelserion.vital.paper.util.ItemUtil;
import net.kyori.adventure.text.Component;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import su.nightexpress.excellentcrates.CratesAPI;
import su.nightexpress.excellentcrates.crate.impl.Crate;
import su.nightexpress.excellentcrates.key.CrateKey;
import su.nightexpress.nightcore.config.FileConfig;

public class ExcellentCratesMigrator
extends ICrateMigrator {
    public ExcellentCratesMigrator(CommandSender sender) {
        super(sender, MigrationType.EXCELLENT_CRATES);
    }

    @Override
    public void run() {
        File directory = this.getCratesDirectory();
        if (!directory.exists()) {
            directory.mkdirs();
        }
        File crateDirectory = CratesAPI.PLUGIN.getDataFolder();
        final ArrayList<CallSite> failed = new ArrayList<CallSite>();
        final ArrayList<CallSite> success = new ArrayList<CallSite>();
        YamlConfiguration locationData = Files.locations.getConfiguration();
        for (Crate crate : CratesAPI.getCrateManager().getCrates()) {
            String crateName = crate.getFile().getName();
            File crateFile = new File(directory, crateName);
            if (crateFile.exists()) {
                this.plugin.getComponentLogger().warn("Crate {} already exists in {}.", (Object)crateName, (Object)directory.getName());
                failed.add((CallSite)((Object)("<red>\u2937 " + crateName)));
                return;
            }
            try {
                crateFile.createNewFile();
            }
            catch (IOException exception) {
                this.plugin.getComponentLogger().warn("Failed to create crate file {} in {}.", new Object[]{crateName, directory.getName(), exception});
                failed.add((CallSite)((Object)("<red>\u2937 " + crateName)));
            }
            CustomFile customFile = new CustomFile(crateName, crateFile).load();
            YamlConfiguration configuration = customFile.getConfiguration();
            if (configuration == null) {
                return;
            }
            this.set((ConfigurationSection)configuration, "Crate.CrateType", "CSGO");
            ConfigurationSection root = configuration.getConfigurationSection("Crate");
            if (root == null) {
                return;
            }
            FileConfig crateConfig = crate.getConfig();
            List locations = crateConfig.getStringList("Block.Locations");
            if (!locations.isEmpty()) {
                crateConfig.getStringList("Block.Locations").forEach(location -> {
                    Object id = "1";
                    int i = 1;
                    while (locationData.contains("Locations." + i)) {
                        id = "" + (i + 1);
                        ++i;
                    }
                    String[] splitter = location.split(",");
                    String arg5 = splitter[5];
                    String arg0 = splitter[0];
                    String arg1 = splitter[1];
                    String arg2 = splitter[2];
                    locationData.set("Locations." + (String)id + ".Crate", (Object)crateName.replace(".yml", ""));
                    locationData.set("Locations." + (String)id + ".World", (Object)arg5);
                    locationData.set("Locations." + (String)id + ".X", (Object)((int)Double.parseDouble(arg0)));
                    locationData.set("Locations." + (String)id + ".Y", (Object)((int)Double.parseDouble(arg1)));
                    locationData.set("Locations." + (String)id + ".Z", (Object)((int)Double.parseDouble(arg2)));
                    Files.locations.save();
                });
            }
            this.set(root, "Glowing", false);
            String name = crate.getPreviewConfig();
            File file = new File(new File(crateDirectory, "menu"), (String)(name == null ? "default.yml" : name + ".yml"));
            if (file.exists()) {
                YamlConfiguration menuFile = YamlConfiguration.loadConfiguration((File)file);
                String previewName = menuFile.getString("Crate.Name", "<bold><#9af7ff>%crate%</bold>").replace("%crate_name%", "%crate%").replace("%crate%", crateName.replace(".yml", ""));
                ArrayList previewLore = new ArrayList();
                menuFile.getStringList("Crate.Lore").forEach(line -> previewLore.add(line.replaceAll("<l", "<").replaceAll("</l", "</")));
                this.set(root, "Name", previewName);
                this.set(root, "Lore", previewLore);
                ConfigurationSection section = menuFile.getConfigurationSection("Crate.Slots");
                if (section != null) {
                    for (String key : section.getKeys(false)) {
                        int slot = section.getInt(key);
                        if (!key.equalsIgnoreCase(crateName.replace(".yml", ""))) continue;
                        this.set(root, "InGUI", slot > 0);
                        this.set(root, "Slot", slot);
                        break;
                    }
                }
            }
            this.set(root, "Preview.Toggle", true);
            this.set(root, "Preview.ChestLines", 6);
            this.set(root, "Preview.Name", crate.getName());
            this.set(root, "Preview.Glass.Toggle", true);
            this.set(root, "Preview.Glass.Name", " ");
            this.set(root, "Preview.Glass.Item", "gray_stained_glass_pane");
            this.set(root, "Preview.Glass.Custom-Model-Data", -1);
            this.set(root, "StartingKeys", 0);
            this.set(root, "RequiredKeys", 0);
            this.set(root, "Max-Mass-Open", 10);
            this.set(root, "OpeningBroadCast", false);
            this.set(root, "BroadCast", "%prefix%<bold><gold>%player%</bold><reset> <gray>is opening a <bold><green>%crate%.</bold>".replace("%crate%", crate.getName()));
            this.set(root, "opening-command.toggle", false);
            this.set(root, "opening-command.commands", List.of("put your command here."));
            this.set(root, "sound.cycle-sound.toggle", false);
            this.set(root, "sound.cycle-sound.value", "block.note_block_xylophone");
            this.set(root, "sound.cycle-sound.volume", 1.0);
            this.set(root, "sound.cycle-sound.pitch", 1.0);
            this.set(root, "sound.click-sound.toggle", false);
            this.set(root, "sound.click-sound.value", "block.note_block_xylophone");
            this.set(root, "sound.click-sound.volume", 1.0);
            this.set(root, "sound.click-sound.pitch", 1.0);
            this.set(root, "sound.stop-sound.toggle", false);
            this.set(root, "sound.stop-sound.value", "block.note_block_xylophone");
            this.set(root, "sound.stop-sound.volume", 1.0);
            this.set(root, "sound.stop-sound.pitch", 1.0);
            this.set(root, "Prize-Message", List.of("<gray>You have won <red>%reward% <gray>from <red>%crate%."));
            ItemStack crateItem = crate.getItem();
            this.set(root, "Item", crateConfig.getString("Item.Material", "player_head").toLowerCase());
            String itemName = crateConfig.getString("Item.Name", "%crate%").replace("%crate%", crateName);
            this.set(root, "Preview-Name", itemName + " Preview");
            if (crateItem.hasItemMeta()) {
                ItemMeta itemMeta = crateItem.getItemMeta();
                this.set(root, "Custom-Model-Data", itemMeta.hasCustomModelData() ? itemMeta.getCustomModelData() : -1);
            }
            this.set(root, "Settings.Knockback", crate.isPushbackEnabled());
            this.set(root, "Hologram.Toggle", crate.isHologramEnabled());
            this.set(root, "Hologram.Height", crate.getHologramYOffset());
            this.set(root, "Hologram.Range", 8);
            this.set(root, "Hologram.Update-Interval", -1);
            this.set(root, "Hologram.Color", "transparent");
            ArrayList hologramText = new ArrayList();
            crate.getHologramText().forEach(line -> {
                String filtered = line.replace("%excellentcrates_keys_" + crateName.replace(".yml", "") + "%", "%crazycrates_" + crateName.replace(".yml", "") + "%").replace("%crate%", crate.getName());
                hologramText.add(filtered);
            });
            this.set(root, "Hologram.Message", hologramText);
            Optional value = crate.getKeys().stream().findFirst();
            if (value.isPresent()) {
                CrateKey key = (CrateKey)value.get();
                FileConfig config = key.getConfig();
                ItemStack itemStack = key.getItem();
                this.set(root, "PhysicalKey.Data", ItemUtil.toBase64(itemStack));
                this.set(root, "PhysicalKey.Name", AdvUtil.fromComponent(itemStack.displayName()));
                this.set(root, "PhysicalKey.Item", itemStack.getType().getKey().getKey());
                List keyLore = itemStack.lore();
                this.set(root, "PhysicalKey.Lore", keyLore != null ? AdvUtil.fromComponent(keyLore) : List.of());
                this.set(root, "PhysicalKey.Glowing", config.contains("Item.Enchants"));
            }
            crate.getRewards().forEach(reward -> {
                ConfigurationSection section;
                String id = reward.getId();
                ItemStack itemStack = reward.getPreview();
                if (itemStack.hasItemMeta()) {
                    Object lore;
                    Component displayName;
                    ItemMeta itemMeta = itemStack.getItemMeta();
                    if (itemMeta.hasDisplayName() && (displayName = itemMeta.displayName()) != null) {
                        this.set(root, "Prizes." + id + ".DisplayName", AdvUtil.fromComponent(itemStack.displayName()));
                    }
                    if (itemMeta.hasLore() && (lore = itemMeta.lore()) != null) {
                        this.set(root, "Prizes." + id + ".DisplayLore", AdvUtil.fromComponent((List<Component>)lore));
                    }
                }
                this.set(root, "Prizes." + id + ".Commands", reward.getCommands());
                this.set(root, "Prizes." + id + ".Settings.Broadcast.Toggle", reward.isBroadcast());
                this.set(root, "Prizes." + id + ".Settings.Broadcast.Messages", List.of());
                this.set(root, "Prizes." + id + ".Settings.Broadcast.Permission", "your_permission");
                this.set(root, "Prizes." + id + ".BlackListed-Permissions", reward.getIgnoredForPermissions());
                this.set(root, "Prizes." + id + ".Chance", (int)reward.getWeight());
                this.set(root, "Prizes." + id + ".DisplayItem", itemStack.getType().getKey().getKey());
                this.set(root, "Prizes." + id + ".DisplayAmount", itemStack.getAmount());
                ArrayList<CallSite> enchantments = new ArrayList<CallSite>();
                for (Map.Entry entry : itemStack.getEnchantments().entrySet()) {
                    enchantments.add((CallSite)((Object)(((Enchantment)entry.getKey()).getKey().getKey() + ":" + String.valueOf(entry.getValue()))));
                }
                if (!enchantments.isEmpty()) {
                    this.set(root, "Prizes." + id + ".DisplayEnchantments", enchantments);
                }
                if ((section = root.getConfigurationSection("Prizes")) == null) {
                    return;
                }
                ConfigurationSection configurationSection = section.getConfigurationSection(id);
                if (configurationSection == null) {
                    return;
                }
                boolean useNewItemEditor = this.config.getProperty(ConfigKeys.use_new_item_editor);
                reward.getItems().forEach(key -> {
                    if (useNewItemEditor) {
                        final String base64 = ItemUtil.toBase64(key);
                        if (prizeSection.contains("Items")) {
                            List items = prizeSection.getStringList("Items");
                            items.add("Data: " + base64);
                            this.set(prizeSection, "Items", items);
                        } else {
                            this.set(prizeSection, "Items", new ArrayList<Object>(){
                                {
                                    this.add("Data: " + base64);
                                }
                            });
                        }
                    } else {
                        List editors;
                        ArrayList<ItemStack> editorItems = new ArrayList<ItemStack>();
                        if (prizeSection.contains("Editor-Items") && (editors = prizeSection.getList("Editor-Items")) != null) {
                            editors.forEach(item -> editorItems.add((ItemStack)item));
                        }
                        editorItems.add((ItemStack)key);
                        this.set(prizeSection, "Editor-Items", editorItems);
                    }
                });
            });
            customFile.save();
            this.fileManager.addFile(true, customFile);
            success.add((CallSite)((Object)("<green>\u2937 " + crateName)));
        }
        this.crateManager.loadHolograms();
        this.crateManager.loadCrates();
        int convertedCrates = success.size();
        int failedCrates = failed.size();
        this.sendMessage((List<String>)new ArrayList<String>(failedCrates + convertedCrates){
            {
                super(arg0);
                this.addAll(failed);
                this.addAll(success);
            }
        }, convertedCrates, failedCrates);
    }

    @Override
    public <T> void set(ConfigurationSection section, String path, T value) {
        section.set(path, value);
    }

    @Override
    public final File getCratesDirectory() {
        return new File(this.plugin.getDataFolder(), "crates");
    }
}

