/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.commands.crates.types.admin.crates.migrator;

import ch.jalu.configme.SettingsManager;
import com.badbones69.crazycrates.CrazyCrates;
import com.badbones69.crazycrates.api.enums.Messages;
import com.badbones69.crazycrates.commands.crates.types.admin.crates.migrator.enums.MigrationType;
import com.badbones69.crazycrates.common.config.ConfigManager;
import com.badbones69.crazycrates.tasks.crates.CrateManager;
import com.badbones69.crazycrates.utils.ItemUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import libs.com.ryderbelserion.vital.common.utils.StringUtil;
import libs.com.ryderbelserion.vital.paper.api.files.CustomFile;
import libs.com.ryderbelserion.vital.paper.api.files.FileManager;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public abstract class ICrateMigrator {
    protected final CrazyCrates plugin = CrazyCrates.getPlugin();
    protected final CrateManager crateManager = this.plugin.getCrateManager();
    protected final SettingsManager config = ConfigManager.getConfig();
    protected final SettingsManager messages = ConfigManager.getMessages();
    protected final FileManager fileManager = this.plugin.getVital().getFileManager();
    protected final CommandSender sender;
    protected final MigrationType type;
    protected final long startTime = System.nanoTime();
    protected String crateName;

    public ICrateMigrator(CommandSender sender, MigrationType type) {
        this.sender = sender;
        this.type = type;
    }

    public ICrateMigrator(CommandSender sender, MigrationType type, String crateName) {
        this(sender, type);
        this.crateName = crateName;
    }

    public abstract void run();

    public abstract <T> void set(ConfigurationSection var1, String var2, T var3);

    public File getCratesDirectory() {
        return null;
    }

    public void sendMessage(final List<String> files, final int success, final int failed) {
        Messages.successfully_migrated.sendMessage(this.sender, (Map<String, String>)new HashMap<String, String>(){
            {
                if (files.size() > 1) {
                    this.put("{files}", StringUtils.chomp((String)StringUtil.convertList(files)));
                } else {
                    this.put("{files}", (String)files.getFirst());
                }
                this.put("{succeeded_amount}", String.valueOf(success));
                this.put("{failed_amount}", String.valueOf(failed));
                this.put("{type}", ICrateMigrator.this.type.getName());
                this.put("{time}", ICrateMigrator.this.time());
            }
        });
    }

    public void migrate(final CustomFile customFile, final String crateName) {
        YamlConfiguration configuration = customFile.getConfiguration();
        if (configuration == null) {
            return;
        }
        ConfigurationSection crate = configuration.getConfigurationSection("Crate");
        if (crate == null) {
            Messages.error_migrating.sendMessage(this.sender, (Map<String, String>)new HashMap<String, String>(){
                {
                    this.put("{file}", crateName.isEmpty() ? customFile.getCleanName() : crateName);
                    this.put("{type}", ICrateMigrator.this.type.getName());
                    this.put("{reason}", "File could not be found in our data, likely invalid yml file that didn't load properly.");
                }
            });
            return;
        }
        this.set(crate, "Item", crate.getString("Item", "diamond").toLowerCase());
        this.set(crate, "Preview.Glass.Item", crate.getString("Preview.Glass.Item", "gray_stained_glass_pane").toLowerCase());
        this.set(crate, "PhysicalKey.Item", crate.getString("PhysicalKey.Item", "lime_dye").toLowerCase());
        ConfigurationSection prizes = crate.getConfigurationSection("Prizes");
        if (prizes != null) {
            for (String value : prizes.getKeys(false)) {
                final ConfigurationSection prizeSection = prizes.getConfigurationSection(value);
                if (prizeSection == null) continue;
                if (prizeSection.contains("DisplayItem")) {
                    this.set(prizeSection, "DisplayItem", prizeSection.getString("DisplayItem", "red_terracotta").toLowerCase());
                }
                if (prizeSection.contains("DisplayTrim")) {
                    this.set(prizeSection, "DisplayTrim.Material", prizeSection.getString("DisplayTrim.Material", "quartz").toLowerCase());
                    this.set(prizeSection, "DisplayTrim.Pattern", prizeSection.getString("DisplayTrim.Pattern", "sentry").toLowerCase());
                }
                if (!prizeSection.contains("DisplayEnchantments")) continue;
                ArrayList<String> enchants = new ArrayList<String>(){
                    {
                        prizeSection.getStringList("DisplayEnchantments").forEach((? super T enchant) -> this.add(ItemUtils.getEnchant(enchant)));
                    }
                };
                this.set(prizeSection, "DisplayEnchantments", enchants);
            }
        }
        customFile.save();
        customFile.load();
    }

    public final String time() {
        double time = (double)(System.nanoTime() - this.startTime) / 1.0E9;
        return String.format(Locale.ROOT, "%.3fs", time);
    }
}

