/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.commands.crates.types.admin.crates;

import com.badbones69.crazycrates.api.enums.Messages;
import com.badbones69.crazycrates.api.enums.misc.Files;
import com.badbones69.crazycrates.commands.crates.types.BaseCommand;
import java.util.Objects;
import libs.dev.triumphteam.cmd.bukkit.annotation.Permission;
import libs.dev.triumphteam.cmd.core.annotations.ArgName;
import libs.dev.triumphteam.cmd.core.annotations.Command;
import libs.dev.triumphteam.cmd.core.annotations.Optional;
import libs.dev.triumphteam.cmd.core.annotations.Suggestion;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionDefault;

public class CommandTeleport
extends BaseCommand {
    private final YamlConfiguration locations = Files.locations.getConfiguration();

    @Command(value="teleport")
    @Permission(value={"crazycrates.teleport"}, def=PermissionDefault.OP)
    public void teleport(Player player, @ArgName(value="crate_id") @Optional @Suggestion(value="locations") String id) {
        if (id == null || id.isEmpty() || id.isBlank()) {
            Messages.cannot_be_empty.sendMessage((CommandSender)player, "{value}", "crate location id");
            return;
        }
        ConfigurationSection section = this.locations.getConfigurationSection("Locations");
        if (section == null) {
            this.locations.set("Locations.Clear", null);
            Files.locations.save();
            return;
        }
        for (String name : section.getKeys(false)) {
            if (!name.equalsIgnoreCase(id)) continue;
            World world = this.plugin.getServer().getWorld(Objects.requireNonNull(this.locations.getString("Locations." + name + ".World")));
            int x = this.locations.getInt("Locations." + name + ".X");
            int y = this.locations.getInt("Locations." + name + ".Y");
            int z = this.locations.getInt("Locations." + name + ".Z");
            Location loc = new Location(world, (double)x, (double)y, (double)z);
            player.teleport(loc.add(0.5, 0.0, 0.5));
            Messages.crate_teleported.sendMessage((CommandSender)player, "{name}", name);
            return;
        }
        Messages.crate_cannot_teleport.sendMessage((CommandSender)player, "{id}", id);
    }
}

