/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.commands.crates.types.admin.crates;

import com.badbones69.crazycrates.api.enums.Messages;
import com.badbones69.crazycrates.commands.crates.types.BaseCommand;
import com.badbones69.crazycrates.commands.crates.types.admin.crates.migrator.enums.MigrationType;
import com.badbones69.crazycrates.commands.crates.types.admin.crates.migrator.types.MojangMappedMigratorMultiple;
import com.badbones69.crazycrates.commands.crates.types.admin.crates.migrator.types.MojangMappedMigratorSingle;
import com.badbones69.crazycrates.commands.crates.types.admin.crates.migrator.types.deprecation.DeprecatedCrateMigrator;
import com.badbones69.crazycrates.commands.crates.types.admin.crates.migrator.types.deprecation.LegacyColorMigrator;
import com.badbones69.crazycrates.commands.crates.types.admin.crates.migrator.types.deprecation.WeightMigrator;
import com.badbones69.crazycrates.commands.crates.types.admin.crates.migrator.types.plugins.ExcellentCratesMigrator;
import com.badbones69.crazycrates.utils.MiscUtils;
import libs.dev.triumphteam.cmd.bukkit.annotation.Permission;
import libs.dev.triumphteam.cmd.core.annotations.ArgName;
import libs.dev.triumphteam.cmd.core.annotations.Command;
import libs.dev.triumphteam.cmd.core.annotations.Optional;
import libs.dev.triumphteam.cmd.core.annotations.Suggestion;
import org.bukkit.command.CommandSender;
import org.bukkit.permissions.PermissionDefault;

public class CommandMigrate
extends BaseCommand {
    @Command(value="migrate")
    @Permission(value={"crazycrates.migrate"}, def=PermissionDefault.OP)
    public void migrate(CommandSender sender, @ArgName(value="migration_type") @Suggestion(value="migrators") String name, @ArgName(value="crate") @Optional @Suggestion(value="crates") String crateName) {
        MigrationType type = MigrationType.fromName(name);
        if (type == null) {
            Messages.migration_not_available.sendMessage(sender);
            return;
        }
        switch (type) {
            case MOJANG_MAPPED_ALL: {
                new MojangMappedMigratorMultiple(sender, type).run();
                break;
            }
            case MOJANG_MAPPED_SINGLE: {
                if (crateName == null || crateName.isEmpty() || crateName.isBlank() || crateName.equalsIgnoreCase("Menu")) {
                    Messages.cannot_be_empty.sendMessage(sender, "{value}", "crate name");
                    return;
                }
                new MojangMappedMigratorSingle(sender, type, crateName).run();
                break;
            }
            case WEIGHT_MIGRATION: {
                new WeightMigrator(sender, type).run();
                break;
            }
            case LEGACY_COLOR_ALL: {
                new LegacyColorMigrator(sender, type).run();
                break;
            }
            case CRATES_DEPRECATED_ALL: {
                new DeprecatedCrateMigrator(sender, type).run();
                break;
            }
            case SPECIALIZED_CRATES: {
                sender.sendRichMessage(Messages.migration_not_available.getMessage(sender));
                break;
            }
            case EXCELLENT_CRATES: {
                if (!MiscUtils.isExcellentCratesEnabled()) {
                    sender.sendRichMessage(Messages.migration_plugin_not_enabled.getMessage(sender, "{name}", type.getName()));
                    return;
                }
                new ExcellentCratesMigrator(sender).run();
            }
        }
    }
}

