/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.commands.crates.types.admin.crates;

import com.badbones69.crazycrates.api.PrizeManager;
import com.badbones69.crazycrates.api.enums.Messages;
import com.badbones69.crazycrates.api.objects.Crate;
import com.badbones69.crazycrates.api.objects.Prize;
import com.badbones69.crazycrates.commands.crates.types.BaseCommand;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import libs.dev.triumphteam.cmd.bukkit.annotation.Permission;
import libs.dev.triumphteam.cmd.core.annotations.ArgName;
import libs.dev.triumphteam.cmd.core.annotations.Command;
import libs.dev.triumphteam.cmd.core.annotations.Suggestion;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionDefault;
import us.crazycrew.crazycrates.api.enums.types.CrateType;

public class CommandClaim
extends BaseCommand {
    @Command(value="claim")
    @Permission(value={"crazycrates.claim"}, def=PermissionDefault.OP)
    public void add(Player player, @ArgName(value="crate") @Suggestion(value="crates") String crateName) {
        String fileName;
        if (crateName == null || crateName.isEmpty() || crateName.isBlank()) {
            Messages.cannot_be_empty.sendMessage((CommandSender)player, "{value}", "crate name");
            return;
        }
        final Crate crate = this.getCrate((CommandSender)player, crateName, false);
        if (crate == null || crate.getCrateType() == CrateType.menu) {
            Messages.not_a_crate.sendMessage((CommandSender)player, "{crate}", crateName);
            return;
        }
        UUID uuid = player.getUniqueId();
        if (!this.userManager.hasRespinPrize(uuid, fileName = crate.getFileName())) {
            Messages.crate_prize_respins_empty.sendMessage((CommandSender)player, (Map<String, String>)new HashMap<String, String>(){
                {
                    this.put("{crate_pretty}", crate.getCrateName());
                    this.put("{crate}", fileName);
                }
            });
            if (!crate.isCyclePersistRestart()) {
                this.userManager.removeRespinCrate(uuid, fileName, this.userManager.getCrateRespin(uuid, fileName));
            }
            return;
        }
        String prizeName = this.userManager.getRespinPrize(uuid, fileName);
        final Prize prize = crate.getPrize(prizeName);
        if (prize == null) {
            Messages.prize_not_found.sendMessage((CommandSender)player, "{prize}", prizeName);
            if (!crate.isCyclePersistRestart()) {
                this.userManager.removeRespinCrate(uuid, fileName, this.userManager.getCrateRespin(uuid, fileName));
            }
            this.userManager.removeRespinPrize(uuid, fileName);
            return;
        }
        PrizeManager.givePrize(player, crate, prize);
        Messages.crate_prize_respins_redeemed.sendMessage((CommandSender)player, (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("{crate_pretty}", crate.getCrateName());
                this.put("{crate}", fileName);
                this.put("{prize}", prize.getPrizeName());
            }
        });
        if (!crate.isCyclePersistRestart()) {
            this.userManager.removeRespinCrate(uuid, fileName, this.userManager.getCrateRespin(uuid, fileName));
        }
        this.userManager.removeRespinPrize(uuid, fileName);
    }
}

