/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.commands.crates.types;

import ch.jalu.configme.SettingsManager;
import com.badbones69.crazycrates.CrazyCrates;
import com.badbones69.crazycrates.api.enums.Messages;
import com.badbones69.crazycrates.api.events.PlayerReceiveKeyEvent;
import com.badbones69.crazycrates.api.objects.Crate;
import com.badbones69.crazycrates.common.config.ConfigManager;
import com.badbones69.crazycrates.common.config.impl.ConfigKeys;
import com.badbones69.crazycrates.managers.BukkitUserManager;
import com.badbones69.crazycrates.managers.InventoryManager;
import com.badbones69.crazycrates.managers.events.EventManager;
import com.badbones69.crazycrates.managers.events.enums.EventType;
import com.badbones69.crazycrates.tasks.crates.CrateManager;
import com.badbones69.crazycrates.utils.MiscUtils;
import java.util.HashMap;
import libs.com.ryderbelserion.vital.paper.api.files.FileManager;
import libs.dev.triumphteam.cmd.core.annotations.Command;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import us.crazycrew.crazycrates.api.enums.types.CrateType;
import us.crazycrew.crazycrates.api.enums.types.KeyType;

@Command(value="crazycrates", alias={"crates", "crate"})
public abstract class BaseCommand {
    @NotNull
    protected final CrazyCrates plugin = CrazyCrates.getPlugin();
    @NotNull
    protected final InventoryManager inventoryManager = this.plugin.getInventoryManager();
    @NotNull
    protected final BukkitUserManager userManager = this.plugin.getUserManager();
    @NotNull
    protected final CrateManager crateManager = this.plugin.getCrateManager();
    @NotNull
    protected final FileManager fileManager = this.plugin.getVital().getFileManager();
    @NotNull
    protected final SettingsManager config = ConfigManager.getConfig();

    protected void addKey(@NotNull CommandSender sender, @NotNull Player player, @NotNull Crate crate, @NotNull KeyType type, int amount) {
        this.addKey(sender, player, null, crate, type, amount);
    }

    protected void addKey(@NotNull CommandSender sender, @Nullable OfflinePlayer player, @NotNull Crate crate, @NotNull KeyType keyType, int amount) {
        this.addKey(sender, null, player, crate, keyType, amount);
    }

    protected void takeKey(@NotNull CommandSender sender, @NotNull Player player, @NotNull Crate crate, @NotNull KeyType keyType, int amount) {
        this.takeKey(sender, player, null, crate, keyType, amount);
    }

    protected void takeKey(@NotNull CommandSender sender, @Nullable OfflinePlayer player, @NotNull Crate crate, @NotNull KeyType keyType, int amount) {
        this.takeKey(sender, null, player, crate, keyType, amount);
    }

    @NotNull
    protected final KeyType getKeyType(@NotNull String type) {
        if (type.isEmpty()) {
            return KeyType.virtual_key;
        }
        KeyType keyType = KeyType.getFromName(type);
        if (keyType == null || keyType == KeyType.free_key) {
            return KeyType.virtual_key;
        }
        return keyType;
    }

    protected final Crate getCrate(@NotNull CommandSender sender, @NotNull String name, boolean ignoreChecks) {
        if (name.isEmpty()) {
            return null;
        }
        Crate crate = this.crateManager.getCrateFromName(name);
        if (ignoreChecks && (crate == null || crate.getCrateType() == CrateType.menu)) {
            Messages.not_a_crate.sendMessage(sender, "{crate}", name);
            return null;
        }
        return crate;
    }

    @ApiStatus.Internal
    private void takeKey(@NotNull CommandSender sender, @Nullable Player player, @Nullable OfflinePlayer offlinePlayer, @NotNull Crate crate, @NotNull KeyType type, int amount) {
        String fileName = crate.getFileName();
        if (player != null) {
            int totalKeys = this.userManager.getTotalKeys(player.getUniqueId(), fileName);
            if (totalKeys < 1) {
                if (MiscUtils.isLogging()) {
                    this.plugin.getComponentLogger().warn("The player {} does not have enough keys to take.", (Object)player.getName());
                }
                Messages.cannot_take_keys.sendMessage(sender, "{player}", player.getName());
                return;
            }
            if (totalKeys < amount) {
                amount = type == KeyType.physical_key ? this.userManager.getPhysicalKeys(player.getUniqueId(), fileName) : this.userManager.getVirtualKeys(player.getUniqueId(), fileName);
            }
            this.userManager.takeKeys(player.getUniqueId(), fileName, type, amount, false);
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("{amount}", String.valueOf(amount));
            placeholders.put("{keytype}", type.getFriendlyName());
            placeholders.put("{player}", player.getName());
            Messages.take_player_keys.sendMessage(sender, placeholders);
            EventManager.logEvent(EventType.event_key_removed, player, sender, crate, type, amount);
            return;
        }
        if (offlinePlayer != null) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("{amount}", String.valueOf(amount));
            placeholders.put("{keytype}", type.getFriendlyName());
            placeholders.put("{player}", offlinePlayer.getName());
            Messages.take_offline_player_keys.sendMessage(sender, placeholders);
            this.userManager.takeOfflineKeys(offlinePlayer.getUniqueId(), fileName, type, amount);
            EventManager.logEvent(EventType.event_key_removed, offlinePlayer, sender, crate, type, amount);
        }
    }

    @ApiStatus.Internal
    private void addKey(@NotNull CommandSender sender, @Nullable Player player, @Nullable OfflinePlayer offlinePlayer, Crate crate, KeyType type, int amount) {
        String fileName = crate.getFileName();
        if (player != null) {
            PlayerReceiveKeyEvent event = new PlayerReceiveKeyEvent(player, crate, PlayerReceiveKeyEvent.KeyReceiveReason.GIVE_COMMAND, amount);
            this.plugin.getServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            if (crate.getCrateType() == CrateType.crate_on_the_go) {
                MiscUtils.addItem(player, crate.getKey(amount, player));
            } else {
                this.userManager.addKeys(player.getUniqueId(), fileName, type, amount);
            }
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("{amount}", String.valueOf(amount));
            placeholders.put("{player}", player.getName());
            placeholders.put("{keytype}", type.getFriendlyName());
            placeholders.put("{key}", crate.getKeyName());
            boolean fullMessage = this.config.getProperty(ConfigKeys.notify_player_when_inventory_full);
            boolean inventoryCheck = this.config.getProperty(ConfigKeys.give_virtual_keys_when_inventory_full);
            Messages.gave_a_player_keys.sendMessage(sender, placeholders);
            if (!inventoryCheck || !fullMessage && !MiscUtils.isInventoryFull(player) && player.isOnline()) {
                Messages.obtaining_keys.sendMessage((CommandSender)player, placeholders);
            }
            EventManager.logEvent(EventType.event_key_given, player, sender, crate, type, amount);
            return;
        }
        if (offlinePlayer != null) {
            PlayerReceiveKeyEvent event = new PlayerReceiveKeyEvent(offlinePlayer, crate, PlayerReceiveKeyEvent.KeyReceiveReason.GIVE_COMMAND, amount);
            this.plugin.getServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            if (!this.userManager.addOfflineKeys(offlinePlayer.getUniqueId(), fileName, type, amount)) {
                Messages.internal_error.sendMessage(sender);
            } else {
                HashMap<String, String> placeholders = new HashMap<String, String>();
                placeholders.put("{amount}", String.valueOf(amount));
                placeholders.put("{keytype}", type.getFriendlyName());
                placeholders.put("{player}", offlinePlayer.getName());
                Messages.given_offline_player_keys.sendMessage(sender, placeholders);
                EventManager.logEvent(EventType.event_key_given, offlinePlayer, sender, crate, type, amount);
            }
        }
    }
}

