/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.api.objects.gui.buttons;

import com.badbones69.crazycrates.CrazyCrates;
import com.badbones69.crazycrates.api.builders.ItemBuilder;
import com.badbones69.crazycrates.tasks.crates.effects.SoundEffect;
import com.badbones69.crazycrates.utils.MiscUtils;
import com.badbones69.crazycrates.utils.MsgUtils;
import java.util.List;
import java.util.Map;
import libs.com.ryderbelserion.vital.paper.api.builders.gui.interfaces.GuiItem;
import net.kyori.adventure.sound.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.jetbrains.annotations.NotNull;

public class GuiButton {
    protected final CrazyCrates plugin = CrazyCrates.getPlugin();
    private final Map<String, String> placeholders;
    private final ConfigurationSection section;
    private final ItemBuilder guiItem;
    private final List<String> commands;
    private final List<String> messages;

    public GuiButton(ConfigurationSection section, Map<String, String> placeholders) {
        this.guiItem = (ItemBuilder)((ItemBuilder)((ItemBuilder)new ItemBuilder().withType(section.getString("material", "emerald_block"))).setDisplayName(section.getString("name", "No display name found."))).setDisplayLore(section.getStringList("lore"));
        this.commands = section.getStringList("commands");
        this.messages = section.getStringList("messages");
        this.placeholders = placeholders;
        this.section = section;
    }

    @NotNull
    public GuiItem getGuiItem() {
        return this.guiItem.asGuiItem(event -> {
            HumanEntity patt0$temp = event.getWhoClicked();
            if (!(patt0$temp instanceof Player)) {
                return;
            }
            Player player = (Player)patt0$temp;
            player.closeInventory(InventoryCloseEvent.Reason.OPEN_NEW);
            this.commands.forEach(command -> MiscUtils.sendCommand(command, this.placeholders));
            this.messages.forEach(message -> MsgUtils.sendMessage((CommandSender)player, MiscUtils.populatePlaceholders((CommandSender)player, message, this.placeholders), false));
            ConfigurationSection sound = this.section.getConfigurationSection("sound");
            if (sound != null) {
                SoundEffect effect = new SoundEffect(this.section, "sound", "entity.villager.yes", Sound.Source.PLAYER);
                effect.play(player, player.getLocation());
            }
        });
    }

    public final ConfigurationSection getSection() {
        return this.section;
    }
}

