/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.api.objects;

import ch.jalu.configme.SettingsManager;
import com.badbones69.crazycrates.CrazyCrates;
import com.badbones69.crazycrates.api.PrizeManager;
import com.badbones69.crazycrates.api.builders.ItemBuilder;
import com.badbones69.crazycrates.api.enums.misc.Keys;
import com.badbones69.crazycrates.api.objects.Prize;
import com.badbones69.crazycrates.api.objects.Tier;
import com.badbones69.crazycrates.api.objects.crates.CrateHologram;
import com.badbones69.crazycrates.common.config.ConfigManager;
import com.badbones69.crazycrates.common.config.impl.ConfigKeys;
import com.badbones69.crazycrates.managers.BukkitUserManager;
import com.badbones69.crazycrates.tasks.crates.CrateManager;
import com.badbones69.crazycrates.tasks.crates.effects.SoundEffect;
import com.badbones69.crazycrates.tasks.crates.other.AbstractCrateManager;
import com.badbones69.crazycrates.tasks.crates.other.CosmicCrateManager;
import com.badbones69.crazycrates.tasks.menus.CratePreviewMenu;
import com.badbones69.crazycrates.tasks.menus.CrateTierMenu;
import com.badbones69.crazycrates.utils.MiscUtils;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import libs.com.ryderbelserion.vital.paper.api.files.CustomFile;
import libs.com.ryderbelserion.vital.paper.util.AdvUtil;
import libs.com.ryderbelserion.vital.paper.util.DyeUtil;
import libs.com.ryderbelserion.vital.paper.util.ItemUtil;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.Component;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import us.crazycrew.crazycrates.api.enums.types.CrateType;

public class Crate {
    private ItemBuilder previewTierBorderItem;
    private ItemBuilder borderItem;
    private ItemBuilder keyBuilder;
    private AbstractCrateManager manager;
    private final String name;
    private String keyName;
    private int maxSlots;
    private String previewName;
    private boolean previewToggle;
    private boolean borderToggle;
    private boolean previewTierToggle;
    private boolean previewTierBorderToggle;
    private int previewTierCrateRows;
    private Color color;
    private Particle particle;
    private final CrateType crateType;
    private YamlConfiguration file;
    private ArrayList<Prize> prizes;
    private String crateName;
    private boolean giveNewPlayerKeys;
    private int previewChestLines;
    private int newPlayerKeys;
    private List<Tier> tiers;
    private CrateHologram hologram;
    private int maxMassOpen;
    private int requiredKeys;
    private boolean cyclePrize;
    private boolean cyclePersistRestart;
    private boolean cyclePermissionToggle;
    private int cyclePermissionCap;
    private List<String> prizeMessage = new ArrayList<String>();
    private List<String> prizeCommands = new ArrayList<String>();
    private final CrazyCrates plugin = CrazyCrates.getPlugin();
    private final CrateManager crateManager = this.plugin.getCrateManager();
    private final BukkitUserManager userManager = this.plugin.getUserManager();
    private final SettingsManager config = ConfigManager.getConfig();
    private boolean broadcastToggle = false;
    private List<String> broadcastMessages = new ArrayList<String>();
    private String broadcastPermission = "";
    private double sum = 0.0;
    private double tierSum = 0.0;

    public Crate(@NotNull String name, @NotNull String previewName, @NotNull CrateType crateType, @NotNull ItemBuilder key, @NotNull String keyName, @NotNull ArrayList<Prize> prizes, @NotNull YamlConfiguration file, int newPlayerKeys, @NotNull List<Tier> tiers, int maxMassOpen, int requiredKeys, @NotNull List<String> prizeMessage, @NotNull List<String> prizeCommands, @NotNull CrateHologram hologram) {
        this.keyBuilder = (ItemBuilder)((ItemBuilder)key.setDisplayName(keyName)).setPersistentString(Keys.crate_key.getNamespacedKey(), name);
        this.keyName = keyName;
        this.file = file;
        this.name = name;
        this.tiers = tiers;
        this.maxMassOpen = maxMassOpen;
        this.requiredKeys = requiredKeys;
        this.prizeMessage = prizeMessage;
        this.prizeCommands = prizeCommands;
        this.broadcastToggle = this.file.getBoolean("Crate.Settings.Broadcast.Toggle", false);
        this.broadcastMessages = this.file.getStringList("Crate.Settings.Broadcast.Messages");
        this.broadcastPermission = this.file.getString("Crate.Settings.Broadcast.Permission", "");
        this.cyclePrize = this.file.getBoolean("Crate.Settings.Rewards.Re-Roll-Spin", false);
        this.cyclePermissionToggle = this.file.getBoolean("Crate.Settings.Rewards.Permission.Toggle", false);
        this.cyclePersistRestart = this.file.getBoolean("Crate.Settings.Rewards.Permission.Persist", false);
        this.cyclePermissionCap = this.file.getInt("Crate.Settings.Rewards.Permission.Max-Cap", 20);
        for (int node = 1; node <= this.cyclePermissionCap; ++node) {
            if (this.cyclePermissionToggle) {
                MiscUtils.registerPermission("crazycrates.respin." + this.name + "." + node, "Allows you to open the crate " + this.name + node + " amount of times.", false);
                continue;
            }
            MiscUtils.unregisterPermission("crazycrates.respin." + this.name + "." + node);
        }
        if (this.broadcastToggle) {
            MiscUtils.registerPermission(this.broadcastPermission, "Hides the broadcast message if a player has this permission", false);
        } else {
            MiscUtils.unregisterPermission(this.broadcastPermission);
        }
        this.prizes = prizes;
        this.sum = this.prizes.stream().filter(prize -> prize.getWeight() != -1.0).mapToDouble(Prize::getWeight).sum();
        this.crateType = crateType;
        this.previewToggle = file.getBoolean("Crate.Preview.Toggle", false);
        this.borderToggle = file.getBoolean("Crate.Preview.Glass.Toggle", false);
        this.previewTierToggle = file.getBoolean("Crate.tier-preview.toggle", false);
        this.previewTierBorderToggle = file.getBoolean("Crate.tier-preview.glass.toggle", false);
        this.previewName = previewName;
        this.newPlayerKeys = newPlayerKeys;
        this.giveNewPlayerKeys = newPlayerKeys > 0;
        this.setPreviewChestLines(file.getInt("Crate.Preview.ChestLines", 6));
        this.maxSlots = this.previewChestLines * 9;
        this.crateName = file.contains("Crate.CrateName") ? file.getString("Crate.CrateName", " ") : file.getString("Crate.Name", " ");
        @NotNull String borderName = file.getString("Crate.Preview.Glass.Name", " ");
        this.borderItem = (ItemBuilder)((ItemBuilder)((ItemBuilder)((ItemBuilder)new ItemBuilder().withType(file.getString("Crate.Preview.Glass.Item", "gray_stained_glass_pane").toLowerCase())).setCustomModelData(file.getInt("Crate.Preview.Glass.Custom-Model-Data", -1))).setHidingItemFlags(file.getBoolean("Crate.Preview.Glass.HideItemFlags", false))).setDisplayName(borderName);
        @NotNull String previewTierBorderName = file.getString("Crate.tier-preview.glass.name", " ");
        this.previewTierBorderItem = (ItemBuilder)((ItemBuilder)((ItemBuilder)((ItemBuilder)new ItemBuilder().withType(file.getString("Crate.tier-preview.glass.item", "gray_stained_glass_pane").toLowerCase())).setCustomModelData(file.getInt("Crate.tier-preview.glass.custom-model-data", -1))).setHidingItemFlags(file.getBoolean("Crate.tier-preview.glass.hideitemflags", false))).setDisplayName(previewTierBorderName);
        this.setTierPreviewRows(file.getInt("Crate.tier-preview.rows", 5));
        if (this.crateType == CrateType.quad_crate) {
            this.particle = ItemUtil.getParticleType(file.getString("Crate.particles.type", "dust"));
            this.color = DyeUtil.getColor(file.getString("Crate.particles.color", "235,64,52"));
        }
        this.hologram = hologram;
        if (this.crateType == CrateType.cosmic) {
            if (this.file != null) {
                this.manager = new CosmicCrateManager(this.file);
            }
            this.tierSum = this.tiers.stream().filter(tier -> tier.getWeight() != -1.0).mapToDouble(Tier::getWeight).sum();
        }
    }

    public Crate(@NotNull String name) {
        this.crateType = CrateType.menu;
        this.name = name;
    }

    public Color getColor() {
        return this.color;
    }

    public Particle getParticle() {
        return this.particle;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public final boolean isPreviewTierBorderToggle() {
        return this.previewTierBorderToggle;
    }

    public final boolean isPreviewTierToggle() {
        return this.previewTierToggle;
    }

    @NotNull
    public final ItemBuilder getPreviewTierBorderItem() {
        return this.previewTierBorderItem;
    }

    @NotNull
    public final AbstractCrateManager getManager() {
        return this.manager;
    }

    public final boolean isBroadcastToggle() {
        return this.broadcastToggle;
    }

    public final String getBroadcastPermission() {
        return this.broadcastPermission;
    }

    public final List<String> getBroadcastMessages() {
        return this.broadcastMessages;
    }

    public void setPreviewChestLines(int amount) {
        int finalAmount = this.borderToggle && amount < 3 ? 3 : Math.min(amount, 6);
        this.previewChestLines = finalAmount;
    }

    public void setTierPreviewRows(int amount) {
        this.previewTierCrateRows = amount;
    }

    public final int getPreviewTierCrateRows() {
        return this.previewTierCrateRows;
    }

    public final int getPreviewChestLines() {
        return this.previewChestLines;
    }

    public final int getMaxSlots() {
        return this.maxSlots;
    }

    public final boolean canWinPrizes(@NotNull Player player) {
        return this.pickPrize(player) != null;
    }

    @NotNull
    public final List<String> getPrizeMessage() {
        return this.prizeMessage;
    }

    @NotNull
    public final List<String> getPrizeCommands() {
        return this.prizeCommands;
    }

    public Prize pickPrize(@NotNull Player player) {
        ArrayList<Prize> prizes = new ArrayList<Prize>();
        for (Prize prize : this.getPrizes()) {
            int pulls;
            if (prize.getWeight() == -1.0 || (pulls = PrizeManager.getCurrentPulls(prize, this)) != 0 && pulls >= prize.getMaxPulls() || prize.hasPermission(player) && !player.isOp() && prize.hasAlternativePrize()) continue;
            prizes.add(prize);
        }
        return this.getPrize(prizes, MiscUtils.useOtherRandom() ? ThreadLocalRandom.current() : new Random());
    }

    public final Prize pickPrize(@NotNull Player player, @NotNull Tier tier) {
        ArrayList<Prize> prizes = new ArrayList<Prize>();
        for (Prize prize : this.getPrizes()) {
            if (prize.hasPermission(player) && !player.isOp() && prize.hasAlternativePrize() || !prize.getTiers().contains(tier)) continue;
            prizes.add(prize);
        }
        return this.getPrize(prizes, MiscUtils.useOtherRandom() ? ThreadLocalRandom.current() : new Random());
    }

    private Prize getPrize(@NotNull List<Prize> prizes, @NotNull Random random) {
        int index;
        double weight = this.sum;
        double value = random.nextDouble() * weight;
        for (index = 0; index < prizes.size() - 1 && !((value -= prizes.get(index).getWeight()) < 0.0); ++index) {
        }
        return prizes.get(index);
    }

    public double getChance(double weight) {
        return weight / this.sum * 100.0;
    }

    public double getTierChance(double weight) {
        return weight / this.tierSum * 100.0;
    }

    public void setPrize(@NotNull List<Prize> prizes) {
        this.purge();
        this.prizes.addAll(prizes.stream().filter(prize -> prize.getWeight() != -1.0).toList());
    }

    public void purge() {
        this.prizes.clear();
    }

    public Prize pickPrize(@NotNull Player player, @NotNull Location location) {
        Prize prize = this.pickPrize(player);
        if (prize.useFireworks()) {
            MiscUtils.spawnFirework(location, null);
        }
        return prize;
    }

    public final boolean isCyclePermissionToggle() {
        return this.cyclePermissionToggle;
    }

    public final int getCyclePermissionCap() {
        return this.cyclePermissionCap;
    }

    @NotNull
    public final String getFileName() {
        return this.name;
    }

    @NotNull
    public final String getPreviewName() {
        return this.previewName;
    }

    public final boolean isPreviewEnabled() {
        return this.previewToggle;
    }

    public final boolean isBorderToggle() {
        return this.borderToggle;
    }

    @NotNull
    public final ItemBuilder getBorderItem() {
        return this.borderItem;
    }

    @NotNull
    public final String getCrateName() {
        return this.crateName;
    }

    public final CratePreviewMenu getPreview(Player player) {
        return this.getPreview(player, null);
    }

    public final CratePreviewMenu getPreview(Player player, @Nullable Tier tier) {
        return new CratePreviewMenu(player, this, tier);
    }

    public final CrateTierMenu getTierPreview(Player player) {
        return new CrateTierMenu(player, this);
    }

    public final CrateType getCrateType() {
        return this.crateType;
    }

    @NotNull
    public final ItemStack getKey() {
        return this.keyBuilder.asItemStack();
    }

    @NotNull
    public final ItemStack getKey(Player player) {
        return this.userManager.addPlaceholders((ItemBuilder)this.keyBuilder.setPlayer(player), this).asItemStack();
    }

    @NotNull
    public final ItemStack getKey(int amount) {
        return ((ItemBuilder)this.keyBuilder.setAmount(amount)).asItemStack();
    }

    @NotNull
    public final ItemStack getKey(int amount, Player player) {
        return ((ItemBuilder)this.userManager.addPlaceholders((ItemBuilder)this.keyBuilder.setPlayer(player), this).setAmount(amount)).asItemStack();
    }

    @NotNull
    public final YamlConfiguration getFile() {
        return this.file;
    }

    @NotNull
    public final List<Prize> getPrizes() {
        return this.prizes;
    }

    public final double getSum() {
        return this.sum;
    }

    @Nullable
    public final Prize getPrize(@NotNull String name) {
        if (name.isEmpty()) {
            return null;
        }
        Prize prize = null;
        for (Prize key : this.prizes) {
            if (!key.getSectionName().equalsIgnoreCase(name)) continue;
            prize = key;
            break;
        }
        return prize;
    }

    @Nullable
    public final Prize getPrize(@NotNull ItemStack item) {
        return this.getPrize((String)item.getPersistentDataContainer().getOrDefault(Keys.crate_prize.getNamespacedKey(), PersistentDataType.STRING, (Object)""));
    }

    public final boolean doNewPlayersGetKeys() {
        return this.giveNewPlayerKeys;
    }

    public final int getNewPlayerKeys() {
        return this.newPlayerKeys;
    }

    public void addEditorItem(@Nullable ItemStack itemStack, @NotNull String prizeName, double weight) {
        if (itemStack == null || prizeName.isEmpty() || weight <= 0.0) {
            return;
        }
        ConfigurationSection section = this.getPrizeSection();
        if (section == null) {
            return;
        }
        this.setItem(itemStack, prizeName, section, weight, "");
    }

    public void addEditorItem(@Nullable ItemStack itemStack, @NotNull String prizeName, @NotNull String tier, double weight) {
        if (tier.isEmpty() || prizeName.isEmpty() || weight <= 0.0 || itemStack == null) {
            return;
        }
        ConfigurationSection section = this.getPrizeSection();
        if (section == null) {
            return;
        }
        this.setItem(itemStack, prizeName, section, weight, tier);
    }

    @Nullable
    public final ConfigurationSection getPrizeSection() {
        ConfigurationSection section = this.file.getConfigurationSection("Crate");
        if (section == null) {
            return null;
        }
        return section.getConfigurationSection("Prizes");
    }

    private void setItem(@Nullable ItemStack itemStack, @NotNull String prizeName, @Nullable ConfigurationSection section, double weight, final String tier) {
        if (prizeName.isEmpty() || section == null || weight <= 0.0 || itemStack == null) {
            return;
        }
        String tiers = this.getPath(prizeName, "Tiers");
        if (!section.contains(prizeName)) {
            section.set(this.getPath(prizeName, "MaxRange"), (Object)100);
        }
        if (itemStack.hasItemMeta()) {
            List lore;
            Component displayName;
            ItemMeta itemMeta = itemStack.getItemMeta();
            if (itemMeta.hasDisplayName() && (displayName = itemMeta.displayName()) != null) {
                section.set(this.getPath(prizeName, "DisplayName"), (Object)AdvUtil.fromComponent(displayName));
            }
            if (itemMeta.hasLore() && (lore = itemMeta.lore()) != null) {
                section.set(this.getPath(prizeName, "DisplayLore"), AdvUtil.fromComponent(lore));
            }
        }
        if (this.config.getProperty(ConfigKeys.use_new_item_editor).booleanValue()) {
            final String toBase64 = ItemUtil.toBase64(itemStack);
            section.set(this.getPath(prizeName, "DisplayData"), (Object)toBase64);
            String items = this.getPath(prizeName, "Items");
            if (section.contains(items)) {
                List list = section.getStringList(items);
                list.add("Data:" + toBase64);
                section.set(items, (Object)list);
            } else {
                section.set(items, (Object)new ArrayList<Object>(){
                    {
                        this.add("Data:" + toBase64);
                    }
                });
            }
        } else {
            Object editors;
            ArrayList<ItemStack> editorItems = new ArrayList<ItemStack>();
            if (section.contains(prizeName + ".Editor-Items") && (editors = section.getList(prizeName + ".Editor-Items")) != null) {
                editors.forEach(item -> editorItems.add((ItemStack)item));
            }
            editorItems.add(itemStack);
            section.set(this.getPath(prizeName, "Editor-Items"), editorItems);
        }
        section.set(this.getPath(prizeName, "DisplayItem"), (Object)itemStack.getType().getKey().getKey());
        section.set(this.getPath(prizeName, "DisplayAmount"), (Object)itemStack.getAmount());
        ArrayList<CallSite> enchantments = new ArrayList<CallSite>();
        for (Map.Entry entry : itemStack.getEnchantments().entrySet()) {
            enchantments.add((CallSite)((Object)(((Enchantment)entry.getKey()).getKey().getKey() + ":" + String.valueOf(entry.getValue()))));
        }
        if (!enchantments.isEmpty()) {
            section.set(this.getPath(prizeName, "DisplayEnchantments"), enchantments);
        }
        section.set(this.getPath(prizeName, "Weight"), (Object)weight);
        if (!tier.isEmpty()) {
            if (section.contains(tiers)) {
                List list = section.getStringList(tiers);
                list.add(tier);
                section.set(tiers, (Object)list);
            } else {
                section.set(tiers, (Object)new ArrayList<Object>(){
                    {
                        this.add(tier);
                    }
                });
            }
        }
        this.saveFile();
    }

    @NotNull
    private String getPath(String section, String path) {
        if (section.isEmpty() || path.isEmpty()) {
            return "";
        }
        return section + "." + path;
    }

    private void saveFile() {
        if (this.name.isEmpty()) {
            return;
        }
        CustomFile customFile = this.plugin.getVital().getFileManager().getFile(this.name, true);
        if (customFile != null) {
            customFile.save();
        }
        this.crateManager.reloadCrate(this.crateManager.getCrateFromName(this.name));
    }

    @NotNull
    public final List<Tier> getTiers() {
        return this.tiers;
    }

    @Nullable
    public final Tier getTier(@Nullable String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        Tier tier = null;
        for (Tier key : this.tiers) {
            if (!key.getName().equalsIgnoreCase(name)) continue;
            tier = key;
            break;
        }
        return tier;
    }

    public final int getMaxMassOpen() {
        return this.maxMassOpen;
    }

    public final int getRequiredKeys() {
        return this.requiredKeys;
    }

    @NotNull
    public final CrateHologram getHologram() {
        return this.hologram;
    }

    @NotNull
    public final List<ItemStack> getPreviewItems(@Nullable Player player, @Nullable Tier tier) {
        ArrayList<ItemStack> prizes = new ArrayList<ItemStack>();
        for (Prize prize : this.getPrizes()) {
            if (prize.getWeight() == -1.0) continue;
            if (tier == null) {
                prizes.add(player == null ? prize.getDisplayItem(this) : prize.getDisplayItem(player, this));
                continue;
            }
            if (!prize.getTiers().contains(tier)) continue;
            prizes.add(player == null ? prize.getDisplayItem(this) : prize.getDisplayItem(player, this));
        }
        return prizes;
    }

    public final boolean isCyclePersistRestart() {
        return this.cyclePersistRestart;
    }

    public final boolean isCyclePrize() {
        return this.cyclePrize;
    }

    public final boolean useRequiredKeys() {
        return ConfigManager.getConfig().getProperty(ConfigKeys.crate_use_required_keys) != false && this.requiredKeys > 0;
    }

    public void playSound(@NotNull Player player, @NotNull Location location, @NotNull String type, @NotNull String fallback, @NotNull Sound.Source source) {
        if (type.isEmpty() && fallback.isEmpty()) {
            return;
        }
        ConfigurationSection section = this.getFile().getConfigurationSection("Crate.sound");
        if (section != null) {
            SoundEffect sound = new SoundEffect(section, type, fallback, source);
            sound.play(player, location);
        }
    }
}

