/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.api.builders.types.features;

import com.badbones69.crazycrates.api.builders.gui.StaticInventoryBuilder;
import com.badbones69.crazycrates.api.enums.Messages;
import com.badbones69.crazycrates.api.objects.Crate;
import com.badbones69.crazycrates.api.objects.gui.GuiSettings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import libs.com.ryderbelserion.vital.paper.api.builders.gui.interfaces.Gui;
import libs.com.ryderbelserion.vital.paper.api.builders.gui.interfaces.GuiFiller;
import libs.com.ryderbelserion.vital.paper.api.builders.gui.interfaces.GuiItem;
import libs.com.ryderbelserion.vital.paper.util.scheduler.FoliaRunnable;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CrateSpinMenu
extends StaticInventoryBuilder {
    private final GuiSettings settings;
    private final Player player = this.getPlayer();
    private final Crate crate = this.getCrate();
    private final Gui gui = this.getGui();

    public CrateSpinMenu(Player player, GuiSettings settings) {
        super(player, settings.getCrate(), settings.getTitle(), settings.getRows());
        this.settings = settings;
    }

    @Override
    public void open() {
        if (this.crate == null) {
            return;
        }
        if (this.settings.isFillerToggled()) {
            GuiItem item = this.settings.getFillerStack();
            GuiFiller guiFiller = this.gui.getFiller();
            switch (this.settings.getFillerType()) {
                case FILL: {
                    guiFiller.fill(item);
                    break;
                }
                case FILL_BORDER: {
                    guiFiller.fillBorder(item);
                    break;
                }
                case FILL_TOP: {
                    guiFiller.fillTop(item);
                    break;
                }
                case FILL_SIDE: {
                    guiFiller.fillSide(GuiFiller.Side.BOTH, List.of(item));
                    break;
                }
                case FILL_BOTTOM: {
                    guiFiller.fillBottom(item);
                }
            }
        }
        final UUID uuid = this.player.getUniqueId();
        final String fileName = this.crate.getFileName();
        this.settings.getButtons().forEach((slot, button) -> this.gui.setItem((int)slot, button.getGuiItem()));
        this.gui.setOpenGuiAction(action -> this.userManager.addRespinPrize(uuid, fileName, this.settings.getPrize().getSectionName()));
        this.gui.setCloseGuiAction(action -> {
            new FoliaRunnable(this.plugin.getServer().getGlobalRegionScheduler()){

                @Override
                public void run() {
                    if (CrateSpinMenu.this.userManager.hasRespinPrize(uuid, fileName)) {
                        Messages.crate_prize_respin_not_claimed.sendMessage((CommandSender)CrateSpinMenu.this.player, (Map<String, String>)new HashMap<String, String>(){
                            {
                                this.put("{crate_pretty}", CrateSpinMenu.this.crate.getCrateName());
                                this.put("{crate}", fileName);
                                this.put("{prize}", CrateSpinMenu.this.userManager.getRespinPrize(uuid, fileName));
                            }
                        });
                    }
                }
            }.runDelayed(this.plugin, 20L);
            this.crateManager.removePlayerFromOpeningList(this.player);
            this.crateManager.removeCrateInUse(this.player);
            this.crateManager.removeCrateTask(this.player);
            this.crateManager.endCrate(this.player);
        });
        this.gui.setItem(this.settings.getSlot(), new GuiItem(this.settings.getPrize().getDisplayItem(this.player, this.crate)));
        this.gui.open(this.player);
    }
}

