/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.api.builders.gui;

import ch.jalu.configme.SettingsManager;
import com.badbones69.crazycrates.CrazyCrates;
import com.badbones69.crazycrates.api.objects.Crate;
import com.badbones69.crazycrates.common.config.ConfigManager;
import com.badbones69.crazycrates.common.config.impl.ConfigKeys;
import com.badbones69.crazycrates.managers.BukkitUserManager;
import com.badbones69.crazycrates.managers.InventoryManager;
import com.badbones69.crazycrates.tasks.crates.CrateManager;
import com.badbones69.crazycrates.tasks.menus.CrateMainMenu;
import com.badbones69.crazycrates.utils.MiscUtils;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import libs.com.ryderbelserion.vital.paper.api.builders.gui.interfaces.GuiItem;
import libs.com.ryderbelserion.vital.paper.api.builders.gui.types.BaseGui;
import libs.com.ryderbelserion.vital.paper.api.enums.Support;
import me.clip.placeholderapi.PlaceholderAPI;
import net.kyori.adventure.sound.Sound;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public abstract class InventoryBuilder {
    protected final Player player;
    protected final CrazyCrates plugin = CrazyCrates.getPlugin();
    protected final CrateManager crateManager = this.plugin.getCrateManager();
    protected final BukkitUserManager userManager = this.plugin.getUserManager();
    protected final InventoryManager inventoryManager = this.plugin.getInventoryManager();
    protected final SettingsManager config = ConfigManager.getConfig();

    public InventoryBuilder(Player player) {
        this.player = player;
    }

    public void addMenuButton(Player player, Crate crate, BaseGui gui, int row, int column) {
        if (this.config.getProperty(ConfigKeys.enable_crate_menu).booleanValue()) {
            gui.setItem(gui.getSlotFromRowColumn(row, column), new GuiItem(this.inventoryManager.getMenuButton(player), action -> {
                if (this.config.getProperty(ConfigKeys.menu_button_override).booleanValue()) {
                    List<String> commands = this.config.getProperty(ConfigKeys.menu_button_command_list);
                    if (!commands.isEmpty()) {
                        commands.forEach(value -> {
                            String command = value.replaceAll("%player%", Matcher.quoteReplacement(player.getName())).replaceAll("%crate%", Matcher.quoteReplacement(crate.getFileName()));
                            MiscUtils.sendCommand(command);
                        });
                        return;
                    }
                    if (MiscUtils.isLogging()) {
                        this.plugin.getComponentLogger().warn("The property {} is empty, so no commands were run.", (Object)ConfigKeys.menu_button_command_list.getPath());
                    }
                    return;
                }
                crate.playSound(player, player.getLocation(), "click-sound", "ui.button.click", Sound.Source.PLAYER);
                new CrateMainMenu(player, this.config.getProperty(ConfigKeys.inventory_name), this.config.getProperty(ConfigKeys.inventory_rows)).open();
            }));
        }
    }

    public final String parse(Player player, String title) {
        return Support.placeholder_api.isEnabled() ? PlaceholderAPI.setPlaceholders((Player)player, (String)title) : title;
    }

    public final String getCrates(@NotNull String option) {
        if (option.isEmpty()) {
            return "";
        }
        UUID uuid = this.player.getUniqueId();
        for (Crate crate : this.crateManager.getUsableCrates()) {
            String fileName = crate.getFileName();
            String lowerCase = fileName.toLowerCase();
            option = option.replaceAll("%" + lowerCase + "}", "" + this.userManager.getVirtualKeys(uuid, fileName)).replaceAll("%" + lowerCase + "_physical%", "" + this.userManager.getPhysicalKeys(uuid, fileName)).replaceAll("%" + lowerCase + "_total%", "" + this.userManager.getTotalKeys(uuid, fileName)).replaceAll("%" + lowerCase + "_opened%", "" + this.userManager.getCrateOpened(uuid, fileName));
        }
        return option;
    }
}

