/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.api.builders.gui;

import com.badbones69.crazycrates.api.builders.gui.InventoryBuilder;
import com.badbones69.crazycrates.api.objects.Crate;
import java.util.function.Consumer;
import libs.com.ryderbelserion.vital.paper.api.builders.gui.PaginatedBuilder;
import libs.com.ryderbelserion.vital.paper.api.builders.gui.interfaces.Gui;
import libs.com.ryderbelserion.vital.paper.api.builders.gui.interfaces.GuiItem;
import libs.com.ryderbelserion.vital.paper.api.builders.gui.types.PaginatedGui;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public abstract class DynamicInventoryBuilder
extends InventoryBuilder {
    private final PaginatedGui gui;
    private final Crate crate;

    public DynamicInventoryBuilder(Player player, Crate crate, String title, int rows) {
        super(player);
        this.gui = ((PaginatedBuilder)((PaginatedBuilder)((PaginatedBuilder)Gui.paginated().setTitle(title)).setRows(rows)).disableInteractions()).create();
        this.crate = crate;
    }

    public DynamicInventoryBuilder(Player player, String title, int rows) {
        this(player, null, title, rows);
    }

    public void open() {
        this.open(null);
    }

    public void open(@Nullable Consumer<DynamicInventoryBuilder> consumer) {
        if (consumer != null) {
            consumer.accept(this);
        }
    }

    public final Player getPlayer() {
        return this.player;
    }

    @Nullable
    public Crate getCrate() {
        return this.crate;
    }

    public final PaginatedGui getGui() {
        return this.gui;
    }

    public void setBackButton(int row, int column, boolean isPreview) {
        if (this.gui.getCurrentPageNumber() <= 1) {
            this.setFillerItem(row, column, isPreview);
            return;
        }
        this.gui.setItem(this.gui.getSlotFromRowColumn(row, column), new GuiItem(this.inventoryManager.getBackButton(this.player, this.gui), event -> {
            event.setCancelled(true);
            this.gui.previous();
            int page = this.gui.getCurrentPageNumber();
            if (page <= 1) {
                this.setFillerItem(row, column, isPreview);
            } else {
                this.setBackButton(row, column, isPreview);
            }
            if (page < this.gui.getMaxPages()) {
                this.setNextButton(this.gui.getRows(), 6, isPreview);
            }
        }));
        this.addMenuButton(this.player, this.crate, this.gui, this.gui.getRows(), 5);
    }

    private void setFillerItem(int row, int column, boolean isPreview) {
        if (this.crate != null && this.crate.isBorderToggle()) {
            this.gui.setItem(row, column, this.crate.getBorderItem().asGuiItem());
        } else if (!isPreview) {
            this.gui.removeItem(row, column);
            this.gui.setItem(row, column, new GuiItem(Material.BLACK_STAINED_GLASS_PANE));
        }
    }

    public void setNextButton(int row, int column, boolean isPreview) {
        if (this.gui.getCurrentPageNumber() >= this.gui.getMaxPages()) {
            return;
        }
        this.gui.setItem(this.gui.getSlotFromRowColumn(row, column), new GuiItem(this.inventoryManager.getNextButton(this.player, this.gui), event -> {
            event.setCancelled(true);
            this.gui.next();
            int page = this.gui.getCurrentPageNumber();
            if (page >= this.gui.getMaxPages()) {
                this.setFillerItem(row, column, isPreview);
            } else {
                this.setNextButton(row, column, isPreview);
            }
            int rows = this.gui.getRows();
            if (page <= 1) {
                if (this.crate != null && this.crate.isBorderToggle()) {
                    this.gui.setItem(rows, 4, this.crate.getBorderItem().asGuiItem());
                } else if (!isPreview) {
                    this.gui.removeItem(rows, 4);
                    this.gui.setItem(rows, 4, new GuiItem(Material.BLACK_STAINED_GLASS_PANE));
                }
            } else {
                this.setBackButton(rows, 4, isPreview);
            }
        }));
        this.addMenuButton(this.player, this.crate, this.gui, this.gui.getRows(), 5);
    }
}

