/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.api.builders;

import ch.jalu.configme.SettingsManager;
import com.badbones69.crazycrates.CrazyCrates;
import com.badbones69.crazycrates.api.objects.Crate;
import com.badbones69.crazycrates.api.objects.Tier;
import com.badbones69.crazycrates.common.config.ConfigManager;
import com.badbones69.crazycrates.common.config.impl.ConfigKeys;
import com.badbones69.crazycrates.managers.BukkitUserManager;
import com.badbones69.crazycrates.managers.InventoryManager;
import com.badbones69.crazycrates.tasks.crates.CrateManager;
import com.badbones69.crazycrates.utils.MiscUtils;
import java.util.List;
import java.util.regex.Matcher;
import libs.com.ryderbelserion.vital.paper.api.enums.Support;
import libs.com.ryderbelserion.vital.paper.util.AdvUtil;
import libs.com.ryderbelserion.vital.paper.util.MiscUtil;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Server;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.jetbrains.annotations.NotNull;

public abstract class InventoryBuilder
implements InventoryHolder,
Listener {
    @NotNull
    protected final CrazyCrates plugin = CrazyCrates.getPlugin();
    @NotNull
    protected final BukkitUserManager userManager = this.plugin.getUserManager();
    @NotNull
    protected final InventoryManager inventoryManager = this.plugin.getInventoryManager();
    @NotNull
    protected final CrateManager crateManager = this.plugin.getCrateManager();
    @NotNull
    protected final Server server = this.plugin.getServer();
    private Inventory inventory;
    private Player player;
    private String title;
    private Crate crate;
    private int size;
    private int page;
    private List<Tier> tiers;

    public InventoryBuilder(@NotNull Player player, @NotNull String title, int size) {
        this.player = player;
        this.title = title;
        this.size = size;
        String inventoryTitle = Support.placeholder_api.isEnabled() ? PlaceholderAPI.setPlaceholders((Player)this.getPlayer(), (String)this.title) : this.title;
        this.inventory = this.server.createInventory((InventoryHolder)this, this.size, AdvUtil.parse(inventoryTitle));
    }

    public InventoryBuilder(@NotNull Player player, @NotNull String title, int size, @NotNull Crate crate) {
        this.player = player;
        this.title = title;
        this.size = size;
        this.crate = crate;
        String inventoryTitle = Support.placeholder_api.isEnabled() ? PlaceholderAPI.setPlaceholders((Player)this.getPlayer(), (String)this.title) : this.title;
        this.inventory = this.server.createInventory((InventoryHolder)this, this.size, AdvUtil.parse(inventoryTitle));
    }

    public InventoryBuilder(@NotNull Player player, @NotNull String title, int size, int page, @NotNull Crate crate) {
        this.player = player;
        this.title = title;
        this.size = size;
        this.page = page;
        this.crate = crate;
        String inventoryTitle = Support.placeholder_api.isEnabled() ? PlaceholderAPI.setPlaceholders((Player)this.getPlayer(), (String)this.title) : this.title;
        this.inventory = this.server.createInventory((InventoryHolder)this, this.size, AdvUtil.parse(inventoryTitle));
    }

    public InventoryBuilder(@NotNull Player player, @NotNull String title, int size, @NotNull Crate crate, @NotNull List<Tier> tiers) {
        this.player = player;
        this.title = title;
        this.size = size;
        this.crate = crate;
        this.tiers = tiers;
        String inventoryTitle = Support.placeholder_api.isEnabled() ? PlaceholderAPI.setPlaceholders((Player)this.getPlayer(), (String)this.title) : this.title;
        this.inventory = this.server.createInventory((InventoryHolder)this, this.size, AdvUtil.parse(inventoryTitle));
    }

    public InventoryBuilder() {
    }

    public boolean overrideMenu() {
        SettingsManager config = ConfigManager.getConfig();
        if (config.getProperty(ConfigKeys.menu_button_override).booleanValue()) {
            List<String> commands = config.getProperty(ConfigKeys.menu_button_command_list);
            if (!commands.isEmpty()) {
                commands.forEach(value -> {
                    String command = value.replaceAll("%player%", Matcher.quoteReplacement(this.player.getName())).replaceAll("%crate%", Matcher.quoteReplacement(this.crate.getFileName()));
                    MiscUtils.sendCommand(command);
                });
                return true;
            }
            if (MiscUtils.isLogging()) {
                this.plugin.getComponentLogger().warn("The property {} is empty so no commands were run.", (Object)ConfigKeys.menu_button_command_list.getPath());
            }
            return true;
        }
        return false;
    }

    public abstract InventoryBuilder build();

    public abstract void run(InventoryClickEvent var1);

    @EventHandler
    public void onPlayerClick(InventoryClickEvent event) {
        this.run(event);
    }

    public void size(int size) {
        this.size = size;
    }

    public final int getSize() {
        return this.size;
    }

    public final int getSize(boolean isBorderEnabled) {
        return this.size - (isBorderEnabled ? 18 : (this.size != 9 ? 9 : 0));
    }

    public void setPage(int page) {
        this.page = page;
    }

    public final int getPage() {
        return this.page;
    }

    @NotNull
    public final Crate getCrate() {
        return this.crate;
    }

    public void title(@NotNull String title) {
        this.title = title;
    }

    public final boolean contains(@NotNull String message) {
        return this.title.contains(message);
    }

    @NotNull
    public final Player getPlayer() {
        return this.player;
    }

    @NotNull
    public final List<Tier> getTiers() {
        return this.tiers;
    }

    @NotNull
    public final InventoryView getView() {
        return this.getPlayer().getOpenInventory();
    }

    public void sendTitleChange() {
        MiscUtil.updateTitle(this.player, this.title);
    }

    @NotNull
    public final Inventory getInventory() {
        return this.inventory;
    }
}

