/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.api.builders;

import ch.jalu.configme.SettingsManager;
import com.badbones69.crazycrates.CrazyCrates;
import com.badbones69.crazycrates.api.PrizeManager;
import com.badbones69.crazycrates.api.builders.InventoryBuilder;
import com.badbones69.crazycrates.api.builders.ItemBuilder;
import com.badbones69.crazycrates.api.events.CrateOpenEvent;
import com.badbones69.crazycrates.api.objects.Crate;
import com.badbones69.crazycrates.api.objects.Tier;
import com.badbones69.crazycrates.common.config.ConfigManager;
import com.badbones69.crazycrates.common.config.impl.ConfigKeys;
import com.badbones69.crazycrates.managers.BukkitUserManager;
import com.badbones69.crazycrates.managers.events.enums.EventType;
import com.badbones69.crazycrates.tasks.crates.CrateManager;
import com.badbones69.crazycrates.tasks.crates.effects.SoundEffect;
import com.badbones69.crazycrates.tasks.crates.other.CosmicCrateManager;
import com.badbones69.crazycrates.tasks.menus.CratePrizeMenu;
import com.badbones69.crazycrates.utils.MiscUtils;
import com.google.common.base.Preconditions;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.List;
import libs.com.ryderbelserion.vital.paper.util.scheduler.FoliaRunnable;
import net.kyori.adventure.sound.Sound;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import us.crazycrew.crazycrates.api.enums.types.CrateType;
import us.crazycrew.crazycrates.api.enums.types.KeyType;

public abstract class CrateBuilder
extends FoliaRunnable {
    protected final CrazyCrates plugin = CrazyCrates.getPlugin();
    protected final CrateManager crateManager = this.plugin.getCrateManager();
    protected final BukkitUserManager userManager = this.plugin.getUserManager();
    private final InventoryBuilder builder;
    private final Inventory inventory;
    private final Location location;
    private final Player player;
    private final Crate crate;
    private final int size;
    protected final SettingsManager config = ConfigManager.getConfig();
    protected boolean isCancelled = false;

    public CrateBuilder(@NotNull Crate crate, @NotNull Player player, int size, @NotNull String title) {
        super(player.getScheduler(), null);
        Preconditions.checkNotNull((Object)crate, (Object)"Crate can't be null.");
        Preconditions.checkNotNull((Object)player, (Object)"Player can't be null.");
        this.location = player.getLocation();
        this.player = player;
        this.crate = crate;
        this.size = size;
        this.builder = new CratePrizeMenu(player, title.isEmpty() ? this.getTitle() : title, size, crate);
        this.inventory = this.builder.build().getInventory();
    }

    public CrateBuilder(@NotNull Crate crate, @NotNull Player player, int size) {
        this(crate, player, size, "");
    }

    public CrateBuilder(@NotNull Crate crate, @NotNull Player player, int size, @NotNull Location location) {
        super(player.getScheduler(), null);
        Preconditions.checkNotNull((Object)crate, (Object)"Crate can't be null.");
        Preconditions.checkNotNull((Object)player, (Object)"Player can't be null.");
        Preconditions.checkNotNull((Object)location, (Object)"Location can't be null.");
        this.location = location;
        this.player = player;
        this.crate = crate;
        this.size = size;
        this.builder = new CratePrizeMenu(player, this.getTitle(), size, crate);
        this.inventory = this.builder.build().getInventory();
    }

    public CrateBuilder(@NotNull Crate crate, @NotNull Player player, @NotNull Location location) {
        super(player.getScheduler(), null);
        Preconditions.checkNotNull((Object)crate, (Object)"Crate can't be null.");
        Preconditions.checkNotNull((Object)player, (Object)"Player can't be null.");
        Preconditions.checkNotNull((Object)location, (Object)"Location can't be null.");
        this.location = location;
        this.player = player;
        this.crate = crate;
        this.size = 0;
        this.builder = null;
        this.inventory = null;
    }

    public CrateBuilder(@NotNull Crate crate, @NotNull Player player) {
        this(crate, player, player.getLocation());
    }

    public abstract void open(@NotNull KeyType var1, boolean var2, boolean var3, EventType var4);

    public void addCrateTask(@NotNull ScheduledTask task) {
        this.crateManager.addCrateTask(this.player, task);
    }

    public void removeTask() {
        this.crateManager.removeCrateTask(this.player);
    }

    public void cancelCrateTask() {
        this.crateManager.getCrateTask(this.player).cancel();
        this.removeTask();
    }

    public final boolean hasCrateTask() {
        return this.crateManager.hasCrateTask(this.player);
    }

    @NotNull
    public final Crate getCrate() {
        return this.crate;
    }

    @NotNull
    public final String getTitle() {
        return this.crate.getCrateName();
    }

    @NotNull
    public final Player getPlayer() {
        return this.player;
    }

    public final int getSize() {
        return this.size;
    }

    public final boolean isFireCracker() {
        return this.crate.getCrateType() == CrateType.fire_cracker;
    }

    public final boolean isCosmicCrate() {
        return this.crate.getCrateType() == CrateType.cosmic;
    }

    public final YamlConfiguration getFile() {
        return this.crate.getFile();
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public Location getLocation() {
        return this.location;
    }

    public InventoryBuilder getMenu() {
        return this.builder.build();
    }

    public void setItem(int slot, @NotNull ItemStack item) {
        this.getInventory().setItem(slot, item);
    }

    public void setItem(int slot, @NotNull Material material, @NotNull String name, @NotNull List<String> lore) {
        this.getInventory().setItem(slot, ((ItemBuilder)((ItemBuilder)((ItemBuilder)new ItemBuilder(material).setPlayer(this.getPlayer())).setDisplayName(name)).setDisplayLore(lore)).asItemStack());
    }

    public void setItem(int slot, @NotNull Material material, @NotNull String name) {
        this.getInventory().setItem(slot, ((ItemBuilder)((ItemBuilder)new ItemBuilder(material).setPlayer(this.getPlayer())).setDisplayName(name)).asItemStack());
    }

    public void setCustomGlassPane(int slot) {
        this.getInventory().setItem(slot, this.getRandomGlassPane());
    }

    @NotNull
    public final ItemStack getRandomGlassPane() {
        return ((ItemBuilder)MiscUtils.getRandomPaneColor().setDisplayName(" ")).asItemStack();
    }

    public final boolean isCrateEventValid(@NotNull KeyType keyType, boolean checkHand, boolean isSilent, EventType eventType) {
        CrateOpenEvent event = new CrateOpenEvent(this.player, this.crate, keyType, checkHand, this.crate.getFile(), isSilent, eventType);
        event.callEvent();
        if (event.isCancelled() && MiscUtils.isLogging()) {
            String fileName = this.crate.getFileName();
            if (this.config.getProperty(ConfigKeys.use_new_permission_system).booleanValue()) {
                if (this.player.hasPermission("crazycrates.deny.open." + fileName)) {
                    this.plugin.getComponentLogger().warn("{} could not open {} due to having the permission preventing them from opening the crate.", (Object)this.player.getName(), (Object)fileName);
                } else {
                    this.plugin.getComponentLogger().warn("{} could not open {} due to no valid prizes being found which led to the event being cancelled.", (Object)this.player.getName(), (Object)fileName);
                }
            } else if (!this.player.hasPermission("crazycrates.open." + fileName)) {
                this.plugin.getComponentLogger().warn("{} could not open {} due to having the permission preventing them from opening the crate.", (Object)this.player.getName(), (Object)fileName);
            } else {
                this.plugin.getComponentLogger().warn("{} could not open {} due to no valid prizes being found which led to the event being cancelled.", (Object)this.player.getName(), (Object)fileName);
            }
        }
        return event.isCancelled();
    }

    @Override
    public void cancel() {
        super.cancel();
        this.isCancelled = true;
    }

    public ItemStack getDisplayItem() {
        return this.getCrate().pickPrize(this.getPlayer()).getDisplayItem(this.getPlayer(), this.getCrate());
    }

    public ItemStack getDisplayItem(@NotNull Tier tier) {
        return this.getCrate().pickPrize(this.getPlayer(), tier).getDisplayItem(this.getPlayer(), this.getCrate());
    }

    public void playSound(@NotNull String type, @NotNull Sound.Source source, @NotNull String fallback) {
        if (type.isEmpty() && fallback.isEmpty()) {
            return;
        }
        ConfigurationSection section = this.getFile().getConfigurationSection("Crate.sound");
        if (section != null) {
            Player player = this.getPlayer();
            SoundEffect sound = new SoundEffect(section, type, fallback, source);
            sound.play(player, player.getLocation());
        }
    }

    public final void populateTiers() {
        CosmicCrateManager manager = (CosmicCrateManager)this.crate.getManager();
        ItemBuilder itemBuilder = (ItemBuilder)manager.getMysteryCrate().setPlayer(this.player);
        for (int slot = 0; slot <= this.size; ++slot) {
            ((ItemBuilder)itemBuilder.addNamePlaceholder("%Slot%", String.valueOf(slot))).addLorePlaceholder("%Slot%", String.valueOf(slot));
            itemBuilder.setAmount(slot);
            Tier tier = PrizeManager.getTier(this.crate);
            if (tier == null) continue;
            this.crateManager.addTier(this.player, slot, tier);
            this.getInventory().setItem(this.getInventory().firstEmpty(), itemBuilder.asItemStack());
        }
    }
}

