/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates;

import com.badbones69.crazycrates.commands.CommandManager;
import com.badbones69.crazycrates.common.Server;
import com.badbones69.crazycrates.listeners.BrokeLocationsListener;
import com.badbones69.crazycrates.listeners.CrateControlListener;
import com.badbones69.crazycrates.listeners.MiscListener;
import com.badbones69.crazycrates.listeners.crates.CrateOpenListener;
import com.badbones69.crazycrates.listeners.crates.types.CosmicCrateListener;
import com.badbones69.crazycrates.listeners.crates.types.MobileCrateListener;
import com.badbones69.crazycrates.listeners.crates.types.QuadCrateListener;
import com.badbones69.crazycrates.listeners.crates.types.WarCrateListener;
import com.badbones69.crazycrates.listeners.other.EntityDamageListener;
import com.badbones69.crazycrates.managers.BukkitUserManager;
import com.badbones69.crazycrates.managers.InventoryManager;
import com.badbones69.crazycrates.support.MetricsWrapper;
import com.badbones69.crazycrates.support.holograms.HologramManager;
import com.badbones69.crazycrates.support.placeholders.PlaceholderAPISupport;
import com.badbones69.crazycrates.tasks.crates.CrateManager;
import com.badbones69.crazycrates.utils.MiscUtils;
import java.util.List;
import java.util.Locale;
import java.util.Timer;
import libs.com.ryderbelserion.vital.paper.Vital;
import libs.com.ryderbelserion.vital.paper.api.enums.Support;
import libs.com.ryderbelserion.vital.paper.util.AdvUtil;
import me.arcaniax.hdb.api.HeadDatabaseAPI;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class CrazyCrates
extends JavaPlugin {
    private final Vital vital;
    private final Timer timer;
    private final long startTime = System.nanoTime();
    private InventoryManager inventoryManager;
    private BukkitUserManager userManager;
    private CrateManager crateManager;
    private HeadDatabaseAPI api;
    private Server instance;

    @ApiStatus.Internal
    public static CrazyCrates getPlugin() {
        return (CrazyCrates)JavaPlugin.getPlugin(CrazyCrates.class);
    }

    public CrazyCrates() {
        this.vital = new Vital(this);
        this.timer = new Timer();
    }

    public void onEnable() {
        this.instance = new Server(this.getDataFolder());
        this.instance.apply();
        this.vital.getFileManager().addFile("locations.yml").addFile("data.yml").addFile("respin-gui.yml", "guis").addFile("crates.log", "logs").addFile("keys.log", "logs").addFolder("crates").addFolder("schematics").init();
        MiscUtils.janitor();
        MiscUtils.save();
        MiscUtils.registerPermissions();
        if (Support.head_database.isEnabled()) {
            this.api = new HeadDatabaseAPI();
        }
        this.inventoryManager = new InventoryManager();
        this.crateManager = new CrateManager();
        this.userManager = new BukkitUserManager();
        this.instance.setUserManager(this.userManager);
        this.crateManager.loadHolograms();
        this.inventoryManager.loadButtons();
        this.crateManager.loadCrates();
        CommandManager.load();
        new MetricsWrapper(this, 4514).start();
        List.of(new BrokeLocationsListener(), new CrateControlListener(), new EntityDamageListener(), new MobileCrateListener(), new CosmicCrateListener(), new QuadCrateListener(), new CrateOpenListener(), new WarCrateListener(), new MiscListener()).forEach(listener -> this.getServer().getPluginManager().registerEvents(listener, (Plugin)this));
        if (Support.placeholder_api.isEnabled()) {
            if (MiscUtils.isLogging()) {
                this.getComponentLogger().info("PlaceholderAPI support is enabled!");
            }
            new PlaceholderAPISupport().register();
        }
        if (MiscUtils.isLogging()) {
            for (Support value : Support.values()) {
                if (value.isEnabled()) {
                    this.getComponentLogger().info(AdvUtil.parse("<bold><gold>" + value.getName() + " <green>FOUND"));
                    continue;
                }
                this.getComponentLogger().info(AdvUtil.parse("<bold><gold>" + value.getName() + " <red>NOT FOUND"));
            }
            this.getComponentLogger().info("Done ({})!", (Object)String.format(Locale.ROOT, "%.3fs", (double)(System.nanoTime() - this.startTime) / 1.0E9));
        }
    }

    public void onDisable() {
        this.getServer().getGlobalRegionScheduler().cancelTasks((Plugin)this);
        this.getServer().getAsyncScheduler().cancelTasks((Plugin)this);
        this.timer.cancel();
        if (this.crateManager != null) {
            this.crateManager.purgeRewards();
            HologramManager holograms = this.crateManager.getHolograms();
            if (holograms != null) {
                holograms.purge(true);
            }
        }
        if (this.instance != null) {
            this.instance.disable();
        }
        MiscUtils.janitor();
    }

    @ApiStatus.Internal
    public final InventoryManager getInventoryManager() {
        return this.inventoryManager;
    }

    @ApiStatus.Internal
    public final BukkitUserManager getUserManager() {
        return this.userManager;
    }

    @ApiStatus.Internal
    public final CrateManager getCrateManager() {
        return this.crateManager;
    }

    @ApiStatus.Internal
    @Nullable
    public final HeadDatabaseAPI getApi() {
        if (this.api == null) {
            return null;
        }
        return this.api;
    }

    @ApiStatus.Internal
    public final Server getInstance() {
        return this.instance;
    }

    @ApiStatus.Internal
    public final Vital getVital() {
        return this.vital;
    }

    @ApiStatus.Internal
    public final Timer getTimer() {
        return this.timer;
    }
}

