/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.properties;

import ch.jalu.configme.properties.BaseProperty;
import ch.jalu.configme.properties.convertresult.ConvertErrorRecorder;
import ch.jalu.configme.properties.types.PropertyType;
import ch.jalu.configme.resource.PropertyReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class SetProperty<T>
extends BaseProperty<Set<T>> {
    private final PropertyType<T> type;

    @SafeVarargs
    public SetProperty(@NotNull String path, @NotNull PropertyType<T> type, T ... defaultValue) {
        this(path, type, SetProperty.newSet(defaultValue));
    }

    public SetProperty(@NotNull String path, @NotNull PropertyType<T> type, @NotNull Set<T> defaultValue) {
        super(path, Collections.unmodifiableSet(defaultValue));
        Objects.requireNonNull(type, "type");
        this.type = type;
    }

    @Override
    protected Set<T> getFromReader(@NotNull PropertyReader reader, @NotNull ConvertErrorRecorder errorRecorder) {
        List<?> list = reader.getList(this.getPath());
        if (list != null) {
            return list.stream().map(elem -> this.type.convert(elem, errorRecorder)).filter(Objects::nonNull).collect(this.setCollector());
        }
        return null;
    }

    @Override
    @NotNull
    public Object toExportValue(@NotNull Set<T> value) {
        return value.stream().map(this.type::toExportValue).collect(Collectors.toList());
    }

    @NotNull
    protected Collector<T, ?, Set<T>> setCollector() {
        return Collectors.collectingAndThen(Collectors.toCollection(LinkedHashSet::new), Collections::unmodifiableSet);
    }

    @NotNull
    private static <E> Set<E> newSet(E @NotNull [] array) {
        return Arrays.stream(array).collect(Collectors.toCollection(LinkedHashSet::new));
    }
}

