/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.beanmapper.leafvaluehandler;

import ch.jalu.configme.beanmapper.leafvaluehandler.AbstractLeafValueHandler;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BigNumberLeafValueHandler
extends AbstractLeafValueHandler {
    private static final BigDecimal BIG_DECIMAL_SCIENTIFIC_THRESHOLD = new BigDecimal("1E100");

    @Override
    @Nullable
    protected Object convert(@Nullable Class<?> clazz, @Nullable Object value) {
        if (clazz != BigInteger.class && clazz != BigDecimal.class) {
            return null;
        }
        if (value instanceof String) {
            return this.fromString(clazz, (String)value);
        }
        if (value instanceof Number) {
            return this.fromNumber(clazz, (Number)value);
        }
        return null;
    }

    @Override
    @Nullable
    public Object toExportValue(@Nullable Object value) {
        Class<?> valueType;
        Class<?> clazz = valueType = value == null ? null : value.getClass();
        if (valueType == BigInteger.class) {
            return value.toString();
        }
        if (valueType == BigDecimal.class) {
            BigDecimal bigDecimal = (BigDecimal)value;
            return bigDecimal.abs().compareTo(BIG_DECIMAL_SCIENTIFIC_THRESHOLD) >= 0 ? bigDecimal.toString() : bigDecimal.toPlainString();
        }
        return null;
    }

    @Nullable
    protected Object fromString(@NotNull Class<?> targetClass, @NotNull String value) {
        try {
            return targetClass == BigInteger.class ? new BigInteger(value) : new BigDecimal(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @NotNull
    protected Object fromNumber(@NotNull Class<?> targetClass, @NotNull Number value) {
        if (targetClass.isInstance(value)) {
            return value;
        }
        if (targetClass == BigInteger.class) {
            if (value instanceof Double || value instanceof Float) {
                return BigDecimal.valueOf(value.doubleValue()).toBigInteger();
            }
            return BigInteger.valueOf(value.longValue());
        }
        if (value instanceof Integer || value instanceof Long) {
            return BigDecimal.valueOf(value.longValue());
        }
        return BigDecimal.valueOf(value.doubleValue()).stripTrailingZeros();
    }
}

