/*
 * Decompiled with CFR 0.152.
 */
package org.padrewin.coldhudbar;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.clip.placeholderapi.PlaceholderAPI;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ColdHudBar
extends JavaPlugin
implements Listener {
    private String actionBarMessage;
    private String pluginTag;
    private String noPermissionMessage;
    private String reloadSuccessMessage;
    private String version;
    private String developer;
    private String github;

    public void onEnable() {
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") == null) {
            this.getLogger().warning("PlaceholderAPI is not loaded. This plugin won't work properly.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        String name = this.getDescription().getName();
        this.getLogger().info("");
        this.getLogger().info("  ____ ___  _     ____  ");
        this.getLogger().info(" / ___/ _ \\| |   |  _ \\ ");
        this.getLogger().info("| |  | | | | |   | | | |");
        this.getLogger().info("| |__| |_| | |___| |_| |");
        this.getLogger().info(" \\____\\___/|_____|____/");
        this.getLogger().info("    " + name + " v" + this.getDescription().getVersion());
        this.getLogger().info("    Author(s): " + (String)this.getDescription().getAuthors().get(0));
        this.getLogger().info("    (c) Cold Development. All rights reserved.");
        this.getLogger().info("");
        this.saveDefaultConfig();
        this.loadConfig();
        this.getCommand("hudactionbar").setExecutor((CommandExecutor)this);
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        new BukkitRunnable(){

            public void run() {
                for (Player player : ColdHudBar.this.getServer().getOnlinePlayers()) {
                    String message = PlaceholderAPI.setPlaceholders((Player)player, (String)ColdHudBar.this.actionBarMessage);
                    message = ColdHudBar.this.translateHexColorCodes(message);
                    player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)message));
                }
            }
        }.runTaskTimer((Plugin)this, 0L, 20L);
    }

    public void onDisable() {
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            String message = PlaceholderAPI.setPlaceholders((Player)player, (String)this.actionBarMessage);
            message = this.translateHexColorCodes(message);
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)message));
        } else {
            this.getLogger().warning("PlaceholderAPI is not loaded.");
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (command.getName().equalsIgnoreCase("hudactionbar") && args.length > 0) {
            if (args[0].equalsIgnoreCase("reload")) {
                if (sender.hasPermission("hudactionbar.reload")) {
                    this.reloadConfig();
                    this.loadConfig();
                    sender.sendMessage(this.formatMessage(this.pluginTag + " " + this.reloadSuccessMessage));
                } else {
                    sender.sendMessage(this.formatMessage(this.pluginTag + " " + this.noPermissionMessage));
                }
                return true;
            }
            if (args[0].equalsIgnoreCase("info")) {
                sender.sendMessage(ChatColor.DARK_GRAY + "Version: v1.0");
                sender.sendMessage(ChatColor.DARK_GRAY + "Developer: padrewin");
                sender.sendMessage(ChatColor.DARK_GRAY + "GitHub: https://github.com/padrewin");
                return true;
            }
        }
        return false;
    }

    private void loadConfig() {
        File configFile = new File(this.getDataFolder(), "config.yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
        this.pluginTag = config.getString("pluginTag");
        this.actionBarMessage = config.getString("actionBarMessage");
        this.noPermissionMessage = config.getString("messages.noPermission");
        this.reloadSuccessMessage = config.getString("messages.reloadSuccess");
        this.version = config.getString("info.version");
        this.developer = config.getString("info.developer");
        this.github = config.getString("info.github");
        this.actionBarMessage = this.translateHexColorCodes(this.actionBarMessage);
    }

    private String formatMessage(String message) {
        message = this.translateHexColorCodes(message);
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    private String translateHexColorCodes(String message) {
        Pattern hexPattern = Pattern.compile("&#([A-Fa-f0-9]{6})");
        Matcher matcher = hexPattern.matcher(message);
        StringBuffer buffer = new StringBuffer(message.length());
        while (matcher.find()) {
            String hexColor = matcher.group(1);
            String replacement = ChatColor.of((String)("#" + hexColor)).toString();
            matcher.appendReplacement(buffer, replacement);
        }
        matcher.appendTail(buffer);
        message = buffer.toString();
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }
}

