/*
 * Decompiled with CFR 0.152.
 */
package net.Zrips.CMILib.Version;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.Zrips.CMILib.CMILib;
import net.Zrips.CMILib.Messages.CMIMessages;
import net.Zrips.CMILib.Version.MinecraftPlatform;
import org.bukkit.Bukkit;
import org.bukkit.World;

public enum Version {
    v1_7_R1,
    v1_7_R2,
    v1_7_R3,
    v1_7_R4,
    v1_8_R1,
    v1_8_R2,
    v1_8_R3,
    v1_9_R1,
    v1_9_R2,
    v1_10_R1,
    v1_11_R1,
    v1_12_R1,
    v1_13_R1,
    v1_13_R2,
    v1_13_R3,
    v1_14_R1,
    v1_14_R2,
    v1_15_R1,
    v1_15_R2,
    v1_16_R1,
    v1_16_R2,
    v1_16_R3,
    v1_17_R1,
    v1_18_R1,
    v1_18_R2,
    v1_19_R1,
    v1_19_R2,
    v1_19_R3,
    v1_20_R1,
    v1_20_R2,
    v1_20_R3(4),
    v1_20_R4(5, 6),
    v1_21_R1(0, 1),
    v1_21_R2,
    v1_21_R3,
    v1_22_R1,
    v1_22_R2,
    v1_22_R3,
    v1_23_R1,
    v1_23_R2,
    v1_23_R3;

    private Integer value;
    private int[] minorVersions = null;
    private String shortVersion;
    private static int subVersion;
    private static Version current;
    private static MinecraftPlatform platform;
    private static boolean testServer;

    private Version(int ... versions) {
        this();
        this.minorVersions = versions;
    }

    private Version() {
        try {
            this.value = Integer.valueOf(this.name().replaceAll("[^\\d.]", ""));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.shortVersion = this.name().substring(0, this.name().length() - 3);
    }

    public Integer getValue() {
        return this.value;
    }

    public static boolean isAsyncProcessing() {
        return Version.getPlatform().isAsync();
    }

    @Deprecated
    public static boolean isPaperBranch() {
        return Version.getPlatform().isAsync();
    }

    public String getShortVersion() {
        return this.shortVersion;
    }

    public String getShortFormated() {
        return this.shortVersion.replace("v", "").replace("_", ".") + ".x";
    }

    public String getFormated() {
        return this.shortVersion.replace("v", "").replace("_", ".") + "." + subVersion;
    }

    @Deprecated
    public static boolean isPaper() {
        return Version.isPaperBranch();
    }

    public static boolean isSpigot() {
        return !Version.getPlatform().equals((Object)MinecraftPlatform.craftbukkit);
    }

    public static boolean isFolia() {
        return Version.getPlatform().equals((Object)MinecraftPlatform.folia);
    }

    public static boolean isPurpur() {
        return Version.getPlatform().equals((Object)MinecraftPlatform.purpur);
    }

    public static MinecraftPlatform getPlatform() {
        if (platform != null) {
            return platform;
        }
        String version = Bukkit.getVersion().toLowerCase();
        if (version.contains("mohist")) {
            platform = MinecraftPlatform.mohist;
            return platform;
        }
        if (version.contains("arclight")) {
            platform = MinecraftPlatform.arclight;
            return platform;
        }
        if (version.contains("purpur")) {
            platform = MinecraftPlatform.purpur;
            return platform;
        }
        if (version.contains("tuinity")) {
            platform = MinecraftPlatform.tuinity;
            return platform;
        }
        if (version.contains("yatopia")) {
            platform = MinecraftPlatform.yatopia;
            return platform;
        }
        if (version.contains("tacospigot")) {
            platform = MinecraftPlatform.tacospigot;
            return platform;
        }
        if (version.contains("glowstone")) {
            platform = MinecraftPlatform.glowstone;
            return platform;
        }
        if (version.contains("pufferfish")) {
            platform = MinecraftPlatform.pufferfish;
            return platform;
        }
        if (version.contains("airplane")) {
            platform = MinecraftPlatform.airplane;
            return platform;
        }
        if (version.contains("fabric")) {
            platform = MinecraftPlatform.fabric;
            return platform;
        }
        if (version.contains("magma")) {
            platform = MinecraftPlatform.magma;
            return platform;
        }
        try {
            Class.forName("io.papermc.paper.threadedregions.RegionizedServer");
            platform = MinecraftPlatform.folia;
            return platform;
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                Class.forName("com.destroystokyo.paper.PaperConfig");
                try {
                    String versionText = (String)Bukkit.class.getMethod("getVersionMessage", new Class[0]).invoke(Bukkit.class, new Object[0]);
                    for (MinecraftPlatform one : MinecraftPlatform.values()) {
                        if (!one.isAsync() || !versionText.toLowerCase().contains(one.toString().toLowerCase())) continue;
                        platform = one;
                    }
                }
                catch (Throwable versionText) {
                    // empty catch block
                }
                if (platform == null) {
                    platform = MinecraftPlatform.paper;
                }
                return platform;
            }
            catch (ClassNotFoundException versionText) {
                try {
                    Class.forName("org.spigotmc.SpigotConfig");
                    platform = MinecraftPlatform.spigot;
                }
                catch (ClassNotFoundException e1) {
                    platform = MinecraftPlatform.craftbukkit;
                }
                return platform;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Version getCurrent() {
        void var5_19;
        Version one;
        void var5_16;
        if (current != null) {
            return current;
        }
        String[] v = Bukkit.getServer().getClass().getPackage().getName().split("\\.");
        try {
            String vr = Bukkit.getBukkitVersion().split("-", 2)[0];
            String[] stringArray = vr.split("\\.");
            subVersion = stringArray.length <= 2 ? 0 : Integer.parseInt(stringArray[2]);
        }
        catch (Throwable vr) {
            // empty catch block
        }
        String vv = v[v.length - 1];
        for (Version version : Version.values()) {
            if (!version.name().equalsIgnoreCase(vv)) continue;
            current = version;
            break;
        }
        if (current != null) {
            return current;
        }
        String string = Bukkit.getBukkitVersion().split("-", 2)[0];
        Version[] versionArray = Version.values();
        int classNotFoundException = versionArray.length;
        boolean bl = false;
        block5: while (var5_16 < classNotFoundException) {
            one = versionArray[var5_16];
            if (one.name().equalsIgnoreCase(string)) {
                current = one;
                break;
            }
            List<String> cleanVersion = one.getMinorVersions();
            for (String cv : cleanVersion) {
                if (!string.equalsIgnoreCase(cv)) continue;
                current = one;
                break block5;
            }
            ++var5_16;
        }
        if (current != null) {
            return current;
        }
        block7: for (int i = 1; i < 10; ++i) {
            try {
                Class.forName("org.bukkit.craftbukkit.v" + string.replace(".", "_") + "_R" + i + ".entity.CraftPlayer");
                for (Version one2 : Version.values()) {
                    if (!one2.name().equalsIgnoreCase("v" + string.replace(".", "_") + "_R" + i)) continue;
                    current = one2;
                    break block7;
                }
                break;
            }
            catch (ClassNotFoundException classNotFoundException2) {
                continue;
            }
        }
        if (current != null) {
            return current;
        }
        Version[] versionArray2 = Version.values();
        int n = versionArray2.length;
        boolean bl2 = false;
        while (var5_19 < n) {
            one = versionArray2[var5_19];
            if (string.startsWith(one.getSimplifiedVersion()) || string.startsWith(one.getSimplifiedVersion().substring(0, one.getSimplifiedVersion().length() - 1))) {
                current = one;
                CMIMessages.consoleMessage("&c[CMILib] &eServer version detection needs aditional update");
                break;
            }
            ++var5_19;
        }
        return current;
    }

    public boolean isLower(Version version) {
        return this.getValue() < version.getValue();
    }

    public boolean isHigher(Version version) {
        return this.getValue() > version.getValue();
    }

    public boolean isEqualOrLower(Version version) {
        return this.getValue() <= version.getValue();
    }

    public boolean isEqualOrHigher(Version version) {
        return this.getValue() >= version.getValue();
    }

    public static boolean isCurrentEqualOrHigher(Version v) {
        return Version.getCurrent().getValue() >= v.getValue();
    }

    public static boolean isCurrentHigher(Version v) {
        return Version.getCurrent().getValue() > v.getValue();
    }

    public static boolean isCurrentLower(Version v) {
        return Version.getCurrent().getValue() < v.getValue();
    }

    public static boolean isCurrentEqualOrLower(Version v) {
        return Version.getCurrent().getValue() <= v.getValue();
    }

    public static boolean isCurrentEqual(Version v) {
        return Version.getCurrent().getValue() == v.getValue();
    }

    public static boolean isCurrentSubEqualOrHigher(int subVersion) {
        return Version.subVersion >= subVersion;
    }

    public static boolean isCurrentSubHigher(int subVersion) {
        return Version.subVersion > subVersion;
    }

    public static boolean isCurrentSubLower(int subVersion) {
        return Version.subVersion < subVersion;
    }

    public static boolean isCurrentSubEqualOrLower(int subVersion) {
        return Version.subVersion <= subVersion;
    }

    public static boolean isCurrentSubEqual(int subVersion) {
        return Version.subVersion == subVersion;
    }

    public static Integer convertVersion(String v) {
        v = v.replaceAll("[^\\d.]", "");
        Integer version = 0;
        if (v.contains(".")) {
            String lVersion = "";
            for (String one : v.split("\\.")) {
                String s = one;
                if (s.length() == 1) {
                    s = "0" + s;
                }
                lVersion = lVersion + s;
            }
            try {
                version = Integer.parseInt(lVersion);
            }
            catch (Exception exception) {}
        } else {
            try {
                version = Integer.parseInt(v);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return version;
    }

    public static String deconvertVersion(Integer v) {
        StringBuilder version = new StringBuilder();
        String vs = String.valueOf(v);
        while (vs.length() > 0) {
            int subv = 0;
            try {
                if (vs.length() > 2) {
                    subv = Integer.parseInt(vs.substring(vs.length() - 2));
                    version.insert(0, "." + subv);
                } else {
                    subv = Integer.parseInt(vs);
                    version.insert(0, subv);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (vs.length() <= 2) break;
            vs = vs.substring(0, vs.length() - 2);
        }
        return version.toString();
    }

    public static boolean isTestServer() {
        return testServer;
    }

    private String getSimplifiedVersion() {
        return this.name().substring(1).replace("_", ".").split("R", 2)[0];
    }

    public List<String> getMinorVersions() {
        if (this.minorVersions == null) {
            return new ArrayList<String>();
        }
        return Arrays.stream(this.minorVersions).mapToObj(version -> this.getSimplifiedVersion() + version).collect(Collectors.toList());
    }

    static {
        subVersion = 0;
        current = null;
        platform = null;
        testServer = false;
        Version.getCurrent();
        CMIMessages.consoleMessage("&3Server version: " + Version.getCurrent().toString() + " - " + Version.getCurrent().getFormated() + " - " + (Object)((Object)Version.getPlatform()) + "  " + Bukkit.getVersion());
        if (CMILib.getInstance().getReflectionManager().getServerName().equals("LT_Craft") && ((World)Bukkit.getWorlds().get(0)).getSeed() == 1782374759L) {
            testServer = true;
        }
    }
}

