/*
 * Decompiled with CFR 0.152.
 */
package net.Zrips.CMILib.Time;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum timeModifier {
    s(1),
    m(60),
    h(3600),
    d(86400),
    w(604800),
    M(2592000),
    Y(31536000);

    static Pattern patern;
    private int modifier = 0;

    private timeModifier(int modifier) {
        this.modifier = modifier;
    }

    public int getModifier() {
        return this.modifier;
    }

    public void setModifier(int modifier) {
        this.modifier = modifier;
    }

    public static Long getTimeRangeFromString(String time) {
        try {
            return Long.parseLong(time);
        }
        catch (Exception exception) {
            Matcher match = patern.matcher(time);
            Long total = null;
            block4: while (match.find()) {
                String t = match.group(1);
                for (timeModifier one : timeModifier.values()) {
                    if (!t.endsWith(one.name())) continue;
                    try {
                        Long amount = Long.parseLong(t.substring(0, t.length() - one.name().length()));
                        time = time.replace(t, "");
                        if (total == null) {
                            total = 0L;
                        }
                        total = total + amount * (long)one.getModifier();
                    }
                    catch (Exception e) {
                        continue block4;
                    }
                }
            }
            if (!time.isEmpty()) {
                return null;
            }
            return total;
        }
    }

    public static Double getDoubleTimeRangeFromString(String time) {
        try {
            return Double.parseDouble(time);
        }
        catch (Exception exception) {
            Matcher match = patern.matcher(time);
            Double total = null;
            block4: while (match.find()) {
                String t = match.group(1);
                for (timeModifier one : timeModifier.values()) {
                    if (!t.endsWith(one.name())) continue;
                    try {
                        Double amount = Double.parseDouble(t.substring(0, t.length() - one.name().length()));
                        time = time.replace(t, "");
                        if (total == null) {
                            total = 0.0;
                        }
                        total = total + amount * Double.valueOf(one.getModifier());
                    }
                    catch (Exception e) {
                        continue block4;
                    }
                }
            }
            if (!time.isEmpty()) {
                return null;
            }
            return total;
        }
    }

    static {
        patern = Pattern.compile("(\\d+[mshdwMY])");
    }
}

