/*
 * Decompiled with CFR 0.152.
 */
package net.Zrips.CMILib.Skins;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;
import net.Zrips.CMILib.CMILib;
import net.Zrips.CMILib.FileHandler.ConfigReader;
import net.Zrips.CMILib.Skins.CMISkin;
import org.bukkit.configuration.file.YamlConfiguration;

public class SkinManager {
    public HashMap<UUID, CMISkin> skinCacheByUUID = new HashMap();
    public HashMap<String, CMISkin> skinCacheByName = new HashMap();
    protected HashMap<String, List<String>> preFetchNames = new HashMap();
    protected HashMap<String, UUID> preFetchUUIDs = new HashMap();
    CMILib plugin;
    private long SkinUpdateTimer = 60L;
    private long SkinRequestFrequency = 60L;
    Long lastUpdateRequest = 0L;
    boolean saving = false;

    public SkinManager(CMILib plugin) {
        this.plugin = plugin;
    }

    public void loadConfig() {
        ConfigReader cfg = this.plugin.getConfigManager().getConfigFile();
        cfg.addComment("Skins.SkinUpdateTimer", "Defines time in minutes how often we want to update skin information from online Mojang servers", "Keep in mind that your server can only send 1 request every minute, so keep it at a decent amount, hour or more", "So if you have this set to 1 hour, then player skin information will be updated if player old skin information is older then 1 hour", "This only triggers when player joins server or changes skin manually");
        this.SkinUpdateTimer = cfg.get("Skins.SkinUpdateTimer", 1320);
        this.SkinUpdateTimer = this.SkinUpdateTimer < 5L ? 5L : this.SkinUpdateTimer;
        cfg.addComment("Skins.SkinRequestFrequency", "Defines time in minutes how often we want to send requests to Mojang servers", "This is to limit amount of requests in specific time to avoid clutter with possible requests");
        this.SkinRequestFrequency = cfg.get("Skins.SkinRequestFrequency", 10);
        this.SkinRequestFrequency = this.SkinRequestFrequency < 1L ? 1L : this.SkinRequestFrequency;
    }

    public void removeSkinFromCache(String playerName) {
        CMISkin skin = this.skinCacheByName.remove(playerName);
        if (skin != null) {
            this.skinCacheByUUID.remove(skin.getUuid());
        }
    }

    public void removeSkinFromCache(UUID uuid) {
        CMISkin skin = this.skinCacheByUUID.remove(uuid);
        if (skin != null) {
            this.skinCacheByName.remove(skin.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean setSkin(GameProfile profile, UUID uuid) {
        if (this.checkCache(profile, uuid)) {
            return true;
        }
        try {
            HttpsURLConnection connection = (HttpsURLConnection)new URL(String.format("https://sessionserver.mojang.com/session/minecraft/profile/%s?unsigned=false", uuid.toString().replace("-", ""))).openConnection();
            if (connection.getResponseCode() == 200) {
                InputStream stream = connection.getInputStream();
                BufferedReader buffer = new BufferedReader(new InputStreamReader(stream));
                try {
                    String reply = buffer.readLine();
                    String lines = "";
                    Iterator iter = buffer.lines().iterator();
                    while (iter.hasNext()) {
                        lines = lines + (String)iter.next();
                    }
                    reply = lines.replace(" ", "");
                    if (!reply.contains("name")) {
                        boolean bl = this.checkCache(profile, uuid);
                        return bl;
                    }
                    String playerName = reply.split("\"name\":\"")[1].split("\"")[0];
                    if (!reply.contains("value")) {
                        boolean bl = this.checkCache(profile, uuid);
                        return bl;
                    }
                    String skin = reply.split("\"value\":\"")[1].split("\"")[0];
                    if (!reply.contains("signature")) {
                        boolean bl = this.checkCache(profile, uuid);
                        return bl;
                    }
                    String signature = reply.split("\"signature\":\"")[1].split("\"")[0];
                    CMISkin cmiSkin = new CMISkin(playerName, uuid, skin, signature);
                    cmiSkin.setLastUpdate(System.currentTimeMillis());
                    this.lastUpdateRequest = System.currentTimeMillis();
                    this.skinCacheByUUID.put(uuid, cmiSkin);
                    this.skinCacheByName.put(playerName, cmiSkin);
                    if (profile == null) return true;
                    profile.getProperties().removeAll((Object)"textures");
                    profile.getProperties().put((Object)"textures", (Object)new Property("textures", skin, signature));
                    return true;
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                    return true;
                }
                finally {
                    buffer.close();
                    stream.close();
                    connection.disconnect();
                }
            }
            if (this.checkCache(profile, uuid)) {
                return true;
            }
            System.out.println("Connection could not be opened (Response code " + connection.getResponseCode() + ", " + connection.getResponseMessage() + ")");
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean checkCache(GameProfile profile, UUID uuid) {
        if (profile == null) {
            return false;
        }
        CMISkin cache = this.skinCacheByUUID.get(uuid);
        if (cache != null && cache.getSkin() != null && cache.getSignature() != null && cache.getLastUpdate() + this.SkinUpdateTimer * 60L * 1000L > System.currentTimeMillis()) {
            profile.getProperties().removeAll((Object)"textures");
            profile.getProperties().put((Object)"textures", (Object)new Property("textures", cache.getSkin(), cache.getSignature()));
            return true;
        }
        return false;
    }

    public CMISkin getSkin(String name) {
        CMISkin cache;
        if (name == null) {
            return null;
        }
        UUID onlineUUID = null;
        if (name.length() == 36) {
            onlineUUID = UUID.fromString(name);
        } else {
            cache = this.skinCacheByName.get(name);
            if (cache != null) {
                return cache;
            }
            if (!this.preFetchUUIDS().containsKey(name)) {
                onlineUUID = this.getUUID(name);
                this.preFetchUUIDS().put(name, onlineUUID);
            } else {
                onlineUUID = this.preFetchUUIDS().get(name);
            }
        }
        if (onlineUUID == null) {
            return null;
        }
        cache = this.skinCacheByUUID.get(onlineUUID);
        if (cache != null) {
            return cache;
        }
        this.setSkin(null, onlineUUID);
        cache = this.skinCacheByUUID.get(onlineUUID);
        if (cache != null) {
            return cache;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UUID getUUID(String name) {
        UUID cached = this.preFetchUUIDS().get(name);
        if (cached != null) {
            return cached;
        }
        String target = "https://api.mojang.com/users/profiles/minecraft/" + name;
        StringBuilder response = new StringBuilder();
        HttpURLConnection connection = null;
        try {
            String line;
            URL url = new URL(target);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setUseCaches(false);
            connection.setDoOutput(true);
            connection.connect();
            if (connection.getResponseCode() != 200) {
                UUID uUID = null;
                return uUID;
            }
            InputStream is = connection.getInputStream();
            BufferedReader rd = new BufferedReader(new InputStreamReader(is));
            while ((line = rd.readLine()) != null) {
                response.append(line);
                response.append('\r').append('\n');
            }
            rd.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        UUID uuid = null;
        try {
            Pattern pattern = Pattern.compile("(\")([a-zA-Z0-9]{32})(\")");
            Matcher matcher = pattern.matcher(response.toString());
            if (matcher.find()) {
                uuid = UUID.fromString(matcher.group(2).replaceFirst("([0-9a-fA-F]{8})([0-9a-fA-F]{4})([0-9a-fA-F]{4})([0-9a-fA-F]{4})([0-9a-fA-F]+)", "$1-$2-$3-$4-$5"));
            }
        }
        catch (Exception e) {
            try {
                String id = response.toString().split("\",\"")[0].split(":")[1].replace("\"", "").replaceFirst("([0-9a-fA-F]{8})([0-9a-fA-F]{4})([0-9a-fA-F]{4})([0-9a-fA-F]{4})([0-9a-fA-F]+)", "$1-$2-$3-$4-$5");
                uuid = UUID.fromString(id);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return uuid;
    }

    public void save(CMISkin skin) {
        this.saving = true;
        File file = new File(this.plugin.getDataFolder(), "skinsCache.yml");
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        YamlConfiguration k = YamlConfiguration.loadConfiguration((File)file);
        String uuid = skin.getUuid().toString();
        k.set(uuid + ".name", (Object)skin.getName());
        k.set(uuid + ".skin", (Object)skin.getSkin());
        k.set(uuid + ".signature", (Object)skin.getSignature());
        k.set(uuid + ".lastUpdate", (Object)(skin.getLastUpdate() == 0L ? null : skin.getLastUpdate()));
        try {
            k.save(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.saving = false;
    }

    public void load() {
        try {
            Long time = System.currentTimeMillis();
            File file = new File(this.plugin.getDataFolder(), "skinsCache.yml");
            if (!file.exists()) {
                try {
                    file.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return;
            }
            YamlConfiguration k = YamlConfiguration.loadConfiguration((File)file);
            for (String key : k.getKeys(false)) {
                UUID uuid = UUID.fromString(key);
                if (uuid == null) continue;
                String name = k.getString(key + ".name");
                String skin = k.getString(key + ".skin");
                String signature = k.getString(key + ".signature");
                Long lastUpdate = 0L;
                if (k.isLong(key + ".lastUpdate")) {
                    lastUpdate = k.getLong(key + ".lastUpdate");
                }
                CMISkin cmiSkin = new CMISkin(name, uuid, skin, signature);
                cmiSkin.setLastUpdate(lastUpdate);
                this.skinCacheByUUID.put(uuid, cmiSkin);
                this.skinCacheByName.put(name, cmiSkin);
            }
            this.plugin.loadMessage(this.skinCacheByUUID.size(), "skin cache entries", System.currentTimeMillis() - time);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public HashMap<String, UUID> preFetchUUIDS() {
        return this.preFetchUUIDs;
    }
}

