/*
 * Decompiled with CFR 0.152.
 */
package net.Zrips.CMILib;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.Zrips.CMILib.Advancements.AdvancementFrameType;
import net.Zrips.CMILib.Advancements.CMIAdvancement;
import net.Zrips.CMILib.Attributes.Attribute;
import net.Zrips.CMILib.CMILib;
import net.Zrips.CMILib.Colors.CMIChatColor;
import net.Zrips.CMILib.Container.CMIServerProperties;
import net.Zrips.CMILib.Effects.CMIEffect;
import net.Zrips.CMILib.Effects.CMIEffectManager;
import net.Zrips.CMILib.Items.CMIItemStack;
import net.Zrips.CMILib.Items.CMIMaterial;
import net.Zrips.CMILib.NBT.CMINBT;
import net.Zrips.CMILib.RawMessages.RawMessage;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import net.Zrips.CMILib.Version.Version;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementDisplay;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.locale.LocaleLanguage;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutAdvancements;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindow;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.protocol.game.PacketPlayOutWorldParticles;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.AdvancementDataWorld;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.PropertyManager;
import net.minecraft.server.level.WorldServer;
import net.minecraft.stats.ServerStatisticManager;
import net.minecraft.stats.Statistic;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.dimension.DimensionManager;
import org.bukkit.Bukkit;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Server;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.profile.PlayerTextures;
import org.bukkit.scoreboard.Scoreboard;

public class Reflections {
    private Class<?> CraftServerClass;
    private Class<?> CraftWorldClass;
    private Class<?> WorldServerClass;
    private Object CraftServer;
    private Object DedicatedServer;
    private Class<?> CraftStatistic;
    private Class<?> Statistics;
    private Class<?> MinecraftServerClass;
    private Class<?> PropertyManagerClass;
    private Object MinecraftServer;
    private Class<?> ServerStatisticManager;
    private Class<?> EntityHuman;
    private Class<?> CraftPlayer;
    private Class<?> CraftEntity;
    private Class<?> CEntity;
    private Class<?> nbtTagCompound;
    private Class<?> NBTBase;
    private Class<?> EntityLiving;
    private Class<?> BlockPosition;
    private Class<?> CraftBeehive;
    private Class<?> CraftNamespacedKey;
    private Class<?> Item;
    private Class<?> IStack;
    private Class<?> nmsChatSerializer;
    private Class<?> dimensionManager;
    private Class<?> CraftContainer;
    private Class<?> CraftContainers;
    private Class<?> PacketPlayOutOpenWindow;
    private Class<?> PacketPlayOutEntityTeleport;
    private Class<?> PacketPlayOutSpawnEntityLiving;
    private Class<?> PacketPlayOutEntityMetadata;
    private Class<?> PacketPlayOutSetSlot;
    private Class<?> DataWatcher;
    private Method sendPacket;
    private Class<?> PacketPlayOutWorldParticles;
    private Class<?> EnumParticle;
    private Class<?> ParticleParam;
    private Class<?> CraftParticle;
    private Class<?> AdvancementDataWorld;
    private Class<?> ChatDeserializer;
    private Class<?> SerializedAdvancement;
    private Class<?> LootDeserializationContext;
    private Class<?> LootDataManager;
    private Class<?> CraftChatMessage;
    private Class<?> world;
    private Object advancementRegistry;
    private CMILib plugin;
    Method nmsChatSerializerMethod = null;
    Field getConnectionField = null;
    private Method getWorldServerMeth = null;
    private Method getWorldWorldMeth = null;
    private Method getTileEntityAtMeth = null;
    private static final Map<Class<?>, Class<?>> CORRESPONDING_TYPES = new HashMap();
    private Method teleportMethod = null;
    private Constructor<?> teleportPacket = null;
    Constructor<?> effectConstructor = null;
    Method CraftParticleMethod = null;
    Constructor<?> vibrationConstructor = null;
    Constructor<?> destinationConstructor = null;
    Constructor<MinecraftKey> keyConstructor = null;

    public Reflections(CMILib plugin) {
        this.plugin = plugin;
        this.initialize();
    }

    private void initialize() {
        if (Version.isCurrentEqualOrHigher(Version.v1_18_R1)) {
            try {
                this.world = net.minecraft.world.level.World.class;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        if (Version.isCurrentEqualOrHigher(Version.v1_17_R1)) {
            try {
                this.sendPacket = Version.isCurrentEqualOrHigher(Version.v1_20_R2) ? Class.forName("net.minecraft.server.network.PlayerConnection").getMethod("b", Packet.class) : (Version.isCurrentEqualOrHigher(Version.v1_18_R1) ? Class.forName("net.minecraft.server.network.PlayerConnection").getMethod("a", Packet.class) : Class.forName("net.minecraft.server.network.PlayerConnection").getMethod("sendPacket", Packet.class));
                this.CraftServerClass = Reflections.getBukkitClass("CraftServer");
                this.CraftServer = this.CraftServerClass.cast(Bukkit.getServer());
                this.DedicatedServer = this.CraftServer.getClass().getMethod("getServer", new Class[0]).invoke(this.CraftServer, new Object[0]);
                this.CraftWorldClass = Reflections.getBukkitClass("CraftWorld");
                this.MinecraftServerClass = MinecraftServer.class;
                this.CraftBeehive = Reflections.getBukkitClass("block.impl.CraftBeehive");
                this.CraftNamespacedKey = Reflections.getBukkitClass("util.CraftNamespacedKey");
                this.PacketPlayOutEntityTeleport = PacketPlayOutEntityTeleport.class;
                this.EntityHuman = EntityHuman.class;
                this.PacketPlayOutSpawnEntityLiving = Version.isCurrentEqualOrLower(Version.v1_18_R2) ? Class.forName("net.minecraft.network.protocol.game.PacketPlayOutSpawnEntityLiving") : PacketPlayOutSpawnEntity.class;
                this.PacketPlayOutEntityMetadata = PacketPlayOutEntityMetadata.class;
                this.PacketPlayOutSetSlot = PacketPlayOutSetSlot.class;
                this.PacketPlayOutOpenWindow = PacketPlayOutOpenWindow.class;
                this.PacketPlayOutWorldParticles = PacketPlayOutWorldParticles.class;
                this.CraftContainer = Container.class;
                this.CraftContainers = Containers.class;
                this.DataWatcher = DataWatcher.class;
                this.AdvancementDataWorld = AdvancementDataWorld.class;
                this.ChatDeserializer = ChatDeserializer.class;
                this.SerializedAdvancement = Advancement.SerializedAdvancement.class;
                if (Version.isCurrentEqualOrLower(Version.v1_20_R2)) {
                    this.LootDeserializationContext = Class.forName("net.minecraft.advancements.critereon.LootDeserializationContext");
                    if (Version.isCurrentEqualOrHigher(Version.v1_20_R1)) {
                        this.LootDataManager = Class.forName("net.minecraft.world.level.storage.loot.LootDataManager");
                    }
                }
                this.CraftParticle = Reflections.getBukkitClass("CraftParticle");
                this.CraftChatMessage = Reflections.getBukkitClass("util.CraftChatMessage");
                this.ParticleParam = ParticleParam.class;
                this.WorldServerClass = WorldServer.class;
                this.dimensionManager = DimensionManager.class;
                this.BlockPosition = BlockPosition.class;
                this.nmsChatSerializer = Class.forName("net.minecraft.network.chat.IChatBaseComponent$ChatSerializer");
                this.MinecraftServer = this.CraftServer.getClass().getMethod("getServer", new Class[0]).invoke(this.CraftServer, new Object[0]);
                this.CraftStatistic = Reflections.getBukkitClass("CraftStatistic");
                this.CraftPlayer = Reflections.getBukkitClass("entity.CraftPlayer");
                this.CraftEntity = Reflections.getBukkitClass("entity.CraftEntity");
                this.Statistics = Statistic.class;
                this.ServerStatisticManager = ServerStatisticManager.class;
                this.PropertyManagerClass = PropertyManager.class;
                this.CEntity = net.minecraft.world.entity.Entity.class;
                this.nbtTagCompound = NBTTagCompound.class;
                this.NBTBase = NBTBase.class;
                this.EntityLiving = EntityLiving.class;
                this.Item = Item.class;
                this.IStack = net.minecraft.world.item.ItemStack.class;
                String variable = "ax";
                if (Version.isCurrentEqualOrHigher(Version.v1_20_R4)) {
                    variable = "aE";
                } else if (Version.isCurrentEqualOrHigher(Version.v1_20_R3)) {
                    variable = "aB";
                } else if (Version.isCurrentEqualOrHigher(Version.v1_19_R3)) {
                    variable = "az";
                } else if (Version.isCurrentEqualOrHigher(Version.v1_19_R2)) {
                    variable = "ay";
                } else if (Version.isCurrentEqualOrHigher(Version.v1_19_R1)) {
                    variable = "az";
                } else if (Version.isCurrentLower(Version.v1_18_R1)) {
                    variable = "getAdvancementData";
                }
                Object advancementData = this.MinecraftServer.getClass().getMethod(variable, new Class[0]).invoke(this.MinecraftServer, new Object[0]);
                this.advancementRegistry = advancementData.getClass().getField("c").get(advancementData);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        } else {
            try {
                this.CraftServerClass = Reflections.getBukkitClass("CraftServer");
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            try {
                this.CraftWorldClass = Reflections.getBukkitClass("CraftWorld");
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            try {
                this.CraftBeehive = Reflections.getBukkitClass("block.impl.CraftBeehive");
            }
            catch (Throwable e) {
                // empty catch block
            }
            try {
                this.PacketPlayOutWorldParticles = this.getMinecraftClass("PacketPlayOutWorldParticles");
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            try {
                this.CraftNamespacedKey = Reflections.getBukkitClass("util.CraftNamespacedKey");
            }
            catch (Throwable e) {
                // empty catch block
            }
            try {
                this.CraftContainer = this.getMinecraftClass("Container");
            }
            catch (Throwable e) {
                // empty catch block
            }
            try {
                this.AdvancementDataWorld = this.getMinecraftClass("AdvancementDataWorld");
            }
            catch (Throwable e) {
                // empty catch block
            }
            try {
                this.ChatDeserializer = this.getMinecraftClass("ChatDeserializer");
            }
            catch (Throwable e) {
                // empty catch block
            }
            try {
                this.SerializedAdvancement = this.getMinecraftClass("Advancement$SerializedAdvancement");
            }
            catch (Throwable e) {
                // empty catch block
            }
            try {
                this.LootDeserializationContext = this.getMinecraftClass("LootDeserializationContext");
            }
            catch (Throwable e) {
                // empty catch block
            }
            try {
                this.CraftContainers = this.getMinecraftClass("Containers");
            }
            catch (Throwable e) {
                // empty catch block
            }
            try {
                if (Version.isCurrentEqualOrLower(Version.v1_12_R1)) {
                    this.EnumParticle = this.getMinecraftClass("EnumParticle");
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            if (Version.isCurrentHigher(Version.v1_12_R1)) {
                try {
                    this.CraftParticle = Reflections.getBukkitClass("CraftParticle");
                }
                catch (Throwable e) {
                    // empty catch block
                }
                try {
                    this.ParticleParam = this.getMinecraftClass("ParticleParam");
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            try {
                this.PacketPlayOutEntityTeleport = this.getMinecraftClass("PacketPlayOutEntityTeleport");
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            try {
                this.PacketPlayOutSpawnEntityLiving = this.getMinecraftClass("PacketPlayOutSpawnEntityLiving");
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            try {
                this.DataWatcher = this.getMinecraftClass("DataWatcher");
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            try {
                this.PacketPlayOutEntityMetadata = this.getMinecraftClass("PacketPlayOutEntityMetadata");
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            try {
                this.PacketPlayOutSetSlot = this.getMinecraftClass("PacketPlayOutSetSlot");
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            try {
                this.PacketPlayOutOpenWindow = this.getMinecraftClass("PacketPlayOutOpenWindow");
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            try {
                this.WorldServerClass = this.getMinecraftClass("WorldServer");
            }
            catch (Throwable e) {
                // empty catch block
            }
            try {
                this.dimensionManager = this.getMinecraftClass("DimensionManager");
            }
            catch (Throwable e) {
                // empty catch block
            }
            try {
                this.BlockPosition = this.getMinecraftClass("BlockPosition");
            }
            catch (Throwable e) {
                // empty catch block
            }
            try {
                this.CraftServer = this.CraftServerClass.cast(Bukkit.getServer());
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            try {
                this.MinecraftServerClass = this.getMinecraftClass("MinecraftServer");
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            try {
                this.nmsChatSerializer = !Version.isCurrentHigher(Version.v1_8_R2) ? this.getMinecraftClass("ChatSerializer") : this.getMinecraftClass("IChatBaseComponent$ChatSerializer");
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            try {
                this.MinecraftServer = this.CraftServer.getClass().getMethod("getServer", new Class[0]).invoke(this.CraftServer, new Object[0]);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            try {
                this.CraftStatistic = Reflections.getBukkitClass("CraftStatistic");
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            try {
                this.Statistics = this.getMinecraftClass("Statistic");
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            try {
                this.ServerStatisticManager = this.getMinecraftClass("ServerStatisticManager");
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            try {
                this.PropertyManagerClass = this.getMinecraftClass("PropertyManager");
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            try {
                this.CraftPlayer = Reflections.getBukkitClass("entity.CraftPlayer");
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            try {
                this.CraftEntity = Reflections.getBukkitClass("entity.CraftEntity");
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            try {
                this.CEntity = this.getMinecraftClass("Entity");
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            try {
                this.nbtTagCompound = this.getMinecraftClass("NBTTagCompound");
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            try {
                this.NBTBase = this.getMinecraftClass("NBTBase");
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            try {
                this.EntityLiving = this.getMinecraftClass("EntityLiving");
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            try {
                this.Item = this.getMinecraftClass("Item");
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            try {
                this.IStack = this.getMinecraftClass("ItemStack");
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public String serializeText(String text) {
        try {
            Object serialized = this.textToIChatBaseComponent(text);
            return (String)serialized.getClass().getMethod("e", new Class[0]).invoke(serialized, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
            return text;
        }
    }

    public Object textToIChatBaseComponent(String text) {
        if (Version.isCurrentEqualOrHigher(Version.v1_20_R4)) {
            try {
                if (this.nmsChatSerializerMethod == null) {
                    this.nmsChatSerializerMethod = this.CraftChatMessage.getMethod("fromJSON", String.class);
                }
                return this.nmsChatSerializerMethod.invoke(null, text);
            }
            catch (Throwable e) {
                e.printStackTrace();
                return text;
            }
        }
        try {
            if (this.nmsChatSerializerMethod == null) {
                this.nmsChatSerializerMethod = this.nmsChatSerializer.getMethod("a", String.class);
            }
            return this.nmsChatSerializerMethod.invoke(null, text);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return text;
        }
    }

    public int getCurrentTick() {
        if (Version.isFolia()) {
            return Bukkit.getCurrentTick();
        }
        try {
            return this.MinecraftServer.getClass().getField("currentTick").getInt(this.CraftServer);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
            return (int)(System.currentTimeMillis() / 50L);
        }
    }

    public Object getItemInfo(int id, String fieldName) {
        try {
            Field field = this.getMinecraftClass("Block").getDeclaredField(fieldName);
            field.setAccessible(true);
            if (Version.isCurrentEqualOrHigher(Version.v1_13_R2)) {
                Method method = this.getMinecraftClass("Block").getDeclaredMethod("getByCombinedId", Integer.TYPE);
                Object res = method.invoke(this.getMinecraftClass("Block"), id);
                res = res.getClass().getMethod("getBlock", new Class[0]).invoke(res, new Object[0]);
                return field.get(res);
            }
            Method method = this.getMinecraftClass("Block").getDeclaredMethod("getById", Integer.TYPE);
            Object res = method.invoke(this.getMinecraftClass("Block"), id);
            return field.get(res);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Class<?> getBukkitClass(String nmsClassString) {
        try {
            return Class.forName("org.bukkit.craftbukkit." + Version.getCurrent().toString() + "." + nmsClassString);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public Class<?> getMinecraftClass(String nmsClassString) {
        try {
            return Class.forName("net.minecraft.server." + Version.getCurrent().toString() + "." + nmsClassString);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public void setServerProperties(CMIServerProperties setting, Object value, boolean save) {
        if (Version.isCurrentEqualOrHigher(Version.v1_20_R2)) {
            try {
                Object field1 = null;
                field1 = Version.isCurrentEqualOrHigher(Version.v1_20_R4) ? this.MinecraftServer.getClass().getField("r").get(this.MinecraftServer) : (Version.isCurrentEqualOrHigher(Version.v1_20_R3) ? this.MinecraftServer.getClass().getField("s").get(this.MinecraftServer) : this.MinecraftServer.getClass().getField("u").get(this.MinecraftServer));
                Object prop = field1.getClass().getMethod("a", new Class[0]).invoke(field1, new Object[0]);
                Object field2 = null;
                field2 = Version.isCurrentEqualOrHigher(Version.v1_21_R1) ? prop.getClass().getField("ac").get(prop) : (Version.isCurrentEqualOrHigher(Version.v1_20_R4) ? prop.getClass().getField("ab").get(prop) : prop.getClass().getField("Z").get(prop));
                Method setPropertyMethod = field2.getClass().getDeclaredMethod("setProperty", String.class, String.class);
                setPropertyMethod.invoke(field2, setting.getPath(), String.valueOf(value));
                if (save) {
                    field1.getClass().getMethod("b", new Class[0]).invoke(field1, new Object[0]);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            return;
        }
        if (Version.isCurrentEqualOrHigher(Version.v1_19_R2)) {
            try {
                Object field1 = this.MinecraftServer.getClass().getField("u").get(this.MinecraftServer);
                Object prop = field1.getClass().getMethod("a", new Class[0]).invoke(field1, new Object[0]);
                Object field2 = prop.getClass().getField("Y").get(prop);
                Method setPropertyMethod = field2.getClass().getDeclaredMethod("setProperty", String.class, String.class);
                setPropertyMethod.invoke(field2, setting.getPath(), String.valueOf(value));
                if (save) {
                    field1.getClass().getMethod("b", new Class[0]).invoke(field1, new Object[0]);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            return;
        }
        if (Version.isCurrentEqualOrHigher(Version.v1_19_R1)) {
            try {
                Object field1 = this.MinecraftServer.getClass().getField("u").get(this.MinecraftServer);
                Object prop = field1.getClass().getMethod("a", new Class[0]).invoke(field1, new Object[0]);
                Object field2 = prop.getClass().getField("X").get(prop);
                Method setPropertyMethod = field2.getClass().getDeclaredMethod("setProperty", String.class, String.class);
                setPropertyMethod.invoke(field2, setting.getPath(), String.valueOf(value));
                if (save) {
                    field1.getClass().getMethod("b", new Class[0]).invoke(field1, new Object[0]);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            return;
        }
        if (Version.isCurrentEqualOrHigher(Version.v1_18_R2)) {
            try {
                Object field1 = this.MinecraftServer.getClass().getField("y").get(this.MinecraftServer);
                Object prop = field1.getClass().getMethod("a", new Class[0]).invoke(field1, new Object[0]);
                Object field2 = prop.getClass().getField("Y").get(prop);
                Method setPropertyMethod = field2.getClass().getDeclaredMethod("setProperty", String.class, String.class);
                setPropertyMethod.invoke(field2, setting.getPath(), String.valueOf(value));
                if (save) {
                    field1.getClass().getMethod("b", new Class[0]).invoke(field1, new Object[0]);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            return;
        }
        if (Version.isCurrentEqualOrHigher(Version.v1_18_R1)) {
            try {
                Object field1 = this.MinecraftServer.getClass().getField("z").get(this.MinecraftServer);
                Object prop = field1.getClass().getMethod("a", new Class[0]).invoke(field1, new Object[0]);
                Object field2 = prop.getClass().getField("Y").get(prop);
                Method setPropertyMethod = field2.getClass().getDeclaredMethod("setProperty", String.class, String.class);
                setPropertyMethod.invoke(field2, setting.getPath(), String.valueOf(value));
                if (save) {
                    field1.getClass().getMethod("b", new Class[0]).invoke(field1, new Object[0]);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            return;
        }
        if (Version.isCurrentEqualOrHigher(Version.v1_17_R1)) {
            try {
                Object field1 = this.MinecraftServer.getClass().getField("x").get(this.MinecraftServer);
                Object prop = field1.getClass().getMethod("getProperties", new Class[0]).invoke(field1, new Object[0]);
                Object field2 = prop.getClass().getField("X").get(prop);
                Method setPropertyMethod = field2.getClass().getDeclaredMethod("setProperty", String.class, String.class);
                setPropertyMethod.invoke(field2, setting.getPath(), String.valueOf(value));
                if (save) {
                    field1.getClass().getMethod("save", new Class[0]).invoke(field1, new Object[0]);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            return;
        }
        if (Version.isCurrentEqualOrHigher(Version.v1_14_R1)) {
            try {
                Object field1 = this.MinecraftServer.getClass().getField("propertyManager").get(this.MinecraftServer);
                Object prop = field1.getClass().getMethod("getProperties", new Class[0]).invoke(field1, new Object[0]);
                Object field2 = prop.getClass().getField("properties").get(prop);
                Method setPropertyMethod = field2.getClass().getDeclaredMethod("setProperty", String.class, String.class);
                setPropertyMethod.invoke(field2, setting.getPath(), String.valueOf(value));
                if (save) {
                    field1.getClass().getMethod("save", new Class[0]).invoke(field1, new Object[0]);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            return;
        }
        try {
            Method getServerMethod = this.MinecraftServerClass.getDeclaredMethod("getServer", new Class[0]);
            Method getPropertyManagerMethod = this.MinecraftServerClass.getDeclaredMethod("getPropertyManager", new Class[0]);
            Method setPropertyMethod = this.PropertyManagerClass.getDeclaredMethod("setProperty", String.class, Object.class);
            Method savePropertiesFileMethod = this.PropertyManagerClass.getDeclaredMethod("savePropertiesFile", new Class[0]);
            Object manager = getPropertyManagerMethod.invoke(getServerMethod.invoke(null, new Object[0]), new Object[0]);
            setPropertyMethod.invoke(manager, setting.getPath(), value);
            if (save) {
                savePropertiesFileMethod.invoke(manager, new Object[0]);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Deprecated
    public boolean isNbtSimilar(ItemStack is, ItemStack is2) {
        return CMINBT.isNBTSimilar(is, is2);
    }

    public GameProfile getProfile(Player player) {
        Object craftPlayer = this.CraftPlayer.cast(player);
        try {
            Method method = this.CraftPlayer.getMethod("getProfile", new Class[0]);
            Object profile = method.invoke(craftPlayer, new Object[0]);
            return (GameProfile)profile;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Object getCraftPlayer(Player player) {
        try {
            return this.CraftPlayer.cast(player);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public Object getPlayerHandle(Player player) {
        Object handle = null;
        try {
            handle = player.getClass().getMethod("getHandle", new Class[0]).invoke((Object)player, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return handle;
    }

    public Object getEntityHandle(Entity ent) {
        Object handle = null;
        try {
            handle = this.CraftEntity.cast(ent).getClass().getMethod("getHandle", new Class[0]).invoke(this.CraftEntity.cast(ent), new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return handle;
    }

    public Object getPlayerConnection(Player player) {
        Object connection = null;
        try {
            Object handle = this.getPlayerHandle(player);
            if (this.getConnectionField == null) {
                this.getConnectionField = Version.isCurrentEqualOrHigher(Version.v1_20_R1) ? handle.getClass().getField("c") : (Version.isCurrentEqualOrHigher(Version.v1_17_R1) ? handle.getClass().getField("b") : handle.getClass().getField("playerConnection"));
            }
            connection = this.getConnectionField.get(handle);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return connection;
    }

    public Object getDimensionManager(World world) {
        Object dm = null;
        try {
            if (Version.isCurrentEqualOrHigher(Version.v1_14_R1)) {
                switch (world.getEnvironment()) {
                    case NETHER: {
                        return this.dimensionManager.getField("NETHER").get(this.dimensionManager);
                    }
                    case NORMAL: {
                        return this.dimensionManager.getField("OVERWORLD").get(this.dimensionManager);
                    }
                    case THE_END: {
                        return this.dimensionManager.getField("NETHER").get(this.dimensionManager);
                    }
                }
            }
            Object worldServer = this.getCraftWorld(world).getClass().getMethod("getHandle", new Class[0]).invoke(this.getCraftWorld(world), new Object[0]);
            dm = worldServer.getClass().getField(Version.isCurrentEqualOrHigher(Version.v1_18_R1) ? "G" : "dimension").get(worldServer);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return dm;
    }

    public String getServerName() {
        if (Version.isCurrentEqualOrLower(Version.v1_13_R2)) {
            Server srv = Bukkit.getServer();
            try {
                Object res = srv.getClass().getMethod("getServerName", new Class[0]).invoke((Object)srv, new Object[0]);
                return (String)res;
            }
            catch (Throwable e) {
                e.printStackTrace();
                return Bukkit.getName();
            }
        }
        try {
            Object worldServer = this.getCraftWorld((World)Bukkit.getWorlds().get(0));
            return (String)worldServer.getClass().getMethod("getName", new Class[0]).invoke(worldServer, new Object[0]);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return Bukkit.getName();
        }
    }

    public Object getCraftWorld(World world) {
        return this.CraftWorldClass.cast(world);
    }

    public Object getWorldServer(World world) {
        Object obj = this.getCraftWorld(world);
        try {
            if (this.getWorldServerMeth == null) {
                this.getWorldServerMeth = obj.getClass().getMethod("getHandle", new Class[0]);
            }
            return this.WorldServerClass.cast(this.getWorldServerMeth.invoke(obj, new Object[0]));
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public Object getMineCraftWorld(World world) {
        Object obj = this.getCraftWorld(world);
        try {
            if (this.getWorldServerMeth == null) {
                this.getWorldServerMeth = obj.getClass().getMethod("getHandle", new Class[0]);
            }
            Object handle = this.WorldServerClass.cast(this.getWorldServerMeth.invoke(obj, new Object[0]));
            if (this.getWorldWorldMeth == null) {
                this.getWorldWorldMeth = handle.getClass().getMethod("getMinecraftWorld", new Class[0]);
            }
            return this.world.cast(this.getWorldWorldMeth.invoke(handle, new Object[0]));
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    private Object getBlockPosition(Location loc) {
        try {
            Constructor<?> constructor = this.BlockPosition.getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE);
            return constructor.newInstance(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public Object getTileEntityAt(Location loc) {
        try {
            if (Version.isCurrentEqualOrHigher(Version.v1_13_R2)) {
                try {
                    Object ncw = this.getWorldServer(loc.getWorld());
                    if (this.getTileEntityAtMeth == null) {
                        this.getTileEntityAtMeth = ncw.getClass().getMethod(Version.isCurrentEqualOrHigher(Version.v1_18_R1) ? "c_" : "getTileEntity", this.BlockPosition);
                    }
                    return this.getTileEntityAtMeth.invoke(ncw, this.getBlockPosition(loc));
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            Object cw = this.getCraftWorld(loc.getWorld());
            Method meth = cw.getClass().getMethod("getTileEntityAt", Integer.TYPE, Integer.TYPE, Integer.TYPE);
            Object res = meth.invoke(cw, loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
            return res;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public void sendPlayerPacket(Player player, Object packet) throws Exception {
        this.sendPacket(this.getPlayerConnection(player), packet);
    }

    public void sendPacket(Object connection, Object packet) {
        try {
            if (Version.isCurrentEqualOrHigher(Version.v1_17_R1)) {
                this.sendPacket.invoke(connection, packet);
            } else {
                connection.getClass().getMethod("sendPacket", this.getClass("{nms}.Packet")).invoke(connection, packet);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Deprecated
    public String toJson(ItemStack item) {
        return CMINBT.toJson(item);
    }

    public String getItemMinecraftName(ItemStack item) {
        try {
            Object nmsStack = this.asNMSCopy(item);
            if (Version.isCurrentEqualOrHigher(Version.v1_13_R1)) {
                Object pre = nmsStack.getClass().getMethod(Version.isCurrentEqualOrHigher(Version.v1_18_R1) ? "c" : "getItem", new Class[0]).invoke(nmsStack, new Object[0]);
                Object n = pre.getClass().getMethod(Version.isCurrentEqualOrHigher(Version.v1_18_R1) ? "a" : "getName", new Class[0]).invoke(pre, new Object[0]);
                Class ll = null;
                ll = Version.isCurrentEqualOrHigher(Version.v1_18_R1) ? LocaleLanguage.class : Class.forName("net.minecraft.server." + (Object)((Object)Version.getCurrent()) + ".LocaleLanguage");
                Object lla = ll.getMethod("a", new Class[0]).invoke(ll, new Object[0]);
                if (Version.isCurrentEqualOrHigher(Version.v1_16_R1)) {
                    Method method = lla.getClass().getMethod("a", String.class);
                    method.setAccessible(true);
                    return (String)method.invoke(lla, (String)n);
                }
                return (String)lla.getClass().getMethod("a", String.class).invoke(lla, (String)n);
            }
            Field field = this.Item.getField("REGISTRY");
            Object reg = field.get(field);
            Method meth = reg.getClass().getMethod("b", Object.class);
            meth.setAccessible(true);
            Method secmeth = nmsStack.getClass().getMethod("getItem", new Class[0]);
            Object res2 = secmeth.invoke(nmsStack, new Object[0]);
            Object res = meth.invoke(reg, res2);
            return res.toString();
        }
        catch (Throwable e) {
            return null;
        }
    }

    public void updateItemWithPacket(Player player, ItemStack item, int slot) {
        if (Version.isCurrentEqualOrHigher(Version.v1_19_R1)) {
            try {
                Constructor<?> packet = this.PacketPlayOutSetSlot.getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE, this.IStack);
                Object newPack = packet.newInstance(this.getActiveContainerId(player), this.getActiveContainerStateId(player), slot, CMINBT.asNMSCopy(item));
                this.sendPlayerPacket(player, newPack);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            return;
        }
        try {
            Constructor<?> packet = this.PacketPlayOutSetSlot.getConstructor(Integer.TYPE, Integer.TYPE, this.IStack);
            Object newPack = packet.newInstance(this.getActiveContainerId(player), slot, CMINBT.asNMSCopy(item));
            this.sendPlayerPacket(player, newPack);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Deprecated
    public ItemStack setTag(ItemStack item, Object tag) {
        return CMINBT.setTag(item, tag);
    }

    @Deprecated
    public Object getNbt(Entity entity) {
        return CMINBT.getNbt(entity);
    }

    @Deprecated
    public Object getNbt(ItemStack item) {
        return CMINBT.getNbt(item);
    }

    private static PlayerProfile getProfile(String name, String url) {
        PlayerProfile profile = Bukkit.createPlayerProfile((UUID)UUID.nameUUIDFromBytes(url.getBytes()), (String)(name == null ? name : name.replace(" ", "")));
        PlayerTextures textures = profile.getTextures();
        try {
            textures.setSkin(new URL(url));
        }
        catch (MalformedURLException exception) {
            throw new RuntimeException("Invalid URL", exception);
        }
        profile.setTextures(textures);
        return profile;
    }

    public ItemStack setSkullTexture(ItemStack item, String customProfileName, String texture) {
        if (item == null) {
            return null;
        }
        try {
            GameProfile prof = null;
            if (Version.isCurrentEqualOrHigher(Version.v1_20_R2)) {
                String decodedString = new String(Base64.getMimeDecoder().decode(texture)).replace("\n", "").replace(" ", "");
                if (decodedString.contains("url\":\"")) {
                    SkullMeta meta = (SkullMeta)item.getItemMeta();
                    meta.setOwnerProfile(Reflections.getProfile(customProfileName, decodedString.split("url\":\"", 2)[1].split("\"", 2)[0]));
                    item.setItemMeta((ItemMeta)meta);
                }
                return item;
            }
            prof = new GameProfile(UUID.nameUUIDFromBytes(texture.getBytes()), null);
            prof.getProperties().removeAll((Object)"textures");
            prof.getProperties().put((Object)"textures", (Object)new Property("textures", texture));
            SkullMeta headMeta = (SkullMeta)item.getItemMeta();
            Field profileField = null;
            try {
                profileField = headMeta.getClass().getDeclaredField("profile");
            }
            catch (NoSuchFieldException | SecurityException e) {
                e.printStackTrace();
            }
            if (profileField != null) {
                profileField.setAccessible(true);
                try {
                    profileField.set(headMeta, prof);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
            item.setItemMeta((ItemMeta)headMeta);
            try {
                byte[] decodedBytes = Base64.getMimeDecoder().decode(texture);
                String decodedString = new String(decodedBytes);
                if (decodedString.contains("profileName\" : \"")) {
                    String name = decodedString.split("profileName\" : \"", 2)[1].split("\"", 2)[0];
                    item = (ItemStack)new CMINBT(item).setString("SkullOwner.Name", name);
                }
            }
            catch (Throwable decodedBytes) {
                // empty catch block
            }
            Object i = new CMINBT(item).setString("Id", UUID.nameUUIDFromBytes(texture.getBytes()).toString());
            return i == null ? null : (ItemStack)i;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return item;
        }
    }

    @Deprecated
    public Object getNbt(Block block) {
        return CMINBT.getNbt(block);
    }

    public void updateTileEntity(Location loadValue, Object tag) {
        if (tag == null) {
            return;
        }
        try {
            Object ent = this.getTileEntityAt(loadValue);
            String ff = "load";
            switch (Version.getCurrent()) {
                case v1_10_R1: 
                case v1_9_R1: 
                case v1_9_R2: 
                case v1_8_R1: 
                case v1_8_R3: 
                case v1_8_R2: 
                case v1_11_R1: {
                    ff = "a";
                    break;
                }
                case v1_12_R1: {
                    ff = "load";
                    break;
                }
                case v1_13_R2: 
                case v1_13_R1: {
                    ff = "create";
                    break;
                }
                case v1_7_R4: {
                    ff = "a";
                    break;
                }
            }
            Method meth = ent.getClass().getMethod(ff, this.nbtTagCompound);
            meth.invoke(ent, tag);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    @Deprecated
    public Object asNMSCopy(ItemStack item) {
        return CMINBT.asNMSCopy(item);
    }

    @Deprecated
    public Object asBukkitCopy(Object item) {
        return CMINBT.asBukkitCopy(item);
    }

    public Object getCraftServer() {
        return this.CraftServer;
    }

    public Object getDedicatedServer() {
        return this.DedicatedServer;
    }

    @Deprecated
    public ItemStack getItemInMainHand(Player player) {
        return CMIItemStack.getItemInMainHand(player);
    }

    @Deprecated
    public void setItemInMainHand(Player player, ItemStack item) {
        CMIItemStack.setItemInMainHand(player, item);
    }

    @Deprecated
    public ItemStack getItemInOffHand(Player player) {
        return CMIItemStack.getItemInOffHand(player);
    }

    @Deprecated
    public void setItemInOffHand(Player player, ItemStack item) {
        CMIItemStack.setItemInOffHand(player, item);
    }

    public Class<?> getClass(String classname) {
        try {
            String version = Bukkit.getServer().getClass().getPackage().getName().replace(".", ",").split(",")[3];
            String path = classname.replace("{nms}", "net.minecraft.server." + version).replace("{nm}", "net.minecraft." + version).replace("{cb}", "org.bukkit.craftbukkit.." + version);
            return Class.forName(path);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public Object getNmsPlayer(Player p) throws Exception {
        Method getHandle = p.getClass().getMethod("getHandle", new Class[0]);
        return getHandle.invoke((Object)p, new Object[0]);
    }

    public Object getNmsScoreboard(Scoreboard s) throws Exception {
        Method getHandle = s.getClass().getMethod("getHandle", new Class[0]);
        return getHandle.invoke((Object)s, new Object[0]);
    }

    public Object getFieldValue(Object instance, String fieldName) throws Exception {
        Field field = instance.getClass().getDeclaredField(fieldName);
        field.setAccessible(true);
        return field.get(instance);
    }

    public <T> T getFieldValue(Field field, Object obj) {
        try {
            return (T)field.get(obj);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Field getField(Class<?> clazz, String fieldName) throws Exception {
        Field field = clazz.getDeclaredField(fieldName);
        field.setAccessible(true);
        return field;
    }

    public void setValue(Object instance, String field, Object value) {
        try {
            Field f = instance.getClass().getDeclaredField(field);
            f.setAccessible(true);
            f.set(instance, value);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void sendAllPacket(Object packet) throws Exception {
        for (Player p : Bukkit.getOnlinePlayers()) {
            Object nmsPlayer = this.getNmsPlayer(p);
            Object connection = nmsPlayer.getClass().getField("playerConnection").get(nmsPlayer);
            if (Version.isCurrentEqualOrHigher(Version.v1_17_R1)) {
                this.sendPacket.invoke(connection, packet);
                continue;
            }
            connection.getClass().getMethod("sendPacket", this.getClass("{nms}.Packet")).invoke(connection, packet);
        }
    }

    public void sendListPacket(List<String> players, Object packet) {
        try {
            for (String name : players) {
                Object nmsPlayer = this.getNmsPlayer(Bukkit.getPlayer((String)name));
                Object connection = nmsPlayer.getClass().getField("playerConnection").get(nmsPlayer);
                if (Version.isCurrentEqualOrHigher(Version.v1_17_R1)) {
                    this.sendPacket.invoke(connection, packet);
                    continue;
                }
                connection.getClass().getMethod("sendPacket", this.getClass("{nms}.Packet")).invoke(connection, packet);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public Class<?> getPrimitiveType(Class<?> Class2) {
        return CORRESPONDING_TYPES.containsKey(Class2) ? CORRESPONDING_TYPES.get(Class2) : Class2;
    }

    public Method getMethod(String MethodName, Class<?> Class2, Class<?> ... Parameters) {
        Class<?>[] T = this.toPrimitiveTypeArray(Parameters);
        for (Method M : Class2.getMethods()) {
            if (!M.getName().equals(MethodName) || !this.equalsTypeArray(this.toPrimitiveTypeArray(M.getParameterTypes()), T)) continue;
            return M;
        }
        return null;
    }

    public boolean equalsTypeArray(Class<?>[] Value1, Class<?>[] Value2) {
        if (Value1.length != Value2.length) {
            return false;
        }
        for (int i = 0; i < Value1.length; ++i) {
            if (Value1[i].equals(Value2[i]) || Value1[i].isAssignableFrom(Value2[i])) continue;
            return false;
        }
        return true;
    }

    public Class<?>[] toPrimitiveTypeArray(Class<?>[] Classes) {
        int L = Classes != null ? Classes.length : 0;
        Class[] T = new Class[L];
        for (int i = 0; i < L; ++i) {
            if (Classes == null) continue;
            T[i] = this.getPrimitiveType(Classes[i]);
        }
        return T;
    }

    public Object invokeMethod(String MethodName, Object Parameter2) {
        try {
            return this.getMethod(MethodName, Parameter2.getClass(), new Class[0]).invoke(Parameter2, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Object getPlayerField(Player Player2, String Field2) {
        try {
            Object P = Player2.getClass().getMethod("getHandle", new Class[0]).invoke((Object)Player2, new Object[0]);
            return P.getClass().getField(Field2).get(P);
        }
        catch (Error | Exception e) {
            return null;
        }
    }

    private Integer getActiveContainerStateId(Player player) {
        try {
            return this.getActiveContainerStateId(this.CraftPlayer.getMethod("getHandle", new Class[0]).invoke((Object)player, new Object[0]));
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Integer getActiveContainerStateId(Object entityplayer) {
        try {
            if (Version.isCurrentEqualOrHigher(Version.v1_19_R1)) {
                try {
                    Field field = entityplayer.getClass().getField("bU");
                    Object container = this.CraftContainer.cast(field.get(entityplayer));
                    Method field2 = container.getClass().getMethod("j", new Class[0]);
                    Object ids = field2.invoke(container, new Object[0]);
                    return (int)((Integer)ids);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return null;
    }

    public Integer getActiveContainerId(Player player) {
        try {
            return this.getActiveContainerId(this.CraftPlayer.getMethod("getHandle", new Class[0]).invoke((Object)player, new Object[0]));
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Integer getActiveContainerId(Object entityplayer) {
        String activeContainer = "activeContainer";
        String windowId = "windowId";
        try {
            if (Version.isCurrentEqualOrHigher(Version.v1_17_R1)) {
                windowId = "j";
            }
            if (Version.isCurrentEqualOrHigher(Version.v1_21_R1)) {
                activeContainer = "cd";
            } else if (Version.isCurrentEqualOrHigher(Version.v1_20_R4)) {
                activeContainer = "cb";
            } else if (Version.isCurrentEqualOrHigher(Version.v1_20_R2)) {
                activeContainer = "bS";
            } else if (Version.isCurrentEqualOrHigher(Version.v1_20_R1)) {
                activeContainer = "bR";
            } else if (Version.isCurrentEqualOrHigher(Version.v1_19_R3)) {
                activeContainer = "bP";
            } else if (Version.isCurrentEqualOrHigher(Version.v1_19_R1)) {
                activeContainer = "bU";
            } else if (Version.isCurrentEqualOrHigher(Version.v1_18_R2)) {
                activeContainer = "bV";
            } else if (Version.isCurrentEqualOrHigher(Version.v1_18_R1)) {
                activeContainer = "bW";
            } else if (Version.isCurrentEqualOrHigher(Version.v1_17_R1)) {
                activeContainer = "bV";
            }
            Object container = null;
            container = Version.isCurrentEqualOrHigher(Version.v1_17_R1) ? (Object)this.CraftContainer.cast(this.EntityHuman.getField(activeContainer).get(entityplayer)) : (Object)this.CraftContainer.cast(entityplayer.getClass().getField(activeContainer).get(entityplayer));
            return (int)((Integer)container.getClass().getField(windowId).get(container));
        }
        catch (Throwable e) {
            if (Version.isCurrentEqualOrHigher(Version.v1_17_R1)) {
                e.printStackTrace();
            }
            return null;
        }
    }

    private Object getContainer(String name) {
        try {
            Field field = this.CraftContainers.getDeclaredField(name);
            return field.get(this.CraftContainers);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void updateInventoryTitle(Player p, String title) {
        block25: {
            if (Version.isCurrentEqualOrHigher(Version.v1_16_R1)) {
                if (CMIChatColor.stripColor(title).length() > 64) {
                    title = title.substring(0, 63) + "~";
                }
            } else if (title.length() > 32) {
                title = title.substring(0, 31) + "~";
            }
            try {
                block26: {
                    Object s;
                    Object entityplayer;
                    block28: {
                        block27: {
                            if (!Version.isCurrentEqualOrHigher(Version.v1_14_R1)) break block26;
                            entityplayer = this.CraftPlayer.getMethod("getHandle", new Class[0]).invoke((Object)p, new Object[0]);
                            s = null;
                            if (!Version.isCurrentEqualOrHigher(Version.v1_17_R1)) break block27;
                            switch (p.getOpenInventory().getTopInventory().getSize()) {
                                case 9: {
                                    s = this.getContainer("a");
                                    break block28;
                                }
                                case 18: {
                                    s = this.getContainer("b");
                                    break block28;
                                }
                                case 27: {
                                    s = this.getContainer("c");
                                    break block28;
                                }
                                case 36: {
                                    s = this.getContainer("d");
                                    break block28;
                                }
                                case 45: {
                                    s = this.getContainer("e");
                                    break block28;
                                }
                                case 54: {
                                    s = this.getContainer("f");
                                    break block28;
                                }
                                default: {
                                    return;
                                }
                            }
                        }
                        switch (p.getOpenInventory().getTopInventory().getSize()) {
                            case 9: {
                                s = this.getContainer("GENERIC_9X1");
                                break;
                            }
                            case 18: {
                                s = this.getContainer("GENERIC_9X2");
                                break;
                            }
                            case 27: {
                                s = this.getContainer("GENERIC_9X3");
                                break;
                            }
                            case 36: {
                                s = this.getContainer("GENERIC_9X4");
                                break;
                            }
                            case 45: {
                                s = this.getContainer("GENERIC_9X5");
                                break;
                            }
                            case 54: {
                                s = this.getContainer("GENERIC_9X6");
                                break;
                            }
                            default: {
                                return;
                            }
                        }
                    }
                    if (Version.isCurrentEqualOrHigher(Version.v1_17_R1)) {
                        RawMessage rm = new RawMessage();
                        rm.addText(title);
                        Constructor<?> packet = this.PacketPlayOutOpenWindow.getConstructor(Integer.TYPE, this.CraftContainers, IChatBaseComponent.class);
                        Object newPack = packet.newInstance(this.getActiveContainerId(entityplayer), s, this.textToIChatBaseComponent(rm.getRaw()));
                        this.sendPlayerPacket(p, newPack);
                        p.updateInventory();
                    } else {
                        RawMessage rm = new RawMessage();
                        rm.addText(title);
                        Constructor<?> packet = this.PacketPlayOutOpenWindow.getConstructor(Integer.TYPE, this.CraftContainers, this.getMinecraftClass("IChatBaseComponent"));
                        Object newPack = packet.newInstance(this.getActiveContainerId(entityplayer), s, this.textToIChatBaseComponent(rm.getRaw()));
                        this.sendPlayerPacket(p, newPack);
                        Field field = entityplayer.getClass().getField("activeContainer");
                        Object container = this.CraftContainer.cast(field.get(entityplayer));
                        Method meth = entityplayer.getClass().getMethod("updateInventory", this.CraftContainer);
                        meth.invoke(entityplayer, container);
                    }
                    break block25;
                }
                if (Version.isCurrentEqualOrHigher(Version.v1_8_R2)) {
                    Object entityplayer = this.CraftPlayer.getMethod("getHandle", new Class[0]).invoke((Object)p, new Object[0]);
                    RawMessage rm = new RawMessage();
                    rm.addText(title);
                    Constructor<?> packet = this.PacketPlayOutOpenWindow.getConstructor(Integer.TYPE, String.class, this.getMinecraftClass("IChatBaseComponent"), Integer.TYPE);
                    Object newPack = packet.newInstance(this.getActiveContainerId(entityplayer), "minecraft:chest", this.textToIChatBaseComponent(rm.getRaw()), p.getOpenInventory().getTopInventory().getSize());
                    this.sendPlayerPacket(p, newPack);
                    Field field = entityplayer.getClass().getField("activeContainer");
                    Object container = this.CraftContainer.cast(field.get(entityplayer));
                    Method meth = entityplayer.getClass().getMethod("updateInventory", this.CraftContainer);
                    meth.invoke(entityplayer, container);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    @Deprecated
    public ItemStack HideFlag(ItemStack item, int state) {
        return CMINBT.HideFlag(item, state);
    }

    public void superficialEntityTeleport(Player player, Object entity, Location targetLoc) {
        try {
            if (entity == null || !this.CEntity.isInstance(entity)) {
                return;
            }
            Object centity = this.CEntity.cast(entity);
            if (this.teleportMethod == null) {
                this.teleportMethod = Version.isCurrentEqualOrHigher(Version.v1_21_R1) ? this.CEntity.getMethod("a_", Double.TYPE, Double.TYPE, Double.TYPE) : (Version.isCurrentEqualOrHigher(Version.v1_20_R4) ? this.CEntity.getMethod("p", Double.TYPE, Double.TYPE, Double.TYPE) : (Version.isCurrentEqualOrHigher(Version.v1_18_R1) ? this.CEntity.getMethod("a", Double.TYPE, Double.TYPE, Double.TYPE) : this.CEntity.getMethod("setPosition", Double.TYPE, Double.TYPE, Double.TYPE)));
            }
            this.teleportMethod.invoke(centity, targetLoc.getX(), targetLoc.getY(), targetLoc.getZ());
            if (player == null) {
                return;
            }
            if (this.teleportPacket == null) {
                this.teleportPacket = this.PacketPlayOutEntityTeleport.getConstructor(this.CEntity);
            }
            Object packet = this.teleportPacket.newInstance(centity);
            try {
                if (Version.isCurrentEqualOrHigher(Version.v1_20_R4)) {
                    this.setValue(packet, "f", (byte)((float)((int)targetLoc.getYaw()) * 256.0f / 360.0f));
                    this.setValue(packet, "g", (byte)((float)((int)targetLoc.getPitch()) * 256.0f / 360.0f));
                } else {
                    this.setValue(packet, "e", (byte)((float)((int)targetLoc.getYaw()) * 256.0f / 360.0f));
                    this.setValue(packet, "f", (byte)((float)((int)targetLoc.getPitch()) * 256.0f / 360.0f));
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            this.sendPlayerPacket(player, packet);
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.teleportMethod = null;
        }
    }

    public void spawnInEntityData(Player player, Entity entity) {
        Object craftEntityHandle;
        if (Version.isCurrentEqualOrHigher(Version.v1_19_R2)) {
            return;
        }
        try {
            Constructor<?> packet = null;
            packet = Version.isCurrentEqualOrHigher(Version.v1_19_R2) ? this.PacketPlayOutSpawnEntityLiving.getConstructor(this.CEntity) : this.PacketPlayOutSpawnEntityLiving.getConstructor(this.EntityLiving);
            Object craftEntity = this.CraftEntity.cast(entity);
            craftEntityHandle = this.CraftEntity.getMethod("getHandle", new Class[0]).invoke(craftEntity, new Object[0]);
            if (this.EntityLiving.isInstance(craftEntityHandle)) {
                Object living = this.EntityLiving.cast(craftEntityHandle);
                Object newPack = packet.newInstance(living);
                this.sendPlayerPacket(player, newPack);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            Object craftEntity = this.CraftEntity.cast(entity);
            int id = (Integer)this.CraftEntity.getMethod("getEntityId", new Class[0]).invoke(craftEntity, new Object[0]);
            craftEntityHandle = this.CraftEntity.getMethod("getHandle", new Class[0]).invoke(craftEntity, new Object[0]);
            String methodName = "getDataWatcher";
            if (Version.isCurrentEqualOrHigher(Version.v1_19_R2)) {
                methodName = "al";
            } else if (Version.isCurrentEqualOrHigher(Version.v1_18_R1)) {
                methodName = "ai";
            }
            Object watcher = craftEntityHandle.getClass().getMethod(methodName, new Class[0]).invoke(craftEntityHandle, new Object[0]);
            Constructor<?> packet = null;
            Object newPack = null;
            if (Version.isCurrentEqualOrHigher(Version.v1_19_R2)) {
                packet = this.PacketPlayOutEntityMetadata.getConstructor(Integer.TYPE, List.class);
                newPack = packet.newInstance(id, watcher.getClass().getMethod("b", new Class[0]).invoke(watcher, new Object[0]));
            } else {
                packet = this.PacketPlayOutEntityMetadata.getConstructor(Integer.TYPE, this.DataWatcher, Boolean.TYPE);
                newPack = packet.newInstance(id, watcher, true);
            }
            Object pack = newPack;
            this.sendPlayerPacket(player, pack);
            CMIScheduler.get().runTaskLater(() -> {
                try {
                    this.sendPlayerPacket(player, pack);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }, 20L);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void playSound(Player player, Location location, Sound sound, float volume, float pitch) {
        Object cPlayer = this.getCraftPlayer(player);
        CMIScheduler.runTask(() -> {
            try {
                cPlayer.getClass().getMethod("playSound", Location.class, Sound.class, Float.TYPE, Float.TYPE).invoke(cPlayer, location, sound, Float.valueOf(volume), Float.valueOf(pitch));
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        });
    }

    public int getEggId(ItemStack item) {
        EntityType type = this.getEggType(item);
        return type == null ? (short)0 : type.getTypeId();
    }

    @Deprecated
    public EntityType getEggType(ItemStack item) {
        return CMINBT.getEggType(item);
    }

    @Deprecated
    public ItemStack setEggType(ItemStack item, EntityType etype) {
        return CMINBT.setEggType(item, etype);
    }

    public ItemStack modifyItemStack(ItemStack stack, String arguments) {
        return CMINBT.modifyItemStack(stack, arguments);
    }

    public int getHoneyLevel(Block block) {
        if (CMIMaterial.get(block) != CMIMaterial.BEE_NEST && CMIMaterial.get(block) != CMIMaterial.BEEHIVE) {
            return 0;
        }
        try {
            Object nb = this.CraftBeehive.cast(block.getBlockData());
            Method method = nb.getClass().getMethod("getHoneyLevel", new Class[0]);
            return (Integer)method.invoke(nb, new Object[0]);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return 0;
        }
    }

    public int getMaxHoneyLevel(Block block) {
        if (CMIMaterial.get(block) != CMIMaterial.BEE_NEST && CMIMaterial.get(block) != CMIMaterial.BEEHIVE) {
            return 0;
        }
        try {
            Object nb = this.CraftBeehive.cast(block.getBlockData());
            Method method = nb.getClass().getMethod("getMaximumHoneyLevel", new Class[0]);
            return (Integer)method.invoke(nb, new Object[0]);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return 5;
        }
    }

    public void playEffect(Player player, Location location, CMIEffect ef) {
        block48: {
            if (location == null || ef == null || location.getWorld() == null || player == null || !player.isOnline()) {
                return;
            }
            if (!location.getWorld().equals((Object)player.getWorld())) {
                return;
            }
            if (ef.getParticle() == null) {
                return;
            }
            if (!ef.getParticle().isParticle()) {
                return;
            }
            try {
                if (Version.isCurrentEqualOrLower(Version.v1_7_R4)) {
                    Effect effect = ef.getParticle().getEffect();
                    if (effect == null) {
                        return;
                    }
                    if (this.effectConstructor == null) {
                        this.effectConstructor = this.PacketPlayOutWorldParticles.getConstructor(String.class, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Integer.TYPE);
                    }
                    Object newPack = this.effectConstructor.newInstance(effect.name(), Float.valueOf((float)location.getX()), Float.valueOf((float)location.getY()), Float.valueOf((float)location.getZ()), Float.valueOf((float)ef.getOffset().getX()), Float.valueOf((float)ef.getOffset().getY()), Float.valueOf((float)ef.getOffset().getZ()), Float.valueOf(ef.getSpeed()), ef.getAmount());
                    this.sendPlayerPacket(player, newPack);
                    break block48;
                }
                if (Version.isCurrentEqualOrLower(Version.v1_12_R1)) {
                    Effect effect = ef.getParticle().getEffect();
                    if (effect == null) {
                        return;
                    }
                    Object particle = ef.getParticle().getEnumParticle() == null ? null : this.EnumParticle.cast(ef.getParticle().getEnumParticle());
                    int[] extra = ef.getParticle().getExtra();
                    if (particle == null) {
                        for (Object p : this.EnumParticle.getEnumConstants()) {
                            String name = p.toString().replace("_", "");
                            if (!ef.getParticle().is(name)) continue;
                            particle = p;
                            if (ef.getParticle().getEffect().getData() == null) break;
                            extra = new int[]{0};
                            break;
                        }
                        if (extra == null) {
                            extra = new int[]{};
                        }
                    }
                    if (particle == null) {
                        return;
                    }
                    if (ef.getParticle().getEnumParticle() == null) {
                        ef.getParticle().setEnumParticle(particle);
                        ef.getParticle().setExtra(extra);
                    }
                    if (this.effectConstructor == null) {
                        this.effectConstructor = this.PacketPlayOutWorldParticles.getConstructor(this.EnumParticle, Boolean.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Integer.TYPE, int[].class);
                    }
                    Object newPack = null;
                    newPack = ef.getParticle().isColored() ? this.effectConstructor.newInstance(particle, true, Float.valueOf((float)location.getX()), Float.valueOf((float)location.getY()), Float.valueOf((float)location.getZ()), Float.valueOf((float)ef.getColorFrom().getRed() / 255.0f), Float.valueOf((float)ef.getColorFrom().getGreen() / 255.0f), Float.valueOf((float)ef.getColorFrom().getBlue() / 255.0f), 1, 0, extra) : this.effectConstructor.newInstance(particle, true, Float.valueOf((float)location.getX()), Float.valueOf((float)location.getY()), Float.valueOf((float)location.getZ()), Float.valueOf((float)ef.getOffset().getX()), Float.valueOf((float)ef.getOffset().getY()), Float.valueOf((float)ef.getOffset().getZ()), Float.valueOf(ef.getSpeed()), ef.getAmount(), extra);
                    this.sendPlayerPacket(player, newPack);
                    break block48;
                }
                if (Version.isCurrentEqualOrLower(Version.v1_14_R1)) {
                    Particle particle = ef.getParticle().getParticle();
                    if (particle == null) {
                        return;
                    }
                    Particle.DustOptions dd = null;
                    if (particle.toString().equals("REDSTONE")) {
                        dd = new Particle.DustOptions(ef.getColor(), (float)ef.getSize());
                    }
                    if (this.CraftParticleMethod == null) {
                        this.CraftParticleMethod = this.CraftParticle.getMethod("toNMS", Particle.class, Object.class);
                    }
                    if (this.effectConstructor == null) {
                        this.effectConstructor = this.PacketPlayOutWorldParticles.getConstructor(this.ParticleParam, Boolean.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Integer.TYPE);
                    }
                    Object param = this.CraftParticleMethod.invoke(null, particle, dd);
                    Object packet = this.effectConstructor.newInstance(param, true, Float.valueOf((float)location.getX()), Float.valueOf((float)location.getY()), Float.valueOf((float)location.getZ()), Float.valueOf((float)ef.getOffset().getX()), Float.valueOf((float)ef.getOffset().getY()), Float.valueOf((float)ef.getOffset().getZ()), Float.valueOf(ef.getSpeed()), ef.getAmount());
                    this.sendPlayerPacket(player, packet);
                    break block48;
                }
                if (Version.isCurrentEqualOrLower(Version.v1_16_R3)) {
                    Particle particle = ef.getParticle().getParticle();
                    if (particle == null) {
                        return;
                    }
                    Particle.DustOptions dd = null;
                    if (particle.toString().equals("REDSTONE")) {
                        dd = new Particle.DustOptions(ef.getColorFrom(), (float)ef.getSize());
                    }
                    if (this.CraftParticleMethod == null) {
                        this.CraftParticleMethod = this.CraftParticle.getMethod("toNMS", Particle.class, Object.class);
                    }
                    if (this.effectConstructor == null) {
                        this.effectConstructor = this.PacketPlayOutWorldParticles.getConstructor(this.ParticleParam, Boolean.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Integer.TYPE);
                    }
                    Object packet = this.effectConstructor.newInstance(this.CraftParticleMethod.invoke(null, particle, dd), true, location.getX(), location.getY(), location.getZ(), Float.valueOf((float)ef.getOffset().getX()), Float.valueOf((float)ef.getOffset().getY()), Float.valueOf((float)ef.getOffset().getZ()), Float.valueOf(ef.getSpeed()), ef.getAmount());
                    this.sendPlayerPacket(player, packet);
                    break block48;
                }
                Particle particle = ef.getParticle().getParticle();
                if (particle == null) {
                    return;
                }
                Object dd = null;
                if (ef.getParticle().getDataType().equals((Object)CMIEffectManager.CMIParticleDataType.DustOptions)) {
                    dd = new Particle.DustOptions(ef.getColorFrom(), (float)ef.getSize());
                } else if (ef.getParticle().getDataType().equals((Object)CMIEffectManager.CMIParticleDataType.DustTransition)) {
                    dd = new Particle.DustTransition(ef.getColorFrom(), ef.getColorTo(), (float)ef.getSize());
                } else if (ef.getParticle().getDataType().equals((Object)CMIEffectManager.CMIParticleDataType.Float)) {
                    dd = Float.valueOf(ef.getSpeed());
                } else if (ef.getParticle().getDataType().equals((Object)CMIEffectManager.CMIParticleDataType.Int)) {
                    dd = (int)ef.getSpeed();
                } else if (ef.getParticle().getDataType().equals((Object)CMIEffectManager.CMIParticleDataType.Vibration)) {
                    if (this.destinationConstructor == null) {
                        this.destinationConstructor = Class.forName("org.bukkit.Vibration$Destination$BlockDestination").getConstructor(Location.class);
                    }
                    if (this.vibrationConstructor == null) {
                        this.vibrationConstructor = Class.forName("org.bukkit.Vibration").getConstructor(Class.forName("org.bukkit.Vibration$Destination$BlockDestination"), Integer.TYPE);
                    }
                    dd = this.vibrationConstructor.newInstance(this.destinationConstructor.newInstance(location), 20);
                } else if (ef.getParticle().getDataType().equals((Object)CMIEffectManager.CMIParticleDataType.Color)) {
                    dd = ef.getColorFrom();
                } else if (ef.getParticle().getDataType().equals((Object)CMIEffectManager.CMIParticleDataType.ItemStack)) {
                    dd = ef.getMaterial() != null ? ef.getMaterial().newItemStack() : CMIMaterial.OAK_BUTTON.newItemStack();
                } else if (ef.getParticle().getDataType().equals((Object)CMIEffectManager.CMIParticleDataType.BlockData)) {
                    dd = Bukkit.createBlockData((Material)(ef.getMaterial() == null ? CMIMaterial.STONE.getMaterial() : ef.getMaterial().getMaterial()));
                }
                if (this.CraftParticleMethod == null) {
                    try {
                        this.CraftParticleMethod = this.CraftParticle.getMethod("toNMS", Particle.class, Object.class);
                    }
                    catch (Throwable e) {
                        this.CraftParticleMethod = this.CraftParticle.getMethod("createParticleParam", Particle.class, Object.class);
                    }
                }
                PacketPlayOutWorldParticles packet = new PacketPlayOutWorldParticles((ParticleParam)this.CraftParticleMethod.invoke(null, particle, dd), true, location.getX(), location.getY(), location.getZ(), (float)ef.getOffset().getX(), (float)ef.getOffset().getY(), (float)ef.getOffset().getZ(), ef.getSpeed(), ef.getAmount());
                this.sendPlayerPacket(player, packet);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    private MinecraftKey getKey(String key) {
        if (Version.isCurrentEqualOrHigher(Version.v1_20_R1)) {
            return MinecraftKey.a((String)key);
        }
        return this.getKey(key.contains(":") ? key.split(":", 2)[0] : "minecraft", key.contains(":") ? key.split(":", 2)[1] : key);
    }

    private MinecraftKey getKey(String base, String key) {
        if (Version.isCurrentEqualOrHigher(Version.v1_20_R1)) {
            return MinecraftKey.a((String)base, (String)key);
        }
        if (this.keyConstructor == null) {
            try {
                this.keyConstructor = MinecraftKey.class.getConstructor(String.class, String.class);
            }
            catch (NoSuchMethodException | SecurityException e) {
                e.printStackTrace();
            }
        }
        try {
            return this.keyConstructor.newInstance(base, key);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public void removeAdvancement(CMIAdvancement ad) {
        if (Version.isCurrentLower(Version.v1_12_R1) || Version.isCurrentEqualOrHigher(Version.v1_20_R2)) {
            return;
        }
        if (Version.isCurrentEqualOrHigher(Version.v1_17_R1)) {
            try {
                Map advancements = (Map)this.advancementRegistry.getClass().getField("b").get(this.advancementRegistry);
                if (ad.getId() != null) {
                    advancements.remove(this.getKey(ad.getId().getNamespace(), ad.getId().getKey()));
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        } else if (Version.isCurrentEqualOrHigher(Version.v1_14_R1)) {
            Bukkit.getUnsafe().removeAdvancement(ad.getId());
            try {
                Object server = this.MinecraftServerClass.getDeclaredMethod("getServer", new Class[0]).invoke(this.MinecraftServer, new Object[0]);
                Object AdvancementData = server.getClass().getMethod("getAdvancementData", new Class[0]).invoke(server, new Object[0]);
                Object REGISTRY = AdvancementData.getClass().getField("REGISTRY").get(AdvancementData);
                Map advs = (Map)REGISTRY.getClass().getField("advancements").get(REGISTRY);
                if (ad.getId() != null) {
                    advs.remove(this.CraftNamespacedKey.getMethod("toMinecraft", NamespacedKey.class).invoke(this.CraftNamespacedKey, ad.getId()));
                }
            }
            catch (Error | Exception e) {
                e.printStackTrace();
            }
        } else {
            Bukkit.getUnsafe().removeAdvancement(ad.getId());
            try {
                Object REGISTRY = this.AdvancementDataWorld.getField("REGISTRY").get(this.AdvancementDataWorld);
                Map advs = (Map)REGISTRY.getClass().getField("advancements").get(REGISTRY);
                if (ad.getId() != null) {
                    advs.remove(this.CraftNamespacedKey.getMethod("toMinecraft", NamespacedKey.class).invoke(this.CraftNamespacedKey, ad.getId()));
                }
            }
            catch (Error | Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void showToast(CMIAdvancement advancement, Player ... players) {
        if (!Version.isCurrentEqualOrHigher(Version.v1_20_R2)) {
            return;
        }
        CMIScheduler.runTaskAsynchronously(() -> {
            if (Version.isCurrentEqualOrHigher(Version.v1_20_R3)) {
                HashSet<MinecraftKey> removed = new HashSet<MinecraftKey>();
                MinecraftKey minecraftkey = this.getKey(advancement.getId().getNamespace(), advancement.getId().getKey());
                removed.add(minecraftkey);
                MinecraftKey bg = this.getKey(advancement.getBackground().getUrl());
                net.minecraft.advancements.AdvancementFrameType frame = net.minecraft.advancements.AdvancementFrameType.a;
                if (advancement.getFrame().equals((Object)AdvancementFrameType.GOAL)) {
                    frame = net.minecraft.advancements.AdvancementFrameType.c;
                } else if (advancement.getFrame().equals((Object)AdvancementFrameType.CHALLENGE)) {
                    frame = net.minecraft.advancements.AdvancementFrameType.b;
                }
                AdvancementDisplay display = new AdvancementDisplay((net.minecraft.world.item.ItemStack)CMINBT.asNMSCopy(advancement.getItem()), (IChatBaseComponent)this.textToIChatBaseComponent(new RawMessage().addText(advancement.getTitle()).getRaw()), (IChatBaseComponent)this.textToIChatBaseComponent(new RawMessage().addText(advancement.getDescription()).getRaw()), Optional.of(bg), frame, true, false, false);
                ArrayList<List<String>> adreq = new ArrayList<List<String>>();
                adreq.add(Arrays.asList("CMITOAST"));
                AdvancementRequirements adhd = new AdvancementRequirements(adreq);
                AdvancementProgress progress = new AdvancementProgress();
                progress.a(adhd);
                progress.a("CMITOAST");
                HashMap<MinecraftKey, AdvancementProgress> progressMap = new HashMap<MinecraftKey, AdvancementProgress>();
                progressMap.put(minecraftkey, progress);
                HashSet<AdvancementHolder> addedMap = new HashSet<AdvancementHolder>();
                Advancement.SerializedAdvancement add = new Advancement.SerializedAdvancement();
                add.a(display);
                add.a(adhd);
                addedMap.add(add.b(minecraftkey));
                for (Player player : players) {
                    Object connection = CMILib.getInstance().getReflectionManager().getPlayerConnection(player);
                    this.sendPacket(connection, new PacketPlayOutAdvancements(false, addedMap, new HashSet(), progressMap));
                    this.sendPacket(connection, new PacketPlayOutAdvancements(false, new HashSet(), removed, new HashMap()));
                }
                return;
            }
            HashMap<MinecraftKey, AdvancementProgress> progressMap = new HashMap<MinecraftKey, AdvancementProgress>();
            HashSet<MinecraftKey> removed = new HashSet<MinecraftKey>();
            MinecraftKey minecraftkey = this.getKey(advancement.getId().getNamespace(), advancement.getId().getKey());
            removed.add(minecraftkey);
            HashSet<AdvancementHolder> addedMap = new HashSet<AdvancementHolder>();
            try {
                Method mt = Advancement.class.getMethod("a", JsonObject.class, this.LootDeserializationContext);
                Advancement adv = (Advancement)mt.invoke(null, advancement.getJSONObject(), null);
                AdvancementProgress progress = new AdvancementProgress();
                progress.a((AdvancementRequirements)adv.getClass().getMethod("g", new Class[0]).invoke((Object)adv, new Object[0]));
                progress.c("CMITOAST").b();
                progressMap.put(minecraftkey, progress);
                AdvancementHolder holder = new AdvancementHolder(minecraftkey, adv);
                addedMap.add(holder);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            for (Player player : players) {
                Object connection = CMILib.getInstance().getReflectionManager().getPlayerConnection(player);
                this.sendPacket(connection, new PacketPlayOutAdvancements(false, addedMap, new HashSet(), progressMap));
                this.sendPacket(connection, new PacketPlayOutAdvancements(false, new HashSet(), removed, new HashMap()));
            }
        });
    }

    public void loadAdvancement(CMIAdvancement ad, String advancement) {
        block37: {
            if (Version.isCurrentLower(Version.v1_12_R1) || Version.isCurrentEqualOrHigher(Version.v1_20_R2)) {
                return;
            }
            if (Bukkit.getAdvancement((NamespacedKey)ad.getId()) != null) {
                return;
            }
            NamespacedKey key = ad.getId();
            if (Version.isCurrentEqualOrHigher(Version.v1_20_R1)) {
                if (Bukkit.getAdvancement((NamespacedKey)key) != null) {
                    return;
                }
                try {
                    MinecraftKey minecraftkey = (MinecraftKey)this.CraftNamespacedKey.getMethod("toMinecraft", NamespacedKey.class).invoke(this.CraftNamespacedKey, key);
                    Object fieldB = this.AdvancementDataWorld.getField("b").get(this.AdvancementDataWorld);
                    Object jsonelement = fieldB.getClass().getMethod("fromJson", String.class, Class.class).invoke(fieldB, advancement, JsonElement.class);
                    Object jsonobject = this.ChatDeserializer.getMethod("m", JsonElement.class, String.class).invoke(this.ChatDeserializer, jsonelement, "advancement");
                    Method meth = this.SerializedAdvancement.getMethod("a", jsonobject.getClass(), this.LootDeserializationContext);
                    Object LootPredicateManager = net.minecraft.server.MinecraftServer.getServer().getClass().getMethod("aH", new Class[0]).invoke((Object)net.minecraft.server.MinecraftServer.getServer(), new Object[0]);
                    Constructor<?> consts = this.LootDeserializationContext.getConstructor(MinecraftKey.class, this.LootDataManager);
                    Object LDC = consts.newInstance(minecraftkey, LootPredicateManager);
                    Advancement.SerializedAdvancement nms = (Advancement.SerializedAdvancement)meth.invoke(this.SerializedAdvancement, jsonobject, LDC);
                    if (nms != null) {
                        Object ax = net.minecraft.server.MinecraftServer.getServer().getClass().getMethod("az", new Class[0]).invoke((Object)net.minecraft.server.MinecraftServer.getServer(), new Object[0]);
                        Object c = ax.getClass().getField("c").get(ax);
                        c.getClass().getMethod("a", Map.class).invoke(c, Maps.newHashMap(Collections.singletonMap(minecraftkey, nms)));
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            } else if (Version.isCurrentEqualOrHigher(Version.v1_18_R1)) {
                if (Bukkit.getAdvancement((NamespacedKey)key) != null) {
                    return;
                }
                try {
                    MinecraftKey minecraftkey = (MinecraftKey)this.CraftNamespacedKey.getMethod("toMinecraft", NamespacedKey.class).invoke(this.CraftNamespacedKey, key);
                    Object fieldB = this.AdvancementDataWorld.getField("b").get(this.AdvancementDataWorld);
                    Object jsonelement = fieldB.getClass().getMethod("fromJson", String.class, Class.class).invoke(fieldB, advancement, JsonElement.class);
                    Object jsonobject = this.ChatDeserializer.getMethod("m", JsonElement.class, String.class).invoke(this.ChatDeserializer, jsonelement, "advancement");
                    Method meth = this.SerializedAdvancement.getMethod("a", jsonobject.getClass(), this.LootDeserializationContext);
                    Object LootPredicateManager = null;
                    if (Version.isCurrentEqualOrLower(Version.v1_18_R1)) {
                        LootPredicateManager = net.minecraft.server.MinecraftServer.getServer().getClass().getMethod("aH", new Class[0]).invoke((Object)net.minecraft.server.MinecraftServer.getServer(), new Object[0]);
                    } else if (Version.isCurrentEqualOrLower(Version.v1_18_R2)) {
                        LootPredicateManager = net.minecraft.server.MinecraftServer.getServer().getClass().getMethod("aG", new Class[0]).invoke((Object)net.minecraft.server.MinecraftServer.getServer(), new Object[0]);
                    } else if (Version.isCurrentEqualOrLower(Version.v1_19_R1)) {
                        LootPredicateManager = net.minecraft.server.MinecraftServer.getServer().getClass().getMethod("aI", new Class[0]).invoke((Object)net.minecraft.server.MinecraftServer.getServer(), new Object[0]);
                    } else if (Version.isCurrentEqualOrLower(Version.v1_19_R2)) {
                        LootPredicateManager = net.minecraft.server.MinecraftServer.getServer().getClass().getMethod("aH", new Class[0]).invoke((Object)net.minecraft.server.MinecraftServer.getServer(), new Object[0]);
                    } else if (Version.isCurrentEqualOrLower(Version.v1_19_R3)) {
                        LootPredicateManager = net.minecraft.server.MinecraftServer.getServer().getClass().getMethod("aI", new Class[0]).invoke((Object)net.minecraft.server.MinecraftServer.getServer(), new Object[0]);
                    }
                    if (LootPredicateManager == null) {
                        return;
                    }
                    Constructor<?> constructor = this.LootDeserializationContext.getConstructor(MinecraftKey.class, LootPredicateManager.getClass());
                    Object LDC = constructor.newInstance(minecraftkey, LootPredicateManager);
                    Advancement.SerializedAdvancement nms = (Advancement.SerializedAdvancement)meth.invoke(this.SerializedAdvancement, jsonobject, LDC);
                    if (nms == null) break block37;
                    if (Version.isCurrentEqualOrHigher(Version.v1_19_R3)) {
                        Object az = net.minecraft.server.MinecraftServer.getServer().getClass().getMethod("az", new Class[0]).invoke((Object)net.minecraft.server.MinecraftServer.getServer(), new Object[0]);
                        Object c = az.getClass().getField("c").get(az);
                        c.getClass().getMethod("a", Map.class).invoke(c, Maps.newHashMap(Collections.singletonMap(minecraftkey, nms)));
                        break block37;
                    }
                    if (Version.isCurrentEqualOrHigher(Version.v1_19_R2)) {
                        Object ay = net.minecraft.server.MinecraftServer.getServer().getClass().getMethod("ay", new Class[0]).invoke((Object)net.minecraft.server.MinecraftServer.getServer(), new Object[0]);
                        Object c = ay.getClass().getField("c").get(ay);
                        c.getClass().getMethod("a", Map.class).invoke(c, Maps.newHashMap(Collections.singletonMap(minecraftkey, nms)));
                        break block37;
                    }
                    if (Version.isCurrentEqualOrHigher(Version.v1_19_R1)) {
                        Object ax = net.minecraft.server.MinecraftServer.getServer().getClass().getMethod("az", new Class[0]).invoke((Object)net.minecraft.server.MinecraftServer.getServer(), new Object[0]);
                        Object c = ax.getClass().getField("c").get(ax);
                        c.getClass().getMethod("a", Map.class).invoke(c, Maps.newHashMap(Collections.singletonMap(minecraftkey, nms)));
                        break block37;
                    }
                    Object ax = net.minecraft.server.MinecraftServer.getServer().getClass().getMethod("ax", new Class[0]).invoke((Object)net.minecraft.server.MinecraftServer.getServer(), new Object[0]);
                    Object c = ax.getClass().getField("c").get(ax);
                    c.getClass().getMethod("a", Map.class).invoke(c, Maps.newHashMap(Collections.singletonMap(minecraftkey, nms)));
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            } else if (Version.isCurrentEqualOrHigher(Version.v1_17_R1)) {
                try {
                    MinecraftKey minecraftkey = (MinecraftKey)this.CraftNamespacedKey.getMethod("toMinecraft", NamespacedKey.class).invoke(this.CraftNamespacedKey, key);
                    Object fieldB = this.AdvancementDataWorld.getField("b").get(this.AdvancementDataWorld);
                    Object jsonelement = fieldB.getClass().getMethod("fromJson", String.class, Class.class).invoke(fieldB, advancement, JsonElement.class);
                    Object jsonobject = this.ChatDeserializer.getMethod("m", JsonElement.class, String.class).invoke(this.ChatDeserializer, jsonelement, "advancement");
                    Method meth = this.SerializedAdvancement.getMethod("a", jsonobject.getClass(), this.LootDeserializationContext);
                    Object LootPredicateManager = net.minecraft.server.MinecraftServer.getServer().getClass().getMethod("getLootPredicateManager", new Class[0]).invoke((Object)net.minecraft.server.MinecraftServer.getServer(), new Object[0]);
                    Constructor<?> constructor = this.LootDeserializationContext.getConstructor(MinecraftKey.class, LootPredicateManager.getClass());
                    Object LDC = constructor.newInstance(minecraftkey, LootPredicateManager);
                    Advancement.SerializedAdvancement nms = (Advancement.SerializedAdvancement)meth.invoke(this.SerializedAdvancement, jsonobject, LDC);
                    Object data = net.minecraft.server.MinecraftServer.getServer().getClass().getMethod("getAdvancementData", new Class[0]).invoke((Object)net.minecraft.server.MinecraftServer.getServer(), new Object[0]);
                    Object c = data.getClass().getField("c").get(data);
                    c.getClass().getMethod("a", Map.class).invoke(c, Maps.newHashMap(Collections.singletonMap(minecraftkey, nms)));
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            } else if (Version.isCurrentEqualOrHigher(Version.v1_16_R1)) {
                try {
                    Object minecraftkey = this.CraftNamespacedKey.getMethod("toMinecraft", NamespacedKey.class).invoke(this.CraftNamespacedKey, key);
                    ad.setId(key);
                    Object DESERIALIZER = this.AdvancementDataWorld.getField("DESERIALIZER").get(this.AdvancementDataWorld);
                    Object jsonelement = DESERIALIZER.getClass().getMethod("fromJson", String.class, Class.class).invoke(DESERIALIZER, advancement, JsonElement.class);
                    Object jsonobject = this.ChatDeserializer.getMethod("m", JsonElement.class, String.class).invoke(this.ChatDeserializer, jsonelement, "advancement");
                    Object Server2 = this.MinecraftServerClass.getDeclaredMethod("getServer", new Class[0]).invoke(this.MinecraftServer, new Object[0]);
                    Object PredicateManager = Server2.getClass().getMethod("getLootPredicateManager", new Class[0]).invoke(Server2, new Object[0]);
                    Method meth = this.SerializedAdvancement.getMethod("a", jsonobject.getClass(), this.LootDeserializationContext);
                    Object LootDeserialization = this.LootDeserializationContext.getConstructor(minecraftkey.getClass(), PredicateManager.getClass()).newInstance(minecraftkey, PredicateManager);
                    Object nms = meth.invoke(this.SerializedAdvancement, jsonobject, LootDeserialization);
                    if (nms != null) {
                        Object AdvancementData = Server2.getClass().getMethod("getAdvancementData", new Class[0]).invoke(Server2, new Object[0]);
                        Object REGISTRY = AdvancementData.getClass().getField("REGISTRY").get(AdvancementData);
                        REGISTRY.getClass().getMethod("a", Map.class).invoke(REGISTRY, Maps.newHashMap(Collections.singletonMap(minecraftkey, nms)));
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    Object minecraftkey = this.CraftNamespacedKey.getMethod("toMinecraft", NamespacedKey.class).invoke(this.CraftNamespacedKey, key);
                    Object DESERIALIZER = this.AdvancementDataWorld.getField("DESERIALIZER").get(this.AdvancementDataWorld);
                    Object nms = DESERIALIZER.getClass().getMethod("fromJson", String.class, Class.class).invoke(DESERIALIZER, advancement, this.SerializedAdvancement);
                    Object REGISTRY = this.AdvancementDataWorld.getField("REGISTRY").get(this.AdvancementDataWorld);
                    REGISTRY.getClass().getMethod("a", Map.class).invoke(REGISTRY, Maps.newHashMap(Collections.singletonMap(minecraftkey, nms)));
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public ItemStack addAttributes(List<Attribute> ls, ItemStack item) {
        if (ls.isEmpty()) {
            return item;
        }
        try {
            CMINBT nbt = new CMINBT(item);
            Object modifiers = nbt.getObjectList("AttributeModifiers", 10);
            if (modifiers == null) {
                modifiers = CMINBT.newNBTTagList(10);
            }
            Method sizeMeth = modifiers.getClass().getMethod("size", new Class[0]);
            for (Attribute one : ls) {
                Object att = this.nbtTagCompound.newInstance();
                CMINBT subNBT = new CMINBT(att);
                subNBT.setString("AttributeName", one.getType().getFullName());
                subNBT.setString("Name", "generic." + one.getType().getName());
                if (one.getSlot() != null) {
                    subNBT.setString("Slot", one.getSlot().getName());
                }
                if (one.getOperation() > 0 && one.getOperation() < 3) {
                    subNBT.setInt("Operation", one.getOperation());
                }
                if (Version.isCurrentEqualOrLower(Version.v1_15_R2)) {
                    UUID uuid = UUID.randomUUID();
                    subNBT.setInt("UUIDLeast", (int)uuid.getLeastSignificantBits());
                    subNBT.setInt("UUIDMost", (int)uuid.getMostSignificantBits());
                } else {
                    Random rand = new Random();
                    int[] uuids = new int[]{rand.nextInt(160000), rand.nextInt(160000), rand.nextInt(160000), rand.nextInt(160000)};
                    subNBT.setIntArray("UUID", uuids);
                }
                subNBT.setDouble("Amount", one.getMod());
                CMINBT.addToList(modifiers, (Integer)sizeMeth.invoke(modifiers, new Object[0]), att);
            }
            item = (ItemStack)nbt.set("AttributeModifiers", modifiers);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return item;
    }
}

