/*
 * Decompiled with CFR 0.152.
 */
package net.Zrips.CMILib.RawMessages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.Zrips.CMILib.CMILib;
import net.Zrips.CMILib.Colors.CMIChatColor;
import net.Zrips.CMILib.Container.CMICommandSender;
import net.Zrips.CMILib.Items.CMIItemStack;
import net.Zrips.CMILib.Locale.LC;
import net.Zrips.CMILib.Messages.CMIMessages;
import net.Zrips.CMILib.NBT.CMINBT;
import net.Zrips.CMILib.RawMessages.RawMessageCommand;
import net.Zrips.CMILib.RawMessages.RawMessageFragment;
import net.Zrips.CMILib.RawMessages.RawMessageManager;
import net.Zrips.CMILib.RawMessages.RawMessagePartType;
import net.Zrips.CMILib.Shadow.ShadowCommand;
import net.Zrips.CMILib.Shadow.ShadowCommandType;
import net.Zrips.CMILib.Version.Version;
import net.Zrips.CMILib.commands.CommandsHandler;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class RawMessage {
    List<String> parts = new ArrayList<String>();
    List<String> onlyText = new ArrayList<String>();
    private LinkedHashMap<RawMessagePartType, String> temp = new LinkedHashMap();
    RawMessageFragment fragment = new RawMessageFragment();
    RawMessageFragment hoverFragment = new RawMessageFragment();
    private RawMessageFragment frozenFragment = new RawMessageFragment();
    private boolean freezeFormat = false;
    private String combined = "";
    String combinedClean = "";
    private boolean dontBreakLine = false;
    public static final String newLine = "\u00a5n";
    static Pattern patern = Pattern.compile("((http|https|ftp|ftps)\\:\\/\\/)?[a-zA-Z0-9\\-]+\\.[a-zA-Z]{2,3}(\\/\\S*)?([^\\s|^\\)]+)");

    public RawMessage RawMessage() {
        return this;
    }

    public void clear() {
        this.parts = new ArrayList<String>();
        this.onlyText = new ArrayList<String>();
        this.combined = "";
        this.combinedClean = "";
    }

    private String textIntoJson(String text, boolean hover) {
        RawMessageFragment f;
        if (text.isEmpty()) {
            return "";
        }
        if (text.equalsIgnoreCase(" ")) {
            return " ";
        }
        text = CMIChatColor.deColorize(text);
        Matcher match = CMIChatColor.fullPattern.matcher(text);
        String matcher = null;
        ArrayList<RawMessageFragment> fragments = new ArrayList<RawMessageFragment>();
        RawMessageFragment rawMessageFragment = f = hover ? this.hoverFragment : this.fragment;
        while (match.find()) {
            matcher = match.group();
            String[] split = text.split(matcher.replace("#", "\\#").replace("{", "\\{").replace("}", "\\}"), 2);
            text = "";
            for (int i = 1; i < split.length; ++i) {
                text = text + split[i];
            }
            if (split[0] != null && !split[0].isEmpty()) {
                String t = split[0];
                f.setText(t);
                fragments.add(f);
                f = new RawMessageFragment(f);
            }
            if (matcher.startsWith("{@")) {
                f.setFont(matcher);
                continue;
            }
            CMIChatColor color = CMIChatColor.getColor(matcher);
            if (color == null) continue;
            if (color.isColor()) {
                f.setLastColor(color);
                continue;
            }
            f.addFormat(color);
        }
        if (!text.isEmpty()) {
            RawMessageFragment t = new RawMessageFragment(f);
            t.setText(text);
            fragments.add(t);
        }
        if (hover) {
            this.hoverFragment = f;
        } else {
            this.fragment = f;
        }
        StringBuilder finalText = new StringBuilder();
        for (RawMessageFragment one : fragments) {
            if (!finalText.toString().isEmpty()) {
                finalText.append("},{");
            }
            StringBuilder options = new StringBuilder();
            for (CMIChatColor format : one.getFormats()) {
                if (!options.toString().isEmpty()) {
                    options.append(",");
                }
                if (format.equals(CMIChatColor.UNDERLINE)) {
                    options.append("\"underlined\":true");
                    continue;
                }
                if (format.equals(CMIChatColor.BOLD)) {
                    options.append("\"bold\":true");
                    continue;
                }
                if (format.equals(CMIChatColor.ITALIC)) {
                    options.append("\"italic\":true");
                    continue;
                }
                if (format.equals(CMIChatColor.STRIKETHROUGH)) {
                    options.append("\"strikethrough\":true");
                    continue;
                }
                if (!format.equals(CMIChatColor.OBFUSCATED)) continue;
                options.append("\"obfuscated\":true");
            }
            if (!options.toString().isEmpty()) {
                finalText.append(options.toString());
                finalText.append(",");
            }
            if (one.getFont() != null) {
                finalText.append("\"font\":\"" + one.getFont() + "\",");
            }
            if (one.getLastColor() != null) {
                if (one.getLastColor().getHex() != null) {
                    finalText.append("\"color\":\"#" + one.getLastColor().getHex() + "\",");
                } else if (one.getLastColor().getName() != null) {
                    finalText.append("\"color\":\"" + one.getLastColor().getName().toLowerCase() + "\",");
                }
            }
            String t = one.getText();
            if (Version.isCurrentLower(Version.v1_16_R1)) {
                StringBuilder oldColors = new StringBuilder();
                if (one.getLastColor() != null && one.getLastColor().getName() != null) {
                    oldColors.append(one.getLastColor().getColorCode());
                }
                for (CMIChatColor format : one.getFormats()) {
                    if (format.equals(CMIChatColor.UNDERLINE)) {
                        oldColors.append("&n");
                        continue;
                    }
                    if (format.equals(CMIChatColor.BOLD)) {
                        oldColors.append("&l");
                        continue;
                    }
                    if (format.equals(CMIChatColor.ITALIC)) {
                        oldColors.append("&o");
                        continue;
                    }
                    if (format.equals(CMIChatColor.STRIKETHROUGH)) {
                        oldColors.append("&m");
                        continue;
                    }
                    if (!format.equals(CMIChatColor.OBFUSCATED)) continue;
                    oldColors.append("&k");
                }
                t = oldColors.toString() + t;
            }
            finalText.append("\"text\":\"" + this.escape(t, this.isDontBreakLine() && !hover) + "\"");
        }
        if (finalText.toString().isEmpty()) {
            return "";
        }
        return "{" + finalText.toString() + "}";
    }

    @Deprecated
    public RawMessage add(String text, String hoverText, String command, String suggestion, String url) {
        this.add(text, hoverText, command, suggestion, url, null);
        return this;
    }

    @Deprecated
    public RawMessage add(String text, String hoverText, String command, String suggestion, String url, String insertion) {
        this.addText(text);
        this.addHover(hoverText);
        this.addCommand(command);
        this.addSuggestion(suggestion);
        this.addUrl(url);
        this.addInsertion(insertion);
        return this;
    }

    @Deprecated
    public RawMessage addUrl(String text, String url) {
        this.addUrl(text, url, null);
        return this;
    }

    @Deprecated
    public RawMessage addUrl(String text, String url, String hoverText) {
        this.addText(text);
        this.addHover(hoverText);
        this.addUrl(url);
        return this;
    }

    @Deprecated
    public RawMessage add(String text) {
        return this.add(text, null, null, null, null);
    }

    @Deprecated
    public RawMessage add(String text, String hoverText) {
        return this.add(text, hoverText, null, null, null);
    }

    @Deprecated
    public RawMessage add(String text, List<String> hoverText) {
        String hover = "";
        if (hoverText != null) {
            for (String one : hoverText) {
                if (!hover.isEmpty()) {
                    hover = hover + "\n";
                }
                hover = hover + one;
            }
        }
        return this.add(text, hover.isEmpty() ? null : hover, null, null, null);
    }

    @Deprecated
    public RawMessage add(String text, String hoverText, RawMessageCommand rmc) {
        return this.add(text, hoverText, rmc.getCommand(), null, null);
    }

    @Deprecated
    public RawMessage add(String text, String hoverText, String command) {
        return this.add(text, hoverText, command, null, null);
    }

    @Deprecated
    public RawMessage add(String text, String hoverText, String command, String suggestion) {
        return this.add(text, hoverText, command, suggestion, null);
    }

    @Deprecated
    public RawMessage addHoverText(List<String> hoverText) {
        return this.addHover(hoverText);
    }

    @Deprecated
    public RawMessage addHoverText(String hover) {
        return this.addHover(hover);
    }

    public RawMessage addRM(RawMessage rm) {
        return this.addRM(rm, false);
    }

    public RawMessage addRM(RawMessage rm, boolean sameLine) {
        rm.build();
        if (!sameLine && !this.parts.isEmpty()) {
            this.addText("\n");
        }
        this.build();
        this.parts.addAll(rm.parts);
        this.onlyText.addAll(rm.onlyText);
        return this;
    }

    public RawMessage addItem(String text, ItemStack item, String command, String suggestion, String insertion) {
        this.addText(text);
        this.addCommand(command);
        this.addSuggestion(suggestion);
        this.addInsertion(insertion);
        this.addItem(item);
        return this;
    }

    public RawMessage addText(LC lc, boolean colorize) {
        return this.addText(lc.getLocale(new Object[0]), colorize);
    }

    public RawMessage addText(LC lc) {
        return this.addText(lc.getLocale(new Object[0]), true);
    }

    public RawMessage addText(String text) {
        return this.addText(text, true);
    }

    public RawMessage addText(String text, boolean colorize) {
        if (text == null || text.isEmpty()) {
            return this;
        }
        if (this.temp.containsKey((Object)RawMessagePartType.Text)) {
            this.build();
        }
        this.onlyText.add(colorize ? CMIChatColor.translate(text) : text);
        text = this.textIntoJson(text, false);
        String f = "";
        if (text.isEmpty()) {
            f = "\"text\":\"\"";
        } else if (text.equalsIgnoreCase(" ")) {
            f = "\"text\":\" \"";
        } else {
            text = colorize ? CMIChatColor.translate(text) : text;
            f = "\"text\":\"\",\"extra\":[" + text.replace("{\uff06#", "{#").replace("\uff06", "&") + "]";
        }
        this.temp.put(RawMessagePartType.Text, f);
        return this;
    }

    public RawMessage addHover(List<String> hoverText) {
        StringBuilder hover = new StringBuilder();
        if (hoverText != null) {
            for (String one : hoverText) {
                if (!hover.toString().isEmpty()) {
                    hover.append("\n");
                }
                hover.append(one);
            }
        }
        return this.addHover(hover.toString());
    }

    public RawMessage addHover(LC lc) {
        return this.addHover(lc.getLocale(new Object[0]));
    }

    public RawMessage addHover(String hover) {
        this.hoverFragment = new RawMessageFragment();
        if (hover == null || hover.isEmpty()) {
            return this;
        }
        hover = this.textIntoJson(hover, true);
        String f = "";
        f = hover.isEmpty() ? "\"text\":\"\"" : (hover.equalsIgnoreCase(" ") ? "\"text\":\" \"" : "\"hoverEvent\":{\"action\":\"show_text\",\"value\":{\"text\":\"\",\"extra\":[" + CMIChatColor.translate(hover).replace("\uff06", "&") + "]}}");
        this.temp.put(RawMessagePartType.HoverText, f);
        return this;
    }

    public RawMessage addCommand(RawMessageCommand rmc) {
        if (rmc == null || rmc.getCommand().isEmpty()) {
            return this;
        }
        this.addCommand(rmc.getCommand());
        return this;
    }

    public RawMessage addCommand(String command) {
        if (command == null || command.isEmpty()) {
            return this;
        }
        if (!command.startsWith("/")) {
            command = "/" + command;
        }
        command = this.escape(command, true);
        String f = "\"clickEvent\":{\"action\":\"run_command\",\"value\":\"" + CMIChatColor.deColorize(command).replace("\uff06", "&") + "\"}";
        this.temp.put(RawMessagePartType.ClickCommand, f);
        return this;
    }

    public RawMessage addSuggestion(String suggestion) {
        if (suggestion == null || suggestion.isEmpty()) {
            return this;
        }
        suggestion = this.escape(suggestion, true);
        String f = "\"clickEvent\":{\"action\":\"suggest_command\",\"value\":\"" + CMIChatColor.deColorize(suggestion, false).replace("\uff06", "&") + "\"}";
        this.temp.put(RawMessagePartType.ClickSuggestion, f);
        return this;
    }

    public RawMessage addInsertion(String insertion) {
        if (insertion == null || insertion.isEmpty()) {
            return this;
        }
        insertion = this.escape(insertion, true);
        String f = "\"insertion\":\"" + CMIChatColor.deColorize(insertion).replace("\uff06", "&") + "\"";
        this.temp.put(RawMessagePartType.ClickInsertion, f);
        return this;
    }

    public RawMessage addItem(ItemStack item) {
        if (item == null) {
            return this;
        }
        if ((item = item.clone()).getItemMeta() instanceof BookMeta) {
            BookMeta bmeta = (BookMeta)item.getItemMeta();
            bmeta.setPages(new ArrayList());
            item.setItemMeta((ItemMeta)bmeta);
        }
        String res = CMINBT.toJson(item);
        res = res.replaceAll("\\\"bold\\\":false,|\\\"underlined\\\":false,|\\\"strikethrough\\\":false,|\\\"obfuscated\\\":false,", "");
        try {
            if (res.length() > 32566) {
                return this;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        String f = "\"hoverEvent\":{\"action\":\"show_item\",\"value\":\"" + this.escape(res, true) + "\"}";
        this.temp.put(RawMessagePartType.HoverItem, f);
        return this;
    }

    public RawMessage addUrl(String url) {
        if (url == null || url.isEmpty()) {
            return this;
        }
        if (!url.toLowerCase().startsWith("http://") && !url.toLowerCase().startsWith("https://")) {
            url = "https://" + url;
        }
        url = url.replace("\"", "");
        url = url.replace("'", "");
        url = this.escape(url, true);
        String f = "\"clickEvent\":{\"action\":\"open_url\",\"value\":\"" + CMIChatColor.deColorize(url).replace("\uff06", "&") + "\"}";
        this.temp.put(RawMessagePartType.ClickLink, f);
        return this;
    }

    public RawMessage build() {
        if (this.temp.isEmpty()) {
            return this;
        }
        if (!this.temp.containsKey((Object)RawMessagePartType.Text)) {
            return this;
        }
        String part = "";
        for (RawMessagePartType one : RawMessagePartType.values()) {
            String t = this.temp.get((Object)one);
            if (t == null) continue;
            if (!part.isEmpty()) {
                part = part + ",";
            }
            part = part + t;
        }
        part = "{" + part + "}";
        this.temp.clear();
        this.parts.add(part);
        return this;
    }

    private String escape(String s, boolean escapeNewLn) {
        if (s == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        s = s.replace("\\n", newLine);
        s = s.replace("\n", newLine);
        RawMessage.escape(s, sb);
        return sb.toString().replace(newLine, escapeNewLn ? "\\\\n" : "\\n");
    }

    private static void escape(String s, StringBuffer sb) {
        block9: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\"': {
                    sb.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '/': {
                    sb.append("\\/");
                    continue block9;
                }
                default: {
                    if (ch >= '\u0000' && ch <= '\u001f' || ch >= '\u007f' && ch <= '\u009f' || ch >= '\u2000' && ch <= '\u20ff') {
                        String ss = Integer.toHexString(ch);
                        sb.append("\\u");
                        for (int k = 0; k < 4 - ss.length(); ++k) {
                            sb.append('0');
                        }
                        sb.append(ss.toUpperCase());
                        continue block9;
                    }
                    sb.append(ch);
                }
            }
        }
    }

    public List<String> softCombine() {
        ArrayList<String> ls = new ArrayList<String>();
        String f = "";
        for (String part : this.parts) {
            if (f.isEmpty()) {
                f = "[\"\",";
            } else {
                if (f.length() > 30000) {
                    ls.add(f + "]");
                    f = "[\"\"," + part;
                    continue;
                }
                f = f + ",";
            }
            f = f + part;
        }
        if (!f.isEmpty()) {
            f = f + "]";
        }
        ls.add(f);
        return ls;
    }

    private RawMessage combine() {
        String f = "";
        for (String part : this.parts) {
            f = f.isEmpty() ? "[\"\"," : f + ",";
            f = f + part;
        }
        if (!f.isEmpty()) {
            f = f + "]";
        }
        if (f.isEmpty()) {
            f = "{\"text\":\" \"}";
        }
        this.combined = f;
        return this;
    }

    public RawMessage combineClean() {
        String f = "";
        for (String part : this.onlyText) {
            f = f + part.replace("\\\"", "\"");
        }
        this.combinedClean = f;
        return this;
    }

    public RawMessage show(Set<Player> player) {
        return this.show(player, true);
    }

    public RawMessage show(Set<Player> players, boolean softCombined) {
        if (players == null) {
            return this;
        }
        if (this.combined.isEmpty()) {
            this.build();
            this.combine();
        }
        if (players.isEmpty()) {
            return this;
        }
        if (softCombined) {
            for (String one : this.softCombine()) {
                if (one.isEmpty()) continue;
                RawMessageManager.send(players, RawMessage.truncate(one));
            }
        } else {
            RawMessageManager.send(players, RawMessage.truncate(this.combined));
        }
        return this;
    }

    private static String truncate(String value) {
        if (value.length() < 5000) {
            return value;
        }
        value = value.replace("\"bold\":false,", "");
        value = value.replace("\\\"bold\\\":false,", "");
        value = value.replace("\"italic\":false,", "");
        value = value.replace("\\\"italic\\\":false,", "");
        value = value.replace("\"obfuscated\":false,", "");
        value = value.replace("\\\"obfuscated\\\":false,", "");
        value = value.replace("\"strikethrough\":false,", "");
        value = value.replace("\\\"strikethrough\\\":false,", "");
        value = value.replace("\"underlined\":false,", "");
        value = value.replace("\\\"underlined\\\":false,", "");
        return value;
    }

    public RawMessage show(Player player) {
        return this.show(player, true);
    }

    public RawMessage show(Player player, boolean softCombined) {
        HashSet<Player> set = new HashSet<Player>();
        set.add(player);
        return this.show(set, softCombined);
    }

    public int getFinalLength() {
        String f = "";
        for (String part : this.parts) {
            f = f.isEmpty() ? "[\"\"," : f + ",";
            f = f + part;
        }
        for (String part : this.temp.values()) {
            f = f.isEmpty() ? "[\"\"," : f + ",";
            f = f + part;
        }
        if (!f.isEmpty()) {
            f = f + "]";
        }
        return f.length();
    }

    public RawMessage show(CMICommandSender sender) {
        if (sender.isPlayer()) {
            return this.show(sender.getPlayer(), true);
        }
        CMIMessages.sendMessage(sender.getSender(), this.combineClean().combinedClean);
        return this;
    }

    public int getFinalLenght() {
        String f = "";
        for (String part : this.parts) {
            f = f.isEmpty() ? "[\"\"," : f + ",";
            f = f + part;
        }
        if (!f.isEmpty()) {
            f = f + "]";
        }
        return f.length();
    }

    public RawMessage show(CommandSender sender) {
        if (this.combined.isEmpty()) {
            this.build();
            this.combine();
        }
        if (sender instanceof Player) {
            this.show((Player)sender);
        } else {
            CMIMessages.sendMessage(sender, this.combineClean().combinedClean);
        }
        return this;
    }

    public String getTextOnly() {
        return this.combineClean().combinedClean;
    }

    public String getRaw() {
        if (this.combined.isEmpty()) {
            this.build();
            this.combine();
        }
        return this.combined;
    }

    public void setCombined(String combined) {
        this.combined = combined;
    }

    public String getShortRaw() {
        this.build();
        String f = "";
        for (String part : this.parts) {
            if (!f.isEmpty()) {
                f = f + ",";
            }
            f = f + part;
        }
        f = RawMessage.truncate(f);
        return f;
    }

    public boolean isDontBreakLine() {
        return this.dontBreakLine;
    }

    public void setDontBreakLine(boolean dontBreakLine) {
        this.dontBreakLine = dontBreakLine;
    }

    public boolean isFormatFrozen() {
        return this.freezeFormat;
    }

    public void freezeFormat() {
        this.frozenFragment = new RawMessageFragment(this.fragment);
        this.freezeFormat = true;
    }

    public void unFreezeFormat() {
        this.fragment = new RawMessageFragment(this.frozenFragment);
        this.freezeFormat = false;
    }

    public static RawMessage translateRawMessage(CommandSender sender, String textLine) {
        return RawMessage.translateRawMessage(sender, textLine, false);
    }

    public static RawMessage translateTextOnlyRawMessage(String textLine) {
        RawMessage rm = new RawMessage();
        textLine = textLine.replace("\n", "\\n");
        ArrayList<String> split = new ArrayList<String>();
        if (textLine.contains("<Next>")) {
            split.addAll(Arrays.asList(textLine.split("<Next>")));
        } else {
            split.add(textLine);
        }
        ArrayList temp = new ArrayList(split);
        split.clear();
        for (String one : temp) {
            if (one.split("<T>").length > 2) {
                for (String spone : one.split("<T>")) {
                    if (spone == null || spone.isEmpty()) continue;
                    split.add("<T>" + spone);
                }
                continue;
            }
            split.add(one);
        }
        for (String message : split) {
            RawMessage.processText(rm, message);
            RawMessage.processHover(rm, message);
        }
        return rm;
    }

    private static void processText(RawMessage rm, String message) {
        if (!message.contains("<T>")) {
            return;
        }
        String text = message.replaceAll(".*\\<T>|\\</T>.*", "");
        Matcher match = patern.matcher(text);
        if (match.find()) {
            String url = match.group();
            String[] sp = text.split(url);
            if (sp.length > 0) {
                if (sp[0].endsWith("&")) {
                    rm.addText(CMIChatColor.translate(sp[0]) + url.substring(0, 1));
                    url = url.substring(1);
                } else {
                    String t = CMIChatColor.translate(sp[0]);
                    if (!t.equals(url)) {
                        rm.addText(t);
                    }
                }
            }
            rm.addText(url);
            rm.addUrl(url);
            if (sp.length > 1) {
                rm.addText(sp[1]);
            }
        } else {
            rm.addText(text);
        }
    }

    private static void processHover(RawMessage rm, String message) {
        if (!message.contains("<H>")) {
            return;
        }
        rm.addHover(message.replaceAll(".*\\<H>|\\</H>.*", ""));
    }

    public static RawMessage translateRawMessage(CommandSender sender, String textLine, boolean book) {
        RawMessage rm = new RawMessage();
        textLine = textLine.replace("\n", "\\n");
        ArrayList<String> split = new ArrayList<String>();
        if (textLine.contains("<Next>")) {
            split.addAll(Arrays.asList(textLine.split("<Next>")));
        } else {
            split.add(textLine);
        }
        ArrayList temp = new ArrayList(split);
        split.clear();
        for (String one : temp) {
            if (one.split("<T>").length > 2) {
                for (String spone : one.split("<T>")) {
                    if (spone == null || spone.isEmpty()) continue;
                    split.add("<T>" + spone);
                }
                continue;
            }
            split.add(one);
        }
        for (String message : split) {
            RawMessage.processText(rm, message);
            RawMessage.processHover(rm, message);
            if (message.contains("<ITEM>")) {
                String st = message.replaceAll(".*\\<ITEM>|\\</ITEM>.*", "");
                CMIItemStack stack = null;
                if (st.equalsIgnoreCase("%itemInHand%")) {
                    if (sender instanceof Player) {
                        stack = new CMIItemStack(CMILib.getInstance().getReflectionManager().getItemInMainHand((Player)sender));
                    }
                } else if (st.equalsIgnoreCase("%itemInOffHand%")) {
                    if (sender instanceof Player) {
                        stack = new CMIItemStack(CMILib.getInstance().getReflectionManager().getItemInOffHand((Player)sender));
                    }
                } else {
                    stack = CMILib.getInstance().getItemManager().getItem(st);
                }
                if (stack != null) {
                    rm.addItem(stack.getItemStack());
                }
            }
            String command = null;
            if (message.contains("<C>")) {
                command = message.replaceAll(".*\\<C>|\\</C>.*", "");
            }
            if (message.contains("<URL>")) {
                rm.addUrl(message.replaceAll(".*\\<URL>|\\</URL>.*", ""));
            }
            String consoleCommand = null;
            if (sender instanceof Player) {
                String id;
                Player player;
                if (message.contains("<CC>")) {
                    player = (Player)sender;
                    consoleCommand = message.replaceAll(".*\\<CC>|\\</CC>.*", "");
                    id = ShadowCommand.addShadowCmd(player, consoleCommand, false, ShadowCommandType.Console);
                    command = CommandsHandler.getLabel() + " shadowcmd " + id + " (" + consoleCommand + ")";
                    if (book) {
                        command = consoleCommand;
                    }
                }
                if (message.contains("<CCI>")) {
                    player = (Player)sender;
                    consoleCommand = message.replaceAll(".*\\<CCI>|\\</CCI>.*", "");
                    id = ShadowCommand.addShadowCmd(player, consoleCommand, true, ShadowCommandType.Console);
                    command = CommandsHandler.getLabel() + " shadowcmd " + id + " (" + consoleCommand + ")";
                    if (book) {
                        command = consoleCommand;
                    }
                }
            }
            if (message.contains("<SC>")) {
                rm.addSuggestion(message.replaceAll(".*\\<SC>|\\</SC>.*", ""));
            }
            if (message.contains("<SI>")) {
                rm.addInsertion(message.replaceAll(".*\\<SI>|\\</SI>.*", ""));
            }
            rm.addCommand(command);
        }
        return rm;
    }

    public LinkedHashMap<RawMessagePartType, String> getTemporyCache() {
        return this.temp;
    }
}

