/*
 * Decompiled with CFR 0.152.
 */
package net.Zrips.CMILib.PersistentData;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.Zrips.CMILib.CMILib;
import net.Zrips.CMILib.PersistentData.CMIBlockPersistentDataContainer;
import net.Zrips.CMILib.PersistentData.CMIEntityPersistentDataContainer;
import net.Zrips.CMILib.PersistentData.CMIItemPersistentDataContainer;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CMIPersistentDataContainer {
    PersistentDataContainer persistentDataContainer = null;
    private static Set<PersistentDataType<?, ?>> DATA_TYPES = new HashSet();

    public static CMIPersistentDataContainer get(ItemStack item) {
        return new CMIItemPersistentDataContainer(item);
    }

    public static CMIPersistentDataContainer get(Entity entity) {
        return new CMIEntityPersistentDataContainer(entity);
    }

    public static CMIPersistentDataContainer get(Block block) {
        return new CMIBlockPersistentDataContainer(block);
    }

    @Nullable
    public static CMIPersistentDataContainer get(Object object) {
        if (object instanceof ItemStack) {
            return new CMIItemPersistentDataContainer((ItemStack)object);
        }
        if (object instanceof Block) {
            return new CMIBlockPersistentDataContainer((Block)object);
        }
        if (object instanceof Entity) {
            return new CMIEntityPersistentDataContainer((Entity)object);
        }
        return null;
    }

    public void save() {
    }

    public PersistentDataType<?, ?> getType(String key) {
        return this.getType(CMIPersistentDataContainer.getKey(key));
    }

    public PersistentDataType<?, ?> getType(NamespacedKey key) {
        for (PersistentDataType<?, ?> dataType : DATA_TYPES) {
            if (!this.persistentDataContainer.has(key, dataType)) continue;
            return dataType;
        }
        return null;
    }

    private static NamespacedKey getKey(String key) {
        if (key.contains(":")) {
            return new NamespacedKey(key.split(":", 2)[0].toLowerCase(), key.split(":", 2)[1].replace(" ", "_"));
        }
        return new NamespacedKey((Plugin)CMILib.getInstance(), key.replace(" ", "_"));
    }

    public boolean hasKey(String key) {
        if (this.persistentDataContainer == null) {
            return false;
        }
        return this.persistentDataContainer.has(CMIPersistentDataContainer.getKey(key));
    }

    @NotNull
    public Set<NamespacedKey> getKeys() {
        if (this.persistentDataContainer == null) {
            return new HashSet<NamespacedKey>();
        }
        return this.persistentDataContainer.getKeys();
    }

    public CMIPersistentDataContainer set(String key, String value) {
        if (this.persistentDataContainer == null) {
            return this;
        }
        this.persistentDataContainer.set(CMIPersistentDataContainer.getKey(key), PersistentDataType.STRING, (Object)value);
        return this;
    }

    public CMIPersistentDataContainer remove(String key) {
        if (this.persistentDataContainer == null) {
            return this;
        }
        this.persistentDataContainer.remove(CMIPersistentDataContainer.getKey(key));
        return this;
    }

    @Nullable
    public String getString(String key) {
        return (String)this.persistentDataContainer.get(CMIPersistentDataContainer.getKey(key), PersistentDataType.STRING);
    }

    public CMIPersistentDataContainer set(String key, int value) {
        if (this.persistentDataContainer == null) {
            return this;
        }
        this.persistentDataContainer.set(CMIPersistentDataContainer.getKey(key), PersistentDataType.INTEGER, (Object)value);
        return this;
    }

    @Nullable
    public Integer getInt(String key) {
        if (this.persistentDataContainer == null) {
            return null;
        }
        return (Integer)this.persistentDataContainer.get(CMIPersistentDataContainer.getKey(key), PersistentDataType.INTEGER);
    }

    public CMIPersistentDataContainer set(String key, long value) {
        if (this.persistentDataContainer == null) {
            return this;
        }
        this.persistentDataContainer.set(CMIPersistentDataContainer.getKey(key), PersistentDataType.LONG, (Object)value);
        return this;
    }

    @Nullable
    public Long getLong(String key) {
        if (this.persistentDataContainer == null) {
            return null;
        }
        return (Long)this.persistentDataContainer.get(CMIPersistentDataContainer.getKey(key), PersistentDataType.LONG);
    }

    public CMIPersistentDataContainer set(String key, long ... value) {
        if (this.persistentDataContainer == null) {
            return this;
        }
        this.persistentDataContainer.set(CMIPersistentDataContainer.getKey(key), PersistentDataType.LONG_ARRAY, (Object)value);
        return this;
    }

    public long @Nullable [] getLongArray(String key) {
        if (this.persistentDataContainer == null) {
            return null;
        }
        return (long[])this.persistentDataContainer.get(CMIPersistentDataContainer.getKey(key), PersistentDataType.LONG_ARRAY);
    }

    public CMIPersistentDataContainer set(String key, boolean value) {
        if (this.persistentDataContainer == null) {
            return this;
        }
        this.persistentDataContainer.set(CMIPersistentDataContainer.getKey(key), PersistentDataType.BOOLEAN, (Object)value);
        return this;
    }

    @Nullable
    public Boolean getBoolean(String key) {
        if (this.persistentDataContainer == null) {
            return null;
        }
        return (Boolean)this.persistentDataContainer.get(CMIPersistentDataContainer.getKey(key), PersistentDataType.BOOLEAN);
    }

    public CMIPersistentDataContainer set(String key, float value) {
        if (this.persistentDataContainer == null) {
            return this;
        }
        this.persistentDataContainer.set(CMIPersistentDataContainer.getKey(key), PersistentDataType.FLOAT, (Object)Float.valueOf(value));
        return this;
    }

    @Nullable
    public Float getFloat(String key) {
        if (this.persistentDataContainer == null) {
            return null;
        }
        return (Float)this.persistentDataContainer.get(CMIPersistentDataContainer.getKey(key), PersistentDataType.FLOAT);
    }

    public CMIPersistentDataContainer set(String key, short value) {
        if (this.persistentDataContainer == null) {
            return this;
        }
        this.persistentDataContainer.set(CMIPersistentDataContainer.getKey(key), PersistentDataType.SHORT, (Object)value);
        return this;
    }

    @Nullable
    public Short getShort(String key) {
        if (this.persistentDataContainer == null) {
            return null;
        }
        return (Short)this.persistentDataContainer.get(CMIPersistentDataContainer.getKey(key), PersistentDataType.SHORT);
    }

    public CMIPersistentDataContainer set(String key, double value) {
        if (this.persistentDataContainer == null) {
            return this;
        }
        this.persistentDataContainer.set(CMIPersistentDataContainer.getKey(key), PersistentDataType.DOUBLE, (Object)value);
        return this;
    }

    @Nullable
    public Double getDouble(String key) {
        if (this.persistentDataContainer == null) {
            return null;
        }
        return (Double)this.persistentDataContainer.get(CMIPersistentDataContainer.getKey(key), PersistentDataType.DOUBLE);
    }

    public CMIPersistentDataContainer set(String key, byte ... value) {
        if (this.persistentDataContainer == null) {
            return this;
        }
        this.persistentDataContainer.set(CMIPersistentDataContainer.getKey(key), PersistentDataType.BYTE_ARRAY, (Object)value);
        return this;
    }

    public byte @Nullable [] getByteArray(String key) {
        if (this.persistentDataContainer == null) {
            return null;
        }
        return (byte[])this.persistentDataContainer.get(CMIPersistentDataContainer.getKey(key), PersistentDataType.BYTE_ARRAY);
    }

    public CMIPersistentDataContainer set(String key, int ... value) {
        if (this.persistentDataContainer == null) {
            return this;
        }
        this.persistentDataContainer.set(CMIPersistentDataContainer.getKey(key), PersistentDataType.INTEGER_ARRAY, (Object)value);
        return this;
    }

    public int @Nullable [] getIntArray(String key) {
        if (this.persistentDataContainer == null) {
            return null;
        }
        try {
            return (int[])this.persistentDataContainer.get(CMIPersistentDataContainer.getKey(key), PersistentDataType.INTEGER_ARRAY);
        }
        catch (Exception exception) {
            try {
                return ((List)this.persistentDataContainer.get(CMIPersistentDataContainer.getKey(key), (PersistentDataType)PersistentDataType.LIST.integers())).stream().mapToInt(i -> i).toArray();
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    public CMIPersistentDataContainer set(String key, byte value) {
        if (this.persistentDataContainer == null) {
            return this;
        }
        this.persistentDataContainer.set(CMIPersistentDataContainer.getKey(key), PersistentDataType.BYTE, (Object)value);
        return this;
    }

    @Nullable
    public Byte getByte(String key) {
        if (this.persistentDataContainer == null) {
            return null;
        }
        return (Byte)this.persistentDataContainer.get(CMIPersistentDataContainer.getKey(key), PersistentDataType.BYTE);
    }

    public CMIPersistentDataContainer set(String key, List<String> value) {
        if (this.persistentDataContainer == null) {
            return this;
        }
        this.persistentDataContainer.set(CMIPersistentDataContainer.getKey(key), (PersistentDataType)PersistentDataType.LIST.strings(), value);
        return this;
    }

    public CMIPersistentDataContainer setIntList(String key, List<Integer> value) {
        if (this.persistentDataContainer == null) {
            return this;
        }
        if (Version.isCurrentEqualOrHigher(Version.v1_20_R4)) {
            this.persistentDataContainer.set(CMIPersistentDataContainer.getKey(key), (PersistentDataType)PersistentDataType.LIST.integers(), value);
            return this;
        }
        int[] array = new int[value.size()];
        for (int i = 0; i < value.size(); ++i) {
            array[i] = value.get(i);
        }
        this.persistentDataContainer.set(CMIPersistentDataContainer.getKey(key), PersistentDataType.INTEGER_ARRAY, (Object)array);
        return this;
    }

    @Nullable
    public List<String> getListString(String key) {
        if (this.persistentDataContainer == null) {
            return null;
        }
        return (List)this.persistentDataContainer.get(CMIPersistentDataContainer.getKey(key), (PersistentDataType)PersistentDataType.LIST.strings());
    }

    @Nullable
    public List<Integer> getListInt(String key) {
        if (this.persistentDataContainer == null) {
            return null;
        }
        try {
            if (Version.isCurrentEqualOrHigher(Version.v1_20_R4)) {
                return (List)this.persistentDataContainer.get(CMIPersistentDataContainer.getKey(key), (PersistentDataType)PersistentDataType.LIST.integers());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        int @Nullable [] array = this.getIntArray(key);
        if (array == null) {
            return null;
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i : array) {
            list.add(i);
        }
        return list;
    }

    @Nullable
    public Object get(String key, PersistentDataType<?, ?> type) {
        return this.get(CMIPersistentDataContainer.getKey(key), type);
    }

    @Nullable
    public Object get(NamespacedKey key, PersistentDataType<?, ?> type) {
        if (this.persistentDataContainer == null) {
            return null;
        }
        return this.persistentDataContainer.get(key, type);
    }

    private PersistentDataContainer getSubContainer(String key) {
        PersistentDataContainer container = this.getSubContainerIfExists(key);
        if (container == null) {
            container = this.persistentDataContainer.getAdapterContext().newPersistentDataContainer();
        }
        return container;
    }

    private PersistentDataContainer getSubContainerIfExists(String key) {
        if (this.persistentDataContainer == null) {
            return null;
        }
        if (!this.persistentDataContainer.has(CMIPersistentDataContainer.getKey(key), PersistentDataType.TAG_CONTAINER)) {
            return null;
        }
        return (PersistentDataContainer)this.persistentDataContainer.get(CMIPersistentDataContainer.getKey(key), PersistentDataType.TAG_CONTAINER);
    }

    public CMIPersistentDataContainer set(String key, String subKey, List<String> value) {
        PersistentDataContainer container = this.getSubContainer(key);
        if (container == null) {
            return this;
        }
        container.set(CMIPersistentDataContainer.getKey(subKey), (PersistentDataType)PersistentDataType.LIST.strings(), value);
        this.persistentDataContainer.set(CMIPersistentDataContainer.getKey(key), PersistentDataType.TAG_CONTAINER, (Object)container);
        return this;
    }

    public CMIPersistentDataContainer set(String key, String subKey, long value) {
        PersistentDataContainer container = this.getSubContainer(key);
        if (container == null) {
            return this;
        }
        container.set(CMIPersistentDataContainer.getKey(subKey), PersistentDataType.LONG, (Object)value);
        this.persistentDataContainer.set(CMIPersistentDataContainer.getKey(key), PersistentDataType.TAG_CONTAINER, (Object)container);
        return this;
    }

    public CMIPersistentDataContainer set(String key, String subKey, boolean value) {
        PersistentDataContainer container = this.getSubContainer(key);
        if (container == null) {
            return this;
        }
        if (Version.isCurrentEqualOrHigher(Version.v1_20_R1)) {
            container.set(CMIPersistentDataContainer.getKey(subKey), PersistentDataType.BOOLEAN, (Object)value);
            this.persistentDataContainer.set(CMIPersistentDataContainer.getKey(key), PersistentDataType.TAG_CONTAINER, (Object)container);
            return this;
        }
        container.set(CMIPersistentDataContainer.getKey(subKey), PersistentDataType.BYTE, (Object)((byte)(value ? 1 : 0)));
        this.persistentDataContainer.set(CMIPersistentDataContainer.getKey(key), PersistentDataType.TAG_CONTAINER, (Object)container);
        return this;
    }

    public CMIPersistentDataContainer set(String key, String subKey, int value) {
        PersistentDataContainer container = this.getSubContainer(key);
        if (container == null) {
            return this;
        }
        container.set(CMIPersistentDataContainer.getKey(subKey), PersistentDataType.INTEGER, (Object)value);
        this.persistentDataContainer.set(CMIPersistentDataContainer.getKey(key), PersistentDataType.TAG_CONTAINER, (Object)container);
        return this;
    }

    public CMIPersistentDataContainer setIntList(String key, String subKey, List<Integer> value) {
        PersistentDataContainer container = this.getSubContainer(key);
        if (container == null) {
            return this;
        }
        container.set(CMIPersistentDataContainer.getKey(subKey), (PersistentDataType)PersistentDataType.LIST.integers(), value);
        this.persistentDataContainer.set(CMIPersistentDataContainer.getKey(key), PersistentDataType.TAG_CONTAINER, (Object)container);
        return this;
    }

    public CMIPersistentDataContainer remove(String key, String subKey) {
        PersistentDataContainer container = this.getSubContainerIfExists(key);
        if (container == null) {
            return this;
        }
        container.remove(CMIPersistentDataContainer.getKey(subKey));
        this.persistentDataContainer.set(CMIPersistentDataContainer.getKey(key), PersistentDataType.TAG_CONTAINER, (Object)container);
        return this;
    }

    @Nullable
    public List<String> getListString(String key, String subKey) {
        if (this.persistentDataContainer == null) {
            return null;
        }
        @Nullable PersistentDataContainer container = this.getSubContainerIfExists(key);
        if (container == null) {
            return null;
        }
        return (List)container.get(CMIPersistentDataContainer.getKey(subKey), (PersistentDataType)PersistentDataType.LIST.strings());
    }

    @Nullable
    public Boolean getBoolean(String key, String subKey) {
        if (this.persistentDataContainer == null) {
            return null;
        }
        @Nullable PersistentDataContainer container = this.getSubContainerIfExists(key);
        if (container == null) {
            return null;
        }
        if (Version.isCurrentEqualOrHigher(Version.v1_20_R1)) {
            return (Boolean)container.get(CMIPersistentDataContainer.getKey(subKey), PersistentDataType.BOOLEAN);
        }
        @Nullable Byte b = (Byte)container.get(CMIPersistentDataContainer.getKey(subKey), PersistentDataType.BYTE);
        return b == null ? null : Boolean.valueOf(b == 1);
    }

    @Nullable
    public Long getLong(String key, String subKey) {
        if (this.persistentDataContainer == null) {
            return null;
        }
        @Nullable PersistentDataContainer container = this.getSubContainerIfExists(key);
        if (container == null) {
            return null;
        }
        return (Long)container.get(CMIPersistentDataContainer.getKey(subKey), PersistentDataType.LONG);
    }

    @Nullable
    public Integer getInt(String key, String subKey) {
        if (this.persistentDataContainer == null) {
            return null;
        }
        @Nullable PersistentDataContainer container = this.getSubContainerIfExists(key);
        if (container == null) {
            return null;
        }
        return (Integer)container.get(CMIPersistentDataContainer.getKey(subKey), PersistentDataType.INTEGER);
    }

    @Nullable
    public Object get(String key) {
        return this.get(CMIPersistentDataContainer.getKey(key));
    }

    @Nullable
    public Object get(NamespacedKey key) {
        PersistentDataType<?, ?> type = this.getType(key);
        if (type == null || this.persistentDataContainer == null) {
            return null;
        }
        return this.persistentDataContainer.get(key, type);
    }

    static {
        DATA_TYPES.add(PersistentDataType.BYTE);
        DATA_TYPES.add(PersistentDataType.SHORT);
        DATA_TYPES.add(PersistentDataType.INTEGER);
        DATA_TYPES.add(PersistentDataType.LONG);
        DATA_TYPES.add(PersistentDataType.FLOAT);
        DATA_TYPES.add(PersistentDataType.DOUBLE);
        DATA_TYPES.add(PersistentDataType.STRING);
        DATA_TYPES.add(PersistentDataType.BYTE_ARRAY);
        DATA_TYPES.add(PersistentDataType.INTEGER_ARRAY);
        DATA_TYPES.add(PersistentDataType.LONG_ARRAY);
        try {
            DATA_TYPES.add(PersistentDataType.BOOLEAN);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            DATA_TYPES.add(PersistentDataType.TAG_CONTAINER);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            DATA_TYPES.add((PersistentDataType<?, ?>)PersistentDataType.LIST.bytes());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            DATA_TYPES.add((PersistentDataType<?, ?>)PersistentDataType.LIST.booleans());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            DATA_TYPES.add((PersistentDataType<?, ?>)PersistentDataType.LIST.doubles());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            DATA_TYPES.add((PersistentDataType<?, ?>)PersistentDataType.LIST.floats());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            DATA_TYPES.add((PersistentDataType<?, ?>)PersistentDataType.LIST.integers());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            DATA_TYPES.add((PersistentDataType<?, ?>)PersistentDataType.LIST.strings());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            DATA_TYPES.add((PersistentDataType<?, ?>)PersistentDataType.LIST.shorts());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

