/*
 * Decompiled with CFR 0.152.
 */
package net.Zrips.CMILib.NBT;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.Zrips.CMILib.CMILib;
import net.Zrips.CMILib.Entities.CMIEntityType;
import net.Zrips.CMILib.Items.CMIMaterial;
import net.Zrips.CMILib.PersistentData.CMIPersistentDataContainer;
import net.Zrips.CMILib.Version.Version;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.server.dedicated.DedicatedServer;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class CMINBT {
    private static Class<?> NBTBase;
    private static Class<?> NBTTagString;
    private static Class<?> nbtTagCompound;
    private static Class<?> nbtTagList;
    private static Method met_getInt;
    private static Method met_getByte;
    private static Method met_getLong;
    private static Method met_getBoolean;
    private static Method met_getFloat;
    private static Method met_getDouble;
    private static Method met_getByteArray;
    private static Method met_getIntArray;
    private static Method met_getLongArray;
    private static Method met_getList;
    private static Method met_get;
    private static Method met_remove;
    private static Method met_getShort;
    private static Method met_getString;
    private static Method met_getCompound;
    private static Method met_toString;
    private static Method met_setBoolean;
    private static Method met_setDouble;
    private static Method met_setByte;
    private static Method met_setShort;
    private static Method met_setString;
    private static Method met_setInt;
    private static Method met_setLong;
    private static Method met_setIntArray;
    private static Method met_setByteArray;
    private static Method met_setLongArray;
    private static Method met_set;
    private static Method met_add;
    private static Method met_tagStringValueOf;
    private static Class<?> CraftItemStack;
    private static Class<?> IStack;
    private static Class<?> CraftEntity;
    private static Class<?> MojangsonParser;
    private static String getTagName;
    private static String setTagName;
    private static String getStringName;
    private static String getIntName;
    private static String getByteName;
    private static String getLongName;
    private static String getBooleanName;
    private static String getFloatName;
    private static String getShortName;
    private static String getDoubleName;
    private static String getListName;
    private static String getByteArrayName;
    private static String getIntArrayName;
    private static String getLongArrayName;
    private static String listGetName;
    private static String setBooleanName;
    private static String setByteName;
    private static String setShortName;
    private static String setStringName;
    private static String setIntName;
    private static String setLongName;
    private static String setDoubleName;
    private static String setIntArrayName;
    private static String setByteArrayName;
    private static String setLongArrayName;
    private static String setName;
    private static String getName;
    private static String removeName;
    private static String getCompoundName;
    private static String asStringName;
    private static String saveName;
    private static String parseName;
    private static String itemSaveName;
    private static String hasKeyName;
    private static String getKeysName;
    private static String getTypeIdName;
    private static String listAddMethod;
    Object tag;
    Object object;
    private nmbtType type;
    private static Method setTagMethod;
    private static Object registry;
    private static Method nbtMethod;
    private static Method asNMSCopy;
    private static Method asBukkitCopy;
    private static Method EntityHandle;
    private static Method saveOptionalMethod;

    public CMINBT(Object nbtTagCompound) {
        this.tag = nbtTagCompound;
        this.type = nmbtType.custom;
    }

    public CMINBT(ItemStack item) {
        this.object = item;
        this.tag = CMINBT.getNbt(item);
        this.type = nmbtType.item;
    }

    public CMINBT(Block block) {
        this.tag = CMINBT.getNbt(block);
        this.object = block;
        this.type = nmbtType.block;
    }

    public CMINBT(Entity entity) {
        this.tag = CMINBT.getNbt(entity);
        this.object = entity;
        this.type = nmbtType.entity;
    }

    private Object get(String path, Method getMethod) {
        if (this.tag == null) {
            return null;
        }
        try {
            if (!path.contains(".")) {
                return getMethod.invoke(this.tag, path);
            }
            Object t = this.updateLegacyTag(this.tag);
            ArrayList<String> keys = new ArrayList<String>();
            keys.addAll(Arrays.asList(path.split("\\.")));
            try {
                Object nbtbase = met_get.invoke(t, keys.get(0));
                for (int i = 1; i < keys.size(); ++i) {
                    if (i + 1 >= keys.size()) {
                        if (nbtbase != null) {
                            return getMethod.invoke(nbtbase, keys.get(i));
                        }
                        break;
                    }
                    nbtbase = met_get.invoke(nbtbase, keys.get(i));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return getMethod.invoke(t, path);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Integer getInt(String path) {
        Integer v;
        CMIPersistentDataContainer persistentDataContainer;
        if (!this.hasNBT(path)) {
            return null;
        }
        if (Version.isCurrentEqualOrHigher(Version.v1_20_R4) && (persistentDataContainer = CMIPersistentDataContainer.get(this.object)) != null && (v = persistentDataContainer.getInt(path)) != null) {
            return v;
        }
        try {
            Object res = this.get(path, met_getInt);
            return res == null ? null : (Integer)res;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Byte getByte(String path) {
        Byte v;
        CMIPersistentDataContainer persistentDataContainer;
        if (!this.hasNBT(path)) {
            return null;
        }
        if (Version.isCurrentEqualOrHigher(Version.v1_20_R4) && (persistentDataContainer = CMIPersistentDataContainer.get(this.object)) != null && (v = CMIPersistentDataContainer.get(this.object).getByte(path)) != null) {
            return v;
        }
        try {
            Object res = this.get(path, met_getByte);
            return res == null ? null : (Byte)res;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Long getLong(String path) {
        Long v;
        CMIPersistentDataContainer persistentDataContainer;
        if (!this.hasNBT(path)) {
            return null;
        }
        if (Version.isCurrentEqualOrHigher(Version.v1_20_R4) && (persistentDataContainer = CMIPersistentDataContainer.get(this.object)) != null && (v = persistentDataContainer.getLong(path)) != null) {
            return v;
        }
        try {
            Object res = this.get(path, met_getLong);
            return res == null ? null : (Long)res;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Boolean getBoolean(String path) {
        Boolean v;
        CMIPersistentDataContainer persistentDataContainer;
        if (!this.hasNBT(path)) {
            return null;
        }
        if (Version.isCurrentEqualOrHigher(Version.v1_20_R4) && (persistentDataContainer = CMIPersistentDataContainer.get(this.object)) != null && (v = persistentDataContainer.getBoolean(path)) != null) {
            return v;
        }
        try {
            Object res = this.get(path, met_getBoolean);
            return res == null ? null : (Boolean)res;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public float getFloat(String path) {
        Float v;
        CMIPersistentDataContainer persistentDataContainer;
        if (!this.hasNBT(path)) {
            return 0.0f;
        }
        if (Version.isCurrentEqualOrHigher(Version.v1_20_R4) && (persistentDataContainer = CMIPersistentDataContainer.get(this.object)) != null && (v = persistentDataContainer.getFloat(path)) != null) {
            return v.floatValue();
        }
        try {
            Object res = this.get(path, met_getFloat);
            return res == null ? 0.0f : ((Float)res).floatValue();
        }
        catch (Exception exception) {
            return 0.0f;
        }
    }

    public Short getShort(String path) {
        Short v;
        CMIPersistentDataContainer persistentDataContainer;
        if (Version.isCurrentEqualOrHigher(Version.v1_20_R4) && (persistentDataContainer = CMIPersistentDataContainer.get(this.object)) != null && (v = persistentDataContainer.getShort(path)) != null) {
            return v;
        }
        if (this.tag == null) {
            return null;
        }
        try {
            Object res = this.get(path, met_getShort);
            return res == null ? null : (Short)res;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public double getDouble(String path) {
        Double v;
        CMIPersistentDataContainer persistentDataContainer;
        if (!this.hasNBT(path)) {
            return 0.0;
        }
        if (Version.isCurrentEqualOrHigher(Version.v1_20_R4) && (persistentDataContainer = CMIPersistentDataContainer.get(this.object)) != null && (v = persistentDataContainer.getDouble(path)) != null) {
            return v;
        }
        try {
            Object res = this.get(path, met_getDouble);
            return res == null ? 0.0 : (Double)res;
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    public byte[] getByteArray(String path) {
        byte[] v;
        CMIPersistentDataContainer persistentDataContainer;
        if (!this.hasNBT(path)) {
            return new byte[0];
        }
        if (Version.isCurrentEqualOrHigher(Version.v1_20_R4) && (persistentDataContainer = CMIPersistentDataContainer.get(this.object)) != null && (v = persistentDataContainer.getByteArray(path)) != null) {
            return v;
        }
        try {
            Object res = this.get(path, met_getByteArray);
            return res == null ? new byte[]{} : (byte[])res;
        }
        catch (Exception exception) {
            return new byte[0];
        }
    }

    public int[] getIntArray(String path) {
        if (!this.hasNBT(path)) {
            return new int[0];
        }
        try {
            Object res = this.get(path, met_getIntArray);
            return res == null ? new int[]{} : (int[])res;
        }
        catch (Exception exception) {
            return new int[0];
        }
    }

    public long[] getLongArray(String path) {
        if (!this.hasNBT(path)) {
            return new long[0];
        }
        if (!Version.isCurrentEqualOrHigher(Version.v1_13_R1)) {
            return new long[0];
        }
        try {
            Object res = this.get(path, met_getLongArray);
            return res == null ? new long[]{} : (long[])res;
        }
        catch (Exception exception) {
            return new long[0];
        }
    }

    public String getString(String path) {
        String v;
        CMIPersistentDataContainer persistentDataContainer;
        if (!this.hasNBT(path)) {
            return null;
        }
        if (Version.isCurrentEqualOrHigher(Version.v1_20_R4) && (persistentDataContainer = CMIPersistentDataContainer.get(this.object)) != null && (v = persistentDataContainer.getString(path)) != null) {
            return v;
        }
        if (this.tag == null) {
            return null;
        }
        try {
            Object res = this.get(path, met_getString);
            return res == null ? null : (String)res;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public List<String> getList(String path) {
        return this.getList(path, -1);
    }

    private Object updateLegacyTag(Object t) {
        if (this.getType().equals((Object)nmbtType.item) && Version.isCurrentEqualOrHigher(Version.v1_20_R4)) {
            t = new CMINBT(new CMINBT(t).get("components")).get("minecraft:custom_data");
        }
        return t;
    }

    public List<String> getList(String path, int type) {
        List<String> v;
        CMIPersistentDataContainer persistentDataContainer;
        if (!this.hasNBT(path)) {
            return null;
        }
        if (Version.isCurrentEqualOrHigher(Version.v1_20_R4) && (persistentDataContainer = CMIPersistentDataContainer.get(this.object)) != null && (v = persistentDataContainer.getListString(path)) != null) {
            return new ArrayList<String>(v);
        }
        if (this.tag == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        try {
            Object t = this.updateLegacyTag(this.tag);
            if (t != null && path.contains(".")) {
                ArrayList<String> keys = new ArrayList<String>();
                keys.addAll(Arrays.asList(path.split("\\.")));
                try {
                    Object nbtbase = met_get.invoke(t, keys.get(0));
                    for (int i = 1; i < keys.size(); ++i) {
                        if (i + 1 >= keys.size()) {
                            t = nbtbase;
                            path = (String)keys.get(i);
                            break;
                        }
                        nbtbase = met_get.invoke(nbtbase, keys.get(i));
                    }
                }
                catch (Throwable nbtbase) {
                    // empty catch block
                }
            }
            if (t == null) {
                return list;
            }
            Object ls = met_getList.invoke(t, path, type < 0 ? 8 : type);
            int size = (Integer)ls.getClass().getMethod("size", new Class[0]).invoke(ls, new Object[0]);
            if (size == 0 && type < 0) {
                ls = met_getList.invoke(t, path, type < 0 ? 10 : 8);
                size = (Integer)ls.getClass().getMethod("size", new Class[0]).invoke(ls, new Object[0]);
            }
            Method method = ls.getClass().getMethod(listGetName, Integer.TYPE);
            if (Version.isCurrentEqualOrLower(Version.v1_12_R1)) {
                method = ls.getClass().getMethod("getString", Integer.TYPE);
                for (int i = 0; i < size; ++i) {
                    Object ress = method.invoke(ls, i);
                    String line = (String)ress;
                    list.add(line);
                }
            } else {
                for (int i = 0; i < size; ++i) {
                    if (Version.isCurrentEqualOrHigher(Version.v1_20_R2)) {
                        list.add(method.invoke(ls, i).toString());
                        continue;
                    }
                    list.add(met_toString.invoke(method.invoke(ls, i), new Object[0]).toString());
                }
            }
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Object getObjectList(String path, int type) {
        if (this.tag == null) {
            return null;
        }
        if (!this.hasNBT(path)) {
            return null;
        }
        try {
            Object t = this.updateLegacyTag(this.tag);
            if (t != null && path.contains(".")) {
                ArrayList<String> keys = new ArrayList<String>();
                keys.addAll(Arrays.asList(path.split("\\.")));
                try {
                    Object nbtbase = met_get.invoke(t, keys.get(0));
                    for (int i = 1; i < keys.size(); ++i) {
                        if (i + 1 >= keys.size()) {
                            t = nbtbase;
                            path = (String)keys.get(i);
                            break;
                        }
                        nbtbase = met_get.invoke(nbtbase, keys.get(i));
                    }
                }
                catch (Throwable nbtbase) {
                    // empty catch block
                }
            }
            if (t == null) {
                return null;
            }
            Object ls = met_getList.invoke(t, path, type < 0 ? 8 : type);
            int size = (Integer)ls.getClass().getMethod("size", new Class[0]).invoke(ls, new Object[0]);
            if (size == 0 && type < 0) {
                ls = met_getList.invoke(t, path, 10);
                size = (Integer)ls.getClass().getMethod("size", new Class[0]).invoke(ls, new Object[0]);
            }
            return ls;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Object setBoolean(String path, Boolean value) {
        if (Version.isCurrentEqualOrHigher(Version.v1_20_R4)) {
            if (value == null) {
                CMIPersistentDataContainer.get(this.object).remove(path).save();
            } else {
                CMIPersistentDataContainer.get(this.object).set(path, value).save();
            }
            return this.object;
        }
        switch (this.type.ordinal()) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 0: {
                try {
                    if (value == null) {
                        met_remove.invoke(this.tag, path);
                    } else {
                        met_setBoolean.invoke(this.tag, path, value);
                    }
                    return CMINBT.setTag((ItemStack)this.object, this.tag);
                }
                catch (Throwable e) {
                    if (Version.isCurrentEqualOrHigher(Version.v1_7_R4)) {
                        e.printStackTrace();
                    }
                    return this.object;
                }
            }
        }
        return this.object;
    }

    public Object setByte(String path, Byte value) {
        if (Version.isCurrentEqualOrHigher(Version.v1_20_R4)) {
            if (value == null) {
                CMIPersistentDataContainer.get(this.object).remove(path).save();
            } else {
                CMIPersistentDataContainer.get(this.object).set(path, (byte)value).save();
            }
            return this.object;
        }
        switch (this.type.ordinal()) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 0: {
                try {
                    if (value == null) {
                        met_remove.invoke(this.tag, path);
                    } else {
                        met_setByte.invoke(this.tag, path, value);
                    }
                    return CMINBT.setTag((ItemStack)this.object, this.tag);
                }
                catch (Throwable e) {
                    if (Version.isCurrentEqualOrHigher(Version.v1_7_R4)) {
                        e.printStackTrace();
                    }
                    return this.object;
                }
            }
        }
        return this.object;
    }

    public Object setShort(String path, Short value) {
        if (Version.isCurrentEqualOrHigher(Version.v1_20_R4)) {
            if (value == null) {
                CMIPersistentDataContainer.get(this.object).remove(path).save();
            } else {
                CMIPersistentDataContainer.get(this.object).set(path, value).save();
            }
            return this.object;
        }
        switch (this.type.ordinal()) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 0: {
                try {
                    if (value == null) {
                        met_remove.invoke(this.tag, path);
                    } else {
                        met_setShort.invoke(this.tag, path, value);
                    }
                    return CMINBT.setTag((ItemStack)this.object, this.tag);
                }
                catch (Throwable e) {
                    if (Version.isCurrentEqualOrHigher(Version.v1_7_R4)) {
                        e.printStackTrace();
                    }
                    return this.object;
                }
            }
        }
        return this.object;
    }

    public Object setStringList(String path, List<String> value) {
        if (Version.isCurrentEqualOrHigher(Version.v1_20_R4)) {
            if (value == null) {
                CMIPersistentDataContainer.get(this.object).remove(path).save();
            } else {
                CMIPersistentDataContainer.get(this.object).set(path, value).save();
            }
            return this.object;
        }
        try {
            int i;
            Object nbtbase = this.tag;
            String realPath = path;
            if (this.tag != null && path.contains(".")) {
                ArrayList<String> keys = new ArrayList<String>();
                keys.addAll(Arrays.asList(path.split("\\.")));
                try {
                    nbtbase = met_get.invoke(this.tag, keys.get(0));
                    for (i = 1; i < keys.size(); ++i) {
                        if (i + 1 >= keys.size()) {
                            realPath = (String)keys.get(i);
                            break;
                        }
                        nbtbase = met_get.invoke(nbtbase, keys.get(i));
                    }
                }
                catch (Throwable i2) {
                    // empty catch block
                }
            }
            if (value == null) {
                met_remove.invoke(nbtbase, realPath);
            } else {
                Object tagList = nbtTagList.newInstance();
                for (i = 0; i < value.size(); ++i) {
                    try {
                        CMINBT.addToList(tagList, i, met_tagStringValueOf.invoke(null, value.get(i)));
                        continue;
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                        e.printStackTrace();
                    }
                }
                met_set.invoke(nbtbase, realPath, tagList);
            }
        }
        catch (Throwable e) {
            return this.object;
        }
        switch (this.type.ordinal()) {
            case 3: {
                return this.tag;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 0: {
                return CMINBT.setTag((ItemStack)this.object, this.tag);
            }
        }
        return this.object;
    }

    public Object setString(String path, String value) {
        if (Version.isCurrentEqualOrHigher(Version.v1_20_R4)) {
            if (value == null) {
                CMIPersistentDataContainer.get(this.object).remove(path).save();
            } else {
                CMIPersistentDataContainer.get(this.object).set(path, value).save();
            }
            return this.object;
        }
        try {
            Object nbtbase = this.tag;
            String realPath = path;
            if (this.tag != null && path.contains(".")) {
                ArrayList<String> keys = new ArrayList<String>();
                keys.addAll(Arrays.asList(path.split("\\.")));
                try {
                    nbtbase = met_get.invoke(this.tag, keys.get(0));
                    for (int i = 1; i < keys.size(); ++i) {
                        if (i + 1 >= keys.size()) {
                            realPath = (String)keys.get(i);
                            break;
                        }
                        nbtbase = met_get.invoke(nbtbase, keys.get(i));
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (value == null) {
                met_remove.invoke(nbtbase, realPath);
            } else {
                met_setString.invoke(nbtbase, realPath, value);
            }
        }
        catch (Throwable e) {
            return this.object;
        }
        switch (this.type.ordinal()) {
            case 3: {
                return this.tag;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 0: {
                return CMINBT.setTag((ItemStack)this.object, this.tag);
            }
        }
        return this.object;
    }

    public Object setInt(String path, Integer value) {
        if (Version.isCurrentEqualOrHigher(Version.v1_20_R4)) {
            if (value == null) {
                CMIPersistentDataContainer.get(this.object).remove(path).save();
            } else {
                CMIPersistentDataContainer.get(this.object).set(path, (int)value).save();
            }
            return this.object;
        }
        try {
            if (value == null) {
                met_remove.invoke(this.tag, path);
            } else {
                met_setInt.invoke(this.tag, path, value);
            }
        }
        catch (Throwable e) {
            if (Version.isCurrentEqualOrHigher(Version.v1_7_R4)) {
                e.printStackTrace();
            }
            return this.object;
        }
        switch (this.type.ordinal()) {
            case 3: {
                return this.tag;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 0: {
                return CMINBT.setTag((ItemStack)this.object, this.tag);
            }
        }
        return this.object;
    }

    public Object setIntArray(String path, int[] value) {
        if (Version.isCurrentEqualOrHigher(Version.v1_20_R4)) {
            if (value == null) {
                CMIPersistentDataContainer.get(this.object).remove(path).save();
            } else {
                CMIPersistentDataContainer.get(this.object).set(path, value).save();
            }
            return this.object;
        }
        try {
            if (value == null) {
                met_remove.invoke(this.tag, path);
            } else {
                met_setIntArray.invoke(this.tag, path, value);
            }
        }
        catch (Throwable e) {
            if (Version.isCurrentEqualOrHigher(Version.v1_7_R4)) {
                e.printStackTrace();
            }
            return this.object;
        }
        switch (this.type.ordinal()) {
            case 3: {
                return this.tag;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 0: {
                return CMINBT.setTag((ItemStack)this.object, this.tag);
            }
        }
        return this.object;
    }

    public Object setByteArray(String path, byte[] value) {
        if (Version.isCurrentEqualOrHigher(Version.v1_20_R4)) {
            if (value == null) {
                CMIPersistentDataContainer.get(this.object).remove(path).save();
            } else {
                CMIPersistentDataContainer.get(this.object).set(path, value).save();
            }
            return this.object;
        }
        try {
            if (value == null) {
                met_remove.invoke(this.tag, path);
            } else {
                met_setByteArray.invoke(this.tag, path, value);
            }
        }
        catch (Throwable e) {
            if (Version.isCurrentEqualOrHigher(Version.v1_7_R4)) {
                e.printStackTrace();
            }
            return this.object;
        }
        switch (this.type.ordinal()) {
            case 3: {
                return this.tag;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 0: {
                return CMINBT.setTag((ItemStack)this.object, this.tag);
            }
        }
        return this.object;
    }

    public Object setLongArray(String path, long[] value) {
        if (Version.isCurrentEqualOrHigher(Version.v1_20_R4)) {
            if (value == null) {
                CMIPersistentDataContainer.get(this.object).remove(path).save();
            } else {
                CMIPersistentDataContainer.get(this.object).set(path, value).save();
            }
            return this.object;
        }
        try {
            if (value == null) {
                met_remove.invoke(this.tag, path);
            } else {
                met_setLongArray.invoke(this.tag, path, value);
            }
        }
        catch (Throwable e) {
            if (Version.isCurrentEqualOrHigher(Version.v1_7_R4)) {
                e.printStackTrace();
            }
            return this.object;
        }
        switch (this.type.ordinal()) {
            case 3: {
                return this.tag;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 0: {
                return CMINBT.setTag((ItemStack)this.object, this.tag);
            }
        }
        return this.object;
    }

    public Object setLong(String path, Long value) {
        if (Version.isCurrentEqualOrHigher(Version.v1_20_R4)) {
            if (value == null) {
                CMIPersistentDataContainer.get(this.object).remove(path).save();
            } else {
                CMIPersistentDataContainer.get(this.object).set(path, (long)value).save();
            }
            return this.object;
        }
        switch (this.type.ordinal()) {
            case 3: {
                try {
                    if (value == null) {
                        met_remove.invoke(this.tag, path, value);
                    } else {
                        met_setLong.invoke(this.tag, path, value);
                    }
                    return this.tag;
                }
                catch (Throwable e) {
                    if (Version.isCurrentEqualOrHigher(Version.v1_7_R4)) {
                        e.printStackTrace();
                    }
                    return this.object;
                }
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 0: {
                try {
                    if (value == null) {
                        met_remove.invoke(this.tag, path, value);
                    } else {
                        met_setLong.invoke(this.tag, path, value);
                    }
                    return CMINBT.setTag((ItemStack)this.object, this.tag);
                }
                catch (Throwable e) {
                    if (Version.isCurrentEqualOrHigher(Version.v1_7_R4)) {
                        e.printStackTrace();
                    }
                    return this.object;
                }
            }
        }
        return this.object;
    }

    public Object setDouble(String path, Double value) {
        if (Version.isCurrentEqualOrHigher(Version.v1_20_R4)) {
            if (value == null) {
                CMIPersistentDataContainer.get(this.object).remove(path).save();
            } else {
                CMIPersistentDataContainer.get(this.object).set(path, value).save();
            }
            return this.object;
        }
        try {
            if (value == null) {
                met_remove.invoke(this.tag, path, value);
            } else {
                met_setDouble.invoke(this.tag, path, value);
            }
        }
        catch (Throwable e) {
            if (Version.isCurrentEqualOrHigher(Version.v1_7_R4)) {
                e.printStackTrace();
            }
            return this.object;
        }
        switch (this.type.ordinal()) {
            case 3: {
                return this.tag;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 0: {
                return CMINBT.setTag((ItemStack)this.object, this.tag);
            }
        }
        return this.object;
    }

    public Object remove(String path) {
        if (Version.isCurrentEqualOrHigher(Version.v1_20_R4)) {
            CMIPersistentDataContainer.get(this.object).remove(path).save();
            return this.object;
        }
        try {
            met_remove.invoke(this.tag, path);
        }
        catch (Throwable e) {
            if (Version.isCurrentEqualOrHigher(Version.v1_7_R4)) {
                e.printStackTrace();
            }
            return this.object;
        }
        switch (this.type.ordinal()) {
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                return this.tag;
            }
            case 0: {
                return CMINBT.setTag((ItemStack)this.object, this.tag);
            }
        }
        return this.object;
    }

    public Object set(String path, Object nbtbase) {
        block8: {
            try {
                met_set.invoke(this.tag, path, nbtbase);
            }
            catch (Throwable e) {
                if (!Version.isCurrentEqualOrHigher(Version.v1_7_R4)) break block8;
                e.printStackTrace();
            }
        }
        switch (this.type.ordinal()) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                return this.tag;
            }
            case 0: {
                return CMINBT.setTag((ItemStack)this.object, this.tag);
            }
        }
        return this.object;
    }

    public boolean hasNBT() {
        return this.tag != null;
    }

    public boolean hasNBT(String key) {
        CMIPersistentDataContainer persistent;
        if (Version.isCurrentEqualOrHigher(Version.v1_20_R4) && (persistent = CMIPersistentDataContainer.get(this.object)) != null && persistent.hasKey(key)) {
            return true;
        }
        Object t = this.updateLegacyTag(this.tag);
        if (t != null && key.contains(".")) {
            try {
                if (((Boolean)t.getClass().getMethod(hasKeyName, String.class).invoke(t, key)).booleanValue()) {
                    return true;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            ArrayList<String> keys = new ArrayList<String>();
            keys.addAll(Arrays.asList(key.split("\\.")));
            try {
                Object nbtbase = met_get.invoke(t, keys.get(0));
                if (nbtbase == null) {
                    return false;
                }
                for (int i = 1; i < keys.size(); ++i) {
                    if (i + 1 >= keys.size()) {
                        if (nbtbase == null) break;
                        return (Boolean)nbtbase.getClass().getMethod(hasKeyName, String.class).invoke(nbtbase, keys.get(i));
                    }
                    nbtbase = met_get.invoke(nbtbase, keys.get(i));
                }
                return (Boolean)t.getClass().getMethod(hasKeyName, String.class).invoke(t, key);
            }
            catch (Throwable e) {
                e.printStackTrace();
                return false;
            }
        }
        try {
            return t != null && (Boolean)t.getClass().getMethod(hasKeyName, String.class).invoke(t, key) != false;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    public Object getNbt() {
        return this.tag;
    }

    public Set<String> getKeys() {
        Set<String> keys = new HashSet<String>();
        if (!this.hasNBT()) {
            return keys;
        }
        try {
            keys = (Set)this.getNbt().getClass().getMethod(getKeysName, new Class[0]).invoke(this.getNbt(), new Object[0]);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return keys;
    }

    public Object get(String path) {
        Object nbt = this.getNbt();
        if (nbt == null) {
            return null;
        }
        try {
            return met_get.invoke(nbt, path);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public Object getCompound(String path) {
        Object nbt = this.getNbt();
        if (nbt == null) {
            return null;
        }
        try {
            return met_getCompound.invoke(nbt, path);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public byte getTypeId() {
        try {
            return (Byte)this.getNbt().getClass().getMethod(getTypeIdName, new Class[0]).invoke(this.getNbt(), new Object[0]);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return 0;
        }
    }

    private static Method getSetTagMethod(Object nmsStack) {
        try {
            if (setTagMethod == null) {
                setTagMethod = Version.isCurrentEqualOrHigher(Version.v1_20_R4) ? nmsStack.getClass().getMethod(setTagName, HolderLookup.a.class, NBTBase) : nmsStack.getClass().getMethod(setTagName, nbtTagCompound);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return setTagMethod;
    }

    public static ItemStack setTag(ItemStack item, Object tag) {
        if (item == null) {
            return item;
        }
        try {
            Object nmsStack = CMINBT.asNMSCopy(item);
            return (ItemStack)CMINBT.asBukkitCopy(CMINBT.setTag(nmsStack, tag));
        }
        catch (Throwable e) {
            if (Version.isCurrentEqualOrHigher(Version.v1_7_R4)) {
                e.printStackTrace();
            }
            return item;
        }
    }

    private static Object getRegistry() {
        if (registry == null) {
            try {
                registry = ((DedicatedServer)CMILib.getInstance().getReflectionManager().getDedicatedServer()).getClass().getMethod("getDefaultRegistryAccess", new Class[0]).invoke(CMILib.getInstance().getReflectionManager().getDedicatedServer(), new Object[0]);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return registry;
    }

    private static Object setTag(Object nmsStack, Object tag) {
        try {
            if (nmsStack == null) {
                return null;
            }
            if (Version.isCurrentEqualOrHigher(Version.v1_20_R4)) {
                return nmsStack;
            }
            CMINBT.getSetTagMethod(nmsStack).invoke(nmsStack, tag);
            return nmsStack;
        }
        catch (Throwable e) {
            if (Version.isCurrentEqualOrHigher(Version.v1_7_R4)) {
                e.printStackTrace();
            }
            return nmsStack;
        }
    }

    public static Object getNbt(Entity entity) {
        if (entity == null) {
            return null;
        }
        try {
            Object tag = nbtTagCompound.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Object nmsStack = CMINBT.getEntityHandle(entity);
            Method methTag = nmsStack.getClass().getMethod(saveName, nbtTagCompound);
            tag = methTag.invoke(nmsStack, tag);
            return tag;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object getNbt(ItemStack item) {
        if (item == null || item.getType().equals((Object)Material.AIR)) {
            return null;
        }
        try {
            Object nmsStack = CMINBT.asNMSCopy(item);
            if (nmsStack == null) {
                return null;
            }
            if (Version.isCurrentEqualOrHigher(Version.v1_20_R4)) {
                if (nbtMethod == null) {
                    nbtMethod = Version.isCurrentEqualOrHigher(Version.v1_21_R1) ? ((net.minecraft.world.item.ItemStack)nmsStack).getClass().getMethod("a", Class.forName("net.minecraft.core.HolderLookup$a")) : ((net.minecraft.world.item.ItemStack)nmsStack).getClass().getMethod("b", Class.forName("net.minecraft.core.HolderLookup$a"));
                }
                return nbtMethod.invoke(nmsStack, CMINBT.getRegistry());
            }
            Method methTag = nmsStack.getClass().getMethod(getTagName, new Class[0]);
            Object tag = methTag.invoke(nmsStack, new Object[0]);
            if (tag == null) {
                tag = nbtTagCompound.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            return tag;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object getNbt(Block block) {
        if (block == null) {
            return null;
        }
        if (Version.isCurrentEqualOrHigher(Version.v1_20_R4)) {
            return null;
        }
        try {
            Object tile = CMILib.getInstance().getReflectionManager().getTileEntityAt(block.getLocation());
            String ff = "d";
            switch (Version.getCurrent()) {
                case v1_7_R4: 
                case v1_8_R1: 
                case v1_8_R3: 
                case v1_8_R2: 
                case v1_9_R1: 
                case v1_9_R2: 
                case v1_10_R1: 
                case v1_11_R1: 
                case v1_12_R1: {
                    ff = "d";
                    break;
                }
                case v1_13_R1: 
                case v1_13_R2: {
                    ff = "aa_";
                    break;
                }
                case v1_14_R1: 
                case v1_15_R1: 
                case v1_16_R1: 
                case v1_16_R2: 
                case v1_16_R3: {
                    ff = "b";
                    break;
                }
                case v1_17_R1: 
                case v1_18_R1: {
                    ff = "Z_";
                    break;
                }
                case v1_18_R2: {
                    ff = "aa_";
                    break;
                }
                case v1_19_R1: {
                    if (Version.isCurrentSubEqual(0)) {
                        ff = "ab_";
                        break;
                    }
                    ff = "aa_";
                    break;
                }
                case v1_19_R2: {
                    ff = "ad_";
                    break;
                }
                case v1_19_R3: {
                    ff = "aq_";
                    break;
                }
                case v1_20_R1: {
                    ff = "ao_";
                    break;
                }
                case v1_20_R2: {
                    ff = "as_";
                    break;
                }
                default: {
                    ff = "ax_";
                }
            }
            if (tile == null) {
                return null;
            }
            Method methTag = tile.getClass().getMethod(ff, new Class[0]);
            return methTag.invoke(tile, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Class<?> getBukkitClass(String nmsClassString) {
        try {
            return Class.forName("org.bukkit.craftbukkit." + Version.getCurrent().toString() + "." + nmsClassString);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Class<?> getMinecraftClass(String nmsClassString) {
        try {
            return Class.forName("net.minecraft.server." + Version.getCurrent().toString() + "." + nmsClassString);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static Object asNMSCopy(ItemStack item) {
        if (item == null) {
            return null;
        }
        try {
            if (asNMSCopy == null) {
                asNMSCopy = CraftItemStack.getMethod("asNMSCopy", ItemStack.class);
            }
            return asNMSCopy.invoke(CraftItemStack, item);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object asBukkitCopy(Object item) {
        try {
            if (asBukkitCopy == null) {
                asBukkitCopy = CraftItemStack.getMethod("asBukkitCopy", IStack);
            }
            return asBukkitCopy.invoke(CraftItemStack, item);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object getEntityHandle(Entity ent) {
        Object handle = null;
        try {
            if (EntityHandle == null) {
                EntityHandle = CraftEntity.getMethod("getHandle", new Class[0]);
            }
            handle = EntityHandle.invoke(CraftEntity.cast(ent), new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return handle;
    }

    public static boolean isNBTSimilar(ItemStack is, ItemStack is2) {
        try {
            Object i1 = CMINBT.asNMSCopy(is);
            Object i2 = CMINBT.asNMSCopy(is2);
            Method meth = null;
            meth = Version.isCurrentEqualOrLower(Version.v1_17_R1) ? i1.getClass().getMethod("equals", IStack, IStack) : i1.getClass().getMethod("a", IStack, IStack);
            return (Boolean)meth.invoke(IStack, i1, i2);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    @Deprecated
    public static ItemStack HideFlag(ItemStack item, int state) {
        if (Version.isCurrentEqualOrHigher(Version.v1_20_R4)) {
            ItemMeta meta = item.getItemMeta();
            for (ItemFlag one : ItemFlag.values()) {
                if ((state & 1 << one.ordinal()) == 0) continue;
                meta.addItemFlags(new ItemFlag[]{one});
            }
            item.setItemMeta(meta);
            return item;
        }
        Object nmsStack = CMINBT.asNMSCopy(item);
        try {
            Object tag = CMINBT.getNbt(item);
            met_setInt.invoke(tag, "HideFlags", state);
            nmsStack = CMINBT.setTag(nmsStack, tag);
            return (ItemStack)CMINBT.asBukkitCopy(nmsStack);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return item;
        }
    }

    public static ItemStack modifyItemStack(ItemStack stack, String arguments) {
        if (Version.isCurrentEqualOrHigher(Version.v1_20_R4)) {
            try {
                try {
                    arguments = arguments.replaceAll("\\s*=\\s*\\[", ":[");
                    NBTTagCompound t = net.minecraft.nbt.MojangsonParser.a((String)arguments);
                    net.minecraft.world.item.ItemStack nmsStack = (net.minecraft.world.item.ItemStack)CMINBT.asNMSCopy(stack);
                    NBTBase base = nmsStack.b((HolderLookup.a)CMINBT.getRegistry(), (NBTBase)t);
                    Optional lenient = net.minecraft.world.item.ItemStack.a((HolderLookup.a)((HolderLookup.a)CMINBT.getRegistry()), (NBTBase)base);
                    stack = (ItemStack)CMINBT.asBukkitCopy(lenient.get());
                    return stack;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    NBTTagCompound s = net.minecraft.nbt.MojangsonParser.a((String)arguments);
                    Optional ti = net.minecraft.world.item.ItemStack.b.decode((DynamicOps)DynamicOpsNBT.a, (Object)s).result();
                    if (!ti.isPresent()) {
                        return stack;
                    }
                    net.minecraft.world.item.ItemStack item = (net.minecraft.world.item.ItemStack)((Pair)ti.get()).getFirst();
                    return (ItemStack)item.h();
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        Object nmsStack = CMINBT.asNMSCopy(stack);
        try {
            Object res = MojangsonParser.getMethod(parseName, String.class).invoke(MojangsonParser, arguments);
            nmsStack = CMINBT.setTag(nmsStack, res);
            Object meta = CraftItemStack.getMethod("getItemMeta", IStack).invoke(CraftItemStack, nmsStack);
            stack.setItemMeta((ItemMeta)meta);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return stack;
    }

    public static String toJson(ItemStack item) {
        if (item == null) {
            return null;
        }
        Object nmsStack = CMINBT.asNMSCopy(item);
        try {
            if (saveOptionalMethod == null) {
                saveOptionalMethod = Version.isCurrentEqualOrHigher(Version.v1_20_R4) ? IStack.getMethod(itemSaveName, HolderLookup.a.class) : IStack.getMethod(itemSaveName, nbtTagCompound);
            }
            if (Version.isCurrentEqualOrHigher(Version.v1_20_R4)) {
                return saveOptionalMethod.invoke(nmsStack, CMINBT.getRegistry()).toString();
            }
            return saveOptionalMethod.invoke(nmsStack, nbtTagCompound.newInstance()).toString();
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static EntityType getEggType(ItemStack item) {
        if (!CMIMaterial.isMonsterEgg(item.getType())) {
            return null;
        }
        if (Version.isCurrentEqual(Version.v1_12_R1)) {
            try {
                CMIEntityType cmiType;
                if (Version.isCurrentEqualOrLower(Version.v1_11_R1) && (cmiType = CMIEntityType.getById(item.getData().getData())) != null) {
                    return cmiType.getType();
                }
                Object tag = CMINBT.getNbt(item);
                Object base = met_getCompound.invoke(tag, "EntityTag");
                String type = (String)met_getString.invoke(base, "id");
                return EntityType.fromName((String)type.replace("minecraft:", "").toUpperCase());
            }
            catch (Exception e) {
                return null;
            }
        }
        CMIEntityType type = CMIEntityType.getByName(item.getType().toString().replace("_SPAWN_EGG", ""));
        return type == null ? null : type.getType();
    }

    public static ItemStack setEggType(ItemStack item, EntityType etype) {
        if (!item.getType().toString().contains("_EGG")) {
            return null;
        }
        try {
            CMIEntityType ce;
            Object tag = CMINBT.getNbt(item);
            Object ttag = met_getCompound.invoke(tag, "EntityTag");
            if (ttag == null) {
                ttag = nbtTagCompound.newInstance();
            }
            if ((ce = CMIEntityType.getByType(etype)) == null) {
                return item;
            }
            met_setString.invoke(ttag, "id", ce.getName());
            met_set.invoke(tag, "EntityTag", ttag);
            CMINBT.setTag(item, tag);
            return (ItemStack)CMINBT.asBukkitCopy(CMINBT.asNMSCopy(item));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object newNBTTagList(int type) {
        try {
            return nbtTagList.newInstance();
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void addToList(Object list, int size, Object data) {
        if (met_add == null) {
            return;
        }
        try {
            met_add.invoke(list, size, data);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public nmbtType getType() {
        return this.type;
    }

    static {
        getTagName = "getTag";
        setTagName = "setTag";
        getStringName = "getString";
        getIntName = "getInt";
        getByteName = "getByte";
        getLongName = "getLong";
        getBooleanName = "getBoolean";
        getFloatName = "getFloat";
        getShortName = "getShort";
        getDoubleName = "getDouble";
        getListName = "getList";
        getByteArrayName = "getByteArray";
        getIntArrayName = "getIntArray";
        getLongArrayName = "getLongArray";
        listGetName = "get";
        setBooleanName = "setBoolean";
        setByteName = "setByte";
        setShortName = "setShort";
        setStringName = "setString";
        setIntName = "setInt";
        setLongName = "setLong";
        setDoubleName = "setDouble";
        setIntArrayName = "setIntArray";
        setByteArrayName = "setByteArray";
        setLongArrayName = "a";
        setName = "set";
        getName = "get";
        removeName = "remove";
        getCompoundName = "getCompound";
        asStringName = "asString";
        saveName = "save";
        parseName = "parse";
        itemSaveName = "save";
        hasKeyName = "hasKey";
        getKeysName = "getKeys";
        getTypeIdName = "getTypeId";
        listAddMethod = "add";
        if (Version.isCurrentEqualOrHigher(Version.v1_17_R1)) {
            try {
                NBTBase = NBTBase.class;
                nbtTagCompound = NBTTagCompound.class;
                nbtTagList = NBTTagList.class;
                CraftItemStack = CMINBT.getBukkitClass("inventory.CraftItemStack");
                IStack = net.minecraft.world.item.ItemStack.class;
                CraftEntity = CMINBT.getBukkitClass("entity.CraftEntity");
                MojangsonParser = MojangsonParser.class;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            try {
                NBTTagString = NBTTagString.class;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        } else {
            try {
                NBTBase = CMINBT.getMinecraftClass("NBTBase");
                nbtTagCompound = CMINBT.getMinecraftClass("NBTTagCompound");
                nbtTagList = CMINBT.getMinecraftClass("NBTTagList");
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            try {
                NBTTagString = CMINBT.getMinecraftClass("NBTTagString");
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            try {
                CraftItemStack = CMINBT.getBukkitClass("inventory.CraftItemStack");
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            try {
                IStack = CMINBT.getMinecraftClass("ItemStack");
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            try {
                CraftEntity = CMINBT.getBukkitClass("entity.CraftEntity");
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            try {
                MojangsonParser = CMINBT.getMinecraftClass("MojangsonParser");
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        if (Version.isCurrentEqualOrHigher(Version.v1_18_R1)) {
            getStringName = "l";
            setTagName = "c";
            getIntName = "h";
            getByteName = "f";
            getLongName = "i";
            getBooleanName = "q";
            getFloatName = "j";
            getShortName = "g";
            getDoubleName = "k";
            getListName = "c";
            getByteArrayName = "m";
            getIntArrayName = "n";
            getLongArrayName = "o";
            setBooleanName = "a";
            setByteName = "a";
            setShortName = "a";
            setStringName = "a";
            setIntName = "a";
            setLongName = "a";
            setDoubleName = "a";
            setIntArrayName = "a";
            setByteArrayName = "a";
            listGetName = "k";
            setName = "a";
            getName = "c";
            removeName = "r";
            getCompoundName = "p";
            asStringName = "e_";
            hasKeyName = "e";
            getKeysName = "d";
            saveName = "f";
            parseName = "a";
            itemSaveName = "b";
            getTypeIdName = "a";
        }
        if (Version.isCurrentEqualOrHigher(Version.v1_14_R1)) {
            listAddMethod = "b";
        } else if (Version.isCurrentEqualOrHigher(Version.v1_13_R1)) {
            listAddMethod = "add";
        }
        if (Version.isCurrentEqual(Version.v1_18_R1)) {
            getTagName = "s";
        }
        if (Version.isCurrentEqualOrHigher(Version.v1_18_R2)) {
            getTagName = "t";
        }
        if (Version.isCurrentEqualOrHigher(Version.v1_19_R1)) {
            getTagName = "u";
        }
        if (Version.isCurrentEqualOrLower(Version.v1_12_R1)) {
            asStringName = "toString";
            getKeysName = "c";
        }
        if (Version.isCurrentEqualOrHigher(Version.v1_19_R2)) {
            asStringName = "f_";
            getKeysName = "e";
            getTypeIdName = "b";
        }
        if (Version.isCurrentEqualOrHigher(Version.v1_20_R1)) {
            asStringName = "m_";
            getTagName = "v";
        }
        if (Version.isCurrentEqualOrHigher(Version.v1_20_R2)) {
            asStringName = "toString";
            listGetName = "j";
        }
        if (Version.isCurrentEqualOrHigher(Version.v1_20_R4)) {
            getTagName = "v";
            setTagName = "b";
        }
        try {
            met_getString = nbtTagCompound.getMethod(getStringName, String.class);
            met_getInt = nbtTagCompound.getMethod(getIntName, String.class);
            met_getByte = nbtTagCompound.getMethod(getByteName, String.class);
            met_getLong = nbtTagCompound.getMethod(getLongName, String.class);
            met_getBoolean = nbtTagCompound.getMethod(getBooleanName, String.class);
            met_getFloat = nbtTagCompound.getMethod(getFloatName, String.class);
            met_getShort = nbtTagCompound.getMethod(getShortName, String.class);
            met_getDouble = nbtTagCompound.getMethod(getDoubleName, String.class);
            met_getList = nbtTagCompound.getMethod(getListName, String.class, Integer.TYPE);
            met_getByteArray = nbtTagCompound.getMethod(getByteArrayName, String.class);
            met_getIntArray = nbtTagCompound.getMethod(getIntArrayName, String.class);
            if (Version.isCurrentEqualOrHigher(Version.v1_13_R1)) {
                met_getLongArray = nbtTagCompound.getMethod(getLongArrayName, String.class);
            }
            met_get = nbtTagCompound.getMethod(getName, String.class);
            met_remove = nbtTagCompound.getMethod(removeName, String.class);
            met_getCompound = nbtTagCompound.getMethod(getCompoundName, String.class);
            met_toString = nbtTagCompound.getMethod(asStringName, new Class[0]);
            met_setBoolean = nbtTagCompound.getMethod(setBooleanName, String.class, Boolean.TYPE);
            met_setByte = nbtTagCompound.getMethod(setByteName, String.class, Byte.TYPE);
            met_setShort = nbtTagCompound.getMethod(setShortName, String.class, Short.TYPE);
            met_setString = nbtTagCompound.getMethod(setStringName, String.class, String.class);
            met_setInt = nbtTagCompound.getMethod(setIntName, String.class, Integer.TYPE);
            met_setLong = nbtTagCompound.getMethod(setLongName, String.class, Long.TYPE);
            met_setDouble = nbtTagCompound.getMethod(setDoubleName, String.class, Double.TYPE);
            met_setIntArray = nbtTagCompound.getMethod(setIntArrayName, String.class, int[].class);
            try {
                met_setByteArray = nbtTagCompound.getMethod(setByteArrayName, String.class, byte[].class);
                if (Version.isCurrentEqualOrHigher(Version.v1_13_R1)) {
                    met_setLongArray = nbtTagCompound.getMethod(setLongArrayName, String.class, long[].class);
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
            met_set = nbtTagCompound.getMethod(setName, String.class, NBTBase);
            try {
                met_add = nbtTagList.getMethod(listAddMethod, Integer.TYPE, NBTBase);
            }
            catch (Throwable ex) {
                // empty catch block
            }
            try {
                met_tagStringValueOf = NBTTagString.getMethod("a", String.class);
            }
            catch (Throwable e) {
                try {
                    met_tagStringValueOf = NBTTagString.getMethod("valueOf", String.class);
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        setTagMethod = null;
        registry = null;
        nbtMethod = null;
        asNMSCopy = null;
        asBukkitCopy = null;
        EntityHandle = null;
        saveOptionalMethod = null;
    }

    public static enum nmbtType {
        item,
        block,
        entity,
        custom;

    }
}

