/*
 * Decompiled with CFR 0.152.
 */
package net.Zrips.CMILib.GUI;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import net.Zrips.CMILib.CMILib;
import net.Zrips.CMILib.GUI.CMIGui;
import net.Zrips.CMILib.GUI.CMIGuiButton;
import net.Zrips.CMILib.GUI.GUIManager;
import net.Zrips.CMILib.Items.CMIItemStack;
import net.Zrips.CMILib.NBT.CMINBT;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.inventory.ItemStack;

public class GUIListener
implements Listener {
    CMILib plugin;
    private HashMap<UUID, Long> LastClick = new HashMap();

    public GUIListener(CMILib plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onNormalInventoryClose(InventoryCloseEvent event) {
        Player player = (Player)event.getPlayer();
        if (this.plugin.getGUIManager().isOpenedGui(player) && this.plugin.getGUIManager().removePlayer(player)) {
            player.updateInventory();
            GUIListener.clearIconItems(player);
        }
    }

    private static void clearIconItems(Player player) {
        for (ItemStack one : player.getInventory().getContents()) {
            CMINBT nbt = new CMINBT(one);
            String res = nbt.getString("CMIGUIIcon");
            if (res == null || !res.equalsIgnoreCase("LIProtection")) continue;
            player.getInventory().remove(one);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerDeathEvent(PlayerDeathEvent event) {
        if (event.getEntity() == null) {
            return;
        }
        GUIListener.clearIconItems(event.getEntity());
    }

    private boolean canClickByTimer(UUID uuid) {
        Long time = this.LastClick.get(uuid);
        if (time == null) {
            this.LastClick.put(uuid, System.currentTimeMillis());
            return true;
        }
        if (time + 51L > System.currentTimeMillis()) {
            this.LastClick.put(uuid, System.currentTimeMillis());
            return false;
        }
        this.LastClick.put(uuid, System.currentTimeMillis());
        return true;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onInventoryClickLog(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        if (!this.plugin.getGUIManager().isOpenedGui(player)) {
            return;
        }
        CMIGui gui = this.plugin.getGUIManager().getGui(player);
        if (!gui.isClickLogging()) {
            return;
        }
        if (gui.isAllowShift() && event.getAction().equals((Object)InventoryAction.MOVE_TO_OTHER_INVENTORY) && (event.getClickedInventory() == null || event.getClickedInventory().getType().equals((Object)InventoryType.PLAYER))) {
            return;
        }
        try {
            gui.addClickLog(event.getClickedInventory() == null ? null : event.getClickedInventory().getType(), event.isCancelled(), event.getClick(), event.getAction(), event.getCurrentItem(), event.getCursor(), event.getSlot());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onInventoryOpenEvent(InventoryOpenEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        GUIListener.clearIconItems((Player)event.getPlayer());
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onItemDrop(PlayerDropItemEvent event) {
        ItemStack one;
        CMINBT nbt;
        String res;
        Player player = event.getPlayer();
        if (this.plugin.getGUIManager().isOpenedGui(player)) {
            event.setCancelled(true);
        }
        if ((res = (nbt = new CMINBT(one = event.getItemDrop().getItemStack())).getString("CMIGUIIcon")) == null || !res.equalsIgnoreCase("LIProtection")) {
            return;
        }
        event.setCancelled(true);
        GUIListener.clearIconItems(player);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onInventoryClick(InventoryClickEvent event) {
        boolean click;
        if (event.isCancelled() && !event.getWhoClicked().getGameMode().toString().equalsIgnoreCase("Spectator")) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (!this.plugin.getGUIManager().isOpenedGui(player)) {
            return;
        }
        CMIGui gui = this.plugin.getGUIManager().getGui(player);
        if (player.isSleeping()) {
            player.closeInventory();
            event.setCancelled(true);
            return;
        }
        if (event.getAction().toString().equalsIgnoreCase("HOTBAR_SWAP") || event.getAction().toString().equalsIgnoreCase("HOTBAR_MOVE_AND_READD")) {
            ItemStack iioh = CMIItemStack.getItemInOffHand(player).clone();
            CMIItemStack.setItemInOffHand(player, null);
            event.setCancelled(true);
            CMIScheduler.runTask(this.plugin, () -> {
                try {
                    player.getInventory().setItemInOffHand(iioh);
                    player.updateInventory();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            });
        }
        if (event.getClick() == ClickType.DOUBLE_CLICK || event.getHotbarButton() != -1) {
            event.setCancelled(true);
            return;
        }
        if (!gui.isAllowShift() && event.isShiftClick()) {
            event.setCancelled(true);
        }
        if (event.isShiftClick() && gui.isNoItemPlacement(GUIManager.InvType.Gui) && !event.getClickedInventory().equals((Object)gui.getInv())) {
            event.setCancelled(true);
        }
        if (!(event.getAction().equals((Object)InventoryAction.PICKUP_ALL) || event.getAction().equals((Object)InventoryAction.PICKUP_ONE) || event.getAction().equals((Object)InventoryAction.PICKUP_HALF) || event.getAction().equals((Object)InventoryAction.PICKUP_SOME) || event.getAction().equals((Object)InventoryAction.PLACE_ALL) || event.getAction().equals((Object)InventoryAction.PLACE_ONE) || event.getAction().equals((Object)InventoryAction.PLACE_SOME) || gui.isAllowShift() || event.getAction().equals((Object)InventoryAction.MOVE_TO_OTHER_INVENTORY))) {
            event.setCancelled(true);
        }
        if (!gui.isAllowPickUpAll() && !this.canClickByTimer(player.getUniqueId())) {
            event.setCancelled(true);
            return;
        }
        ArrayList<Integer> buttons = new ArrayList<Integer>();
        buttons.add(event.getRawSlot());
        if (!this.plugin.getGUIManager().canClick(player, buttons, event.getCursor())) {
            event.setCancelled(true);
            if (GUIManager.usePackets) {
                CMIScheduler.get().runTask(() -> player.setItemOnCursor(player.getItemOnCursor()));
            }
            gui.updateButtons();
        }
        if (this.plugin.getGUIManager().isLockedPart(player, buttons)) {
            event.setCancelled(true);
            if (GUIManager.usePackets) {
                CMIScheduler.get().runTask(() -> player.setItemOnCursor(player.getItemOnCursor()));
            }
        }
        if (this.plugin.getGUIManager().isLockedPart(player, buttons, event.getCursor())) {
            event.setCancelled(true);
            if (GUIManager.usePackets) {
                CMIScheduler.get().runTask(() -> player.setItemOnCursor(player.getItemOnCursor()));
            }
        }
        InventoryAction action = event.getAction();
        if (!gui.isAllowMoveAll() && action.equals((Object)InventoryAction.MOVE_TO_OTHER_INVENTORY)) {
            GUIManager.limit.remove(player.getUniqueId());
        }
        if (!(click = this.plugin.getGUIManager().processClick(player, event.getCurrentItem(), buttons, this.plugin.getGUIManager().getClickType(event.isLeftClick(), event.isShiftClick(), action, event.getClick())))) {
            event.setCancelled(true);
            return;
        }
        if (!event.isCancelled() && gui.isAllowShift() && event.getAction().equals((Object)InventoryAction.MOVE_TO_OTHER_INVENTORY) && event.getClickedInventory().getType().equals((Object)InventoryType.PLAYER)) {
            event.setCancelled(true);
            ItemStack item = event.getCurrentItem().clone();
            for (int i = 0; i < gui.getInvSize().getFields(); ++i) {
                CMIGuiButton b = gui.getButtons().get(i);
                if (b != null && (b.isLocked() || b.getItem() != null) || gui.getInv().getItem(i) != null || i >= gui.getInv().getSize()) continue;
                if (gui.isClickLogging()) {
                    try {
                        gui.addClickLog(event.getClickedInventory() == null ? null : event.getClickedInventory().getType(), event.isCancelled(), event.getClick(), event.getAction(), event.getCurrentItem(), event.getCursor(), event.getSlot());
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
                gui.getInv().setItem(i, item);
                player.getInventory().setItem(event.getSlot(), null);
                event.setCurrentItem(null);
                break;
            }
        }
        CMIScheduler.get().runTask(() -> GUIListener.clearIconItems(player));
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onInventoryDragEventLog(InventoryDragEvent event) {
        Player player = (Player)event.getWhoClicked();
        if (!this.plugin.getGUIManager().isOpenedGui(player)) {
            return;
        }
        if (player.isSleeping()) {
            player.closeInventory();
            event.setCancelled(true);
            return;
        }
        CMIGui gui = this.plugin.getGUIManager().getGui(player);
        if (!gui.isClickLogging()) {
            return;
        }
        try {
            gui.addClickLog(event.getInventory().getType(), event.isCancelled(), event.getCursor(), event.getNewItems(), event.getInventorySlots(), event.getType());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onInventoryMove(InventoryDragEvent event) {
        if (event.isCancelled() && !event.getWhoClicked().getGameMode().toString().equalsIgnoreCase("Spectator")) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (!this.plugin.getGUIManager().isOpenedGui(player)) {
            return;
        }
        CMIGui gui = this.plugin.getGUIManager().getGui(player);
        if (!gui.isAllowPickUpAll() && !this.canClickByTimer(player.getUniqueId())) {
            event.setCancelled(true);
            return;
        }
        ArrayList<Integer> buttons = new ArrayList<Integer>();
        buttons.addAll(event.getRawSlots());
        if (!this.plugin.getGUIManager().canClick(player, buttons, event.getCursor())) {
            event.setCancelled(true);
        }
        if (this.plugin.getGUIManager().isLockedPart(player, buttons, event.getCursor())) {
            event.setCancelled(true);
        }
        if (!this.plugin.getGUIManager().processClick(player, event.getOldCursor(), buttons, this.plugin.getGUIManager().getClickType(true, false, null, null))) {
            event.setCancelled(true);
        }
        CMIScheduler.get().runTask(() -> GUIListener.clearIconItems(player));
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void PlayerPickupItemEvent(PlayerPickupItemEvent event) {
        Player player = event.getPlayer();
        if (!this.plugin.getGUIManager().isOpenedGui(player)) {
            return;
        }
        CMIGui gui = this.plugin.getGUIManager().getGui(player);
        if (!gui.isAllowItemPickup()) {
            event.setCancelled(true);
            event.getItem().setPickupDelay(event.getItem().getPickupDelay() < 20 ? 20 : event.getItem().getPickupDelay());
        }
    }
}

