/*
 * Decompiled with CFR 0.152.
 */
package net.Zrips.CMILib.Enchants;

import java.util.HashMap;
import java.util.Map;
import net.Zrips.CMILib.CMILib;
import net.Zrips.CMILib.Colors.CMIChatColor;
import net.Zrips.CMILib.Container.CMIText;
import net.Zrips.CMILib.Enchants.CMIEnchantEnum;
import net.Zrips.CMILib.FileHandler.ConfigReader;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;

public class CMIEnchantment {
    private String keyName = null;
    private String translatedName = null;
    private Enchantment enchant = null;
    private CMIEnchantEnum enumEnchant = null;
    private static final Map<String, CMIEnchantment> byName = new HashMap<String, CMIEnchantment>();
    private static final Map<Enchantment, CMIEnchantment> byEnchant = new HashMap<Enchantment, CMIEnchantment>();
    private static HashMap<String, String> enchantList = new HashMap();

    CMIEnchantment(Enchantment enchant, CMIEnchantEnum enumEnchant) {
        this(enchant);
        this.enumEnchant = enumEnchant;
    }

    CMIEnchantment(Enchantment enchant) {
        this.enchant = enchant;
        try {
            this.keyName = enchant.getKey().getKey().replace("minecraft:", "");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String getName() {
        return this.enchant.getName();
    }

    public String getKeyName() {
        try {
            return this.keyName == null ? this.enchant.getKey().getKey().replace("minecraft:", "") : this.keyName;
        }
        catch (Throwable e) {
            return this.getName();
        }
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public String getTranslatedName() {
        return this.translatedName == null ? (this.getKeyName() == null ? this.getName() : this.getKeyName()) : this.translatedName;
    }

    public void setTranslatedName(String translatedName) {
        this.translatedName = translatedName;
    }

    public Enchantment getEnchant() {
        return this.enchant;
    }

    public boolean equalEnum(CMIEnchantEnum enumEnchant) {
        return this.enumEnchant == null ? false : this.enumEnchant.equals((Object)enumEnchant);
    }

    public CMIEnchantEnum getCMIEnum() {
        return this.enumEnchant;
    }

    public static Map<Enchantment, CMIEnchantment> getEnchants() {
        return byEnchant;
    }

    private static String strip(String name) {
        return name.replace("_", "").replace(" ", "").toLowerCase();
    }

    public static void initialize() {
        CMIEnchantment cmi;
        HashMap<String, CMIEnchantment> eList = new HashMap<String, CMIEnchantment>();
        for (CMIEnchantEnum cMIEnchantEnum : CMIEnchantEnum.values()) {
            Enchantment got = cMIEnchantEnum.getEnchantment();
            if (got == null) continue;
            cmi = new CMIEnchantment(got, cMIEnchantEnum);
            eList.put(CMIEnchantment.strip(cMIEnchantEnum.getName()), cmi);
            byName.putIfAbsent(CMIEnchantment.strip(cMIEnchantEnum.getName()), cmi);
            byEnchant.putIfAbsent(got, cmi);
            for (String oneAlternative : cMIEnchantEnum.getAlternativeNames()) {
                eList.put(CMIEnchantment.strip(oneAlternative), cmi);
                byName.putIfAbsent(CMIEnchantment.strip(oneAlternative), cmi);
            }
        }
        for (CMIEnchantEnum cMIEnchantEnum : Enchantment.values()) {
            try {
                String name;
                if (cMIEnchantEnum == null || (name = cMIEnchantEnum.getName()) == null || name.isEmpty() || name == " ") continue;
                cmi = eList.getOrDefault(CMIEnchantment.strip(name), new CMIEnchantment((Enchantment)cMIEnchantEnum));
                byName.putIfAbsent(CMIEnchantment.strip(cMIEnchantEnum.getName()), cmi);
                byEnchant.putIfAbsent((Enchantment)cMIEnchantEnum, cmi);
            }
            catch (Error | Exception e) {
                e.printStackTrace();
            }
        }
        enchantList = byName.entrySet().stream().collect(HashMap::new, (map, entry) -> map.put(CMIText.firstToUpperCase(CMIEnchantment.strip((String)entry.getKey())), CMIText.firstToUpperCase(CMIEnchantment.strip(((CMIEnchantment)entry.getValue()).getName()))), HashMap::putAll);
    }

    public static void updateLocale() {
        ConfigReader locale = CMILib.getInstance().getConfigManager().getLocaleConfig();
        locale.addComment("info.EnchantNames", "Avoid adding color codes to the enchant name");
        for (CMIEnchantment cmiEnchant : byEnchant.values()) {
            String name = cmiEnchant.getName();
            if (name == null || name.isEmpty() || name == " ") continue;
            String existing = null;
            if (locale.getC().isList("info.EnchantAliases." + name.toLowerCase())) {
                existing = (String)locale.getC().getStringList("info.EnchantAliases." + name.toLowerCase()).get(0);
            }
            String defaultValue = existing != null ? existing : CMIText.everyFirstToUpperCase(name, false);
            String translated = CMIChatColor.stripColor(locale.get("info.EnchantNames." + name.toLowerCase(), defaultValue));
            cmiEnchant.setTranslatedName(translated);
            byName.putIfAbsent(CMIEnchantment.strip(cmiEnchant.getTranslatedName()), cmiEnchant);
        }
    }

    @Deprecated
    public static void saveEnchants() {
    }

    public static Enchantment get(String nameId) {
        return CMIEnchantment.getByName(nameId);
    }

    public static Enchantment getByName(String name) {
        String[] split;
        if (name == null) {
            return null;
        }
        if (name.contains(":")) {
            name = name.split(":", 2)[0];
        }
        String original = name;
        CMIEnchantment got = byName.get(name = name.replace("_", "").replace(" ", "").toLowerCase());
        if (got != null) {
            return got.getEnchant();
        }
        Enchantment e = null;
        if (name.contains(":") && (e = Enchantment.getByKey((NamespacedKey)new NamespacedKey((split = name.split(":", 2))[0], split[1]))) != null) {
            return e;
        }
        try {
            e = Enchantment.getByName((String)original.toUpperCase());
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return e;
    }

    public static CMIEnchantment get(Enchantment enchantment) {
        return byEnchant.get(enchantment);
    }

    public static CMIEnchantment getCMIByName(String name) {
        if (name.contains(":")) {
            name = name.split(":", 2)[0];
        }
        return byName.get(name.replace("_", "").replace(" ", "").toLowerCase());
    }

    public static boolean isEnabled(Enchantment enchant) {
        if (enchant == null || enchant.getName() == null) {
            return false;
        }
        for (Enchantment one : Enchantment.values()) {
            if (one == null || one.getName() == null || !one.getName().equalsIgnoreCase(enchant.getName())) continue;
            return true;
        }
        return false;
    }

    public static Enchantment[] values() {
        return byEnchant.keySet().toArray(new Enchantment[byName.size()]);
    }

    public static String getName(Enchantment enchant) {
        if (enchant == null || enchant.getName() == null) {
            return null;
        }
        CMIEnchantment got = byEnchant.get(enchant);
        if (got != null) {
            return CMIText.firstToUpperCase(got.getName()).replace(" ", "");
        }
        return CMIText.firstToUpperCase(enchant.getName()).replace(" ", "");
    }

    public static String getTranslatedName(Enchantment enchant) {
        if (enchant == null || enchant.getName() == null) {
            return null;
        }
        CMIEnchantment got = byEnchant.get(enchant);
        if (got != null) {
            return got.getTranslatedName();
        }
        return CMIText.firstToUpperCase(enchant.getName());
    }

    public static HashMap<String, String> getEnchantList() {
        return enchantList;
    }
}

