/*
 * Decompiled with CFR 0.152.
 */
package net.Zrips.CMILib.Container;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CMIJson {
    private CMIJson() {
        throw new IllegalStateException("Utility class");
    }

    public static <K, V> String serialize(HashMap<K, V> map) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        for (Map.Entry<K, V> entry : map.entrySet()) {
            sb.append(CMIJson.serializeObject(entry.getKey())).append(":").append(CMIJson.serializeObject(entry.getValue())).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public static HashMap<String, Object> deserialize(String json) {
        String[] entries;
        HashMap<String, Object> map = new HashMap<String, Object>();
        json = json.substring(1, json.length() - 1);
        for (String entry : entries = CMIJson.splitJsonEntries(json)) {
            String[] keyValue = entry.split(":", 2);
            if (keyValue.length != 2) continue;
            String key = CMIJson.deserializeObject(keyValue[0]).toString();
            Object value = CMIJson.deserializeObject(keyValue[1]);
            map.put(key, value);
        }
        return map;
    }

    private static String serializeObject(Object obj) {
        if (obj == null) {
            return "\"null\"";
        }
        if (obj instanceof String) {
            return "\"" + CMIJson.escapeJson(obj.toString()) + "\"";
        }
        if (obj instanceof Boolean) {
            return "\"" + ((Boolean)obj != false ? "1b" : "0b") + "\"";
        }
        if (obj instanceof Integer || obj instanceof Long || obj instanceof Double) {
            return "\"" + obj.toString() + "\"";
        }
        if (obj instanceof List) {
            return CMIJson.serializeList((List)obj);
        }
        if (obj instanceof HashMap) {
            return CMIJson.serialize((HashMap)obj);
        }
        return "\"" + obj.toString() + "\"";
    }

    private static String escapeJson(String str) {
        return str.replace("\\", "\\\\").replace("\"", "\\\"").replace("\b", "\\b").replace("\f", "\\f").replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t");
    }

    private static String unescapeJson(String str) {
        return str.replace("\\\"", "\"").replace("\\\\", "\\").replace("\\b", "\b").replace("\\f", "\f").replace("\\n", "\n").replace("\\r", "\r").replace("\\t", "\t");
    }

    public static String serializeList(List<?> list) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (Object item : list) {
            sb.append(CMIJson.serializeObject(item)).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("]");
        return sb.toString();
    }

    private static Object deserializeObject(String str) {
        if ((str = str.trim()).startsWith("\"") && str.endsWith("\"")) {
            str = str.substring(1, str.length() - 1);
        }
        if ("null".equals(str)) {
            return null;
        }
        if (str.equals("true") || str.equals("false")) {
            return Boolean.parseBoolean(str);
        }
        if (str.equals("1b")) {
            return true;
        }
        if (str.equals("0b")) {
            return false;
        }
        if (str.startsWith("[") && str.endsWith("]")) {
            return CMIJson.deserializeList(str);
        }
        if (str.startsWith("{") && str.endsWith("}")) {
            return CMIJson.deserialize(str);
        }
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException e1) {
            try {
                return Integer.parseInt(str);
            }
            catch (NumberFormatException e2) {
                try {
                    return Double.parseDouble(str);
                }
                catch (NumberFormatException e3) {
                    if (str.startsWith("\"") && str.endsWith("\"")) {
                        return CMIJson.unescapeJson(str.substring(1, str.length() - 1));
                    }
                    return CMIJson.unescapeJson(str);
                }
            }
        }
    }

    public static List<Object> deserializeList(String str) {
        String[] items;
        ArrayList<Object> list = new ArrayList<Object>();
        str = str.substring(1, str.length() - 1);
        for (String item : items = CMIJson.splitJsonEntries(str)) {
            list.add(CMIJson.deserializeObject(item));
        }
        return list;
    }

    private static String[] splitJsonEntries(String str) {
        ArrayList<String> entries = new ArrayList<String>();
        int braceCount = 0;
        int bracketCount = 0;
        int start = 0;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '{') {
                ++braceCount;
            }
            if (c == '}') {
                --braceCount;
            }
            if (c == '[') {
                ++bracketCount;
            }
            if (c == ']') {
                --bracketCount;
            }
            if (c != ',' || braceCount != 0 || bracketCount != 0) continue;
            entries.add(str.substring(start, i).trim());
            start = i + 1;
        }
        if (start < str.length()) {
            entries.add(str.substring(start).trim());
        }
        return entries.toArray(new String[0]);
    }
}

