/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.utils;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Modules.Permissions.PermissionsManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.Zrips.CMILib.Container.CMIList;
import net.Zrips.CMILib.Container.CMILocation;
import net.Zrips.CMILib.FileHandler.ConfigReader;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class SpawnUtil {
    public static final String defaultG = "CMISpawnGroup";
    public static final String defaultGW = "CMISWG";
    static HashMap<String, SpawnPoint> map = new HashMap();
    private static Set<String> ignoredSpawnWorlds = new HashSet<String>();
    private static boolean SpawnSpawnOnJoin = false;

    public static void addNew(String string, CMILocation cMILocation, boolean bl) {
        SpawnUtil.addNew(string, cMILocation, bl, null);
    }

    public static void addNew(String string, CMILocation cMILocation, boolean bl, Integer n) {
        SpawnUtil.addNew(string, cMILocation, bl, n, new ArrayList<World>());
    }

    public static void addNew(String string, CMILocation cMILocation, boolean bl, Integer n, Set<String> set) {
        if (string == null && !set.isEmpty()) {
            string = defaultGW + new Random(Integer.MAX_VALUE).nextInt(100000);
        }
        if (string == null) {
            string = defaultG;
        }
        if (cMILocation == null) {
            return;
        }
        map.put(string, new SpawnPoint(string, cMILocation, bl, n, set));
    }

    public static void addNew(String string, CMILocation cMILocation, boolean bl, Integer n, List<World> list2) {
        if (string == null && !list2.isEmpty()) {
            string = defaultGW + new Random(Integer.MAX_VALUE).nextInt(100000);
        }
        if (string == null) {
            string = defaultG;
        }
        if (cMILocation == null) {
            return;
        }
        map.put(string, new SpawnPoint(string, cMILocation, bl, n, list2));
    }

    public static CMILocation getSpawnPoint(Player player) {
        SpawnPoint spawnPoint;
        if (player != null) {
            spawnPoint = null;
            for (Map.Entry<String, SpawnPoint> entry : map.entrySet()) {
                if (entry.getKey().equals(defaultG) || entry.getKey().startsWith(defaultGW) || !PermissionsManager.CMIPerm.spawngroup_$1.hasPermission((CommandSender)player, entry.getKey())) continue;
                if (!entry.getValue().getWorlds().isEmpty()) {
                    if (!entry.getValue().getWorlds().contains(player.getWorld())) continue;
                    spawnPoint = entry.getValue().getLocation();
                    break;
                }
                spawnPoint = entry.getValue().getLocation();
                break;
            }
            if (spawnPoint == null) {
                for (Map.Entry<String, SpawnPoint> entry : map.entrySet()) {
                    if (entry.getValue().getWorlds().isEmpty() || !entry.getValue().getWorlds().contains(player.getWorld())) continue;
                    spawnPoint = entry.getValue().getLocation();
                    break;
                }
            }
            if (spawnPoint != null) {
                return spawnPoint.clone();
            }
        }
        if ((spawnPoint = map.get(defaultG)) != null) {
            return spawnPoint.getLocation().clone();
        }
        return null;
    }

    public static CMILocation getGroupReSpawnPoint(Player player) {
        SpawnPoint spawnPoint;
        if (player != null) {
            spawnPoint = null;
            for (Map.Entry<String, SpawnPoint> entry : map.entrySet()) {
                if (entry.getKey().equals(defaultG) || entry.getKey().startsWith(defaultGW) || !entry.getValue().isRespawn() || !PermissionsManager.CMIPerm.respawngroup_$1.hasPermission((CommandSender)player, entry.getKey())) continue;
                if (!entry.getValue().getWorlds().isEmpty()) {
                    if (!entry.getValue().getWorlds().contains(player.getWorld())) continue;
                    spawnPoint = entry.getValue().getLocation();
                    break;
                }
                spawnPoint = entry.getValue().getLocation();
                break;
            }
            if (spawnPoint == null) {
                for (Map.Entry<String, SpawnPoint> entry : map.entrySet()) {
                    if (entry.getValue().getWorlds().isEmpty() || !entry.getValue().isRespawn() || !entry.getValue().getWorlds().contains(player.getWorld())) continue;
                    spawnPoint = entry.getValue().getLocation();
                    break;
                }
            }
            if (spawnPoint != null) {
                return spawnPoint;
            }
        }
        if ((spawnPoint = map.get(defaultG)) != null && spawnPoint.isRespawn()) {
            return spawnPoint.getLocation();
        }
        return null;
    }

    public static void save() {
        File file = new File(CMI.getInstance().getDataFolder(), "config.yml");
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
        yamlConfiguration.options().copyDefaults(true);
        for (Map.Entry<String, SpawnPoint> entry : map.entrySet()) {
            String string = entry.getKey();
            if (string.equals(defaultG)) {
                SpawnUtil.setToConfig(yamlConfiguration, "Spawn.Main", entry.getValue());
                continue;
            }
            String string2 = "Spawn.Groups." + string;
            SpawnUtil.setToConfig(yamlConfiguration, string2, entry.getValue());
        }
        try {
            yamlConfiguration.save(file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        CMI.getInstance().getConfigManager().load();
    }

    private static void setToConfig(YamlConfiguration yamlConfiguration, String string, SpawnPoint spawnPoint) {
        yamlConfiguration.set(string, null);
        string = String.valueOf(string) + ".";
        yamlConfiguration.set(String.valueOf(string) + "Location", (Object)CMILocation.toString((Location)spawnPoint.getLocation()));
        yamlConfiguration.set(String.valueOf(string) + "RespawnLocation", (Object)spawnPoint.isRespawn());
        yamlConfiguration.set(String.valueOf(string) + "Rng", (Object)spawnPoint.getRng());
        if (!spawnPoint.getWorlds().isEmpty()) {
            yamlConfiguration.set(String.valueOf(string) + "TeleportFrom", spawnPoint.getWorldsAsStringList());
        }
    }

    public static void loadConfig() {
        double d;
        double d2;
        Object object;
        ConfigReader configReader = CMI.getInstance().getConfigManager().getConfig();
        configReader.addComment("Spawn.SpawnOnJoin", new String[]{"Forces players to login in defined spawn point when logging into server", "Can be bypasses with " + PermissionsManager.CMIPerm.spawnonjoin_bypass.getPermission() + " permission node"});
        SpawnSpawnOnJoin = configReader.get("Spawn.SpawnOnJoin", Boolean.valueOf(false));
        configReader.addComment("Spawn.IgnoredWorlds", new String[]{"List of worlds which should be ignored and players joining in those servers will not be teleported to appropriate spawn point but will login at their log out location"});
        List list2 = configReader.get("Spawn.IgnoredWorlds", new ArrayList());
        CMIList.toLowerCase((List)list2);
        ignoredSpawnWorlds.clear();
        ignoredSpawnWorlds.addAll(list2);
        configReader.addComment("Spawn.Main", new String[]{"Defines players spawn point after death if set to true, if not, then it will be used only for /cmi spawn command", "RespawnLocation will indicate if you want to use this location as possible respawn point for player after death", "TeleportFrom will indicate list of worlds from which player should be teleported to this spawn point"});
        CMILocation cMILocation = null;
        if (configReader.getC().isString("Spawn.Main.World")) {
            object = configReader.get("Spawn.Main.World", "None");
            double d3 = configReader.get("Spawn.Main.X", Double.valueOf(0.0));
            double d4 = configReader.get("Spawn.Main.Y", Double.valueOf(0.0));
            double d5 = configReader.get("Spawn.Main.Z", Double.valueOf(0.0));
            d2 = configReader.get("Spawn.Main.Pitch", Double.valueOf(0.0));
            d = configReader.get("Spawn.Main.Yaw", Double.valueOf(0.0));
            cMILocation = new CMILocation((String)object, d3, d4, d5);
            cMILocation.setPitch((float)d2);
            cMILocation.setYaw((float)d);
        } else {
            cMILocation = CMILocation.fromString((String)configReader.get("Spawn.Main.Location", ""));
        }
        object = configReader.get("Spawn.Main.RespawnLocation", Boolean.valueOf(false));
        Integer n = configReader.get("Spawn.Main.Rng", 0);
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(configReader.get("Spawn.Main.TeleportFrom", new ArrayList()));
        if (cMILocation != null && !cMILocation.getWorldName().equalsIgnoreCase("none")) {
            SpawnUtil.addNew(null, cMILocation, ((Boolean)object).booleanValue(), n, hashSet);
        }
        try {
            if (configReader.getC().isConfigurationSection("Spawn.Groups")) {
                for (String string : configReader.getC().getConfigurationSection("Spawn.Groups").getKeys(false)) {
                    hashSet = new HashSet();
                    String string2 = "Spawn.Groups." + string + ".";
                    cMILocation = null;
                    if (configReader.getC().isString(String.valueOf(string2) + "World")) {
                        String string3 = configReader.get(String.valueOf(string2) + "World", "None");
                        d2 = configReader.get(String.valueOf(string2) + "X", Double.valueOf(0.0));
                        d = configReader.get(String.valueOf(string2) + "Y", Double.valueOf(0.0));
                        double d6 = configReader.get(String.valueOf(string2) + "Z", Double.valueOf(0.0));
                        double d7 = configReader.get(String.valueOf(string2) + "Pitch", Double.valueOf(0.0));
                        double d8 = configReader.get(String.valueOf(string2) + "Yaw", Double.valueOf(0.0));
                        cMILocation = new CMILocation(string3, d2, d, d6);
                        cMILocation.setPitch((float)d7);
                        cMILocation.setYaw((float)d8);
                    } else {
                        cMILocation = CMILocation.fromString((String)configReader.get(String.valueOf(string2) + "Location", ""));
                    }
                    object = configReader.get(String.valueOf(string2) + "RespawnLocation", Boolean.valueOf(false));
                    if (configReader.getC().isInt(String.valueOf(string2) + "Rng")) {
                        n = configReader.get(String.valueOf(string2) + "Rng", 0);
                    }
                    if (configReader.getC().isList(String.valueOf(string2) + "TeleportFrom")) {
                        hashSet.addAll(configReader.get(String.valueOf(string2) + "TeleportFrom", new ArrayList()));
                    }
                    if (cMILocation == null || cMILocation.getWorldName().equalsIgnoreCase("none")) continue;
                    SpawnUtil.addNew(string, cMILocation, ((Boolean)object).booleanValue(), n, hashSet);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isSpawnSpawnOnJoin() {
        return SpawnSpawnOnJoin;
    }

    public static Set<String> getIgnoredSpawnWorlds() {
        return ignoredSpawnWorlds;
    }

    public static boolean isIgnoresSpawnWorld(String string) {
        if (ignoredSpawnWorlds.isEmpty()) {
            return false;
        }
        return ignoredSpawnWorlds.contains(string.toLowerCase());
    }

    public static class SpawnPoint {
        private String group;
        private CMILocation location;
        private boolean respawn = false;
        private Integer rng = null;
        private List<World> worlds;
        private Set<String> worldNames = null;

        public SpawnPoint(String string, CMILocation cMILocation, boolean bl) {
            this(string, cMILocation, bl, null, new ArrayList<World>());
        }

        public SpawnPoint(String string, CMILocation cMILocation, boolean bl, Integer n) {
            this(string, cMILocation, bl, n, new ArrayList<World>());
        }

        public SpawnPoint(String string, CMILocation cMILocation, boolean bl, Integer n, List<World> list2) {
            this.group = string;
            this.location = cMILocation;
            this.respawn = bl;
            this.rng = n;
            this.worlds = list2;
        }

        public SpawnPoint(String string, CMILocation cMILocation, boolean bl, Integer n, Set<String> set) {
            this.group = string;
            this.location = cMILocation;
            this.respawn = bl;
            this.rng = n;
            this.worldNames = set;
        }

        public String getGroup() {
            return this.group;
        }

        public void setGroup(String string) {
            this.group = string;
        }

        public CMILocation getLocation() {
            if (this.rng != null && this.rng > 0) {
                Random random = new Random(System.currentTimeMillis());
                double d = (double)(random.nextInt(this.rng * 10 * 2) - this.rng * 10) / 10.0;
                double d2 = (double)(random.nextInt(this.rng * 10 * 2) - this.rng * 10) / 10.0;
                return new CMILocation(this.location.clone().add(d, 0.0, d2));
            }
            return this.location;
        }

        public void setLocation(CMILocation cMILocation) {
            this.location = cMILocation;
        }

        public boolean isRespawn() {
            return this.respawn;
        }

        public void setRespawn(boolean bl) {
            this.respawn = bl;
        }

        public Integer getRng() {
            return this.rng;
        }

        public void setRng(Integer n) {
            this.rng = n;
        }

        public List<World> getWorlds() {
            if (this.worlds == null) {
                this.worlds = new ArrayList<World>();
                if (this.worldNames != null) {
                    for (String string : this.worldNames) {
                        World world2 = CMI.getInstance().getUtilManager().getWorld(string);
                        if (world2 == null) continue;
                        this.worlds.add(world2);
                    }
                    this.worldNames = null;
                }
            }
            return this.worlds;
        }

        public List<String> getWorldsAsStringList() {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (!this.getWorlds().isEmpty()) {
                for (World world2 : this.getWorlds()) {
                    if (world2 == null) continue;
                    arrayList.add(world2.getName());
                }
            }
            return arrayList;
        }

        public void setWorlds(List<World> list2) {
            this.worlds = list2;
        }
    }
}

