/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.utils;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Modules.ModuleHandling.CMIModule;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import net.Zrips.CMILib.Colors.CMIChatColor;
import net.Zrips.CMILib.FileHandler.ConfigReader;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.Bukkit;
import org.bukkit.ServerLinks;
import org.bukkit.plugin.Plugin;

public class ServerLinksManager {
    public static void save() {
        if (Version.isCurrentLower((Version)Version.v1_21_R1)) {
            return;
        }
        ConfigReader configReader = null;
        try {
            configReader = new ConfigReader((Plugin)CMI.getInstance(), "Saves" + File.separator + "serverLinks.yml");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (configReader == null) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ServerLinks.ServerLink serverLink : Bukkit.getServerLinks().getLinks()) {
            arrayList.add(String.valueOf(CMIChatColor.deColorize((String)serverLink.getDisplayName())) + ";" + serverLink.getUrl().toString());
        }
        configReader.set("Links", arrayList);
        configReader.save();
    }

    public static void load() {
        if (Version.isCurrentLower((Version)Version.v1_21_R1)) {
            return;
        }
        if (!CMIModule.serverLinks.isEnabled()) {
            return;
        }
        File file = new File(CMI.getInstance().getDataFolder(), "Saves" + File.separator + "serverLinks.yml");
        if (!file.exists()) {
            return;
        }
        Long l = System.currentTimeMillis();
        ConfigReader configReader = null;
        try {
            configReader = new ConfigReader(file);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (configReader == null) {
            return;
        }
        if (!configReader.getC().isList("Links")) {
            return;
        }
        Bukkit.getServerLinks().getLinks().forEach(serverLink -> {
            boolean bl = Bukkit.getServerLinks().removeLink(serverLink);
        });
        for (String string : configReader.getC().getStringList("Links")) {
            String[] stringArray;
            if (!string.contains(";") || (stringArray = string.split(";", 2)).length < 2) continue;
            String string2 = stringArray[1];
            if (!string2.startsWith("http://") && !string2.startsWith("https://")) {
                string2 = "http://" + string2;
            }
            try {
                Bukkit.getServerLinks().addLink(CMIChatColor.translate((String)stringArray[0]), new URI(string2));
            }
            catch (URISyntaxException uRISyntaxException) {
                uRISyntaxException.printStackTrace();
            }
        }
        Bukkit.getOnlinePlayers().forEach(player -> player.sendLinks(Bukkit.getServerLinks()));
        CMI.getInstance().loadMessage(Bukkit.getServerLinks().getLinks().size(), "Server links", System.currentTimeMillis() - l);
    }
}

