/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.utils;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMILwc;
import java.io.File;
import java.util.HashMap;
import java.util.UUID;
import net.Zrips.CMILib.FileHandler.ConfigReader;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import net.Zrips.CMILib.Version.Schedulers.CMITask;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.plugin.java.JavaPlugin;

public class Purge {
    private CMITask purgeId = null;
    public boolean running = false;
    private CMI plugin;
    HashMap<PurgeType, Integer> map = new HashMap();
    private boolean CleanOnStart;
    private int OfflineDays;
    private boolean PlayerDataEnabled;
    private String PlayerDataSourceFolder;
    private boolean PlayerDataDeleteFiles;
    private String PlayerDataDestinationFolder;
    private boolean PlayerStatsEnabled;
    private String PlayerStatsSourceFolder;
    private boolean PlayerStatsDeleteFiles;
    private String PlayerStatsDestinationFolder;
    private boolean PlayerAdvancementsEnabled;
    private String PlayerAdvancementsSourceFolder;
    private boolean PlayerAdvancementsDeleteFiles;
    private String PlayerAdvancementsDestinationFolder;
    private boolean EssentialsEnabled;
    private String EssentialsSourceFolder;
    private boolean EssentialsDeleteFiles;
    private String EssentialsDestinationFolder;
    private boolean LwcEnabled;
    private static OfflinePlayer[] offPlayers;
    private static int x;
    private static int count;

    static {
        x = 0;
        count = 0;
    }

    public Purge(CMI cMI) {
        this.plugin = cMI;
        this.fillZero();
    }

    public void loadConfig() {
        ConfigReader configReader = this.plugin.getConfigManager().getConfig();
        configReader.addComment("purge", new String[]{"Removeuser command will use same configurations when removing player data files or moving them to new place"});
        configReader.addComment("purge.CleanOnStart", new String[]{"Cleans files on server startup"});
        this.CleanOnStart = configReader.get("purge.CleanOnStart", Boolean.valueOf(false));
        configReader.addComment("purge.OfflineDays", new String[]{"How long player should be offline for his data to be moved"});
        this.OfflineDays = configReader.get("purge.OfflineDays", 90);
        configReader.addComment("purge.PlayerData.Enabled", new String[]{"Do you want to enable player data file cleaning"});
        this.PlayerDataEnabled = configReader.get("purge.PlayerData.Enabled", Boolean.valueOf(true));
        configReader.addComment("purge.PlayerData.SourceFolder", new String[]{"Source folder to take files from"});
        this.PlayerDataSourceFolder = configReader.get("purge.PlayerData.SourceFolder", String.valueOf(((World)Bukkit.getWorlds().get(0)).getName()) + File.separator + "playerdata");
        configReader.addComment("purge.PlayerData.DeleteFiles", new String[]{"When this is false, data files will be moved to backup folder. When its true files will be deleted"});
        this.PlayerDataDeleteFiles = configReader.get("purge.PlayerData.DeleteFiles", Boolean.valueOf(false));
        configReader.addComment("purge.PlayerData.DestinationFolder", new String[]{"Target folder to put files into if DeleteFiles set to false"});
        this.PlayerDataDestinationFolder = configReader.get("purge.PlayerData.DestinationFolder", String.valueOf(((World)Bukkit.getWorlds().get(0)).getName()) + File.separator + "playerdata_backup");
        configReader.addComment("purge.PlayerStats.Enabled", new String[]{"Do you want to enable player stats file cleaning"});
        this.PlayerStatsEnabled = configReader.get("purge.PlayerStats.Enabled", Boolean.valueOf(true));
        configReader.addComment("purge.PlayerStats.SourceFolder", new String[]{"Source folder to take files from"});
        this.PlayerStatsSourceFolder = configReader.get("purge.PlayerStats.SourceFolder", String.valueOf(((World)Bukkit.getWorlds().get(0)).getName()) + File.separator + "stats");
        configReader.addComment("purge.PlayerStats.DeleteFiles", new String[]{"When this is false, data files will be moved to backup folder. When its true files will be deleted"});
        this.PlayerStatsDeleteFiles = configReader.get("purge.PlayerStats.DeleteFiles", Boolean.valueOf(false));
        configReader.addComment("purge.PlayerStats.DestinationFolder", new String[]{"Target folder to put files into if DeleteFiles set to false"});
        this.PlayerStatsDestinationFolder = configReader.get("purge.PlayerStats.DestinationFolder", String.valueOf(((World)Bukkit.getWorlds().get(0)).getName()) + File.separator + "stats_backup");
        configReader.addComment("purge.PlayerAdvancements.Enabled", new String[]{"Do you want to enable player Advancements file cleaning"});
        this.PlayerAdvancementsEnabled = configReader.get("purge.PlayerAdvancements.Enabled", Boolean.valueOf(true));
        configReader.addComment("purge.PlayerAdvancements.SourceFolder", new String[]{"Source folder to take files from"});
        this.PlayerAdvancementsSourceFolder = configReader.get("purge.PlayerAdvancements.SourceFolder", String.valueOf(((World)Bukkit.getWorlds().get(0)).getName()) + File.separator + "Advancements");
        configReader.addComment("purge.PlayerAdvancements.DeleteFiles", new String[]{"When this is false, data files will be moved to backup folder. When its true files will be deleted"});
        this.PlayerAdvancementsDeleteFiles = configReader.get("purge.PlayerAdvancements.DeleteFiles", Boolean.valueOf(false));
        configReader.addComment("purge.PlayerAdvancements.DestinationFolder", new String[]{"Target folder to put files into if DeleteFiles set to false"});
        this.PlayerAdvancementsDestinationFolder = configReader.get("purge.PlayerAdvancements.DestinationFolder", String.valueOf(((World)Bukkit.getWorlds().get(0)).getName()) + File.separator + "Advancements_backup");
        if (Version.isCurrentLower((Version)Version.v1_12_R1)) {
            this.PlayerAdvancementsEnabled = false;
        }
        configReader.addComment("purge.Essentials.Enabled", new String[]{"Do you want to enable essentials playerdata file cleaning"});
        this.EssentialsEnabled = configReader.get("purge.Essentials.Enabled", Boolean.valueOf(false));
        configReader.addComment("purge.Essentials.SourceFolder", new String[]{"Source folder to take files from"});
        this.EssentialsSourceFolder = configReader.get("purge.Essentials.SourceFolder", "plugins" + File.separator + "Essentials" + File.separator + "userdata");
        configReader.addComment("purge.Essentials.DeleteFiles", new String[]{"When this is false, data files will be moved to backup folder. When its true files will be deleted"});
        this.EssentialsDeleteFiles = configReader.get("purge.Essentials.DeleteFiles", Boolean.valueOf(false));
        configReader.addComment("purge.Essentials.DestinationFolder", new String[]{"Target folder to put files into if DeleteFiles set to false"});
        this.EssentialsDestinationFolder = configReader.get("purge.Essentials.DestinationFolder", "plugins" + File.separator + "Essentials" + File.separator + "userdata_backup");
        configReader.addComment("purge.LWC.Enabled", new String[]{"Do you want to enable lwc protection cleaning"});
        this.LwcEnabled = configReader.get("purge.LWC.Enabled", Boolean.valueOf(false));
    }

    public void initialize() {
        File file;
        if (this.PlayerDataEnabled && !(file = new File(this.PlayerDataDestinationFolder)).exists()) {
            System.out.println("Creating directory: " + file.getParent());
            try {
                file.mkdir();
                System.out.println("DIR created: " + this.PlayerDataDestinationFolder);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (Version.isCurrentEqualOrHigher((Version)Version.v1_12_R1) && this.PlayerAdvancementsEnabled && !(file = new File(this.PlayerAdvancementsDestinationFolder)).exists()) {
            System.out.println("Creating directory: " + file.getParent());
            try {
                file.mkdir();
                System.out.println("DIR created: " + this.PlayerAdvancementsDestinationFolder);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (this.PlayerStatsEnabled && !(file = new File(this.PlayerStatsDestinationFolder)).exists()) {
            System.out.println("Creating directory: " + file.getParent());
            try {
                file.mkdir();
                System.out.println("DIR created: " + this.PlayerStatsDestinationFolder);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (this.EssentialsEnabled && !(file = new File(this.EssentialsDestinationFolder)).exists()) {
            System.out.println("Creating directory: " + file.getParent());
            try {
                file.mkdir();
                System.out.println("DIR created: " + this.EssentialsDestinationFolder);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        this.fillZero();
        CMIScheduler.runTaskAsynchronously((JavaPlugin)this.plugin, () -> {
            this.plugin.getPurgeManager().running = true;
            this.StartingPurge();
        });
    }

    private void fillZero() {
        this.map.clear();
        PurgeType[] purgeTypeArray = PurgeType.values();
        int n = purgeTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            PurgeType purgeType = purgeTypeArray[n2];
            this.map.put(purgeType, 0);
            ++n2;
        }
    }

    public void StartingPurge() {
        offPlayers = Bukkit.getOfflinePlayers();
        x = -1;
        count = 0;
        this.fillZero();
        if (this.purgeId != null) {
            this.purgeId.cancel();
        }
        this.purgeId = CMIScheduler.scheduleSyncRepeatingTask((JavaPlugin)this.plugin, () -> {
            if (!this.running) {
                return;
            }
            if (count >= 100) {
                this.plugin.consoleMessage("&eChecking... &6" + offPlayers.length + "&e/&6" + x);
                count = 0;
            }
            long l = System.currentTimeMillis();
            int n = 0;
            while (n < 10) {
                ++count;
                if (++x >= offPlayers.length) {
                    if (this.purgeId != null) {
                        this.purgeId.cancel();
                    }
                    this.plugin.consoleMessage("&eChecking... &6" + offPlayers.length + "&e/&6" + x);
                    this.plugin.consoleMessage("&eFinished cleaning");
                    this.plugin.consoleMessage("&ePlayer data files removed: &6" + this.map.get((Object)PurgeType.PlayerData) + " &eKeeping: &6" + (offPlayers.length - this.map.get((Object)PurgeType.PlayerData)));
                    if (this.map.get((Object)PurgeType.PlayerStat) > 0) {
                        this.plugin.consoleMessage("&ePlayer stat files removed: &6" + this.map.get((Object)PurgeType.PlayerStat));
                    }
                    if (this.map.get((Object)PurgeType.PlayerAdvancements) > 0) {
                        this.plugin.consoleMessage("&ePlayer advancements files removed: &6" + this.map.get((Object)PurgeType.PlayerAdvancements));
                    }
                    if (this.map.get((Object)PurgeType.Essentials) > 0) {
                        this.plugin.consoleMessage("&eEssential data files removed: &6" + this.map.get((Object)PurgeType.Essentials));
                    }
                    if (this.map.get((Object)PurgeType.Lwc) > 0) {
                        this.plugin.consoleMessage("&eLWC protections removed: &6" + this.map.get((Object)PurgeType.Lwc));
                    }
                    return;
                }
                OfflinePlayer offlinePlayer = offPlayers[x];
                if (!offlinePlayer.isOnline()) {
                    long l2 = offlinePlayer.getLastPlayed();
                    int n2 = (int)((l - l2) / 1000L / 60L / 60L / 24L);
                    if (l2 <= 0L || n2 >= this.OfflineDays) {
                        UUID uUID = offlinePlayer.getUniqueId();
                        this.purgePlayerDataFiles(uUID, true);
                        this.purgePlayerStatsFiles(uUID, true);
                        this.purgePlayerAdvancementsFiles(uUID, true);
                        this.purgeEssentialsFiles(uUID);
                        this.purgeLWC(uUID);
                    }
                }
                ++n;
            }
        }, (long)2L, (long)2L);
    }

    private void addValue(PurgeType purgeType) {
        this.addValue(purgeType, 1);
    }

    private void addValue(PurgeType purgeType, int n) {
        this.map.put(purgeType, this.map.get((Object)purgeType) + n);
    }

    public boolean purgePlayerAdvancementsFiles(UUID uUID, boolean bl) {
        if (Version.isCurrentEqualOrLower((Version)Version.v1_11_R1) || !this.PlayerAdvancementsEnabled && bl) {
            return false;
        }
        File file = new File(String.valueOf(this.PlayerAdvancementsSourceFolder) + File.separator + uUID + ".json");
        if (!file.exists()) {
            return false;
        }
        if (!this.PlayerAdvancementsDeleteFiles) {
            file.renameTo(new File(String.valueOf(this.PlayerAdvancementsDestinationFolder) + File.separator + file.getName()));
        } else {
            file.delete();
        }
        this.addValue(PurgeType.PlayerAdvancements);
        return true;
    }

    public boolean purgePlayerDataFiles(UUID uUID, boolean bl) {
        if (!this.PlayerDataEnabled && bl) {
            return false;
        }
        File file = new File(String.valueOf(this.PlayerDataSourceFolder) + File.separator + uUID + ".dat");
        if (!file.exists()) {
            return false;
        }
        if (!this.PlayerDataDeleteFiles) {
            File file2 = new File(String.valueOf(this.PlayerDataDestinationFolder) + File.separator + file.getName());
            if (file2.exists()) {
                file2.delete();
            }
            file.renameTo(file2);
        } else {
            file.delete();
        }
        this.addValue(PurgeType.PlayerData);
        return true;
    }

    public boolean purgePlayerStatsFiles(UUID uUID, boolean bl) {
        if (!this.PlayerStatsEnabled && bl) {
            return false;
        }
        File file = new File(String.valueOf(this.PlayerStatsSourceFolder) + File.separator + uUID + ".json");
        if (!file.exists()) {
            return false;
        }
        if (!this.PlayerStatsDeleteFiles) {
            File file2 = new File(String.valueOf(this.PlayerStatsDestinationFolder) + File.separator + file.getName());
            if (file2.exists()) {
                file2.delete();
            }
            file.renameTo(file2);
        } else {
            file.delete();
        }
        this.addValue(PurgeType.PlayerStat);
        return true;
    }

    public void purgeEssentialsFiles(UUID uUID) {
        if (!this.EssentialsEnabled) {
            return;
        }
        File file = new File(String.valueOf(this.EssentialsSourceFolder) + File.separator + uUID + ".yml");
        if (!file.exists()) {
            return;
        }
        if (!this.EssentialsDeleteFiles) {
            File file2 = new File(String.valueOf(this.EssentialsDestinationFolder) + File.separator + file.getName());
            if (file2.exists()) {
                file2.delete();
            }
            file.renameTo(file2);
        } else {
            file.delete();
        }
        this.addValue(PurgeType.Essentials);
    }

    public void purgeLWC(UUID uUID) {
        if (!this.LwcEnabled) {
            return;
        }
        if (CMILwc.getLWC() == null) {
            return;
        }
        int n = CMILwc.getLWC().getPhysicalDatabase().removeProtectionsByPlayer(uUID.toString());
        this.addValue(PurgeType.Lwc, n);
    }

    public boolean isCleanOnStart() {
        return this.CleanOnStart;
    }

    public boolean isPlayerDataEnabled() {
        return this.PlayerDataEnabled;
    }

    public boolean isPlayerStatsEnabled() {
        return this.PlayerStatsEnabled;
    }

    public static enum PurgeType {
        PlayerData,
        PlayerStat,
        PlayerAdvancements,
        Essentials,
        Lwc;

    }
}

