/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.commands.list;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Locale.CMILC;
import com.Zrips.CMI.commands.CAnnotation;
import com.Zrips.CMI.commands.Cmd;
import com.Zrips.CMI.utils.CMIDiskUsage;
import com.Zrips.CMI.utils.Lag;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.Zrips.CMILib.FileHandler.ConfigReader;
import net.Zrips.CMILib.Locale.LC;
import net.Zrips.CMILib.Logs.CMIDebug;
import net.Zrips.CMILib.RawMessages.RawMessage;
import net.Zrips.CMILib.Version.PaperMethods.PaperLib;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;

public class status
implements Cmd {
    static final DecimalFormat df = new DecimalFormat("0.00");
    private static String javaVersion = null;

    @Override
    public void getExtra(ConfigReader configReader) {
        configReader.get("Platform", " &ePlatform: &6[platform] &e(&6[os]&e) &eRunning threads: &6[threads]");
        configReader.get("Tps", " &eTPS: &6[tps]");
        configReader.get("CpuUsage", " &eCpu usage: &6[cpuusage]% &e(&6[cores] cores&e)");
        configReader.get("Uptime.main", " &eUptime: ");
        configReader.get("Uptime.weeks", "&e[weeks] &6weeks ");
        configReader.get("Uptime.days", "&e[days] &6days ");
        configReader.get("Uptime.hours", "&e[hours] &6hours ");
        configReader.get("Uptime.mins", "&e[mins] &6mins ");
        configReader.get("Uptime.secs", "&e[secs] &6secs ");
        configReader.get("MemoryUsage", " &eMemory usage: &6[percent]% &e(&6[current]&e/&6[max] MB&e)");
        configReader.get("MemoryUsageHover", "&fFree: &7[free] \n&fAllocated: &7[allocated] \n&fMax: &7[max] \n&fTotal: &7[total]");
        configReader.get("Java", " &eJava version: &6[mainV].[majorV].[minorV]&e(&6[update]&e) Build: &6[build]");
        configReader.get("DiskUsage", " &eDisk usage: &6[percent]% &e(&6[current]&e/&6[max] GB&e)");
        configReader.get("Worlds", "&e [number]. &6[world] &e[chunks] Chunks &6[entities] Entities &e[tiles] tiles &6[players] players");
        configReader.get("MostTiles", "&7Most tiles (&f[tiles]&7) in &f[coord] &7chunk");
        configReader.get("MostEntities", "&7Most entities (&f[entities]&7) in &f[coord] &7chunk");
    }

    private static void showPendingTasks() {
        if (!Version.isTestServer()) {
            return;
        }
        CMIDebug.d((Object[])new Object[]{"Pending Tasks:", Bukkit.getScheduler().getPendingTasks().size()});
        HashMap hashMap = new HashMap();
        new ArrayList<BukkitTask>(Bukkit.getScheduler().getPendingTasks()).forEach(bukkitTask -> {
            String string = "Unknown";
            try {
                string = bukkitTask.getOwner().getName();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            hashMap.merge(string, 1, Integer::sum);
        });
        List list2 = hashMap.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).collect(Collectors.toList());
        for (Map.Entry entry : list2) {
            CMIDebug.d((Object[])new Object[]{String.valueOf((String)entry.getKey()) + ": " + entry.getValue()});
        }
    }

    @Override
    @CAnnotation(priority=257, info="&eShow server status", regVar={0}, consoleVar={0}, customAlias={"gc", "!lag"}, others=false)
    public Boolean perform(CMI cMI, CommandSender commandSender, String[] stringArray) {
        status status2 = this;
        CMIScheduler.runTaskAsynchronously((JavaPlugin)cMI, () -> {
            status.showPendingTasks();
            RawMessage rawMessage = new RawMessage();
            if (!(commandSender instanceof Player)) {
                rawMessage.addText("\n");
            }
            rawMessage.addText(LC.info_Spliter.getLocale(new Object[0]));
            try {
                OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
                int n = operatingSystemMXBean.getAvailableProcessors();
                rawMessage.addText("\n");
                rawMessage.addText(CMILC.getIM(status2, "Platform", "[platform]", operatingSystemMXBean.getArch(), "[os]", operatingSystemMXBean.getName(), "[threads]", Thread.getAllStackTraces().keySet().size()));
                if (commandSender instanceof Player) {
                    rawMessage.addText("\n");
                    rawMessage.addText(CMILC.getIM(status2, "Tps", "[tps]", df.format(cMI.getLagMeter().getTPS(20)))).addHover(LC.info_sec.getLocale(new Object[]{"[secs]", 1}));
                    rawMessage.addText(" (" + df.format(cMI.getLagMeter().getTPS(200))).addHover(LC.info_sec.getLocale(new Object[]{"[secs]", 10}));
                    rawMessage.addText(" " + df.format(cMI.getLagMeter().getTPS(600))).addHover(LC.info_sec.getLocale(new Object[]{"[secs]", 30}));
                    rawMessage.addText(" " + df.format(cMI.getLagMeter().getTPS(1200))).addHover(LC.info_min.getLocale(new Object[]{"[mins]", 1}));
                    rawMessage.addText(" " + df.format(cMI.getLagMeter().getTPS(6000)) + ")").addHover(LC.info_min.getLocale(new Object[]{"[mins]", 10}));
                } else {
                    rawMessage.addText("\n");
                    rawMessage.addText(String.valueOf(CMILC.getIM(status2, "Tps", "[tps]", df.format(cMI.getLagMeter().getTPS(20)))) + " (" + df.format(cMI.getLagMeter().getTPS(200)) + " " + df.format(cMI.getLagMeter().getTPS(600)) + " " + df.format(cMI.getLagMeter().getTPS(1200)) + " " + df.format(cMI.getLagMeter().getTPS(6000)) + ")");
                }
                double d = Lag.getProcessCpuLoad();
                rawMessage.addText("\n");
                rawMessage.addText(CMILC.getIM(status2, "CpuUsage", "[cpuusage]", df.format(d), "[cores]", n));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            long l = ManagementFactory.getRuntimeMXBean().getStartTime();
            l = System.currentTimeMillis() - l;
            long l2 = l / 1000L % 60L;
            long l3 = l / 60000L % 60L;
            long l4 = l / 3600000L % 24L;
            long l5 = l / 86400000L % 7L;
            long l6 = l / 604800000L;
            String string = CMILC.getIM(status2, "Uptime.main", new Object[0]);
            if (l6 > 0L) {
                string = String.valueOf(string) + CMILC.getIM(status2, "Uptime.weeks", "[weeks]", l6);
            }
            if (l5 > 0L) {
                string = String.valueOf(string) + CMILC.getIM(status2, "Uptime.days", "[days]", l5);
            }
            if (l4 > 0L) {
                string = String.valueOf(string) + CMILC.getIM(status2, "Uptime.hours", "[hours]", l4);
            }
            if (l3 > 0L) {
                string = String.valueOf(string) + CMILC.getIM(status2, "Uptime.mins", "[mins]", l3);
            }
            if (l2 > 0L) {
                string = String.valueOf(string) + CMILC.getIM(status2, "Uptime.secs", "[secs]", l2);
            }
            rawMessage.addText("\n");
            rawMessage.addText(string);
            Runtime runtime = Runtime.getRuntime();
            long l7 = runtime.maxMemory();
            long l8 = runtime.totalMemory();
            long l9 = runtime.freeMemory();
            long l10 = l7 - (l8 - l9);
            rawMessage.addText("\n");
            rawMessage.addText(CMILC.getIM(status2, "MemoryUsage", "[percent]", df.format(100.0 - (double)l10 * 100.0 / (double)l7), "[current]", df.format((l7 - l10) / 1024L / 1024L), "[max]", l7 / 1024L / 1024L));
            rawMessage.addHover(CMILC.getIM(status2, "MemoryUsageHover", "[free]", df.format(l9 / 1024L / 1024L), "[allocated]", df.format(l8 / 1024L / 1024L), "[total]", df.format(l7 / 1024L / 1024L), "[max]", df.format(l7 / 1024L / 1024L)));
            rawMessage.addText("\n");
            rawMessage.addText(status.getJavaVersionText());
            rawMessage.addText("\n");
            rawMessage.addText(status.getDiskUsageText());
            this.getInfo().thenAccept(hashMap -> {
                int n = 0;
                for (Map.Entry entry : hashMap.entrySet()) {
                    Data data = (Data)entry.getValue();
                    rawMessage.addText("\n");
                    World world2 = (World)entry.getKey();
                    rawMessage.addText(CMILC.getIM(status2, "Worlds", "[number]", ++n, "[world]", world2.getName(), "[chunks]", data.getLoadedChunks(), "[entities]", data.getEntities(), "[tiles]", data.getTileEntities(), "[players]", data.getPlayerCount()));
                    ArrayList<String> arrayList = new ArrayList<String>();
                    if (data.getTileEntities() > 0) {
                        arrayList.add(CMILC.getIM(status.class, "MostTiles", "[tiles]", data.getMostTileEntities(), "[coord]", data.getMostTileEntitiesAt()));
                    }
                    if (data.getMostEntities() > 0) {
                        arrayList.add(CMILC.getIM(status.class, "MostEntities", "[entities]", data.getMostEntities(), "[coord]", data.getMostEntitiesAt()));
                    }
                    if (CMIDebug.isTestServer()) {
                        rawMessage.addSuggestion(world2.getUID().toString());
                    }
                    if (arrayList.isEmpty()) continue;
                    rawMessage.addHover(arrayList);
                }
                rawMessage.addText("\n");
                rawMessage.addText(LC.info_Spliter.getLocale(new Object[0]));
                rawMessage.show(commandSender);
            });
        });
        return true;
    }

    private static String getDiskUsageText() {
        try {
            int n = (int)(CMIDiskUsage.getTotal() / 1024L / 1024L / 1024L);
            int n2 = (int)(CMIDiskUsage.getUsable() / 1024L / 1024L / 1024L);
            String string = df.format((double)(n - n2) * 100.0 / (double)n);
            return CMILC.getIM(status.class, "DiskUsage", "[percent]", string, "[current]", n - n2, "[max]", n);
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    private static String getJavaVersionText() {
        if (javaVersion != null) {
            return javaVersion;
        }
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String[] stringArray = System.getProperty("java.runtime.version").split("\\.|_|-b");
        try {
            string = stringArray[0];
            string2 = stringArray[1];
            string3 = stringArray[2];
            string4 = stringArray[3];
            string5 = stringArray[4];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            try {
                String string6 = System.getProperty("java.version");
                string4 = string6.split("_")[1];
                String[] stringArray2 = string6.split("_")[0].split(".");
                string = stringArray2[0];
                string2 = stringArray2[1];
                string3 = stringArray2[2];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException2) {
                // empty catch block
            }
        }
        javaVersion = CMILC.getIM(status.class, "Java", "[mainV]", string, "[majorV]", string2, "[minorV]", string3, "[update]", string4, "[build]", string5);
        return javaVersion;
    }

    private CompletableFuture<HashMap<World, Data>> getInfo() {
        HashSet<CompletableFuture<Entity[]>> hashSet = new HashSet<CompletableFuture<Entity[]>>();
        LinkedHashMap<Object, Data> linkedHashMap = new LinkedHashMap<Object, Data>();
        block6: for (Object object : Bukkit.getServer().getWorlds()) {
            Data data = new Data(object.getPlayers().size(), object.getLoadedChunks().length);
            linkedHashMap.put(object, data);
            try {
                Chunk[] chunkArray = object.getLoadedChunks();
                int n = chunkArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Chunk chunk = chunkArray[n2];
                    try {
                        hashSet.add(status.getEntitiesFromChunks((World)object, chunk.getX(), chunk.getZ(), data));
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                        continue block6;
                    }
                    ++n2;
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        try {
            Object object;
            object = CompletableFuture.allOf(hashSet.toArray(new CompletableFuture[0]));
            return ((CompletableFuture)object).thenApply(void_ -> linkedHashMap);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return CompletableFuture.completedFuture(linkedHashMap);
        }
    }

    private static CompletableFuture<Entity[]> getEntitiesFromChunks(World world2, int n, int n2, Data data) {
        CompletableFuture completableFuture = PaperLib.getChunkAtAsync((World)world2, (int)n, (int)n2, (boolean)false);
        return completableFuture.thenCompose(chunk -> {
            if (chunk == null) {
                return CompletableFuture.completedFuture(null);
            }
            CompletableFuture completableFuture = new CompletableFuture();
            CMIScheduler.runAtLocation((JavaPlugin)CMI.getInstance(), (Chunk)chunk, () -> {
                try {
                    data.add(n, n2, chunk.getTileEntities().length, chunk.getEntities().length);
                    completableFuture.complete(chunk.getEntities());
                }
                catch (Throwable throwable) {
                    completableFuture.completeExceptionally(throwable);
                }
            });
            return completableFuture;
        });
    }

    class Data {
        private int tileEntities = 0;
        private int entities = 0;
        private int players = 0;
        private int loadedChunks = 0;
        private int mostTileEntities = 0;
        private String mostTileEntitiesAt = "";
        private int mostEntities = 0;
        private String mostEntitiesAt = "";

        public Data(int n, int n2) {
            this.players = n;
            this.loadedChunks = n2;
        }

        public int getTileEntities() {
            return this.tileEntities;
        }

        public int getEntities() {
            return this.entities;
        }

        public void add(int n, int n2, int n3, int n4) {
            if (n3 > this.mostTileEntities) {
                this.mostTileEntities = n3;
                this.mostTileEntitiesAt = String.valueOf(n) + ":" + n2;
            }
            if (n4 > this.mostEntities) {
                this.mostEntities = n4;
                this.mostEntitiesAt = String.valueOf(n) + ":" + n2;
            }
            this.tileEntities += n3;
            this.entities += n4;
        }

        public String getMostTileEntitiesAt() {
            return this.mostTileEntitiesAt;
        }

        public String getMostEntitiesAt() {
            return this.mostEntitiesAt;
        }

        public int getMostTileEntities() {
            return this.mostTileEntities;
        }

        public int getMostEntities() {
            return this.mostEntities;
        }

        public int getPlayerCount() {
            return this.players;
        }

        public int getLoadedChunks() {
            return this.loadedChunks;
        }
    }
}

