/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.commands.list;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Locale.CMILC;
import com.Zrips.CMI.Modules.AStand.ArmorStandManager;
import com.Zrips.CMI.Modules.AStand.ArmorStandSave;
import com.Zrips.CMI.Modules.Permissions.PermissionsManager;
import com.Zrips.CMI.commands.CAnnotation;
import com.Zrips.CMI.commands.Cmd;
import com.Zrips.CMI.commands.CommandsHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import net.Zrips.CMILib.CMILib;
import net.Zrips.CMILib.Chat.ChatEditorObject;
import net.Zrips.CMILib.Chat.ChatMessageObjectEdit;
import net.Zrips.CMILib.Container.CMIText;
import net.Zrips.CMILib.Container.PageInfo;
import net.Zrips.CMILib.FileHandler.ConfigReader;
import net.Zrips.CMILib.GUI.CMIGui;
import net.Zrips.CMILib.GUI.GUIManager;
import net.Zrips.CMILib.Items.CMIMaterial;
import net.Zrips.CMILib.Locale.LC;
import net.Zrips.CMILib.RawMessages.RawMessage;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class armorstand
implements Cmd {
    @Override
    public void getExtra(ConfigReader configReader) {
        configReader.get("cantClick", "&cCant do this. Someone is already editing this armor stand");
        configReader.get("tooFar", "&cArmor stand is too far");
        configReader.get("title", "Editor");
        configReader.get("coordX", "&cX");
        configReader.get("coordY", "&2Y");
        configReader.get("coordZ", "&eZ");
        configReader.get("body", "&7Body rotation: &f[amount]");
        configReader.get("head", "&7Head [coord]&7: &f[amount]");
        configReader.get("torso", "&7Torso [coord]&7: &f[amount]");
        configReader.get("leftArm", "&7Left arm [coord]&7: &f[amount]");
        configReader.get("rightArm", "&7Right arm [coord]&7: &f[amount]");
        configReader.get("leftLeg", "&7Left leg [coord]&7: &f[amount]");
        configReader.get("rightLeg", "&7Right leg [coord]&7: &f[amount]");
        configReader.get("pos", "&7Position [coord]&7: &f[amount]");
        configReader.get("list", "&7[place]. &6[distance] [items]");
        configReader.get("items", "&3[displayName]&e[type]");
        configReader.get("plate", "&7Plate");
        configReader.get("size", "&7Small");
        configReader.get("visible", "&7Visible");
        configReader.get("arms", "&7Visible arms");
        configReader.get("gravity", "&7Gravity");
        configReader.get("glow", "&7Glowing");
        configReader.get("invulnerable", "&7Invulnerable");
        configReader.get("name", "&7Visible name");
        configReader.get("nameEdit", "&7Q click to edit name");
        configReader.get("interactable", "&7Interactable");
        configReader.get("scale", "&7Scale: &f[amount]");
        configReader.get("explanation", "&8Left or right mouse button adjusts value");
        configReader.get("explanation2", "&8Hold shift to make it 10x faster");
        configReader.get("disableGravity", "&eDisable gravity if you want to change this value");
        configReader.get("copyLabel", "&7Open clone picker");
        configReader.get("copyTitle", "&8Pick what you want to clone");
        configReader.get("click", "&eClick armor stand to duplicate it, or punch any block to cancel process");
        configReader.get("canceled", "&eArmorStand copy process cancelled");
        configReader.get("updated", "&eArmorStand updated");
        configReader.get("positionLabel", "&7Open position options");
        configReader.get("saveLabel", "&7Open template saver");
        configReader.get("saveButton", "&7Save");
        configReader.get("saveTitle", "&8Pick what you want to save");
        configReader.get("receivedItem", "&eReceived special armor stand into your inventory");
        configReader.get("armorStandItem", "&7ArmorStand Template: &6[name]");
        ArmorStandManager.armorStandSaveOptions[] armorStandSaveOptionsArray = ArmorStandManager.armorStandSaveOptions.values();
        int n = armorStandSaveOptionsArray.length;
        int n2 = 0;
        while (n2 < n) {
            ArmorStandManager.armorStandSaveOptions armorStandSaveOptions2 = armorStandSaveOptionsArray[n2];
            configReader.get("action." + armorStandSaveOptions2.toString(), "&7" + CMIText.firstToUpperCase((String)armorStandSaveOptions2.toString()));
            ++n2;
        }
    }

    @Override
    @CAnnotation(priority=47, info="&eOpen armor stand editor", args="(last/near)", tab={"last%%near%%list"}, explanation={}, regVar={0, 1, 2}, consoleVar={666}, modules={"armorstand"}, paccess=false, others=false)
    public Boolean perform(CMI cMI, CommandSender commandSender, String[] stringArray) {
        block32: {
            Player player;
            block30: {
                player = (Player)commandSender;
                if (stringArray.length <= 0) break block30;
                switch (stringArray[0].toLowerCase()) {
                    case "list": {
                        if (!PermissionsManager.CMIPerm.command_armorstand_admin.hasPermission(commandSender, true, new String[0])) {
                            return false;
                        }
                        Integer n = null;
                        String[] stringArray2 = stringArray;
                        int n2 = stringArray.length;
                        int n3 = 0;
                        while (n3 < n2) {
                            String string = stringArray2[n3];
                            if (n == null) {
                                try {
                                    n = Integer.parseInt(string);
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                            ++n3;
                        }
                        if (n == null) {
                            n = 1;
                        }
                        return this.processList(player, n);
                    }
                    case "last": {
                        return this.processLast(player);
                    }
                    case "near": {
                        return this.processNear(stringArray, player);
                    }
                }
                if (!CMILib.getInstance().getGUIManager().isOpenedGui(player)) {
                    return false;
                }
                CMIGui cMIGui = CMILib.getInstance().getGUIManager().getGui(player);
                if (stringArray[0].length() == 36) {
                    for (Entity entity : player.getWorld().getNearbyEntities(player.getLocation(), 20.0, 20.0, 20.0)) {
                        if (!entity.getUniqueId().toString().equals(stringArray[0])) continue;
                        if (cMI.getArmorStandManager().isTooFar(player, entity)) {
                            CMILC.info((Object)this, commandSender, "tooFar", new Object[0]);
                            return null;
                        }
                        if (cMIGui != null && cMIGui.getType().equals((Object)GUIManager.CmiInventoryType.ArmorStandEditor) && !cMI.getArmorStandManager().openEditor(player, entity, false)) {
                            return false;
                        }
                        return true;
                    }
                }
                break block32;
            }
            Entity entity = cMI.getUtilManager().getTargetEntity(player, 0.94);
            if (entity == null) {
                LC.info_lookAtEntity.sendMessage((Object)commandSender, new Object[0]);
                return null;
            }
            if (!entity.getType().equals((Object)EntityType.ARMOR_STAND)) {
                return false;
            }
            if (entity.hasMetadata("CMIArmorStandForSit")) {
                return false;
            }
            if (cMI.getArmorStandManager().isBeingEdited(entity.getUniqueId())) {
                CMILC.info((Object)this, commandSender, "cantClick", new Object[0]);
                return null;
            }
            if (cMI.getArmorStandManager().isTooFar(player, entity)) {
                CMILC.info((Object)this, commandSender, "tooFar", new Object[0]);
                return null;
            }
            if (!cMI.getArmorStandManager().openEditor(player, entity, true)) {
                return false;
            }
        }
        return true;
    }

    private Boolean processLast(Player player) {
        Entity entity = CMI.getInstance().getArmorStandManager().getLast(player);
        if (entity == null) {
            return false;
        }
        if (!entity.getType().equals((Object)EntityType.ARMOR_STAND)) {
            return false;
        }
        if (CMI.getInstance().getArmorStandManager().isBeingEdited(entity.getUniqueId())) {
            CMILC.info((Object)this, (CommandSender)player, "cantClick", new Object[0]);
            return null;
        }
        if (CMI.getInstance().getArmorStandManager().isTooFar(player, entity)) {
            CMILC.info((Object)this, (CommandSender)player, "tooFar", new Object[0]);
            return null;
        }
        CMI.getInstance().getArmorStandManager().openEditor(player, entity, false);
        return true;
    }

    private Boolean processList(final Player player, final int n) {
        HashMap<String, ArmorStandSave> hashMap = CMI.getInstance().getArmorStandManager().getSavedArmorStands();
        PageInfo pageInfo = new PageInfo(10, hashMap.size(), n){

            public Boolean pageChange(int n) {
                armorstand.this.processList(player, n);
                return true;
            }
        };
        LC.info_Spliter.sendMessage((Object)player, new Object[0]);
        ArrayList<String> arrayList = new ArrayList<String>(hashMap.keySet());
        ChatMessageObjectEdit chatMessageObjectEdit = new ChatMessageObjectEdit((CommandSender)player, pageInfo);
        int n2 = hashMap.size() - 1;
        while (n2 >= 0) {
            if (pageInfo.isEntryOk()) {
                final ArmorStandSave armorStandSave = hashMap.get(arrayList.get(n2));
                ChatEditorObject chatEditorObject = new ChatEditorObject(armorStandSave.getName()){

                    public void onDelete() {
                        CMI.getInstance().getArmorStandManager().removeSavedArmorStand(armorStandSave.getName());
                        CMI.getInstance().getArmorStandManager().save();
                        armorstand.this.processList(player, n);
                    }

                    public void onClick() {
                        ItemStack itemStack = armorStandSave.createItem();
                        player.getInventory().addItem(new ItemStack[]{itemStack});
                    }
                };
                chatEditorObject.setHover(LC.info_Click.getLocale(new Object[]{armorStandSave.getName()}));
                chatMessageObjectEdit.addline(chatEditorObject);
            }
            --n2;
        }
        chatMessageObjectEdit.setAddNew(false);
        chatMessageObjectEdit.print();
        pageInfo.autoPagination((CommandSender)player, String.valueOf(CommandsHandler.getLabel()) + " " + armorstand.class.getSimpleName() + " list");
        return true;
    }

    private Boolean processNear(String[] stringArray, Player player) {
        Entity entity = null;
        if (stringArray.length == 1 || stringArray[1].length() != 36) {
            TreeMap<Double, Entity> treeMap = CMI.getInstance().getUtilManager().getClosestEntities(player.getLocation(), 10, 2.0, EntityType.ARMOR_STAND);
            if (treeMap == null || treeMap.isEmpty()) {
                return false;
            }
            if (treeMap.size() > 1) {
                int n = 0;
                RawMessage rawMessage = new RawMessage();
                for (Map.Entry<Double, Entity> entry : treeMap.entrySet()) {
                    ++n;
                    if (rawMessage.getFinalLength() > 0) {
                        rawMessage.addText("\n");
                    }
                    ArmorStand armorStand = (ArmorStand)entry.getValue();
                    ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>(Arrays.asList(armorStand.getEquipment().getArmorContents()));
                    arrayList.add(armorStand.getItemInHand());
                    if (Version.isCurrentEqualOrHigher((Version)Version.v1_9_R1)) {
                        arrayList.add(armorStand.getEquipment().getItemInOffHand());
                    }
                    StringBuilder stringBuilder = new StringBuilder();
                    for (ItemStack itemStack : arrayList) {
                        String string;
                        if (itemStack == null || CMIMaterial.isAir((Material)itemStack.getType())) continue;
                        if (!stringBuilder.toString().isEmpty()) {
                            stringBuilder.append(LC.info_ListSpliter.getLocale(new Object[0]));
                        }
                        String string2 = "";
                        ItemMeta itemMeta = itemStack.getItemMeta();
                        if (itemMeta != null && (string = itemMeta.getDisplayName()) != null && !string.isEmpty()) {
                            string2 = string;
                        }
                        stringBuilder.append(CMILC.getIM(this, "items", "[displayName]", string2, "[type]", CMIMaterial.get((ItemStack)itemStack).getName()));
                    }
                    rawMessage.addText(CMILC.getIM(this, "list", "[place]", n, "[distance]", (double)((int)(entry.getKey() * 100.0)) / 100.0, "[items]", stringBuilder.toString()));
                    rawMessage.addHover(LC.info_Click.getLocale(new Object[0]));
                    rawMessage.addCommand(String.valueOf(CommandsHandler.getLabel()) + " " + armorstand.class.getSimpleName() + " near " + entry.getValue().getUniqueId().toString());
                }
                rawMessage.show(player);
                return null;
            }
            entity = treeMap.values().iterator().next();
        } else {
            UUID uUID = UUID.fromString(stringArray[1]);
            for (Entity entity2 : player.getWorld().getNearbyEntities(player.getLocation(), 20.0, 20.0, 20.0)) {
                if (!entity2.getUniqueId().equals(uUID)) continue;
                entity = entity2;
                break;
            }
        }
        if (entity == null || !entity.getType().equals((Object)EntityType.ARMOR_STAND)) {
            return false;
        }
        if (CMI.getInstance().getArmorStandManager().isBeingEdited(entity.getUniqueId())) {
            CMILC.info((Object)this, (CommandSender)player, "cantClick", new Object[0]);
            return null;
        }
        if (CMI.getInstance().getArmorStandManager().isTooFar(player, entity)) {
            CMILC.info((Object)this, (CommandSender)player, "tooFar", new Object[0]);
            return null;
        }
        CMI.getInstance().getArmorStandManager().openEditor(player, entity, true);
        return true;
    }
}

