/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Worlds;

import com.Zrips.CMI.Modules.Worlds.CMIRegion;
import java.util.TreeMap;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;

public class CMIWorld {
    private World world;
    private TreeMap<Integer, CMIRegion> regions = new TreeMap();

    public CMIWorld(Chunk chunk) {
        this.world = chunk.getWorld();
    }

    public CMIWorld(World world2) {
        this.world = world2;
    }

    public World getWorld() {
        return this.world;
    }

    public CMIRegion addRegion(World world2, int n, int n2) {
        CMIRegion cMIRegion = new CMIRegion(world2, n, n2);
        this.regions.put(CMIWorld.coordinatesToPlace(n, n2), cMIRegion);
        return cMIRegion;
    }

    public CMIRegion addRegion(Chunk chunk) {
        CMIRegion cMIRegion = new CMIRegion(chunk);
        this.regions.put(CMIWorld.coordinatesToPlace(chunk.getX() >> 5, chunk.getZ() >> 5), cMIRegion);
        return cMIRegion;
    }

    public void setWorld(World world2) {
        this.world = world2;
    }

    public TreeMap<Integer, CMIRegion> getRegions() {
        return this.regions;
    }

    public void setRegions(TreeMap<Integer, CMIRegion> treeMap) {
        this.regions = treeMap;
    }

    public CMIRegion getRegion(Chunk chunk) {
        return this.getRegionByChunkCoord(chunk.getX(), chunk.getZ());
    }

    public CMIRegion getRegionByChunkCoord(int n, int n2) {
        return this.getRegion(n >> 5, n2 >> 5);
    }

    public CMIRegion getRegion(int n, int n2) {
        Integer n3 = CMIWorld.coordinatesToPlace(n, n2);
        return this.regions.get(n3);
    }

    private static Integer coordinatesToPlace(int n, int n2) {
        return n + n2 * 1024;
    }

    public boolean insideWorldBorder(Location location) {
        try {
            Location location2 = this.world.getWorldBorder().getCenter();
            double d = this.world.getWorldBorder().getSize() / 2.0;
            double d2 = location2.getX() - d;
            double d3 = location2.getX() + d;
            double d4 = location2.getZ() - d;
            double d5 = location2.getZ() + d;
            return location.getX() >= d2 && location.getX() < d3 && location.getZ() >= d4 && location.getZ() < d5;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return true;
        }
    }

    public static int getMinHeight(World world2) {
        if (Version.isCurrentEqualOrLower((Version)Version.v1_16_R3)) {
            return 0;
        }
        return world2.getMinHeight();
    }
}

