/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Warnings;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIJson;
import com.Zrips.CMI.Containers.Snd;
import com.Zrips.CMI.Modules.Warnings.CMIPlayerWarning;
import com.Zrips.CMI.Modules.Warnings.CMIWarningCategory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.Zrips.CMILib.FileHandler.ConfigReader;
import org.bukkit.entity.Player;

public class WarningManager {
    private CMI plugin;
    private LinkedHashMap<Integer, List<String>> commands = new LinkedHashMap();
    private HashMap<String, CMIWarningCategory> Categories = new HashMap();
    private HashMap<UUID, List<CMIPlayerWarning>> warnings = new HashMap();

    @Nullable
    public List<CMIPlayerWarning> getWarnings(UUID uUID) {
        List<CMIPlayerWarning> list2 = this.warnings.get(uUID);
        if (list2 != null) {
            list2.removeIf(cMIPlayerWarning -> cMIPlayerWarning.getGivenAt() + cMIPlayerWarning.getCategory().getLifeTime() < System.currentTimeMillis());
        }
        return list2;
    }

    public List<CMIPlayerWarning> getOrCreateWarnings(UUID uUID2) {
        return this.warnings.computeIfAbsent(uUID2, uUID -> new ArrayList());
    }

    public void setWarnings(UUID uUID, List<CMIPlayerWarning> list2) {
        if (list2 == null || list2.isEmpty()) {
            this.warnings.remove(uUID);
        } else {
            this.warnings.put(uUID, list2);
        }
    }

    public WarningManager(CMI cMI) {
        this.plugin = cMI;
    }

    public String serializeWarnings(List<CMIPlayerWarning> list2) {
        if (list2 == null) {
            return null;
        }
        HashMap hashMap = new HashMap();
        for (CMIPlayerWarning cMIPlayerWarning : list2) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(cMIPlayerWarning.getGivenBy());
            if (cMIPlayerWarning.getCategory() != null && !cMIPlayerWarning.getCategory().getName().equalsIgnoreCase(this.getDefaultCategory().getName())) {
                arrayList.add(cMIPlayerWarning.getCategory().getName());
            }
            if (cMIPlayerWarning.getReason() != null) {
                arrayList.add(cMIPlayerWarning.getReason());
            }
            hashMap.put(cMIPlayerWarning.getGivenAt(), arrayList);
        }
        return CMIJson.serialize(hashMap);
    }

    public List<CMIPlayerWarning> deserializeWarnings(String string) {
        ArrayList<CMIPlayerWarning> arrayList = new ArrayList<CMIPlayerWarning>();
        HashMap<String, Object> hashMap = CMIJson.deserialize(string);
        for (Map.Entry<String, Object> entry : hashMap.entrySet()) {
            long l = 0L;
            List list2 = new ArrayList();
            try {
                l = Long.parseLong(entry.getKey());
                list2 = (List)entry.getValue();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            if (l <= 0L) continue;
            String string2 = !list2.isEmpty() ? (String)list2.get(0) : null;
            String string3 = list2.size() > 1 ? (String)list2.get(1) : null;
            String string4 = list2.size() > 2 ? (String)list2.get(2) : null;
            CMIPlayerWarning cMIPlayerWarning = new CMIPlayerWarning();
            cMIPlayerWarning.setGivenAt(l);
            cMIPlayerWarning.setGivenBy(string2);
            CMIWarningCategory cMIWarningCategory = this.plugin.getWarningManager().getCategory(string3);
            cMIPlayerWarning.setCategory(cMIWarningCategory == null ? this.plugin.getWarningManager().getDefaultCategory() : cMIWarningCategory);
            cMIPlayerWarning.setReason(string4 == null || string4.isEmpty() ? (cMIWarningCategory == null && string3 != null ? string3 : null) : string4);
            arrayList.add(cMIPlayerWarning);
        }
        return arrayList;
    }

    public void loadConfig() {
        Long l = System.currentTimeMillis();
        this.commands.clear();
        this.Categories.clear();
        this.warnings.clear();
        ConfigReader configReader = CMI.getInstance().getConfigManager().getConfig();
        CMIWarningCategory cMIWarningCategory = new CMIWarningCategory("Default");
        configReader.addComment("Warnings.Default", new String[]{"Should be always present. This will be used when category of warning isint being defined when warning player"});
        configReader.addComment("Warnings.Default.LifeTime", new String[]{"Time in seconds for how long this warning applies to player"});
        cMIWarningCategory.setLifeTime((long)configReader.get("Warnings.Default.LifeTime", 86400) * 1000L);
        configReader.addComment("Warnings.Default.Points", new String[]{"Warning point amount player receives for warning"});
        cMIWarningCategory.setPoints(configReader.get("Warnings.Default.Points", 1));
        configReader.addComment("Warnings.Default.DefaultReason", new String[]{"Default reason used when reason is not provided when warning player"});
        cMIWarningCategory.setDefaultReason(configReader.get("Warnings.Default.DefaultReason", "&7Violated server rules"));
        this.Categories.put(cMIWarningCategory.getName().toLowerCase(), cMIWarningCategory);
        if (!configReader.getC().isConfigurationSection("Warnings.Categories")) {
            cMIWarningCategory = new CMIWarningCategory("Swear");
            cMIWarningCategory.setLifeTime((long)configReader.get("Warnings.Categories.Swear.LifeTime", 86400) * 1000L);
            cMIWarningCategory.setPoints(configReader.get("Warnings.Categories.Swear.Points", 3));
            cMIWarningCategory.setDefaultReason(configReader.get("Warnings.Categories.Swear.DefaultReason", "&7Swearing"));
            this.Categories.put(cMIWarningCategory.getName().toLowerCase(), cMIWarningCategory);
            cMIWarningCategory = new CMIWarningCategory("Grief");
            cMIWarningCategory.setLifeTime((long)configReader.get("Warnings.Categories.Grief.LifeTime", 86400) * 1000L);
            cMIWarningCategory.setPoints(configReader.get("Warnings.Categories.Grief.Points", 10));
            cMIWarningCategory.setDefaultReason(configReader.get("Warnings.Categories.Grief.DefaultReason", "&7Griefing"));
            this.Categories.put(cMIWarningCategory.getName().toLowerCase(), cMIWarningCategory);
            cMIWarningCategory = new CMIWarningCategory("Bug");
            cMIWarningCategory.setLifeTime((long)configReader.get("Warnings.Categories.Bug.LifeTime", 86400) * 1000L);
            cMIWarningCategory.setPoints(configReader.get("Warnings.Categories.Bug.Points", 30));
            cMIWarningCategory.setDefaultReason(configReader.get("Warnings.Categories.Bug.DefaultReason", "&7Using bugs"));
            this.Categories.put(cMIWarningCategory.getName().toLowerCase(), cMIWarningCategory);
            cMIWarningCategory = new CMIWarningCategory("Cheat");
            cMIWarningCategory.setLifeTime((long)configReader.get("Warnings.Categories.Cheat.LifeTime", 86400) * 1000L);
            cMIWarningCategory.setPoints(configReader.get("Warnings.Categories.Cheat.Points", 50));
            cMIWarningCategory.setDefaultReason(configReader.get("Warnings.Categories.Cheat.DefaultReason", "&7Using cheats"));
            this.Categories.put(cMIWarningCategory.getName().toLowerCase(), cMIWarningCategory);
        } else {
            for (String string : configReader.getC().getConfigurationSection("Warnings.Categories").getKeys(false)) {
                try {
                    cMIWarningCategory = new CMIWarningCategory(string);
                    cMIWarningCategory.setLifeTime((long)configReader.get("Warnings.Categories." + string + ".LifeTime", 600) * 1000L);
                    cMIWarningCategory.setPoints(configReader.get("Warnings.Categories." + string + ".Points", 5));
                    cMIWarningCategory.setDefaultReason(configReader.get("Warnings.Categories." + string + ".DefaultReason", "&7Violated server rules"));
                    this.Categories.put(cMIWarningCategory.getName().toLowerCase(), cMIWarningCategory);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.plugin.loadMessage(this.Categories.size(), "warning categories", System.currentTimeMillis() - l);
        l = System.currentTimeMillis();
        if (!configReader.getC().isConfigurationSection("Warnings.Perform")) {
            this.commands.put(3, configReader.get("Warnings.Perform.3", Arrays.asList("cmi mute [playerName] 10m", "cmi msg [playerName] !&cMuted for &710 &cminutes for getting &73 &cwarnings!")));
            this.commands.put(5, configReader.get("Warnings.Perform.5", Arrays.asList("cmi kick [playerName] &cKicked for getting 5 warnings!")));
            this.commands.put(10, configReader.get("Warnings.Perform.10", Arrays.asList("cmi tempban [playerName] 5m &cTemporary banned for getting 10 warnings!")));
        } else {
            for (String string : configReader.getC().getConfigurationSection("Warnings.Perform").getKeys(false)) {
                try {
                    this.commands.put(Integer.parseInt(string), configReader.get("Warnings.Perform." + string, Arrays.asList("")));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.plugin.loadMessage(this.commands.size(), "warning commands", System.currentTimeMillis() - l);
    }

    public CMIWarningCategory getDefaultCategory() {
        return this.Categories.get("default");
    }

    public CMIWarningCategory getCategory(String string) {
        if (string == null) {
            return null;
        }
        return this.Categories.get(string.toLowerCase());
    }

    public List<String> getCommandsByWarns(Player player, int n, int n2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Snd snd = new Snd();
        snd.setSource(player);
        snd.setTarget(player);
        Integer n3 = 0;
        for (Map.Entry<Integer, List<String>> entry : this.commands.entrySet()) {
            if (entry.getKey() < n || entry.getKey() > n2 || entry.getKey() <= n3) continue;
            n3 = entry.getKey();
        }
        if (n3 > 0 && this.commands.containsKey(n3)) {
            arrayList.addAll(this.plugin.getLM().updateSnd(snd, new ArrayList<String>((Collection)this.commands.get(n3))));
        }
        return arrayList;
    }

    public List<String> getCommandsByWarns(int n) {
        return this.commands.get(n) != null ? new ArrayList(this.commands.get(n)) : null;
    }

    public HashMap<String, CMIWarningCategory> getCategories() {
        return this.Categories;
    }
}

