/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Vanish;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Containers.CMIVanish;
import com.Zrips.CMI.Containers.Snd;
import com.Zrips.CMI.Locale.CMILC;
import com.Zrips.CMI.Modules.Afk.AfkManager;
import com.Zrips.CMI.Modules.ModuleHandling.CMIModule;
import com.Zrips.CMI.Modules.Permissions.PermissionsManager;
import com.Zrips.CMI.Modules.SilentChest.silentChestListener;
import com.Zrips.CMI.Modules.Statistics.StatsManager;
import com.Zrips.CMI.Modules.Vanish.VanishAction;
import com.Zrips.CMI.commands.list.vanishedit;
import com.Zrips.CMI.events.CMIPlayerUnVanishEvent;
import com.Zrips.CMI.events.CMIPlayerVanishEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.Zrips.CMILib.BossBar.BossBarInfo;
import net.Zrips.CMILib.FileHandler.ConfigReader;
import net.Zrips.CMILib.Messages.CMIMessages;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import net.Zrips.CMILib.Version.Schedulers.CMITask;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarStyle;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class VanishManager {
    private CMI plugin;
    private Set<UUID> vanishedOnlineList = new HashSet<UUID>();
    private Set<UUID> vanishedList = new HashSet<UUID>();
    private HashMap<UUID, CMIVanish> vanishedCache = new HashMap();
    private static final String vanishBossBar = "CMIVanishBossBar";
    public static String defaultString = "";
    private CMITask playtimeSched = null;
    List<CMIUser> playtimeList = new ArrayList<CMIUser>();

    @Nullable
    public CMIVanish getVanish(UUID uUID) {
        return this.vanishedCache.get(uUID);
    }

    public CMIVanish getOrCreateVanish(CMIUser cMIUser) {
        return this.vanishedCache.computeIfAbsent(cMIUser.getUniqueId(), uUID -> new CMIVanish(cMIUser));
    }

    public CMIVanish getOrCreateVanish(UUID uUID) {
        return this.vanishedCache.computeIfAbsent(uUID, uUID2 -> new CMIVanish(CMIUser.getUser(uUID)));
    }

    @Deprecated
    @Nullable
    public CMIVanish getVanishRaw(UUID uUID) {
        return this.vanishedCache.get(uUID);
    }

    public VanishManager(CMI cMI) {
        this.plugin = cMI;
    }

    public Set<UUID> getAllVanished() {
        return this.vanishedList;
    }

    public void addPlayer(CMIUser cMIUser) {
        if (cMIUser == null) {
            return;
        }
        this.addPlayer(cMIUser.getUniqueId());
    }

    public void addPlayer(Player player) {
        if (player == null) {
            return;
        }
        this.addPlayer(player.getUniqueId());
    }

    public void addPlayer(UUID uUID) {
        if (uUID == null) {
            return;
        }
        this.vanishedOnlineList.add(uUID);
        this.vanishedList.add(uUID);
        Player player = CMIUser.getOnlinePlayer(uUID);
        if (player == null) {
            this.vanishedOnlineList.remove(uUID);
            return;
        }
        this.hidePlayerForEveryone(player);
    }

    public boolean nearActivePlayer(Location location) {
        if (this.vanishedOnlineList.isEmpty()) {
            return true;
        }
        boolean bl = false;
        for (UUID serializable2 : this.vanishedOnlineList) {
            Object object = this.plugin.getPlayerManager().getUser(serializable2);
            if (object == null || ((CMIUser)object).getVanishOrNull() == null || !((CMIUser)object).isVanished() || ((CMIUser)object).getVanish().is(VanishAction.mobSpawning)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return true;
        }
        ArrayList<Player> arrayList = new ArrayList<Player>();
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (player == null || !AfkManager.isNear(player.getLocation(), location).booleanValue()) continue;
            arrayList.add(player);
        }
        boolean bl2 = true;
        for (Object object : arrayList) {
            if (object == null) continue;
            CMIUser cMIUser = this.plugin.getPlayerManager().getUser((Player)object);
            if (cMIUser.isAfk()) {
                return true;
            }
            if (cMIUser.getVanishOrNull() == null) continue;
            if (!cMIUser.isVanished() || cMIUser.getVanish().is(VanishAction.mobSpawning)) {
                return true;
            }
            bl2 = false;
        }
        return bl2;
    }

    public void applyVanish(CMIUser cMIUser) {
        this.applyVanish(cMIUser, true, true);
    }

    public void applyVanish(CMIUser cMIUser, boolean bl) {
        this.applyVanish(cMIUser, bl, true);
    }

    public void applyVanish(CMIUser cMIUser, boolean bl, boolean bl2) {
        this.applyVanish(cMIUser, bl, bl2, false);
    }

    public void applyVanish(CMIUser cMIUser, boolean bl, boolean bl2, boolean bl3) {
        if (!cMIUser.isOnline()) {
            return;
        }
        Player player = cMIUser.getPlayer();
        if (player == null) {
            return;
        }
        if (cMIUser.isCMIVanished()) {
            CMIPlayerVanishEvent cMIPlayerVanishEvent = new CMIPlayerVanishEvent(player);
            if (bl) {
                Bukkit.getPluginManager().callEvent((Event)cMIPlayerVanishEvent);
            }
            if (!cMIPlayerVanishEvent.isCancelled() || !bl) {
                if (cMIUser.getVanish().getVanishedFrom() == null) {
                    cMIUser.getVanish().setVanishedFrom(System.currentTimeMillis());
                }
                if (Version.isCurrentEqualOrHigher((Version)Version.v1_9_R1) && player.getPotionEffect(PotionEffectType.NIGHT_VISION) == null) {
                    CMIScheduler.runAtEntity((JavaPlugin)this.plugin, (Entity)player, () -> {
                        if (cMIUser.getVanish().is(VanishAction.nightVision)) {
                            player.removePotionEffect(PotionEffectType.NIGHT_VISION);
                            player.addPotionEffect(new PotionEffect(PotionEffectType.NIGHT_VISION, 864000, 1));
                        } else {
                            player.removePotionEffect(PotionEffectType.NIGHT_VISION);
                        }
                    });
                }
                try {
                    if (cMIUser.getVanish().is(VanishAction.sleepIgnore)) {
                        player.setSleepingIgnored(true);
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                if (Version.isCurrentEqualOrHigher((Version)Version.v1_9_R1)) {
                    CMIScheduler.runTaskLater((JavaPlugin)this.plugin, () -> {
                        if (cMIUser.getVanish().is(VanishAction.bossbar)) {
                            BossBarInfo bossBarInfo;
                            if (bl3) {
                                cMIUser.removeBossBar(vanishBossBar);
                            }
                            if ((bossBarInfo = cMIUser.getBossBar(vanishBossBar)) == null) {
                                bossBarInfo = new BossBarInfo(cMIUser.getPlayer(), vanishBossBar);
                            }
                            bossBarInfo.setPercentage(Double.valueOf(1.0));
                            bossBarInfo.setColor(BarColor.WHITE);
                            bossBarInfo.setStyle(BarStyle.SOLID);
                            bossBarInfo.setAuto(Integer.valueOf(20));
                            bossBarInfo.setTitleOfBar(CMILC.getIM(vanishedit.class, "bossbarTitle", new Object[0]));
                            bossBarInfo.setKeepForTicks(Integer.valueOf(-1));
                            cMIUser.addBossBar(bossBarInfo);
                        } else {
                            BossBarInfo bossBarInfo = cMIUser.getBossBar(vanishBossBar);
                            if (bossBarInfo != null) {
                                bossBarInfo.remove();
                            }
                        }
                    }, (long)2L);
                }
                if (bl2 && cMIUser.getVanish().is(VanishAction.fakeJoinLeave)) {
                    Snd snd = new Snd().setSender(player).setTarget(player);
                    String string = CMILC.info_LogoutCustom.getLocale(snd);
                    string = this.plugin.getPlaceholderAPIManager().updatePlaceHolders(player, string);
                    CMIMessages.broadcastMessage((CommandSender)player, (String)string);
                }
                if (cMIUser.getVanish().is(VanishAction.noisyChest)) {
                    silentChestListener.toggledSilentChest.remove(player.getUniqueId());
                } else {
                    silentChestListener.toggledSilentChest.put(player.getUniqueId(), true);
                }
                if (cMIUser.getVanish().is(VanishAction.stopPlaytime)) {
                    this.addToPlayTimePreventer(cMIUser);
                }
            }
            cMIUser.getVanish().setWasCollidable(cMIUser.isCollidable());
            if (bl3) {
                CMIScheduler.runTaskLater((JavaPlugin)this.plugin, () -> cMIUser.setCollision(false), (long)20L);
            } else {
                cMIUser.setCollision(false);
            }
            if (cMIUser.isOnline()) {
                cMIUser.getPlayer().setMetadata("vanished", (MetadataValue)new FixedMetadataValue((Plugin)CMI.getInstance(), (Object)true));
            }
        } else if (!bl3) {
            CMIPlayerUnVanishEvent cMIPlayerUnVanishEvent = new CMIPlayerUnVanishEvent(player);
            if (bl) {
                Bukkit.getPluginManager().callEvent((Event)cMIPlayerUnVanishEvent);
            }
            if (!cMIPlayerUnVanishEvent.isCancelled() || !bl) {
                Object object;
                if (Version.isCurrentEqualOrHigher((Version)Version.v1_9_R1) && cMIUser.getVanish().is(VanishAction.nightVision) && bl) {
                    CMIScheduler.runAtEntity((JavaPlugin)this.plugin, (Entity)player, () -> player.removePotionEffect(PotionEffectType.NIGHT_VISION));
                }
                if (cMIUser.getVanish().is(VanishAction.bossbar) && (object = cMIUser.getBossBar(vanishBossBar)) != null) {
                    object.remove();
                }
                if (cMIUser.getVanish().is(VanishAction.bossbar) && (object = cMIUser.getBossBar(vanishBossBar)) != null) {
                    object.remove();
                }
                try {
                    if (cMIUser.getVanish().is(VanishAction.sleepIgnore)) {
                        player.setSleepingIgnored(false);
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                if (bl2 && cMIUser.getVanish().is(VanishAction.fakeJoinLeave)) {
                    object = new Snd().setSender(player).setTarget(player);
                    String string = CMILC.info_LoginCustom.getLocale(object);
                    string = this.plugin.getPlaceholderAPIManager().updatePlaceHolders(player, string);
                    CMIMessages.broadcastMessage((CommandSender)player, (String)string);
                }
                if (cMIUser.getGlow() != null) {
                    cMIUser.setGlow(cMIUser.getGlow(), false);
                }
                cMIUser.reapplyNamePlate();
                this.removeFromPlayTimePreventer(cMIUser);
            }
            cMIUser.setCollision(cMIUser.getVanish().getWasCollidable());
            cMIUser.getVanish().setWasCollidable(null);
            silentChestListener.toggledSilentChest.remove(player.getUniqueId());
        }
        this.plugin.getBungeeCordManager().sendNewPlayerInfoToNetwork(player);
    }

    public void loadConfig() {
        defaultString = "";
        ConfigReader configReader = this.plugin.getConfigManager().getConfig();
        configReader.addComment("Vanish.Defaults", new String[]{"Defines default states of vanish edit options for players", "This will not have any effect if player already edited his vanish mode with vanishedit command"});
        VanishAction[] vanishActionArray = VanishAction.values();
        int n = vanishActionArray.length;
        int n2 = 0;
        while (n2 < n) {
            VanishAction vanishAction = vanishActionArray[n2];
            if (!defaultString.isEmpty()) {
                defaultString = String.valueOf(defaultString) + ":";
            }
            defaultString = String.valueOf(defaultString) + (vanishAction.isEnabled() ? "1" : "0");
            if (vanishAction != VanishAction.isVanished) {
                vanishAction.setEnabled(configReader.get("Vanish.Defaults." + vanishAction.toString(), Boolean.valueOf(vanishAction.isEnabled())));
            }
            ++n2;
        }
    }

    public void hideVanishedPlayersFor(Player player) {
        if (player == null) {
            return;
        }
        boolean bl = PermissionsManager.CMIPerm.seevanished.hasPermission((CommandSender)player);
        if (bl) {
            return;
        }
        for (UUID uUID : this.vanishedOnlineList) {
            CMIUser cMIUser = this.plugin.getPlayerManager().getUser(uUID);
            if (cMIUser == null || !cMIUser.isOnline() || uUID.equals(player.getUniqueId()) || !cMIUser.isCMIVanished()) continue;
            player.hidePlayer(cMIUser.getPlayer());
        }
    }

    public void hidePlayerForEveryone(Player player) {
        if (player == null) {
            return;
        }
        this.vanishedOnlineList.add(player.getUniqueId());
        for (Player player2 : Bukkit.getOnlinePlayers()) {
            if (player2.getUniqueId().equals(player.getUniqueId()) || PermissionsManager.CMIPerm.seevanished.hasPermission((CommandSender)player2)) continue;
            player2.hidePlayer(player);
        }
    }

    public void removePlayer(CMIUser cMIUser) {
        if (cMIUser == null) {
            return;
        }
        this.removePlayer(cMIUser.getUniqueId(), true);
    }

    public void removePlayer(Player player) {
        if (player == null) {
            return;
        }
        this.removePlayer(player.getUniqueId(), true);
    }

    public void removePlayer(UUID uUID) {
        this.removePlayer(uUID, true);
    }

    public void removePlayer(UUID uUID, boolean bl) {
        if (uUID == null) {
            return;
        }
        this.vanishedOnlineList.remove(uUID);
        this.vanishedList.remove(uUID);
        Player player = CMIUser.getOnlinePlayer(uUID);
        if (player == null) {
            return;
        }
        if (bl) {
            for (Player player2 : Bukkit.getOnlinePlayers()) {
                if (player2.getUniqueId().equals(uUID)) continue;
                player2.showPlayer(player);
            }
        }
    }

    public Set<UUID> getVanishedOnlineList() {
        return this.vanishedOnlineList;
    }

    public void removeFromPlayTimePreventer(CMIUser cMIUser) {
        this.playtimeList.remove(cMIUser);
    }

    public void addToPlayTimePreventer(CMIUser cMIUser) {
        this.playtimeList.add(cMIUser);
        cMIUser.getVanish().setPlaytimeAtVanishStart(cMIUser.getTotalPlayTime() / 1000L * 1000L);
        this.playTimePreventer();
    }

    private void playTimePreventer() {
        if (this.playtimeSched != null) {
            return;
        }
        if (!CMIModule.vanish.isEnabled()) {
            return;
        }
        this.playtimeSched = CMIScheduler.scheduleSyncRepeatingTask((JavaPlugin)this.plugin, () -> {
            try {
                if (this.playtimeList.isEmpty()) {
                    if (this.playtimeSched != null) {
                        this.playtimeSched.cancel();
                        this.playtimeSched = null;
                    }
                    return;
                }
                ArrayList<CMIUser> arrayList = new ArrayList<CMIUser>(this.playtimeList);
                for (CMIUser cMIUser : arrayList) {
                    if (!cMIUser.isOnline() || !cMIUser.isCMIVanished()) {
                        this.playtimeList.remove(cMIUser);
                        continue;
                    }
                    long l = cMIUser.getVanish().getPlaytimeAtVanishStart();
                    if (l < 1000L) continue;
                    Long l2 = l / 50L;
                    if (CMI.getInstance().getConfigManager().PlayTimeFromStats) {
                        this.plugin.getStatsManager().changeTo(cMIUser.getPlayer(), StatsManager.CMIStatistic.PLAY_ONE_TICK, "none", l2);
                        continue;
                    }
                    cMIUser.getPlayer().setTicksLived(l2.intValue());
                }
            }
            catch (Exception exception) {
                this.playtimeList = new ArrayList<CMIUser>();
                if (this.playtimeSched != null) {
                    this.playtimeSched.cancel();
                    this.playtimeSched = null;
                }
                exception.printStackTrace();
            }
        }, (long)0L, (long)19L);
    }
}

