/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Totems;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Locale.CMILC;
import com.Zrips.CMI.Modules.Permissions.PermissionsManager;
import com.Zrips.CMI.Modules.Teleportations.CMITeleportType;
import com.Zrips.CMI.Modules.Totems.TotemManager;
import com.Zrips.CMI.commands.list.util;
import net.Zrips.CMILib.CMILib;
import net.Zrips.CMILib.Items.CMIMaterial;
import net.Zrips.CMILib.Messages.CMIMessages;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityResurrectEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

public class ResurectionListener
implements Listener {
    private CMI plugin;

    public ResurectionListener(CMI cMI) {
        this.plugin = cMI;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void PlayerInteractEvent(PlayerInteractEvent playerInteractEvent) {
        if (!this.plugin.getTotemManager().isTotemWarmupUse()) {
            return;
        }
        if (playerInteractEvent.getAction() != Action.RIGHT_CLICK_AIR && playerInteractEvent.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Player player = playerInteractEvent.getPlayer();
        if (this.plugin.getTotemManager().isOnWarmup(player)) {
            return;
        }
        if (this.plugin.getTotemManager().isOnCd(player)) {
            return;
        }
        if (!this.removeTotemMainHand(player)) {
            return;
        }
        this.plugin.getTotemManager().addWarmupPlayer(player);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void EntityResurrectEventTotemUse(EntityResurrectEvent entityResurrectEvent) {
        if (entityResurrectEvent.isCancelled()) {
            return;
        }
        if (!this.plugin.getTotemManager().isTotemCooldownUse()) {
            return;
        }
        if (!(entityResurrectEvent.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)entityResurrectEvent.getEntity();
        Long l = this.plugin.getTotemManager().getLeftCd(player, this.plugin.getTotemManager().getTotemCooldownTime());
        if (l > 0L) {
            entityResurrectEvent.setCancelled(true);
            CMILC.info_totem_cantConsume.sendMessage(player, new Object[0]);
            return;
        }
        this.plugin.getTotemManager().addCooldownPlayer(player);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void EntityDamageByEntityEvent(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (!(entityDamageByEntityEvent.getEntity() instanceof Player)) {
            return;
        }
        if (entityDamageByEntityEvent.isCancelled()) {
            return;
        }
        if (!this.plugin.getTotemManager().isTotemRemoveFromInventory() || this.plugin.getTotemManager().isTotemWarmupUse()) {
            return;
        }
        Player player = (Player)entityDamageByEntityEvent.getEntity();
        if (this.plugin.getTotemManager().isTotemRequirePermission() && !PermissionsManager.CMIPerm.totem_frominventory.hasPermission((CommandSender)player)) {
            return;
        }
        double d = entityDamageByEntityEvent.getFinalDamage();
        double d2 = player.getHealth();
        if (d2 - d > 0.0) {
            return;
        }
        if (!ResurectionListener.haveTotem(player)) {
            return;
        }
        EntityResurrectEvent entityResurrectEvent = new EntityResurrectEvent((LivingEntity)player);
        Bukkit.getServer().getPluginManager().callEvent((Event)entityResurrectEvent);
        if (!entityResurrectEvent.isCancelled()) {
            ItemStack itemStack = this.removeTotem(player);
            if (itemStack == null) {
                return;
            }
            entityDamageByEntityEvent.setDamage(0.0);
            if (util.imortaldebug) {
                CMIMessages.consoleMessage((String)"Totem EntityDamageByEntityEvent->EntityDamageByEntityEvent");
            }
            this.plugin.getNMS().showResurection(player);
            player.updateInventory();
            this.plugin.getTotemManager().stopWarmupEffect(player);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void EntityDamageByEntityEventWarmup(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (!(entityDamageByEntityEvent.getEntity() instanceof Player)) {
            return;
        }
        if (!this.plugin.getTotemManager().isTotemWarmupUse()) {
            return;
        }
        Player player = (Player)entityDamageByEntityEvent.getEntity();
        double d = entityDamageByEntityEvent.getFinalDamage();
        double d2 = player.getHealth();
        if (d2 - d > 0.0) {
            return;
        }
        if (!this.plugin.getTotemManager().isOnWarmup(player)) {
            return;
        }
        EntityResurrectEvent entityResurrectEvent = new EntityResurrectEvent((LivingEntity)player);
        Bukkit.getServer().getPluginManager().callEvent((Event)entityResurrectEvent);
        if (!entityResurrectEvent.isCancelled()) {
            if (util.imortaldebug) {
                CMIMessages.consoleMessage((String)"Totem EntityDamageByEntityEventWarmup->EntityDamageByEntityEvent");
            }
            entityDamageByEntityEvent.setCancelled(true);
            this.plugin.getNMS().showResurection(player);
            this.plugin.getTotemManager().stopWarmupEffect(player);
            this.plugin.getTotemManager().removePlayer(player, TotemManager.BossBarType.Warmup);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void EntityDamageEvent(EntityDamageEvent entityDamageEvent) {
        if (entityDamageEvent instanceof EntityDamageByEntityEvent) {
            return;
        }
        if (!(entityDamageEvent.getEntity() instanceof Player)) {
            return;
        }
        if (EntityDamageEvent.DamageCause.SUICIDE.equals((Object)entityDamageEvent.getCause())) {
            return;
        }
        if (entityDamageEvent.isCancelled()) {
            return;
        }
        if (!this.plugin.getTotemManager().isTotemRemoveFromInventory()) {
            return;
        }
        Player player = (Player)entityDamageEvent.getEntity();
        double d = entityDamageEvent.getFinalDamage();
        if (d >= 1000.0) {
            return;
        }
        double d2 = player.getHealth();
        if (d2 - d > 0.0) {
            return;
        }
        if (!ResurectionListener.haveTotem(player)) {
            return;
        }
        EntityResurrectEvent entityResurrectEvent = new EntityResurrectEvent((LivingEntity)player);
        Bukkit.getServer().getPluginManager().callEvent((Event)entityResurrectEvent);
        if (!entityResurrectEvent.isCancelled()) {
            ItemStack itemStack = this.removeTotem(player);
            if (itemStack == null) {
                return;
            }
            if (util.imortaldebug) {
                CMIMessages.consoleMessage((String)"Resurection EntityDamageEvent->EntityDamageEvent");
            }
            entityDamageEvent.setDamage(0.0);
            entityDamageEvent.setCancelled(true);
            if (EntityDamageEvent.DamageCause.VOID.equals((Object)entityDamageEvent.getCause()) && this.plugin.getTotemManager().isTotemProtectFromVoid()) {
                Location location = this.plugin.getHomeManager().getReSpawnLocation(player);
                player.setNoDamageTicks(20);
                if (location != null) {
                    this.plugin.getNMS().showResurection(player);
                    this.plugin.getTotemManager().stopWarmupEffect(player);
                    player.setHealth(d2 + d);
                    this.plugin.getTeleportHandler().teleportPlayer(player, location, CMITeleportType.Totem).thenAccept(cMITeleportFeedback -> {
                        if (!cMITeleportFeedback.isSuccess()) {
                            return;
                        }
                        player.updateInventory();
                    });
                }
            } else {
                this.plugin.getNMS().showResurection(player);
                this.plugin.getTotemManager().stopWarmupEffect(player);
                player.updateInventory();
            }
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void EntityDamageEventWarmup(EntityDamageEvent entityDamageEvent) {
        if (entityDamageEvent instanceof EntityDamageByEntityEvent) {
            return;
        }
        if (!(entityDamageEvent.getEntity() instanceof Player)) {
            return;
        }
        if (EntityDamageEvent.DamageCause.SUICIDE.equals((Object)entityDamageEvent.getCause())) {
            return;
        }
        if (!this.plugin.getTotemManager().isTotemWarmupUse()) {
            return;
        }
        Player player = (Player)entityDamageEvent.getEntity();
        double d = entityDamageEvent.getFinalDamage();
        double d2 = player.getHealth();
        if (d2 - d > 0.0) {
            return;
        }
        if (!this.plugin.getTotemManager().isOnWarmup(player)) {
            return;
        }
        EntityResurrectEvent entityResurrectEvent = new EntityResurrectEvent((LivingEntity)player);
        Bukkit.getServer().getPluginManager().callEvent((Event)entityResurrectEvent);
        if (entityResurrectEvent.isCancelled()) {
            return;
        }
        entityDamageEvent.setCancelled(true);
        if (util.imortaldebug) {
            CMIMessages.consoleMessage((String)"Resurection EntityDamageEventWarmup->EntityDamageEvent");
        }
        if (EntityDamageEvent.DamageCause.VOID.equals((Object)entityDamageEvent.getCause()) && this.plugin.getTotemManager().isTotemProtectFromVoid()) {
            player.setNoDamageTicks(20);
            Location location = this.plugin.getHomeManager().getReSpawnLocation(player);
            if (location != null) {
                this.plugin.getTeleportHandler().teleportPlayer(player, location, CMITeleportType.Totem).thenAccept(cMITeleportFeedback -> {
                    if (!cMITeleportFeedback.isSuccess()) {
                        return;
                    }
                    this.plugin.getNMS().showResurection(player);
                    player.updateInventory();
                    this.plugin.getTotemManager().stopWarmupEffect(player);
                });
            }
        } else {
            this.plugin.getNMS().showResurection(player);
            this.plugin.getTotemManager().stopWarmupEffect(player);
        }
        this.plugin.getTotemManager().removePlayer(player, TotemManager.BossBarType.Warmup);
    }

    public static boolean haveTotem(Player player) {
        ItemStack[] itemStackArray = player.getInventory().getContents();
        int n = itemStackArray.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack itemStack = itemStackArray[n2];
            if (itemStack != null && CMIMaterial.TOTEM_OF_UNDYING.equals(itemStack.getType())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean removeTotemMainHand(Player player) {
        ItemStack itemStack = CMILib.getInstance().getReflectionManager().getItemInMainHand(player);
        if (itemStack != null && CMIMaterial.TOTEM_OF_UNDYING.equals(itemStack.getType())) {
            if (itemStack.getAmount() == 1) {
                CMILib.getInstance().getReflectionManager().setItemInMainHand(player, null);
            } else {
                ItemStack itemStack2 = itemStack.clone();
                itemStack2.setAmount(itemStack.getAmount() - 1);
                CMILib.getInstance().getReflectionManager().setItemInMainHand(player, itemStack2);
            }
            player.updateInventory();
            return true;
        }
        return false;
    }

    private ItemStack removeTotem(Player player) {
        int n = -1;
        ItemStack itemStack = CMILib.getInstance().getReflectionManager().getItemInMainHand(player);
        if (itemStack != null && CMIMaterial.TOTEM_OF_UNDYING.equals(itemStack.getType())) {
            ItemStack itemStack2 = null;
            if (itemStack.getAmount() == 1) {
                CMILib.getInstance().getReflectionManager().setItemInMainHand(player, null);
                itemStack2 = itemStack.clone();
                itemStack2.setAmount(1);
            } else {
                ItemStack itemStack3 = itemStack.clone();
                itemStack3.setAmount(itemStack.getAmount() - 1);
                CMILib.getInstance().getReflectionManager().setItemInMainHand(player, itemStack3);
                itemStack2 = itemStack3.clone();
                itemStack2.setAmount(1);
            }
            player.updateInventory();
            return itemStack2;
        }
        ItemStack[] itemStackArray = player.getInventory().getContents();
        int n2 = itemStackArray.length;
        int n3 = 0;
        while (n3 < n2) {
            ItemStack itemStack4 = itemStackArray[n3];
            ++n;
            if (itemStack4 != null && CMIMaterial.TOTEM_OF_UNDYING.equals(itemStack4.getType())) {
                ItemStack itemStack5 = null;
                if (itemStack4.getAmount() == 1) {
                    player.getInventory().setItem(n, null);
                    itemStack5 = itemStack4.clone();
                    itemStack5.setAmount(1);
                } else {
                    ItemStack itemStack6 = itemStack4.clone();
                    itemStack6.setAmount(itemStack4.getAmount() - 1);
                    player.getInventory().setItem(n, itemStack6);
                    itemStack5 = itemStack6.clone();
                    itemStack5.setAmount(1);
                }
                player.updateInventory();
                return itemStack5;
            }
            ++n3;
        }
        return null;
    }
}

