/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.TimedCommands;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Modules.Permissions.PermissionsManager;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

public class TimedCommandListener
implements Listener {
    private CMI plugin;

    public TimedCommandListener(CMI cMI) {
        this.plugin = cMI;
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerLogOff(PlayerQuitEvent playerQuitEvent) {
        Player player = playerQuitEvent.getPlayer();
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player);
        if (cMIUser == null) {
            return;
        }
        this.plugin.getTimedCommandManager().checkTFly(cMIUser, true);
        this.plugin.getTimedCommandManager().checkTGod(cMIUser, true);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void PlayerLoginEvent(PlayerLoginEvent playerLoginEvent) {
        Player player = playerLoginEvent.getPlayer();
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player);
        if (cMIUser == null) {
            return;
        }
        if (cMIUser.getTgod() > System.currentTimeMillis()) {
            int n = (int)((cMIUser.getTgod() - System.currentTimeMillis()) / 1000L * 20L);
            if (n >= 0) {
                player.setNoDamageTicks(n);
            } else {
                player.setNoDamageTicks(1);
            }
            this.plugin.getTimedCommandManager().addTimed(cMIUser);
        }
        if (cMIUser.getTfly() != 0L) {
            if (cMIUser.getTfly() > System.currentTimeMillis()) {
                this.plugin.getTimedCommandManager().addTimed(cMIUser);
                player.setAllowFlight(true);
            } else {
                cMIUser.setAllowFlight(false);
                cMIUser.setFlying(false);
                cMIUser.setWasFlying(false);
                cMIUser.setHadAllowFlight(false);
                if (this.plugin.getTeleportHandler().needToFly(player)) {
                    this.plugin.getTeleportHandler().teleportPlayer(player, player.getLocation(), PlayerTeleportEvent.TeleportCause.PLUGIN, true);
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void EntityTargetLivingEntityEvent(EntityTargetLivingEntityEvent entityTargetLivingEntityEvent) {
        if (entityTargetLivingEntityEvent.isCancelled()) {
            return;
        }
        try {
            if (!entityTargetLivingEntityEvent.getReason().equals((Object)EntityTargetEvent.TargetReason.CLOSEST_PLAYER) && !entityTargetLivingEntityEvent.getReason().equals((Object)EntityTargetEvent.TargetReason.OWNER_ATTACKED_TARGET) && !entityTargetLivingEntityEvent.getReason().equals((Object)EntityTargetEvent.TargetReason.TARGET_ATTACKED_ENTITY) || !entityTargetLivingEntityEvent.getEntity().getType().isAlive()) {
                return;
            }
            if (entityTargetLivingEntityEvent.getTarget() == null) {
                return;
            }
            if (entityTargetLivingEntityEvent.getTarget().getType() != EntityType.PLAYER) {
                return;
            }
            CMIUser cMIUser = CMIUser.getUser((Player)entityTargetLivingEntityEvent.getTarget());
            if (cMIUser == null) {
                return;
            }
            if (cMIUser.isTgod()) {
                entityTargetLivingEntityEvent.setCancelled(true);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void PlayerLoginEvent(PlayerChangedWorldEvent playerChangedWorldEvent) {
        Player player = playerChangedWorldEvent.getPlayer();
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player);
        if (cMIUser == null) {
            return;
        }
        if (cMIUser.getTfly() > System.currentTimeMillis()) {
            player.setAllowFlight(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onRespawn(PlayerRespawnEvent playerRespawnEvent) {
        Player player = playerRespawnEvent.getPlayer();
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player);
        if (cMIUser == null) {
            return;
        }
        if (this.plugin.getConfigManager().WorldLimits) {
            World world2 = playerRespawnEvent.getRespawnLocation().getWorld();
            if (Version.isCurrentEqualOrHigher((Version)Version.v1_16_R3) && !PermissionsManager.CMIPerm.worldlimit_fly_bypass.hasPermission((CommandSender)player) && this.plugin.getConfigManager().worldFlyMode.containsKey(world2.getName()) && !this.plugin.getConfigManager().worldFlyMode.get(world2.getName()).booleanValue()) {
                return;
            }
        }
        if (cMIUser.getTfly() != 0L) {
            if (cMIUser.getTfly() > System.currentTimeMillis()) {
                this.plugin.getTimedCommandManager().addTimed(cMIUser);
                player.setAllowFlight(true);
            } else {
                player.setAllowFlight(false);
            }
        }
    }
}

